/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.question;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.questionnaire.question.QuestionService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class QuestionServiceImpl
implements QuestionService {
    private static final String QUESTION_REF_ID = "questionRefId";
    private static final String QUESTION_ID = "questionId";
    private static final String QUESTION_QUESTION_ID = "questionnaireQuestions.question.questionId";
    private static final String QUESTIONNAIRE_ID = "questionnaireId";
    private BusinessObjectService businessObjectService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public Question getQuestionByRefId(String questionRefId) {
        Question question = null;
        if (!StringUtils.isBlank((String)questionRefId)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(QUESTION_REF_ID, questionRefId);
            question = (Question)this.businessObjectService.findByPrimaryKey(Question.class, fieldValues);
        }
        return question;
    }

    public Question getQuestionById(String questionId) {
        Question question = null;
        if (questionId != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(QUESTION_ID, questionId);
            Collection questions = this.businessObjectService.findMatching(Question.class, fieldValues);
            if (questions.size() > 0) {
                question = (Question)Collections.max(questions);
            }
        }
        return question;
    }

    public boolean isQuestionUsed(String questionId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(QUESTION_QUESTION_ID, questionId);
        List questionnaires = (List)this.businessObjectService.findMatching(Questionnaire.class, fieldValues);
        for (Questionnaire questionnaire : questionnaires) {
            if (!this.isActiveQuestionnaire(questionnaire)) continue;
            return true;
        }
        return false;
    }

    protected boolean isActiveQuestionnaire(Questionnaire questionnaire) {
        Questionnaire maxQuestionnaire;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(QUESTIONNAIRE_ID, questionnaire.getQuestionnaireId());
        Collection questionnaires = this.businessObjectService.findMatching(Questionnaire.class, fieldValues);
        return questionnaires.size() > 0 && (maxQuestionnaire = (Questionnaire)Collections.max(questionnaires)).getQuestionnaireRefId().equals(questionnaire.getQuestionnaireRefId());
    }
}

