/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.reporting.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.reporting.BirtHelper;
import org.kuali.kra.reporting.bo.BirtParameterBean;
import org.kuali.kra.reporting.bo.CustReportDetails;
import org.kuali.kra.reporting.service.BirtReportService;
import org.kuali.kra.reporting.web.struts.action.ReportGenerationBaseAction;
import org.kuali.kra.reporting.web.struts.form.ReportGenerationForm;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ReportGenerationAction
extends ReportGenerationBaseAction {
    private BirtReportService birtReportService;

    public ActionForward getReportParametersFromDesign(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportGenerationForm reportGenerationForm = (ReportGenerationForm)form;
        ArrayList parameterList = new ArrayList();
        if (request.getParameter("reportId") != null) {
            parameterList = ((BirtReportService)KraServiceLocator.getService(BirtReportService.class)).getInputParametersFromTemplateFile(request.getParameter("reportId"));
            reportGenerationForm.setReportParameterList(parameterList);
            reportGenerationForm.setReportId(request.getParameter("reportId"));
            reportGenerationForm.setReportName(request.getParameter("reportLabel"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward printReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream birtFilePrintArrayOutputStream = new ByteArrayOutputStream();
        int birtCounter = 0;
        String reportId = request.getParameter("custReportDetails.reportLabelDisplay");
        if (reportId.equalsIgnoreCase("0")) {
            new ErrorReporter().reportError("custReportDetails.reportLabelDisplay", "error.invalid.report", new String[]{"select"});
            return mapping.findForward("basic");
        }
        ArrayList parameterList = new ArrayList();
        String printReportFormat = "application/pdf";
        String printReportNameAndExtension = ".pdf";
        boolean isValid = Boolean.TRUE;
        ReportGenerationForm reportGenerationForm = (ReportGenerationForm)form;
        InputStream reportDesignInputStream = ((BirtReportService)KraServiceLocator.getService(BirtReportService.class)).getReportDesignFileStream(reportId);
        IReportRunnable iReportRunnableDesign = BirtHelper.getEngine().openReportDesign(reportDesignInputStream);
        ReportDesignHandle designHandle = (ReportDesignHandle)iReportRunnableDesign.getDesignHandle();
        designHandle.getDataSources().add((DesignElementHandle)BirtHelper.getDataSourceHandle());
        designHandle.close();
        iReportRunnableDesign.setDesignHandle((DesignElementHandle)designHandle);
        IRunAndRenderTask reportTask = BirtHelper.getEngine().createRunAndRenderTask(iReportRunnableDesign);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameterList = ((BirtReportService)KraServiceLocator.getService(BirtReportService.class)).getInputParametersFromTemplateFile(reportId);
        CustReportDetails reportDetails = (CustReportDetails)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findBySinglePrimaryKey(CustReportDetails.class, (Object)reportId);
        reportGenerationForm.setReportParameterList(parameterList);
        reportGenerationForm.setReportId(reportId);
        reportGenerationForm.setReportName(reportDetails.getReportLabel());
        for (BirtParameterBean parameterBean : parameterList) {
            if (parameterBean.getDataType() == 5) {
                try {
                    Date inputDate = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).convertToDateTime(request.getParameter("reportParameterList[" + birtCounter + "].inputParameterText"));
                    parameters.put(parameterBean.getName(), inputDate);
                }
                catch (Exception exception) {
                    new ErrorReporter().reportError("reportParameterList[0].inputParameterText", "error.invalid.report.date", new String[]{"select"});
                    return mapping.findForward("basic");
                }
            } else {
                parameters.put(parameterBean.getName(), request.getParameter("reportParameterList[" + birtCounter + "].inputParameterText"));
            }
            ++birtCounter;
        }
        HashMap contextMap = new HashMap();
        reportTask.setAppContext(contextMap);
        reportTask.setParameterValues(parameters);
        isValid = reportTask.validateParameters();
        if (!isValid) {
            new ErrorReporter().reportError("reportParameterList[0].inputParameterText", "error.missing.report.inputparameters", new String[]{"select"});
        } else {
            PDFRenderOption renderOption = null;
            if (reportGenerationForm.getReportFormat().equalsIgnoreCase("pdf")) {
                renderOption = new PDFRenderOption();
                printReportFormat = "application/pdf";
                printReportNameAndExtension = reportDetails.getReportLabel() + ".pdf";
                renderOption.setOutputFormat(reportGenerationForm.getReportFormat());
            } else if (reportGenerationForm.getReportFormat().equalsIgnoreCase("html")) {
                renderOption = new HTMLRenderOption();
                printReportFormat = "application/html";
                printReportNameAndExtension = reportDetails.getReportLabel() + ".html";
                renderOption.setOutputFormat(reportGenerationForm.getReportFormat());
            } else if (reportGenerationForm.getReportFormat().equalsIgnoreCase("excel")) {
                renderOption = new EXCELRenderOption();
                printReportFormat = "application/xls";
                printReportNameAndExtension = reportDetails.getReportLabel() + ".xls";
                renderOption.setOutputFormat("xls");
            } else {
                printReportFormat = "application/pdf";
                renderOption = new PDFRenderOption();
            }
            renderOption.setOutputStream((OutputStream)birtFilePrintArrayOutputStream);
            reportTask.setRenderOption((IRenderOption)renderOption);
            reportTask.run();
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)printReportFormat, (ByteArrayOutputStream)birtFilePrintArrayOutputStream, (String)printReportNameAndExtension);
            reportTask.close();
            DataSourceHandle designElementHandle = designHandle.findDataSource("Data Source");
            designHandle.getDataSources().dropAndClear((DesignElementHandle)designElementHandle);
            designHandle.clearAllProperties();
        }
        return mapping.findForward("basic");
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.close(mapping, form, request, response);
    }

    public void setBirtReportService(BirtReportService birtReportService) {
        this.birtReportService = birtReportService;
    }

    public BirtReportService getBirtReportService() {
        return (BirtReportService)KraServiceLocator.getService(BirtReportService.class);
    }
}

