/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class ActivityTypeAuditRule
implements DocumentAuditRule {
    private static final Log LOG = LogFactory.getLog(ActivityTypeAuditRule.class);

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        BudgetDocument budgetDocument = (BudgetDocument)document;
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        if (this.isActivityTypeChanged(budgetDocument)) {
            if (budgetDocument.getParentDocument() instanceof AwardDocument) {
                auditErrors.add(new AuditError("document.developmentProposalList[0].activityTypeCode".replace("developmentProposalList", "awardList"), "warning.activityType.changed", "home.detailsDate"));
            } else {
                auditErrors.add(new AuditError("document.developmentProposalList[0].activityTypeCode", "warning.activityType.changed", "proposal.RequiredFieldsforSavingDocument"));
            }
            KNSGlobalVariables.getAuditErrorMap().put("activityTypeAuditWarnings", new AuditCluster("Activity type changed", auditErrors, "Warnings"));
            valid = false;
        }
        return valid;
    }

    private boolean isActivityTypeChanged(BudgetDocument budgetDocument) {
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        boolean syncRate = false;
        Collection allBudgetRates = ((BudgetService)KraServiceLocator.getService(BudgetService.class)).getSavedBudgetRates(budgetDocument.getBudget());
        syncRate = this.getBudgetService().checkActivityTypeChange(allBudgetRates, parentDocument.getBudgetParent().getActivityTypeCode());
        return syncRate;
    }

    private BudgetService getBudgetService() {
        return (BudgetService)KraServiceLocator.getService(BudgetService.class);
    }
}

