/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.HashMap;
import org.kuali.kra.budget.core.BudgetCategory;
import org.kuali.kra.budget.core.BudgetCategoryMapping;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;

public class BudgetCategoryExistenceRule
extends KraMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkExistence(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkExistence(document);
    }

    private boolean checkExistence(MaintenanceDocument maintenanceDocument) {
        String budgetCategoryCode;
        boolean valid = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        if (maintenanceDocument.getNewMaintainableObject().getDataObject() instanceof BudgetCategoryMapping) {
            BudgetCategoryMapping budgetCategoryMapping = (BudgetCategoryMapping)maintenanceDocument.getNewMaintainableObject().getDataObject();
            budgetCategoryCode = budgetCategoryMapping.getBudgetCategoryCode();
        } else {
            CostElement costElement = (CostElement)maintenanceDocument.getNewMaintainableObject().getDataObject();
            budgetCategoryCode = costElement.getBudgetCategoryCode();
        }
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("budgetCategoryCode", budgetCategoryCode);
        valid = this.checkExistenceFromTable(BudgetCategory.class, pkMap, "budgetCategoryCode", "Budget Category");
        return valid;
    }
}

