/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.CustomAttribute;
import org.kuali.kra.bo.CustomAttributeDataType;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.ArgValueLookupValuesFinder;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rule.event.SaveCustomDataEvent;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.CustomAttributeService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;

public class CustomDataRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<SaveCustomDataEvent> {
    private static final String STRING = "String";
    private static final String DATE = "Date";
    private static final String NUMBER = "Number";
    private static String CUSTOMATTRIBUTE_ERROR_START = "[";
    private static String CUSTOMATTRIBUTE_ERROR_END = "].value";
    private static DateFormat dateFormat;
    private static final String DATE_REGEX = "(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01])/(19|2[0-9])[0-9]{2}";
    private static Map<String, ValidationPattern> VALIDATION_CLASSES;
    private CustomAttributeService customAttributeService;

    public boolean processRules(SaveCustomDataEvent event) {
        boolean rulePassed = true;
        Map customAttributeDocuments = event.getCustomAttributeDocuments();
        for (Map.Entry customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
            CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)customAttributeDocumentEntry.getValue();
            CustomAttribute customAttribute = customAttributeDocument.getCustomAttribute();
            List customDataList = event.getCustomDataList();
            int index = 0;
            for (DocumentCustomData data : customDataList) {
                if (data.getCustomAttributeId().longValue() == customAttribute.getId().longValue()) {
                    customAttribute.setValue(data.getValue());
                    break;
                }
                ++index;
            }
            String errorKey = event.getErrorPathPrefix() + CUSTOMATTRIBUTE_ERROR_START + index + CUSTOMATTRIBUTE_ERROR_END;
            if (StringUtils.isNotBlank((String)customAttribute.getValue())) {
                CustomAttributeDataType customAttributeDataType = customAttribute.getCustomAttributeDataType();
                if (customAttributeDataType == null && customAttribute.getDataTypeCode() != null) {
                    customAttributeDataType = this.getCustomAttributeService().getCustomAttributeDataType(customAttribute.getDataTypeCode());
                }
                if (customAttributeDataType != null) {
                    rulePassed &= this.validateAttributeFormat(customAttribute, errorKey, event);
                }
            }
            if (!event.isValidateRequiredFields() || !customAttributeDocument.isRequired() || !StringUtils.isBlank((String)customAttribute.getValue())) continue;
            event.reportError(customAttribute, errorKey, "error.required", new String[]{customAttribute.getLabel(), customAttribute.getValue(), this.getValidFormat(customAttribute.getCustomAttributeDataType().getDescription())});
            rulePassed = false;
        }
        return rulePassed;
    }

    protected boolean validateAttributeFormat(CustomAttribute customAttribute, String errorKey, SaveCustomDataEvent event) {
        boolean isValid = true;
        CustomAttributeDataType customAttributeDataType = customAttribute.getCustomAttributeDataType();
        String attributeValue = customAttribute.getValue();
        if (customAttributeDataType == null && customAttribute.getDataTypeCode() != null) {
            customAttributeDataType = this.getCustomAttributeService().getCustomAttributeDataType(customAttribute.getDataTypeCode());
        }
        if (customAttributeDataType != null) {
            String lookupClass;
            Integer maxLength = customAttribute.getDataLength();
            if (maxLength != null && maxLength < attributeValue.length()) {
                event.reportError(customAttribute, errorKey, "error.maxLength", new String[]{customAttribute.getLabel(), maxLength.toString()});
                isValid = false;
            }
            ValidationPattern validationPattern = (ValidationPattern)VALIDATION_CLASSES.get(customAttributeDataType.getDescription());
            String validFormat = this.getValidFormat(customAttributeDataType.getDescription());
            if (validationPattern != null) {
                if (!validationPattern.matches(attributeValue)) {
                    event.reportError(customAttribute, errorKey, "error.invalidFormat.withFormat", new String[]{customAttribute.getLabel(), attributeValue, validFormat});
                    isValid = false;
                }
            } else if (DATE.equals(customAttributeDataType.getDescription())) {
                if (attributeValue != null && !attributeValue.matches(DATE_REGEX)) {
                    event.reportError(customAttribute, errorKey, "error.invalidFormat", new String[]{customAttribute.getLabel(), attributeValue, validFormat});
                    isValid = false;
                } else {
                    try {
                        dateFormat.parse(attributeValue);
                    }
                    catch (ParseException e) {
                        event.reportError(customAttribute, errorKey, "error.date", new String[]{attributeValue, customAttribute.getLabel()});
                        isValid = false;
                    }
                }
            }
            if ((lookupClass = customAttribute.getLookupClass()) != null && lookupClass.equals("org.kuali.kra.bo.KcPerson")) {
                if (customAttribute.getDataTypeCode().equals("1") && customAttribute.getLookupReturn().equals("userName")) {
                    validFormat = this.getValidFormat(customAttributeDataType.getDescription());
                    KcPersonService kps = this.getKcPersonService();
                    KcPerson customPerson = kps.getKcPersonByUserName(customAttribute.getValue());
                    if (customPerson == null) {
                        event.reportError(customAttribute, errorKey, "error.existence", new String[]{customAttribute.getLabel(), attributeValue, validFormat});
                        isValid = false;
                    }
                }
            } else if (lookupClass != null && lookupClass.equals("org.kuali.kra.bo.ArgValueLookup")) {
                ArgValueLookupValuesFinder finder = new ArgValueLookupValuesFinder();
                finder.setArgName(customAttribute.getLookupReturn());
                List kv = finder.getKeyValues();
                Iterator i = kv.iterator();
                boolean found = false;
                while (i.hasNext()) {
                    KeyValue element = (KeyValue)i.next();
                    String label = element.getKey().toLowerCase();
                    if (!label.equals(attributeValue.toLowerCase())) continue;
                    found = true;
                }
                if (!found) {
                    validFormat = this.getValidFormat(customAttributeDataType.getDescription());
                    event.reportError(customAttribute, errorKey, "error.existence", new String[]{customAttribute.getLabel(), attributeValue, validFormat});
                    isValid = false;
                }
            } else if (lookupClass != null) {
                Class<?> boClass = null;
                try {
                    boClass = Class.forName(lookupClass);
                }
                catch (ClassNotFoundException cnfE) {
                    // empty catch block
                }
                if (this.isInvalid(boClass, new Map.Entry[]{this.keyValue(customAttribute.getLookupReturn(), (Object)customAttribute.getValue())})) {
                    validFormat = this.getValidFormat(customAttributeDataType.getDescription());
                    event.reportError(customAttribute, errorKey, "error.existence", new String[]{customAttribute.getLabel(), attributeValue, validFormat});
                    return false;
                }
            }
        }
        return isValid;
    }

    private String getValidFormat(String dataType) {
        String validFormat = "String - Any Character";
        if (dataType.equalsIgnoreCase(NUMBER)) {
            validFormat = "Number - [0-9]";
        } else if (dataType.equalsIgnoreCase(DATE)) {
            validFormat = "Date - [xx/xx/xxxx]";
        }
        return validFormat;
    }

    public CustomAttributeService getCustomAttributeService() {
        if (this.customAttributeService == null) {
            this.customAttributeService = (CustomAttributeService)KraServiceLocator.getService(CustomAttributeService.class);
        }
        return this.customAttributeService;
    }

    public void setCustomAttributeService(CustomAttributeService customAttributeService) {
        this.customAttributeService = customAttributeService;
    }

    protected KcPersonService getKcPersonService() {
        return (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
    }

    static {
        VALIDATION_CLASSES = new HashMap();
        HashMap<String, Object> tempPatterns = new HashMap<String, Object>();
        AnyCharacterValidationPattern anyCharVal = new AnyCharacterValidationPattern();
        anyCharVal.setAllowWhitespace(true);
        tempPatterns.put(STRING, anyCharVal);
        tempPatterns.put(NUMBER, new NumericValidationPattern());
        VALIDATION_CLASSES = Collections.unmodifiableMap(tempPatterns);
        dateFormat = DateFormat.getDateInstance(3);
        dateFormat.setLenient(false);
    }
}

