/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.PersonTraining;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.util.GlobalVariables;

public class PersonTrainingMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        PersonTraining personTraining = (PersonTraining)document.getNoteTarget();
        return this.validate(personTraining);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        PersonTraining personTraining = (PersonTraining)document.getNoteTarget();
        return this.validate(personTraining);
    }

    private boolean validate(PersonTraining personTraining) {
        boolean valid = true;
        if (StringUtils.isNotBlank((String)personTraining.getPersonId()) && personTraining.getTrainingNumber() != null) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("personId", personTraining.getPersonId());
            fieldValues.put("trainingNumber", personTraining.getTrainingNumber());
            List personTrainings = (List)this.boService.findMatching(PersonTraining.class, fieldValues);
            if (!personTrainings.isEmpty()) {
                PersonTraining existPersonTraining = (PersonTraining)personTrainings.get(0);
                if (personTraining.getPersonTrainingId() == null || personTraining.getPersonTrainingId() == existPersonTraining.getPersonTrainingId()) {
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.personId", "error.persontraining.exists", new String[]{personTraining.getTrainingNumber().toString(), personTraining.getPersonId()});
                    valid = false;
                }
            }
        }
        return valid;
    }
}

