/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalColumnsToAlter;
import org.kuali.kra.proposaldevelopment.bo.ProposalOverview;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.service.KraPersistenceStructureService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalColumnsToAlterMaintenanceDocumentRule
extends MaintenanceDocumentRuleBase {
    private static Map<String, String> validationClassesMap = new HashMap();

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkLookupReturn(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkLookupReturn(document);
    }

    private boolean checkLookupReturn(MaintenanceDocument maintenanceDocument) {
        ProposalColumnsToAlter newEditableProposalField;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("New maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        if (StringUtils.isNotBlank((String)(newEditableProposalField = (ProposalColumnsToAlter)maintenanceDocument.getNewMaintainableObject().getDataObject()).getLookupClass())) {
            GlobalVariables.getUserSession().addObject("lookupClassName", (Object)newEditableProposalField.getLookupClass());
        }
        if (StringUtils.isNotBlank((String)newEditableProposalField.getLookupClass()) && StringUtils.isBlank((String)newEditableProposalField.getLookupReturn())) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.lookupReturn", "error.required", new String[]{"Lookup Return"});
            return false;
        }
        return true;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.verifyProposaEditableColumnsDataType(document);
    }

    private boolean verifyProposaEditableColumnsDataType(MaintenanceDocument maintenanceDocument) {
        ProposalColumnsToAlter newEditableProposalField = (ProposalColumnsToAlter)maintenanceDocument.getNewMaintainableObject().getDataObject();
        KraPersistenceStructureService kraPersistenceStructureService = (KraPersistenceStructureService)KraServiceLocator.getService(KraPersistenceStructureService.class);
        DataDictionaryService dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        Map fieldMap = kraPersistenceStructureService.getDBColumnToObjectAttributeMap(ProposalOverview.class);
        DataDictionaryEntry entry = dataDictionaryService.getDataDictionary().getDictionaryObjectEntry(ProposalDevelopmentDocument.class.getName());
        boolean returnFlag = true;
        String editableProposalField = "";
        Integer fieldMaxLength = -1;
        Integer inputDataLength = -1;
        String proposalFieldDataType = "";
        String inputDataType = "";
        ValidationPattern validatingPattern = null;
        if (newEditableProposalField != null && StringUtils.isNotEmpty((String)newEditableProposalField.getColumnName()) && StringUtils.isNotEmpty((String)(editableProposalField = (String)fieldMap.get(newEditableProposalField.getColumnName())))) {
            AttributeDefinition attributeDefinition;
            if (entry != null && (attributeDefinition = entry.getAttributeDefinition(editableProposalField)) != null && attributeDefinition.hasValidationPattern() && (validatingPattern = attributeDefinition.getValidationPattern()) != null && !(proposalFieldDataType = (String)validationClassesMap.get(validatingPattern.getClass().getName())).equalsIgnoreCase(inputDataType = newEditableProposalField.getDataType())) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.dataType", "error.column.datatype.mismatch", new String[0]);
                returnFlag = false;
            }
            inputDataLength = newEditableProposalField.getDataLength();
            fieldMaxLength = dataDictionaryService.getAttributeMaxLength(DevelopmentProposal.class, editableProposalField);
            if (fieldMaxLength > inputDataLength) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.dataLength", "error.column.dataLength.mismatch", new String[0]);
                returnFlag = false;
            }
        }
        return returnFlag;
    }

    static {
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern", "STRING");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern", "STRING");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaValidationPattern", "STRING");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.fieldlevel.DateValidationPattern", "DATE");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern", "NUMBER");
    }
}

