/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.rules.ResearchDocumentBaseAuditRule;
import org.kuali.kra.rules.SoftError;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.DocumentRuleBase;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public abstract class ResearchDocumentRuleBase
extends DocumentRuleBase
implements DocumentAuditRule {
    private static final Log LOG = LogFactory.getLog(ResearchDocumentRuleBase.class);
    public static final String DOCUMENT_ERROR_PATH = "document";
    public static final boolean VALIDATION_REQUIRED = true;
    public static final boolean CHOMP_LAST_LETTER_S_FROM_COLLECTION_NAME = false;
    private final ErrorReporter errorReporter = new ErrorReporter();
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private DictionaryValidationService knsDictionaryValidationService;

    protected void reportError(String propertyName, String errorKey, String ... errorParams) {
        this.errorReporter.reportError(propertyName, errorKey, errorParams);
    }

    protected void reportWarning(String propertyName, String errorKey, String ... errorParams) {
        this.errorReporter.reportWarning(propertyName, errorKey, errorParams);
    }

    protected void addAuditError(AuditError error, String errorKey, String clusterLabel, String clusterCategory) {
        this.errorReporter.reportAuditError(error, errorKey, clusterLabel, clusterCategory);
    }

    protected void reportSoftError(String propertyName, String errorKey, String ... errorParams) {
        this.errorReporter.reportSoftError(propertyName, errorKey, errorParams);
    }

    public Map<String, Collection<SoftError>> getSoftErrors() {
        return this.errorReporter.getSoftErrors();
    }

    protected void reportErrorWithoutFullErrorPath(String propertyName, String errorKey, String ... errorParams) {
        LOG.debug((Object)"reportErrorWithoutFullErrorPath(String, String, String) - start");
        GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(propertyName, errorKey, errorParams);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rule failure at " + ErrorReporter.getMethodPath((int)1, (int)2)));
        }
    }

    public boolean processRunAuditBusinessRules(Document document) {
        return new ResearchDocumentBaseAuditRule().processRunAuditBusinessRules(document);
    }

    protected boolean processBudgetVersionsBusinessRule(BudgetParentDocument budgetParentDocument, boolean runDatactionaryValidation) {
        if (budgetParentDocument == null) {
            throw new NullPointerException("the parentDocument is null.");
        }
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        boolean finalVersionFound = false;
        DictionaryValidationService dictionaryValidationService = this.getKnsDictionaryValidationService();
        int index = 0;
        for (BudgetDocumentVersion budgetDocumentVersion : budgetParentDocument.getBudgetDocumentVersions()) {
            String budgetStatusCompleteCode;
            BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
            if (runDatactionaryValidation) {
                dictionaryValidationService.validateBusinessObject((BusinessObject)budgetVersion, true);
            }
            if (budgetVersion.isFinalVersionFlag()) {
                if (finalVersionFound) {
                    errorMap.putError("finalVersionFlag", "error.final.multiple", new String[0]);
                } else {
                    finalVersionFound = true;
                }
            }
            if ((budgetStatusCompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode")).equalsIgnoreCase(budgetVersion.getBudgetStatus()) && !budgetVersion.isFinalVersionFlag()) {
                errorMap.putError("budgetVersionOverview[" + index + "].budgetStatus", "error.final.budget.required", new String[0]);
                valid = false;
            }
            ++index;
        }
        return valid;
    }

    protected boolean hasPermission(ProposalDevelopmentDocument doc, String permissionName) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        return kraAuthorizationService.hasPermission(userId, (Permissionable)doc, permissionName);
    }

    protected boolean hasRole(ProposalDevelopmentDocument doc, String roleName) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        return kraAuthorizationService.hasRole(userId, (Permissionable)doc, roleName);
    }

    protected boolean hasPermission(String userId, ProposalDevelopmentDocument doc, String permissionName) {
        KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        return kraAuthorizationService.hasPermission(userId, (Permissionable)doc, permissionName);
    }

    protected boolean hasRole(String userId, ProposalDevelopmentDocument doc, String roleName) {
        KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        return kraAuthorizationService.hasRole(userId, (Permissionable)doc, roleName);
    }

    protected Map.Entry<String, String> keyValue(String key, Object value) {
        DefaultMapEntry entry = value == null ? new DefaultMapEntry((Object)key, (Object)"") : new DefaultMapEntry((Object)key, (Object)value.toString());
        return entry;
    }

    protected boolean isInvalid(Class<?> boClass, Map.Entry<String, String> ... entries) {
        return !this.isValid(boClass, (Map.Entry[])entries);
    }

    protected boolean isValid(Class<?> boClass, Map.Entry<String, String> ... entries) {
        boolean retval = false;
        if (entries != null && entries.length > 0) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : entries) {
                fieldValues.put(entry.getKey(), entry.getValue());
            }
            if (this.getBusinessObjectService().countMatching(boClass, fieldValues) > 0) {
                retval = true;
            }
        }
        return retval;
    }

    protected final BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    protected DictionaryValidationService getKnsDictionaryValidationService() {
        if (this.knsDictionaryValidationService == null) {
            this.knsDictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        }
        return this.knsDictionaryValidationService;
    }
}

