/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.regex.Pattern;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.util.GlobalVariables;

public class SponsorMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    private static final String SPONSOR_CODE_FIELD_NAME = "sponsorCode";
    private static final String SPONSOR_CODE_FORMAT_DESCRIPTION = "exactly six(6) alphanumeric characters";
    private static final String SPONSOR_CODE_ERROR_PROPERTY_NAME = "document.newMaintainableObject.sponsorCode";
    private static final String SPONSOR_CODE_REGEX = "[a-zA-Z0-9]{6}";

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkSponsorCode(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkSponsorCode(document);
    }

    private boolean checkSponsorCode(MaintenanceDocument document) {
        boolean valid = true;
        Sponsor sponsor = (Sponsor)document.getNewMaintainableObject().getDataObject();
        if (sponsor.getSponsorCode() != null && !Pattern.matches(SPONSOR_CODE_REGEX, sponsor.getSponsorCode())) {
            String errorLabel = ((DataDictionaryService)KraServiceLocator.getService(DataDictionaryService.class)).getAttributeErrorLabel(Sponsor.class, SPONSOR_CODE_FIELD_NAME);
            GlobalVariables.getMessageMap().putError(SPONSOR_CODE_ERROR_PROPERTY_NAME, "error.invalidFormat.withFormat", new String[]{errorLabel, sponsor.getSponsorCode(), SPONSOR_CODE_FORMAT_DESCRIPTION});
            valid = false;
        }
        return valid;
    }
}

