/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateTerm;
import org.kuali.kra.bo.SponsorTermType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SponsorTemplateTermsExistenceRule
extends KraMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkTermsExistence(document);
    }

    private boolean checkTermsExistence(MaintenanceDocument maintenanceDocument) {
        boolean valid = true;
        AwardTemplate awardTemplate = (AwardTemplate)maintenanceDocument.getNewMaintainableObject().getDataObject();
        List aList = awardTemplate.getAwardSponsorTerms();
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        Collection types = businessObjectService.findAll(SponsorTermType.class);
        ArrayList<String> currentTypeCodes = new ArrayList<String>();
        for (AwardTemplateTerm aTerm : aList) {
            currentTypeCodes.add(aTerm.getSponsorTermTypeCode());
        }
        for (SponsorTermType aType : types) {
            if (currentTypeCodes.contains(aType.getSponsorTermTypeCode())) continue;
            ErrorReporter errorReporter = new ErrorReporter();
            errorReporter.reportError("document.newMaintainableObject.templateTerms", "error.award.sponsorTemplate.term.required", new String[]{aType.getDescription()});
            valid = false;
        }
        return valid;
    }
}

