/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.bo.UnitAdministratorType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class UnitAdministratorMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.validateMultipleUnitAdministratorTypes(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.validateMultipleUnitAdministratorTypes(document);
    }

    private boolean validateMultipleUnitAdministratorTypes(MaintenanceDocument document) {
        boolean isValid = true;
        UnitAdministrator newUnitAdministrator = (UnitAdministrator)document.getNewMaintainableObject().getDataObject();
        Unit newUnit = newUnitAdministrator.getUnit();
        UnitAdministratorType newUnitAdministratorType = newUnitAdministrator.getUnitAdministratorType();
        if (document.getNewMaintainableObject().getMaintenanceAction().equals("Delete") || document.getOldMaintainableObject().getMaintenanceAction().equals("Delete")) {
            return true;
        }
        if (!newUnitAdministratorType.getMultiplesFlag().booleanValue()) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("unitNumber", newUnit.getUnitNumber());
            Collection unitAdministrators = this.getBusinessObjectService().findMatching(UnitAdministrator.class, fieldValues);
            for (UnitAdministrator unitAdministrator : unitAdministrators) {
                if (!StringUtils.equals((String)newUnitAdministratorType.getUnitAdministratorTypeCode(), (String)unitAdministrator.getUnitAdministratorTypeCode())) continue;
                isValid = false;
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.unitAdministratorTypeCode", "error.unitAdministrator.multiple.types.not.allowed", new String[]{newUnitAdministratorType.getDescription()});
                break;
            }
        }
        return isValid;
    }

    private BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }
}

