/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s;

public class S2SException
extends Exception {
    private String errorMessage;
    private String errorKey = "error.s2s.unknown";
    private int messageType;
    private String[] params;

    public S2SException() {
    }

    public S2SException(Exception ex) {
        super(ex);
        this.errorMessage = ex.getMessage();
    }

    public S2SException(String message, Exception ex) {
        super(message, ex);
    }

    public S2SException(String msg) {
        super(msg);
        this.errorMessage = msg;
    }

    public S2SException(String errorKey, String msg) {
        super(msg);
        this.errorMessage = msg;
        this.errorKey = errorKey;
    }

    public S2SException(String errorKey, String msg, String ... params) {
        super(msg);
        this.errorMessage = msg;
        this.errorKey = errorKey;
        this.params = params;
    }

    public S2SException(String msg, int messageType) {
        this.errorMessage = msg;
        this.messageType = messageType;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public String[] getMessageWithParams() {
        String[] messageWithParams = new String[this.getParams().length + 1];
        messageWithParams[0] = this.errorMessage;
        for (int i = 1; i < messageWithParams.length; ++i) {
            messageWithParams[i] = this.params[i - 1];
        }
        return messageWithParams;
    }

    public void setMessage(String msg) {
        this.errorMessage = msg;
    }

    public String getUserMessage() {
        return this.errorMessage;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] params) {
        this.params = params;
    }
}

