/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator;

import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalV10.HashValueDocument;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeAttachment;
import org.kuali.kra.proposaldevelopment.bo.NarrativeType;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiographyAttachment;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.service.NarrativeService;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.s2s.generator.S2SFormGenerator;
import org.kuali.kra.s2s.generator.bo.AttachmentData;
import org.kuali.kra.s2s.generator.impl.GlobalLibraryV1_0Generator;
import org.kuali.kra.s2s.generator.impl.GlobalLibraryV2_0Generator;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.rice.kns.util.AuditError;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class S2SBaseFormGenerator
implements S2SFormGenerator {
    private static final Log LOG = LogFactory.getLog(S2SBaseFormGenerator.class);
    private List<AttachmentData> attachments;
    public static final String TYPE_SEPARATOR = "_";
    public static final String KEY_VALUE_SEPARATOR = "-";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String TITLE = "TITLE";
    public static final String MODULE_NUMBER = "M";
    public static final String AREAS_AFFECTED_ABSTRACT_TYPE_CODE = "16";
    private static final String NARRATIVE_ATTACHMENT_LIST = "narrativeAttachmentList";
    private static final String NARRATIVE_ATTACHMENT_FILE_LOCATION = "att:FileLocation";
    protected static final int ORGANIZATON_NAME_MAX_LENGTH = 60;
    protected static final int DUNS_NUMBER_MAX_LENGTH = 13;
    protected static final int PRIMARY_TITLE_MAX_LENGTH = 45;
    protected static final int CONGRESSIONAL_DISTRICT_MAX_LENGTH = 6;
    protected ProposalDevelopmentDocument pdDoc = null;
    private List<AuditError> auditErrors;
    protected GlobalLibraryV1_0Generator globLibV10Generator = new GlobalLibraryV1_0Generator();
    protected GlobalLibraryV2_0Generator globLibV20Generator = new GlobalLibraryV2_0Generator();

    public List<AttachmentData> getAttachments() {
        return this.attachments;
    }

    protected void addAttachment(AttachmentData attachment) {
        this.attachments.add(attachment);
    }

    protected HashValueDocument.HashValue getHashValue(byte[] fileData) {
        return S2SBaseFormGenerator.createHashValue((String)S2SBaseFormGenerator.computeAttachmentHash((byte[])fileData));
    }

    public String createContentId(Narrative narrative) {
        int index;
        String retVal = "N-" + narrative.getModuleNumber();
        if (narrative.getNarrativeType() != null) {
            retVal = narrative.getNarrativeType().getAllowMultiple() != null && narrative.getNarrativeType().getAllowMultiple().equals("Y") && StringUtils.isNotBlank((String)narrative.getModuleTitle()) ? retVal + "_" + narrative.getModuleTitle().trim() : retVal + "_" + narrative.getNarrativeType().getDescription().trim();
        }
        if ((index = this.getIndexOfAttachmentAlreadyAdded(retVal)) > 0) {
            retVal = retVal + "-" + index;
        }
        return retVal;
    }

    private int getIndexOfAttachmentAlreadyAdded(String contentId) {
        int index = 0;
        List attachments = this.getAttachments();
        for (AttachmentData attachmentData : attachments) {
            String attContentId = attachmentData.getContentId();
            int lastIndex = attContentId.indexOf(45, 6);
            if (lastIndex != -1) {
                attContentId = attContentId.substring(0, attContentId.lastIndexOf(45));
            }
            if (!attContentId.equals(contentId)) continue;
            ++index;
        }
        return index;
    }

    public String createContentId(ProposalPersonBiography biography) {
        int index;
        String retVal = "B-" + biography.getProposalPersonNumber() + "_" + biography.getBiographyNumber();
        if (biography.getPropPerDocType() != null) {
            retVal = retVal + "_" + biography.getPropPerDocType().getDescription().trim();
        }
        if (StringUtils.isNotBlank((String)biography.getDescription())) {
            retVal = retVal + "_" + biography.getDescription().trim();
        }
        if ((index = this.getIndexOfAttachmentAlreadyAdded(retVal)) > 0) {
            retVal = retVal + index;
        }
        return retVal;
    }

    private static synchronized HashValueDocument.HashValue createHashValue(String hashValueStr) {
        HashValueDocument.HashValue hashValue = null;
        hashValue = HashValueDocument.HashValue.Factory.newInstance();
        hashValue.setHashAlgorithm("SHA-1");
        try {
            hashValue.setByteArrayValue(Base64.decode((String)hashValueStr));
        }
        catch (Base64DecodingException base64DecodingException) {
            // empty catch block
        }
        return hashValue;
    }

    protected static final String computeAttachmentHash(byte[] attachment) {
        Init.init();
        try {
            MessageDigest messageDigester = MessageDigest.getInstance("SHA-1");
            byte[] rawDigest = messageDigester.digest(attachment);
            return Base64.encode((byte[])rawDigest);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    protected AttachedFileDataType getAttachedFileType(Narrative narrative) {
        AttachedFileDataType attachedFileDataType = null;
        byte[] attachementContent = null;
        narrative.refreshReferenceObject("narrativeAttachmentList");
        if (narrative.getNarrativeAttachmentList() != null && narrative.getNarrativeAttachmentList().size() > 0) {
            attachementContent = ((NarrativeAttachment)narrative.getNarrativeAttachmentList().get(0)).getContent();
        }
        if (attachementContent != null && attachementContent.length > 0) {
            AttachedFileDataType.FileLocation fileLocation = AttachedFileDataType.FileLocation.Factory.newInstance();
            String contentId = this.createContentId(narrative);
            fileLocation.setHref(contentId);
            attachedFileDataType = AttachedFileDataType.Factory.newInstance();
            attachedFileDataType.setFileLocation(fileLocation);
            attachedFileDataType.setFileName(narrative.getFileName());
            attachedFileDataType.setMimeType("application/octet-stream");
            narrative.refreshReferenceObject("narrativeAttachmentList");
            attachedFileDataType.setHashValue(this.getHashValue(attachementContent));
            AttachmentData attachmentData = new AttachmentData();
            attachmentData.setContent(attachementContent);
            attachmentData.setContentId(contentId);
            attachmentData.setContentType("application/octet-stream");
            attachmentData.setFileName(narrative.getFileName());
            this.addAttachment(attachmentData);
        }
        return attachedFileDataType;
    }

    protected AttachedFileDataType[] getAttachedFileDataTypes(String narrativeTypeCode) {
        int size = 0;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || !narrative.getNarrativeTypeCode().equals(narrativeTypeCode)) continue;
            ++size;
        }
        AttachedFileDataType[] attachedFileDataTypes = new AttachedFileDataType[size];
        int attachments = 0;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || !narrative.getNarrativeTypeCode().equals(narrativeTypeCode)) continue;
            attachedFileDataTypes[attachments] = this.getAttachedFileType(narrative);
            ++attachments;
        }
        return attachedFileDataTypes;
    }

    protected AttachedFileDataType getAttachedFileDataType(String narrativeTypeCode) {
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || !narrative.getNarrativeTypeCode().equals(narrativeTypeCode)) continue;
            return this.getAttachedFileType(narrative);
        }
        return null;
    }

    protected AttachedFileDataType getPernonnelAttachments(ProposalDevelopmentDocument pdDoc, String personId, Integer rolodexId, String documentType) {
        boolean personBiographyFound = false;
        for (ProposalPersonBiography proposalPersonBiography : pdDoc.getDevelopmentProposal().getPropPersonBios()) {
            if (personId != null && proposalPersonBiography.getPersonId() != null && proposalPersonBiography.getPersonId().equals(personId) && documentType.equals(proposalPersonBiography.getDocumentTypeCode())) {
                personBiographyFound = true;
            } else if (rolodexId != null && proposalPersonBiography.getRolodexId() != null && proposalPersonBiography.getRolodexId().toString().equals(rolodexId.toString()) && documentType.equals(proposalPersonBiography.getDocumentTypeCode())) {
                personBiographyFound = true;
            }
            if (!personBiographyFound) continue;
            AttachedFileDataType.FileLocation fileLocation = AttachedFileDataType.FileLocation.Factory.newInstance();
            String contentId = this.createContentId(proposalPersonBiography);
            fileLocation.setHref(contentId);
            AttachedFileDataType attachedFileDataType = AttachedFileDataType.Factory.newInstance();
            attachedFileDataType.setFileLocation(fileLocation);
            attachedFileDataType.setFileName(proposalPersonBiography.getFileName());
            attachedFileDataType.setMimeType("application/octet-stream");
            proposalPersonBiography.refreshReferenceObject("personnelAttachmentList");
            attachedFileDataType.setHashValue(this.getHashValue(((ProposalPersonBiographyAttachment)proposalPersonBiography.getPersonnelAttachmentList().get(0)).getContent()));
            AttachmentData attachmentData = new AttachmentData();
            attachmentData.setContent(((ProposalPersonBiographyAttachment)proposalPersonBiography.getPersonnelAttachmentList().get(0)).getContent());
            attachmentData.setContentId(contentId);
            attachmentData.setContentType("application/octet-stream");
            attachmentData.setFileName(proposalPersonBiography.getFileName());
            this.addAttachment(attachmentData);
            return attachedFileDataType;
        }
        return null;
    }

    public List<AuditError> getAuditErrors() {
        return this.auditErrors;
    }

    public void setAuditErrors(List<AuditError> auditErrors) {
        this.auditErrors = auditErrors;
    }

    protected boolean isSponsorNIH(ProposalDevelopmentDocument document) {
        SponsorService sponsorService = (SponsorService)KraServiceLocator.getService(SponsorService.class);
        return sponsorService.isSponsorNihMultiplePi((Sponsorable)document.getDevelopmentProposal());
    }

    protected Narrative saveNarrative(byte[] attachment, String narrativeTypeCode, String fileName, String comment) {
        Narrative narrative = null;
        narrative = new Narrative();
        narrative.setModuleStatusCode("C");
        narrative.setNarrativeTypeCode(narrativeTypeCode);
        narrative.setComments(comment);
        narrative.setModuleTitle(comment);
        NarrativeType narrativeType = new NarrativeType();
        narrativeType.setDescription(comment);
        narrativeType.setSystemGenerated("Y");
        narrativeType.setNarrativeTypeCode(narrativeTypeCode);
        narrative.setNarrativeType(narrativeType);
        narrative.setModuleSequenceNumber(this.getNextModuleSequenceNumber(this.pdDoc));
        NarrativeAttachment narrativeAttachment = new NarrativeAttachment();
        narrativeAttachment.setContentType("application/octet-stream");
        narrativeAttachment.setNarrativeData(attachment);
        narrativeAttachment.setFileName(fileName);
        narrative.setFileName(fileName);
        narrative.getNarrativeAttachmentList().add(narrativeAttachment);
        ((NarrativeService)KraServiceLocator.getService(NarrativeService.class)).addNarrative(this.pdDoc, narrative);
        return narrative;
    }

    private Integer getNextModuleSequenceNumber(ProposalDevelopmentDocument proposaldevelopmentDocument) {
        List narrativeList = proposaldevelopmentDocument.getDevelopmentProposal().getNarratives();
        List instituteAttachmentsList = proposaldevelopmentDocument.getDevelopmentProposal().getInstituteAttachments();
        ArrayList mergedNarrativeList = new ArrayList();
        mergedNarrativeList.addAll(narrativeList);
        mergedNarrativeList.addAll(instituteAttachmentsList);
        if (mergedNarrativeList.isEmpty()) {
            return 1;
        }
        Collections.sort(mergedNarrativeList, new /* Unavailable Anonymous Inner Class!! */);
        return ((Narrative)mergedNarrativeList.get(mergedNarrativeList.size() - 1)).getModuleSequenceNumber() + 1;
    }

    public void setAttachments(List<AttachmentData> attachments) {
        this.attachments = attachments;
    }

    public List<AnswerHeader> getQuestionnaireAnswers(DevelopmentProposal proposal, boolean finalDoc) {
        ProposalDevelopmentModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalDevelopmentModuleQuestionnaireBean(this.pdDoc.getDevelopmentProposal());
        QuestionnaireAnswerService questionnaireAnswerService = (QuestionnaireAnswerService)KraServiceLocator.getService(QuestionnaireAnswerService.class);
        return questionnaireAnswerService.getQuestionnaireAnswer((ModuleQuestionnaireBean)moduleQuestionnaireBean);
    }

    public void sortAttachments(ByteArrayInputStream byteArrayInputStream) {
        ArrayList<String> attachmentNameList = new ArrayList<String>();
        List attacmentList = this.getAttachments();
        ArrayList<AttachmentData> tempAttacmentList = new ArrayList<AttachmentData>();
        try {
            DocumentBuilderFactory domParserFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder domParser = domParserFactory.newDocumentBuilder();
            Document document = domParser.parse(byteArrayInputStream);
            byteArrayInputStream.close();
            NodeList fileLocationList = document.getElementsByTagName("att:FileLocation");
            for (int itemLocation = 0; itemLocation < fileLocationList.getLength(); ++itemLocation) {
                String attachmentName = fileLocationList.item(itemLocation).getAttributes().item(0).getNodeValue();
                String[] name = attachmentName.split("-");
                String fileName = name[name.length - 1];
                attachmentNameList.add(fileName);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        for (String attachmentName : attachmentNameList) {
            for (AttachmentData attachment : attacmentList) {
                String[] names = attachment.getContentId().split("-");
                String fileName = names[names.length - 1];
                if (!fileName.equalsIgnoreCase(attachmentName)) continue;
                tempAttacmentList.add(attachment);
            }
        }
        if (tempAttacmentList.size() > 0) {
            this.attachments.clear();
            for (AttachmentData tempAttachment : tempAttacmentList) {
                this.attachments.add(tempAttachment);
            }
        }
    }
}

