/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.cd511V11.CD511Document;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.service.S2SUtilService;

public class CD511V1_1Generator
extends S2SBaseFormGenerator {
    private S2SUtilService s2sUtilService = (S2SUtilService)KraServiceLocator.getService(S2SUtilService.class);
    private DepartmentalPerson aorInfo;

    private CD511Document getcd511Document() {
        CD511Document cd511Document = CD511Document.Factory.newInstance();
        CD511Document.CD511 cd511 = CD511Document.CD511.Factory.newInstance();
        cd511.setFormVersion("1.1");
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            cd511.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
        }
        if (this.pdDoc.getDevelopmentProposal().getCurrentAwardNumber() != null && !this.pdDoc.getDevelopmentProposal().getCurrentAwardNumber().equals("")) {
            cd511.setAwardNumber(this.pdDoc.getDevelopmentProposal().getCurrentAwardNumber());
        }
        if (this.pdDoc.getDevelopmentProposal().getTitle() != null && !this.pdDoc.getDevelopmentProposal().getTitle().equals("")) {
            cd511.setProjectName(this.pdDoc.getDevelopmentProposal().getTitle());
        }
        String title = "";
        if (this.aorInfo != null) {
            cd511.setContactName(this.globLibV20Generator.getHumanNameDataType(this.aorInfo));
            if (this.aorInfo.getPrimaryTitle() != null && !this.aorInfo.getPrimaryTitle().equals("")) {
                title = this.aorInfo.getPrimaryTitle();
            }
        }
        cd511.setTitle(title);
        cd511.setSignature("  ");
        cd511.setSubmittedDate(this.s2sUtilService.getCurrentCalendar());
        cd511Document.setCD511(cd511);
        return cd511Document;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.s2sUtilService.getDepartmentalPerson(this.pdDoc);
        return this.getcd511Document();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        CD511Document cd511Document = CD511Document.Factory.newInstance();
        CD511Document.CD511 cd511 = (CD511Document.CD511)xmlObject;
        cd511Document.setCD511(cd511);
        return cd511Document;
    }
}

