/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.ed524BudgetV11.ED524BudgetDocument;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.impl.ED524BudgetBaseGenerator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class ED524BudgetV1_1Generator
extends ED524BudgetBaseGenerator {
    private static final Log LOG = LogFactory.getLog(ED524BudgetV1_1Generator.class);

    private ED524BudgetDocument getED524Budget() {
        ED524BudgetDocument ed524BudgetDocument = ED524BudgetDocument.Factory.newInstance();
        ED524BudgetDocument.ED524Budget ed524Budget = ED524BudgetDocument.ED524Budget.Factory.newInstance();
        ed524Budget.setFormVersion("1.1");
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            ed524Budget.setLEGALNAME(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
        } else {
            ed524Budget.setLEGALNAME("NONE");
        }
        BudgetDecimal totalCategoryCS = BudgetDecimal.ZERO;
        BudgetDecimal totalPersonnel = BudgetDecimal.ZERO;
        BudgetDecimal totalPersonnelCS = BudgetDecimal.ZERO;
        BudgetDecimal totalFringe = BudgetDecimal.ZERO;
        BudgetDecimal totalFringeCS = BudgetDecimal.ZERO;
        BudgetDecimal totalTravel = BudgetDecimal.ZERO;
        BudgetDecimal totalTravelCS = BudgetDecimal.ZERO;
        BudgetDecimal totalEquip = BudgetDecimal.ZERO;
        BudgetDecimal totalEquipCS = BudgetDecimal.ZERO;
        BudgetDecimal totalSupplies = BudgetDecimal.ZERO;
        BudgetDecimal totalSuppliesCS = BudgetDecimal.ZERO;
        BudgetDecimal totalContractual = BudgetDecimal.ZERO;
        BudgetDecimal totalContractualCS = BudgetDecimal.ZERO;
        BudgetDecimal totalConstruction = BudgetDecimal.ZERO;
        BudgetDecimal totalConstructionCS = BudgetDecimal.ZERO;
        BudgetDecimal totalOther = BudgetDecimal.ZERO;
        BudgetDecimal totalOtherCS = BudgetDecimal.ZERO;
        BudgetDecimal totalTraining = BudgetDecimal.ZERO;
        BudgetDecimal totalTrainingCS = BudgetDecimal.ZERO;
        BudgetDecimal totalCostAllYrs = BudgetDecimal.ZERO;
        BudgetDecimal totalCostSharingAllYrs = BudgetDecimal.ZERO;
        BudgetDecimal totalDirectCostAllYrs = BudgetDecimal.ZERO;
        BudgetDecimal totalDirectCostAllYrsCS = BudgetDecimal.ZERO;
        BudgetDecimal totalIndirectCostAllYrs = BudgetDecimal.ZERO;
        BudgetDecimal totalIndirectCostAllYrsCS = BudgetDecimal.ZERO;
        BudgetDocument budgetDoc = null;
        try {
            budgetDoc = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return ed524BudgetDocument;
        }
        if (budgetDoc == null) {
            return ed524BudgetDocument;
        }
        Budget budget = budgetDoc.getBudget();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetPeriod().equals(1)) {
                this.getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalFirstYearAmount(this.totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFirstYearAmount(this.totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectFirstYearAmount(this.totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectFirstYearAmount(this.totalIndirectCost.bigDecimalValue());
                totalCostAllYrs = (BudgetDecimal)totalCostAllYrs.add((AbstractKualiDecimal)this.totalCost);
                totalCostSharingAllYrs = (BudgetDecimal)totalCostSharingAllYrs.add((AbstractKualiDecimal)this.totalCostSharing);
                totalDirectCostAllYrs = (BudgetDecimal)totalDirectCostAllYrs.add((AbstractKualiDecimal)this.totalDirectCost);
                totalIndirectCostAllYrs = (BudgetDecimal)totalIndirectCostAllYrs.add((AbstractKualiDecimal)this.totalIndirectCost);
                this.getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectFirstYearAmount(this.indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = (BudgetDecimal)totalIndirectCostAllYrsCS.add((AbstractKualiDecimal)this.indirectCS);
                this.getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesFirstYearAmount(this.supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesFirstYearAmount(this.supplyCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.supplyCostCS);
                totalSupplies = (BudgetDecimal)totalSupplies.add((AbstractKualiDecimal)this.supplyCost);
                totalSuppliesCS = (BudgetDecimal)totalSuppliesCS.add((AbstractKualiDecimal)this.supplyCostCS);
                ed524Budget.setBudgetFederalConstructionFirstYearAmount(BudgetDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionFirstYearAmount(BudgetDecimal.ZERO.bigDecimalValue());
                this.getOtherCosts(budgetPeriod);
                ed524Budget.setBudgetFederalOtherFirstYearAmount(this.otherCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalOtherFirstYearAmount(this.otherCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.otherCostCS);
                totalOther = (BudgetDecimal)totalOther.add((AbstractKualiDecimal)this.otherCost);
                totalOtherCS = (BudgetDecimal)totalOtherCS.add((AbstractKualiDecimal)this.otherCostCS);
                this.getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentFirstYearAmount(this.equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentFirstYearAmount(this.equipmentCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.equipmentCostCS);
                totalEquip = (BudgetDecimal)totalEquip.add((AbstractKualiDecimal)this.equipmentCost);
                totalEquipCS = (BudgetDecimal)totalEquipCS.add((AbstractKualiDecimal)this.equipmentCostCS);
                this.getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualFirstYearAmount(this.contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualFirstYearAmount(this.contractualCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.contractualCostCS);
                totalContractual = (BudgetDecimal)totalContractual.add((AbstractKualiDecimal)this.contractualCost);
                totalContractualCS = (BudgetDecimal)totalContractualCS.add((AbstractKualiDecimal)this.contractualCostCS);
                this.getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelFirstYearAmount(this.travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelFirstYearAmount(this.travelCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.travelCostCS);
                totalTravel = (BudgetDecimal)totalTravel.add((AbstractKualiDecimal)this.travelCost);
                totalTravelCS = (BudgetDecimal)totalTravelCS.add((AbstractKualiDecimal)this.travelCostCS);
                this.getTrainingCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTrainingFirstYearAmount(this.trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingFirstYearAmount(this.trainingCostCS.bigDecimalValue());
                totalTraining = (BudgetDecimal)totalTraining.add((AbstractKualiDecimal)this.trainingCost);
                totalTrainingCS = (BudgetDecimal)totalTrainingCS.add((AbstractKualiDecimal)this.trainingCostCS);
                ed524Budget.setBudgetFederalFringeFirstYearAmount(this.categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeFirstYearAmount(this.categoryCostCSFringe.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.categoryCostCSFringe);
                totalFringe = (BudgetDecimal)totalFringe.add((AbstractKualiDecimal)this.categoryCostFringe);
                totalFringeCS = (BudgetDecimal)totalFringeCS.add((AbstractKualiDecimal)this.categoryCostCSFringe);
                this.getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelFirstYearAmount(this.personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelFirstYearAmount(this.personnelCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.personnelCostCS);
                totalPersonnel = (BudgetDecimal)totalPersonnel.add((AbstractKualiDecimal)this.personnelCost);
                totalPersonnelCS = (BudgetDecimal)totalPersonnelCS.add((AbstractKualiDecimal)this.personnelCostCS);
                ed524Budget.setBudgetNonFederalDirectFirstYearAmount(totalCategoryCS.bigDecimalValue());
                continue;
            }
            if (budgetPeriod.getBudgetPeriod().equals(2)) {
                totalCategoryCS = BudgetDecimal.ZERO;
                this.getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSecondYearAmount(this.totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSecondYearAmount(this.totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectSecondYearAmount(this.totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectSecondYearAmount(this.totalIndirectCost.bigDecimalValue());
                totalCostAllYrs = (BudgetDecimal)totalCostAllYrs.add((AbstractKualiDecimal)this.totalCost);
                totalCostSharingAllYrs = (BudgetDecimal)totalCostSharingAllYrs.add((AbstractKualiDecimal)this.totalCostSharing);
                totalDirectCostAllYrs = (BudgetDecimal)totalDirectCostAllYrs.add((AbstractKualiDecimal)this.totalDirectCost);
                totalIndirectCostAllYrs = (BudgetDecimal)totalIndirectCostAllYrs.add((AbstractKualiDecimal)this.totalIndirectCost);
                this.getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectSecondYearAmount(this.indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = (BudgetDecimal)totalIndirectCostAllYrsCS.add((AbstractKualiDecimal)this.indirectCS);
                this.getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesSecondYearAmount(this.supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesSecondYearAmount(this.supplyCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.supplyCostCS);
                totalSupplies = (BudgetDecimal)totalSupplies.add((AbstractKualiDecimal)this.supplyCost);
                totalSuppliesCS = (BudgetDecimal)totalSuppliesCS.add((AbstractKualiDecimal)this.supplyCostCS);
                ed524Budget.setBudgetFederalConstructionSecondYearAmount(BudgetDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionSecondYearAmount(BudgetDecimal.ZERO.bigDecimalValue());
                this.getOtherCosts(budgetPeriod);
                if (this.otherCost.longValue() < 0L) {
                    ed524Budget.setBudgetFederalOtherSecondYearAmount(BigDecimal.ZERO);
                } else {
                    ed524Budget.setBudgetFederalOtherSecondYearAmount(this.otherCost.bigDecimalValue());
                }
                ed524Budget.setBudgetNonFederalOtherSecondYearAmount(this.otherCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.otherCostCS);
                totalOther = (BudgetDecimal)totalOther.add((AbstractKualiDecimal)this.otherCost);
                totalOtherCS = (BudgetDecimal)totalOtherCS.add((AbstractKualiDecimal)this.otherCostCS);
                this.getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentSecondYearAmount(this.equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentSecondYearAmount(this.equipmentCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.equipmentCostCS);
                totalEquip = (BudgetDecimal)totalEquip.add((AbstractKualiDecimal)this.equipmentCost);
                totalEquipCS = (BudgetDecimal)totalEquipCS.add((AbstractKualiDecimal)this.equipmentCostCS);
                this.getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualSecondYearAmount(this.contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualSecondYearAmount(this.contractualCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.contractualCostCS);
                totalContractual = (BudgetDecimal)totalContractual.add((AbstractKualiDecimal)this.contractualCost);
                totalContractualCS = (BudgetDecimal)totalContractualCS.add((AbstractKualiDecimal)this.contractualCostCS);
                this.getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelSecondYearAmount(this.travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelSecondYearAmount(this.travelCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.travelCostCS);
                totalTravel = (BudgetDecimal)totalTravel.add((AbstractKualiDecimal)this.travelCost);
                totalTravelCS = (BudgetDecimal)totalTravelCS.add((AbstractKualiDecimal)this.travelCostCS);
                ed524Budget.setBudgetFederalTrainingSecondYearAmount(this.trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingSecondYearAmount(this.trainingCostCS.bigDecimalValue());
                totalTraining = (BudgetDecimal)totalTraining.add((AbstractKualiDecimal)this.trainingCost);
                totalTrainingCS = (BudgetDecimal)totalTrainingCS.add((AbstractKualiDecimal)this.trainingCostCS);
                ed524Budget.setBudgetFederalFringeSecondYearAmount(this.categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeSecondYearAmount(this.categoryCostCSFringe.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.categoryCostCSFringe);
                totalFringe = (BudgetDecimal)totalFringe.add((AbstractKualiDecimal)this.categoryCostFringe);
                totalFringeCS = (BudgetDecimal)totalFringeCS.add((AbstractKualiDecimal)this.categoryCostCSFringe);
                this.getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelSecondYearAmount(this.personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelSecondYearAmount(this.personnelCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.personnelCostCS);
                totalPersonnel = (BudgetDecimal)totalPersonnel.add((AbstractKualiDecimal)this.personnelCost);
                totalPersonnelCS = (BudgetDecimal)totalPersonnelCS.add((AbstractKualiDecimal)this.personnelCostCS);
                ed524Budget.setBudgetNonFederalDirectSecondYearAmount(totalCategoryCS.bigDecimalValue());
                continue;
            }
            if (budgetPeriod.getBudgetPeriod().equals(3)) {
                totalCategoryCS = BudgetDecimal.ZERO;
                this.getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalThirdYearAmount(this.totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalThirdYearAmount(this.totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectThirdYearAmount(this.totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectThirdYearAmount(this.totalIndirectCost.bigDecimalValue());
                totalCostAllYrs = (BudgetDecimal)totalCostAllYrs.add((AbstractKualiDecimal)this.totalCost);
                totalCostSharingAllYrs = (BudgetDecimal)totalCostSharingAllYrs.add((AbstractKualiDecimal)this.totalCostSharing);
                totalDirectCostAllYrs = (BudgetDecimal)totalDirectCostAllYrs.add((AbstractKualiDecimal)this.totalDirectCost);
                totalIndirectCostAllYrs = (BudgetDecimal)totalIndirectCostAllYrs.add((AbstractKualiDecimal)this.totalIndirectCost);
                this.getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectThirdYearAmount(this.indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = (BudgetDecimal)totalIndirectCostAllYrsCS.add((AbstractKualiDecimal)this.indirectCS);
                this.getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesThirdYearAmount(this.supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesThirdYearAmount(this.supplyCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.supplyCostCS);
                totalSupplies = (BudgetDecimal)totalSupplies.add((AbstractKualiDecimal)this.supplyCost);
                totalSuppliesCS = (BudgetDecimal)totalSuppliesCS.add((AbstractKualiDecimal)this.supplyCostCS);
                ed524Budget.setBudgetFederalConstructionThirdYearAmount(BudgetDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionThirdYearAmount(BudgetDecimal.ZERO.bigDecimalValue());
                this.getOtherCosts(budgetPeriod);
                if (this.otherCost.longValue() < 0L) {
                    ed524Budget.setBudgetFederalOtherThirdYearAmount(BigDecimal.ZERO);
                } else {
                    ed524Budget.setBudgetFederalOtherThirdYearAmount(this.otherCost.bigDecimalValue());
                }
                ed524Budget.setBudgetNonFederalOtherThirdYearAmount(this.otherCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.otherCostCS);
                totalOther = (BudgetDecimal)totalOther.add((AbstractKualiDecimal)this.otherCost);
                totalOtherCS = (BudgetDecimal)totalOtherCS.add((AbstractKualiDecimal)this.otherCostCS);
                this.getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentThirdYearAmount(this.equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentThirdYearAmount(this.equipmentCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.equipmentCostCS);
                totalEquip = (BudgetDecimal)totalEquip.add((AbstractKualiDecimal)this.equipmentCost);
                totalEquipCS = (BudgetDecimal)totalEquipCS.add((AbstractKualiDecimal)this.equipmentCostCS);
                this.getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualThirdYearAmount(this.contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualThirdYearAmount(this.contractualCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.contractualCostCS);
                totalContractual = (BudgetDecimal)totalContractual.add((AbstractKualiDecimal)this.contractualCost);
                totalContractualCS = (BudgetDecimal)totalContractualCS.add((AbstractKualiDecimal)this.contractualCostCS);
                this.getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelThirdYearAmount(this.travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelThirdYearAmount(this.travelCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.travelCostCS);
                totalTravel = (BudgetDecimal)totalTravel.add((AbstractKualiDecimal)this.travelCost);
                totalTravelCS = (BudgetDecimal)totalTravelCS.add((AbstractKualiDecimal)this.travelCostCS);
                ed524Budget.setBudgetFederalTrainingThirdYearAmount(this.trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingThirdYearAmount(this.trainingCostCS.bigDecimalValue());
                totalTraining = (BudgetDecimal)totalTraining.add((AbstractKualiDecimal)this.trainingCost);
                totalTrainingCS = (BudgetDecimal)totalTrainingCS.add((AbstractKualiDecimal)this.trainingCostCS);
                ed524Budget.setBudgetFederalFringeThirdYearAmount(this.categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeThirdYearAmount(this.categoryCostCSFringe.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.categoryCostCSFringe);
                totalFringe = (BudgetDecimal)totalFringe.add((AbstractKualiDecimal)this.categoryCostFringe);
                totalFringeCS = (BudgetDecimal)totalFringeCS.add((AbstractKualiDecimal)this.categoryCostCSFringe);
                this.getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelThirdYearAmount(this.personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelThirdYearAmount(this.personnelCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.personnelCostCS);
                totalPersonnel = (BudgetDecimal)totalPersonnel.add((AbstractKualiDecimal)this.personnelCost);
                totalPersonnelCS = (BudgetDecimal)totalPersonnelCS.add((AbstractKualiDecimal)this.personnelCostCS);
                ed524Budget.setBudgetNonFederalDirectThirdYearAmount(totalCategoryCS.bigDecimalValue());
                continue;
            }
            if (budgetPeriod.getBudgetPeriod().equals(4)) {
                totalCategoryCS = BudgetDecimal.ZERO;
                this.getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalFourthYearAmount(this.totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFourthYearAmount(this.totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectFourthYearAmount(this.totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectFourthYearAmount(this.totalIndirectCost.bigDecimalValue());
                totalCostAllYrs = (BudgetDecimal)totalCostAllYrs.add((AbstractKualiDecimal)this.totalCost);
                totalCostSharingAllYrs = (BudgetDecimal)totalCostSharingAllYrs.add((AbstractKualiDecimal)this.totalCostSharing);
                totalDirectCostAllYrs = (BudgetDecimal)totalDirectCostAllYrs.add((AbstractKualiDecimal)this.totalDirectCost);
                totalIndirectCostAllYrs = (BudgetDecimal)totalIndirectCostAllYrs.add((AbstractKualiDecimal)this.totalIndirectCost);
                this.getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectFourthYearAmount(this.indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = (BudgetDecimal)totalIndirectCostAllYrsCS.add((AbstractKualiDecimal)this.indirectCS);
                this.getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesFourthYearAmount(this.supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesFourthYearAmount(this.supplyCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.supplyCostCS);
                totalSupplies = (BudgetDecimal)totalSupplies.add((AbstractKualiDecimal)this.supplyCost);
                totalSuppliesCS = (BudgetDecimal)totalSuppliesCS.add((AbstractKualiDecimal)this.supplyCostCS);
                ed524Budget.setBudgetFederalConstructionFourthYearAmount(BudgetDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionFourthYearAmount(BudgetDecimal.ZERO.bigDecimalValue());
                this.getOtherCosts(budgetPeriod);
                ed524Budget.setBudgetFederalOtherFourthYearAmount(this.otherCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalOtherFourthYearAmount(this.otherCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.otherCostCS);
                totalOther = (BudgetDecimal)totalOther.add((AbstractKualiDecimal)this.otherCost);
                totalOtherCS = (BudgetDecimal)totalOtherCS.add((AbstractKualiDecimal)this.otherCostCS);
                this.getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentFourthYearAmount(this.equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentFourthYearAmount(this.equipmentCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.equipmentCostCS);
                totalEquip = (BudgetDecimal)totalEquip.add((AbstractKualiDecimal)this.equipmentCost);
                totalEquipCS = (BudgetDecimal)totalEquipCS.add((AbstractKualiDecimal)this.equipmentCostCS);
                this.getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualFourthYearAmount(this.contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualFourthYearAmount(this.contractualCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.contractualCostCS);
                totalContractual = (BudgetDecimal)totalContractual.add((AbstractKualiDecimal)this.contractualCost);
                totalContractualCS = (BudgetDecimal)totalContractualCS.add((AbstractKualiDecimal)this.contractualCostCS);
                this.getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelFourthYearAmount(this.travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelFourthYearAmount(this.travelCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.travelCostCS);
                totalTravel = (BudgetDecimal)totalTravel.add((AbstractKualiDecimal)this.travelCost);
                totalTravelCS = (BudgetDecimal)totalTravelCS.add((AbstractKualiDecimal)this.travelCostCS);
                ed524Budget.setBudgetFederalTrainingFourthYearAmount(this.trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingFourthYearAmount(this.trainingCostCS.bigDecimalValue());
                totalTraining = (BudgetDecimal)totalTraining.add((AbstractKualiDecimal)this.trainingCost);
                totalTrainingCS = (BudgetDecimal)totalTrainingCS.add((AbstractKualiDecimal)this.trainingCostCS);
                ed524Budget.setBudgetFederalFringeFourthYearAmount(this.categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeFourthYearAmount(this.categoryCostCSFringe.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.categoryCostCSFringe);
                totalFringe = (BudgetDecimal)totalFringe.add((AbstractKualiDecimal)this.categoryCostFringe);
                totalFringeCS = (BudgetDecimal)totalFringeCS.add((AbstractKualiDecimal)this.categoryCostCSFringe);
                this.getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelFourthYearAmount(this.personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelFourthYearAmount(this.personnelCostCS.bigDecimalValue());
                totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.personnelCostCS);
                totalPersonnel = (BudgetDecimal)totalPersonnel.add((AbstractKualiDecimal)this.personnelCost);
                totalPersonnelCS = (BudgetDecimal)totalPersonnelCS.add((AbstractKualiDecimal)this.personnelCostCS);
                ed524Budget.setBudgetNonFederalDirectFourthYearAmount(totalCategoryCS.bigDecimalValue());
                continue;
            }
            if (!budgetPeriod.getBudgetPeriod().equals(5)) continue;
            totalCategoryCS = BudgetDecimal.ZERO;
            this.getTotalCosts(budgetPeriod);
            ed524Budget.setBudgetFederalFifthYearAmount(this.totalCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalFifthYearAmount(this.totalCostSharing.bigDecimalValue());
            ed524Budget.setBudgetFederalDirectFifthYearAmount(this.totalDirectCost.bigDecimalValue());
            ed524Budget.setBudgetFederalIndirectFifthYearAmount(this.totalIndirectCost.bigDecimalValue());
            totalCostAllYrs = (BudgetDecimal)totalCostAllYrs.add((AbstractKualiDecimal)this.totalCost);
            totalCostSharingAllYrs = (BudgetDecimal)totalCostSharingAllYrs.add((AbstractKualiDecimal)this.totalCostSharing);
            totalDirectCostAllYrs = (BudgetDecimal)totalDirectCostAllYrs.add((AbstractKualiDecimal)this.totalDirectCost);
            totalIndirectCostAllYrs = (BudgetDecimal)totalIndirectCostAllYrs.add((AbstractKualiDecimal)this.totalIndirectCost);
            this.getIndirectCosts(budgetPeriod);
            ed524Budget.setBudgetNonFederalIndirectFifthYearAmount(this.indirectCS.bigDecimalValue());
            totalIndirectCostAllYrsCS.add((AbstractKualiDecimal)this.indirectCS);
            this.getSuppliesCosts(budgetPeriod);
            ed524Budget.setBudgetFederalSuppliesFifthYearAmount(this.supplyCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalSuppliesFifthYearAmount(this.supplyCostCS.bigDecimalValue());
            totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.supplyCostCS);
            totalSupplies = (BudgetDecimal)totalSupplies.add((AbstractKualiDecimal)this.supplyCost);
            totalSuppliesCS = (BudgetDecimal)totalSuppliesCS.add((AbstractKualiDecimal)this.supplyCostCS);
            ed524Budget.setBudgetFederalConstructionFifthYearAmount(BudgetDecimal.ZERO.bigDecimalValue());
            ed524Budget.setBudgetNonFederalConstructionFifthYearAmount(BudgetDecimal.ZERO.bigDecimalValue());
            this.getOtherCosts(budgetPeriod);
            ed524Budget.setBudgetFederalOtherFifthYearAmount(this.otherCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalOtherFifthYearAmount(this.otherCostCS.bigDecimalValue());
            totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.otherCostCS);
            totalOther = (BudgetDecimal)totalOther.add((AbstractKualiDecimal)this.otherCost);
            totalOtherCS = (BudgetDecimal)totalOtherCS.add((AbstractKualiDecimal)this.otherCostCS);
            this.getEquipmentCosts(budgetPeriod);
            ed524Budget.setBudgetFederalEquipmentFifthYearAmount(this.equipmentCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalEquipmentFifthYearAmount(this.equipmentCostCS.bigDecimalValue());
            totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.equipmentCostCS);
            totalEquip = (BudgetDecimal)totalEquip.add((AbstractKualiDecimal)this.equipmentCost);
            totalEquipCS = (BudgetDecimal)totalEquipCS.add((AbstractKualiDecimal)this.equipmentCostCS);
            this.getContractualCosts(budgetPeriod);
            ed524Budget.setBudgetFederalContractualFifthYearAmount(this.contractualCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalContractualFifthYearAmount(this.contractualCostCS.bigDecimalValue());
            totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.contractualCostCS);
            totalContractual = (BudgetDecimal)totalContractual.add((AbstractKualiDecimal)this.contractualCost);
            totalContractualCS = (BudgetDecimal)totalContractualCS.add((AbstractKualiDecimal)this.contractualCostCS);
            this.getTravelCosts(budgetPeriod);
            ed524Budget.setBudgetFederalTravelFifthYearAmount(this.travelCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalTravelFifthYearAmount(this.travelCostCS.bigDecimalValue());
            totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.travelCostCS);
            totalTravel = (BudgetDecimal)totalTravel.add((AbstractKualiDecimal)this.travelCost);
            totalTravelCS = (BudgetDecimal)totalTravelCS.add((AbstractKualiDecimal)this.travelCostCS);
            ed524Budget.setBudgetFederalTrainingFifthYearAmount(this.trainingCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalTrainingFifthYearAmount(this.trainingCostCS.bigDecimalValue());
            totalTraining = (BudgetDecimal)totalTraining.add((AbstractKualiDecimal)this.trainingCost);
            totalTrainingCS = (BudgetDecimal)totalTrainingCS.add((AbstractKualiDecimal)this.trainingCostCS);
            ed524Budget.setBudgetFederalFringeFifthYearAmount(this.categoryCostFringe.bigDecimalValue());
            ed524Budget.setBudgetNonFederalFringeFifthYearAmount(this.categoryCostCSFringe.bigDecimalValue());
            totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.categoryCostCSFringe);
            totalFringe = (BudgetDecimal)totalFringe.add((AbstractKualiDecimal)this.categoryCostFringe);
            totalFringeCS = (BudgetDecimal)totalFringeCS.add((AbstractKualiDecimal)this.categoryCostCSFringe);
            this.getPersonnelCosts(budgetPeriod);
            ed524Budget.setBudgetFederalPersonnelFifthYearAmount(this.personnelCost.bigDecimalValue());
            ed524Budget.setBudgetNonFederalPersonnelFifthYearAmount(this.personnelCostCS.bigDecimalValue());
            totalCategoryCS = (BudgetDecimal)totalCategoryCS.add((AbstractKualiDecimal)this.personnelCostCS);
            totalPersonnel = (BudgetDecimal)totalPersonnel.add((AbstractKualiDecimal)this.personnelCost);
            totalPersonnelCS = (BudgetDecimal)totalPersonnelCS.add((AbstractKualiDecimal)this.personnelCostCS);
            ed524Budget.setBudgetNonFederalDirectFifthYearAmount(totalCategoryCS.bigDecimalValue());
        }
        ed524Budget.setBudgetFederalPersonnelTotalAmount(totalPersonnel.bigDecimalValue());
        ed524Budget.setBudgetNonFederalPersonnelTotalAmount(totalPersonnelCS.bigDecimalValue());
        ed524Budget.setBudgetFederalFringeTotalAmount(totalFringe.bigDecimalValue());
        ed524Budget.setBudgetNonFederalFringeTotalAmount(totalFringeCS.bigDecimalValue());
        ed524Budget.setBudgetFederalTravelTotalAmount(totalTravel.bigDecimalValue());
        ed524Budget.setBudgetNonFederalTravelTotalAmount(totalTravelCS.bigDecimalValue());
        ed524Budget.setBudgetFederalEquipmentTotalAmount(totalEquip.bigDecimalValue());
        ed524Budget.setBudgetNonFederalEquipmentTotalAmount(totalEquipCS.bigDecimalValue());
        ed524Budget.setBudgetFederalContractualTotalAmount(totalContractual.bigDecimalValue());
        ed524Budget.setBudgetNonFederalContractualTotalAmount(totalContractualCS.bigDecimalValue());
        ed524Budget.setBudgetFederalSuppliesTotalAmount(totalSupplies.bigDecimalValue());
        ed524Budget.setBudgetNonFederalSuppliesTotalAmount(totalSuppliesCS.bigDecimalValue());
        ed524Budget.setBudgetFederalConstructionTotalAmount(totalConstruction.bigDecimalValue());
        ed524Budget.setBudgetNonFederalConstructionTotalAmount(totalConstructionCS.bigDecimalValue());
        ed524Budget.setBudgetFederalTrainingTotalAmount(totalTraining.bigDecimalValue());
        ed524Budget.setBudgetNonFederalTrainingTotalAmount(totalTrainingCS.bigDecimalValue());
        if (totalOther.longValue() < 0L) {
            ed524Budget.setBudgetFederalOtherTotalAmount(BigDecimal.ZERO);
        } else {
            ed524Budget.setBudgetFederalOtherTotalAmount(totalOther.bigDecimalValue());
        }
        ed524Budget.setBudgetNonFederalOtherTotalAmount(totalOtherCS.bigDecimalValue());
        totalDirectCostAllYrsCS = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)((BudgetDecimal)((BudgetDecimal)((BudgetDecimal)((BudgetDecimal)totalPersonnelCS.add((AbstractKualiDecimal)totalFringeCS)).add((AbstractKualiDecimal)totalTravelCS)).add((AbstractKualiDecimal)totalEquipCS)).add((AbstractKualiDecimal)totalContractualCS)).add((AbstractKualiDecimal)totalConstructionCS)).add((AbstractKualiDecimal)totalSuppliesCS)).add((AbstractKualiDecimal)totalOtherCS);
        ed524Budget.setBudgetNonFederalDirectTotalAmount(totalDirectCostAllYrsCS.bigDecimalValue());
        ed524Budget.setBudgetNonFederalIndirectTotalAmount(totalIndirectCostAllYrsCS.bigDecimalValue());
        ed524Budget.setBudgetFederalIndirectTotalAmount(totalIndirectCostAllYrs.bigDecimalValue());
        ed524Budget.setBudgetFederalTotalAmount(totalCostAllYrs.bigDecimalValue());
        ed524Budget.setBudgetFederalDirectTotalAmount(totalDirectCostAllYrs.bigDecimalValue());
        ed524Budget.setBudgetNonFederalTotalAmount(totalCostSharingAllYrs.bigDecimalValue());
        ED524BudgetDocument.ED524Budget.IndirectCost indirectCost = ED524BudgetDocument.ED524Budget.IndirectCost.Factory.newInstance();
        ED524BudgetDocument.ED524Budget.IndirectCost.ApprovingFederalAgency approvingFederalAgency = ED524BudgetDocument.ED524Budget.IndirectCost.ApprovingFederalAgency.Factory.newInstance();
        ED524BudgetDocument.ED524Budget.IndirectCost.OtherApprovingFederalAgency otherAgency = ED524BudgetDocument.ED524Budget.IndirectCost.OtherApprovingFederalAgency.Factory.newInstance();
        ED524BudgetDocument.ED524Budget.IndirectCost.IndirectCostRateAgreementFromDate fromDate = ED524BudgetDocument.ED524Budget.IndirectCost.IndirectCostRateAgreementFromDate.Factory.newInstance();
        String restrictedQuestion = " ";
        String agencyName = this.getAgencyName();
        String indirectCostRateAgreement = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getIndirectCostRateAgreement();
        if (indirectCostRateAgreement != null && indirectCostRateAgreement.equals("NONE")) {
            approvingFederalAgency.setIsIndirectCostRateAgreementApproved(YesNoDataType.N_NO);
        } else {
            fromDate.setCalendarValue(this.s2sUtilService.convertDateStringToCalendar(indirectCostRateAgreement));
            fromDate.setIsIndirectCostRateAgreementApproved(YesNoDataType.Y_YES);
            if (fromDate.getCalendarValue() != null) {
                indirectCost.setIndirectCostRateAgreementFromDate(fromDate);
            }
            approvingFederalAgency.setIsIndirectCostRateAgreementApproved(YesNoDataType.Y_YES);
            if (agencyName.equals("ED")) {
                approvingFederalAgency.setStringValue("ED");
            } else {
                approvingFederalAgency.setStringValue("Other");
                otherAgency.setApprovingFederalAgency(ED524BudgetDocument.ED524Budget.IndirectCost.ApprovingFederalAgency.OTHER);
                otherAgency.setStringValue(agencyName);
                indirectCost.setOtherApprovingFederalAgency(otherAgency);
                indirectCost.setIsIndirectCostRateAgreementApproved(YesNoDataType.Y_YES);
                if (restrictedQuestion.length() > 1) {
                    indirectCost.setRestrictedIndirectCostRate(ED524BudgetDocument.ED524Budget.IndirectCost.RestrictedIndirectCostRate.COMPLIES_WITH_34_CFR_76_564_C_2);
                }
                indirectCost.setApprovingFederalAgency(approvingFederalAgency);
                ed524Budget.setIndirectCost(indirectCost);
            }
        }
        ed524BudgetDocument.setED524Budget(ed524Budget);
        return ed524BudgetDocument;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getED524Budget();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        ED524BudgetDocument.ED524Budget ed524Budget = (ED524BudgetDocument.ED524Budget)xmlObject;
        ED524BudgetDocument ed524BudgetDocument = ED524BudgetDocument.Factory.newInstance();
        ed524BudgetDocument.setED524Budget(ed524Budget);
        return ed524BudgetDocument;
    }
}

