/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.edCertificationDebarmentV11.CertificationDebarmentDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.service.S2SUtilService;

public class EDCertificationDebarmentV1_1Generator
extends S2SBaseFormGenerator {
    private static final int ED_CERTIFICATION_DEBARMENT = 58;
    S2SUtilService s2sUtilService = (S2SUtilService)KraServiceLocator.getService(S2SUtilService.class);

    private CertificationDebarmentDocument getCertificationDebarment() {
        CertificationDebarmentDocument certificationDebarmentDocument = CertificationDebarmentDocument.Factory.newInstance();
        CertificationDebarmentDocument.CertificationDebarment certificationDebarment = CertificationDebarmentDocument.CertificationDebarment.Factory.newInstance();
        certificationDebarment.setFormVersion("1.1");
        Organization organization = null;
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        }
        if (organization != null && organization.getOrganizationName() != null) {
            if (organization.getOrganizationName().length() > 60) {
                certificationDebarment.setOrganizationName(organization.getOrganizationName().substring(0, 60));
            } else {
                certificationDebarment.setOrganizationName(organization.getOrganizationName());
            }
        }
        DepartmentalPerson departmentalPerson = this.s2sUtilService.getDepartmentalPerson(this.pdDoc);
        String authorizedRepresentativeTitle = "";
        String authorizedRepresentativeSignature = "";
        if (departmentalPerson != null) {
            if (departmentalPerson.getPrimaryTitle() != null && !departmentalPerson.getPrimaryTitle().equals("")) {
                authorizedRepresentativeTitle = departmentalPerson.getPrimaryTitle().length() > 45 ? departmentalPerson.getPrimaryTitle().substring(0, 45) : departmentalPerson.getPrimaryTitle();
            }
            if (departmentalPerson.getFullName() != null && !departmentalPerson.getFullName().equals("")) {
                authorizedRepresentativeSignature = departmentalPerson.getFullName();
            }
        }
        certificationDebarment.setAuthorizedRepresentativeTitle(authorizedRepresentativeTitle);
        certificationDebarment.setAuthorizedRepresentativeName(this.globLibV20Generator.getHumanNameDataType(departmentalPerson));
        certificationDebarment.setAuthorizedRepresentativeSignature(authorizedRepresentativeSignature);
        certificationDebarment.setSubmittedDate(this.s2sUtilService.getCurrentCalendar());
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 58 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            certificationDebarment.setAttachment(attachedFileDataType);
            break;
        }
        certificationDebarmentDocument.setCertificationDebarment(certificationDebarment);
        return certificationDebarmentDocument;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getCertificationDebarment();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        CertificationDebarmentDocument.CertificationDebarment certificationDebarment = (CertificationDebarmentDocument.CertificationDebarment)xmlObject;
        CertificationDebarmentDocument certificationDebarmentDocument = CertificationDebarmentDocument.Factory.newInstance();
        certificationDebarmentDocument.setCertificationDebarment(certificationDebarment);
        return certificationDebarmentDocument;
    }
}

