/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.system.globalLibraryV10.AddressDataType;
import gov.grants.apply.system.globalLibraryV10.AddressRequireCountryDataType;
import gov.grants.apply.system.globalLibraryV10.ContactPersonDataType;
import gov.grants.apply.system.globalLibraryV10.HumanNameDataType;
import gov.grants.apply.system.universalCodesV10.CountryCodeType;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;

public class GlobalLibraryV1_0Generator {
    public AddressDataType getAddressDataType(ProposalPerson person) {
        AddressDataType addressType = AddressDataType.Factory.newInstance();
        if (person != null) {
            String county;
            String zipcode;
            String street1 = person.getAddressLine1();
            addressType.setStreet1(street1);
            String street2 = person.getAddressLine2();
            if (street2 != null && !street2.equals("")) {
                addressType.setStreet2(street2);
            }
            String city = person.getCity();
            addressType.setCity(city);
            String state = person.getState();
            if (state != null && !state.equals("")) {
                addressType.setState(state);
            }
            if ((zipcode = person.getPostalCode()) != null && !zipcode.equals("")) {
                addressType.setZipCode(zipcode);
            }
            if ((county = person.getCounty()) != null && !county.equals("")) {
                addressType.setCounty(county);
            }
            String country = person.getCountryCode();
            CountryCodeType.Enum countryCode = null;
            if (country != null && !country.equals("")) {
                countryCode = CountryCodeType.Enum.forString((String)country);
            }
            addressType.setCountry(countryCode);
        }
        return addressType;
    }

    public AddressDataType getAddressDataType(Rolodex rolodex) {
        AddressDataType addressType = AddressDataType.Factory.newInstance();
        if (rolodex != null) {
            String country;
            String county;
            String zipcode;
            String street1 = rolodex.getAddressLine1();
            addressType.setStreet1(street1);
            String street2 = rolodex.getAddressLine2();
            if (street2 != null && !street2.equals("")) {
                addressType.setStreet2(street2);
            }
            addressType.setCity(rolodex.getCity());
            String state = rolodex.getState();
            if (state != null && !state.equals("")) {
                addressType.setState(state);
            }
            if ((zipcode = rolodex.getPostalCode()) != null && !zipcode.equals("")) {
                addressType.setZipCode(zipcode);
            }
            if ((county = rolodex.getCounty()) != null && !county.equals("")) {
                addressType.setCounty(county);
            }
            if ((country = rolodex.getCountryCode()) != null && !country.equals("")) {
                CountryCodeType.Enum countryCode = CountryCodeType.Enum.forString((String)country);
                addressType.setCountry(countryCode);
            }
        }
        return addressType;
    }

    public AddressRequireCountryDataType getAddressRequireCountryDataType(Rolodex rolodex) {
        AddressRequireCountryDataType address = AddressRequireCountryDataType.Factory.newInstance();
        if (rolodex != null) {
            String zipcode;
            String state;
            String street1 = rolodex.getAddressLine1();
            address.setStreet1(street1);
            String street2 = rolodex.getAddressLine2();
            if (street2 != null && !street2.equals("")) {
                address.setStreet2(street2);
            }
            String city = rolodex.getCity();
            address.setCity(city);
            String county = rolodex.getCounty();
            if (county != null && !county.equals("")) {
                address.setCounty(county);
            }
            if ((state = rolodex.getState()) != null && !state.equals("")) {
                address.setState(state);
            }
            if ((zipcode = rolodex.getPostalCode()) != null && !zipcode.equals("")) {
                address.setZipCode(zipcode);
            }
            String country = rolodex.getCountryCode();
            address.setCountry(CountryCodeType.Enum.forString((String)country));
        }
        return address;
    }

    public AddressRequireCountryDataType getAddressRequireCountryDataType(ProposalPerson person) {
        AddressRequireCountryDataType address = AddressRequireCountryDataType.Factory.newInstance();
        if (person != null) {
            String zipcode;
            String state;
            String street1 = person.getAddressLine1();
            address.setStreet1(street1);
            String street2 = person.getAddressLine2();
            if (street2 != null && !street2.equals("")) {
                address.setStreet2(street2);
            }
            String city = person.getCity();
            address.setCity(city);
            String county = person.getCounty();
            if (county != null && !county.equals("")) {
                address.setCounty(county);
            }
            if ((state = person.getState()) != null && !state.equals("")) {
                address.setState(state);
            }
            if ((zipcode = person.getPostalCode()) != null && !zipcode.equals("")) {
                address.setZipCode(zipcode);
            }
            String country = person.getCountryCode();
            address.setCountry(CountryCodeType.Enum.forString((String)country));
        }
        return address;
    }

    public AddressRequireCountryDataType getAddressRequireCountryDataType(DepartmentalPerson person) {
        AddressRequireCountryDataType address = AddressRequireCountryDataType.Factory.newInstance();
        if (person != null) {
            String zipcode;
            String state;
            String street1 = person.getAddress1();
            address.setStreet1(street1);
            String street2 = person.getAddress2();
            if (street2 != null && !street2.equals("")) {
                address.setStreet2(street2);
            }
            String city = person.getCity();
            address.setCity(city);
            String county = person.getCounty();
            if (county != null && !county.equals("")) {
                address.setCounty(county);
            }
            if ((state = person.getState()) != null && !state.equals("")) {
                address.setState(state);
            }
            if ((zipcode = person.getPostalCode()) != null && !zipcode.equals("")) {
                address.setZipCode(zipcode);
            }
            String country = person.getCountryCode();
            address.setCountry(CountryCodeType.Enum.forString((String)country));
        }
        return address;
    }

    public HumanNameDataType getHumanNameDataType(ProposalPerson person) {
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        if (person != null) {
            humanName.setFirstName(person.getFirstName());
            humanName.setLastName(person.getLastName());
            String middleName = person.getMiddleName();
            if (middleName != null && !middleName.equals("")) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public HumanNameDataType getHumanNameDataType(DepartmentalPerson person) {
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        if (person != null) {
            humanName.setFirstName(person.getFirstName());
            humanName.setLastName(person.getLastName());
            String middleName = person.getMiddleName();
            if (middleName != null && !middleName.equals("")) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public HumanNameDataType getHumanNameDataType(String explanation) {
        HumanNameDataType humanNameDataType = HumanNameDataType.Factory.newInstance();
        String firstName = null;
        String lastName = null;
        String formerName = explanation;
        int commaPos = 0;
        if (formerName != null) {
            commaPos = formerName.indexOf(",");
            if (commaPos > 0) {
                lastName = formerName.substring(0, commaPos);
                firstName = formerName.substring(commaPos + 1);
            } else {
                lastName = formerName;
            }
        }
        humanNameDataType.setLastName(lastName);
        humanNameDataType.setFirstName(firstName);
        return humanNameDataType;
    }

    public HumanNameDataType getHumanNameDataType(Rolodex rolodex) {
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        if (rolodex != null) {
            humanName.setFirstName(rolodex.getFirstName());
            humanName.setLastName(rolodex.getLastName());
            String middleName = rolodex.getMiddleName();
            if (middleName != null && !middleName.equals("")) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public HumanNameDataType getHumanNameDataType(KeyPersonInfo keyPerson) {
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        humanName.setFirstName(keyPerson.getFirstName());
        humanName.setLastName(keyPerson.getLastName());
        String middleName = keyPerson.getMiddleName();
        if (middleName != null && !middleName.equals("")) {
            humanName.setMiddleName(middleName);
        }
        return humanName;
    }

    public ContactPersonDataType getContactPersonDataType(ProposalPerson person) {
        ContactPersonDataType contactPerson = ContactPersonDataType.Factory.newInstance();
        if (person != null) {
            String fax;
            String title;
            contactPerson.setName(this.getHumanNameDataType(person));
            contactPerson.setPhone(person.getOfficePhone());
            String email = person.getEmailAddress();
            if (email != null && !email.equals("")) {
                contactPerson.setEmail(email);
            }
            if ((title = person.getDirectoryTitle()) != null && !title.equals("")) {
                contactPerson.setTitle(title);
            }
            if ((fax = person.getFaxNumber()) != null && !fax.equals("")) {
                contactPerson.setFax(fax);
            }
            contactPerson.setAddress(this.getAddressDataType(person));
        }
        return contactPerson;
    }
}

