/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.nasaOtherProjectInformationV10.FYDataType;
import gov.grants.apply.forms.nasaOtherProjectInformationV10.NASAOtherProjectInformationDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.service.RolodexService;

public class NASAOtherProjectInformationV1_0Generator
extends S2SBaseFormGenerator {
    private static final String PRINCIPAL_INVESTIGATOR = "PI";
    private static final String COLLABORATOR_ROLE = "Collaborator";
    private static final String C0_INVESTIGATOR = "Co-I";
    private static final String EQUIPMENT = "Equipment";
    private static final String FACILITY = "Facility";
    private static final String HISTORICAL_IMPACT = "106";
    private static final String CIVIL_SERVICE_PERSONNEL = "101";
    private static final String EXPLATATION = "107";
    private static final String INTERNATIONAL_PARTICIPATION = "108";
    private static final String INTERNATIONAL_PARTICIPATION_SUPPORT = "109";
    private static final String FTE = "104";
    private static final String FISCAL_YEAR = "103";
    private static final int PROGRAM_SPECIFIC_DATA = 47;
    private static final int APPENDICES = 48;
    private static final int NON_US_ORGANIZATION_LETTERS_OF_ENDORSEMENT = 49;
    private static final int NARRATIVE_IRB_ACUC_LETTERS = 50;
    private static final int MAX_EXPLANATION_LENGTH = 2000;
    private static final String COUNTRY_CODE_USA = "USA";
    private static final String COUNTRY_CODE_PUERTO_RICO = "PRI";
    private static final String COUNTRY_CODE_VIRGIN_ISLANDS = "VIR";
    private static final int MAX_PROPOSAL_PERSON_COUNT = 40;
    private static final String NOT_ANSWERED = "No";
    private static final int FISCAL_YEAR_2006 = 2006;
    private static final int FISCAL_YEAR_2007 = 2007;
    private static final int FISCAL_YEAR_2008 = 2008;
    private static final int FISCAL_YEAR_2009 = 2009;
    private static final int FISCAL_YEAR_2010 = 2010;
    private static final int FISCAL_YEAR_2011 = 2011;
    private static final int FISCAL_YEAR_2012 = 2012;
    private static final int FISCAL_YEAR_2013 = 2013;
    private static final int FISCAL_YEAR_2014 = 2014;
    private static final int FISCAL_YEAR_2015 = 2015;
    private static final int FISCAL_YEAR_2016 = 2016;
    private static final int FISCAL_YEAR_2017 = 2017;
    private static final int FISCAL_YEAR_2018 = 2018;
    private static final int FISCAL_YEAR_2019 = 2019;
    private static final int FISCAL_YEAR_2020 = 2020;
    private static final int FISCAL_YEAR_2021 = 2021;
    private static final int FISCAL_YEAR_1 = 0;
    private static final int FISCAL_YEAR_2 = 1;
    private static final int FISCAL_YEAR_3 = 2;
    private static final int FISCAL_YEAR_4 = 3;
    private static final int FISCAL_YEAR_5 = 4;
    private static final int FISCAL_YEAR_6 = 5;
    List<AnswerHeader> answerHeaders;

    private NASAOtherProjectInformationDocument getNasaOtherProjectInformation() {
        NASAOtherProjectInformationDocument nasaOtherInformationDocument = NASAOtherProjectInformationDocument.Factory.newInstance();
        NASAOtherProjectInformationDocument.NASAOtherProjectInformation nasaOtherProjectInformation = NASAOtherProjectInformationDocument.NASAOtherProjectInformation.Factory.newInstance();
        nasaOtherProjectInformation.setFormVersion("1.0");
        nasaOtherProjectInformation.setNASACivilServicePersonnel(this.getNasaCivilServicePersonnel());
        nasaOtherProjectInformation.setHistoricImpact(this.getHistoricImpact());
        nasaOtherProjectInformation.setInternationalParticipation(this.getInternationalParticipation());
        nasaOtherInformationDocument.setNASAOtherProjectInformation(nasaOtherProjectInformation);
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 47 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            nasaOtherProjectInformation.setPSDataAttach(attachedFileDataType);
            break;
        }
        AttachmentGroupMin0Max100DataType attachmentAppendix = AttachmentGroupMin0Max100DataType.Factory.newInstance();
        attachmentAppendix.setAttachedFileArray(this.getAppendixFileDataTypes());
        nasaOtherProjectInformation.setAppendAttach(attachmentAppendix);
        AttachmentGroupMin0Max100DataType attachmentEndorsement = AttachmentGroupMin0Max100DataType.Factory.newInstance();
        attachmentEndorsement.setAttachedFileArray(this.getEndorsementFileDataTypes());
        nasaOtherProjectInformation.setLetterEndorsAttach(attachmentEndorsement);
        AttachmentGroupMin0Max100DataType attachmentIRBACUC = AttachmentGroupMin0Max100DataType.Factory.newInstance();
        attachmentIRBACUC.setAttachedFileArray(this.getIRBACUCLettersFileDataTypes());
        nasaOtherProjectInformation.setIRBACUCLettersAttach(attachmentIRBACUC);
        nasaOtherInformationDocument.setNASAOtherProjectInformation(nasaOtherProjectInformation);
        return nasaOtherInformationDocument;
    }

    private NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel getNasaCivilServicePersonnel() {
        FYDataType.Enum fyscalYear;
        String fiscalYear;
        String fte;
        NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel nasaCivilServicePersonnel = NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.Factory.newInstance();
        String answerDetails = this.getAnswer(CIVIL_SERVICE_PERSONNEL);
        if (answerDetails != null && !answerDetails.equals(NOT_ANSWERED)) {
            YesNoDataType.Enum answer = answerDetails.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            nasaCivilServicePersonnel.setCivilServicePersonnel(answer);
        }
        List fteAnswerDetails = this.getAnswerList(FTE);
        List fiscalYearDetails = this.getAnswerList(FISCAL_YEAR);
        if (fteAnswerDetails.size() > 0) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE1 fyfte1 = NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE1.Factory.newInstance();
            fte = ((String)fteAnswerDetails.get(0)).toString();
            BigDecimal fte1 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte1.setFTE1(fte1);
            if (fiscalYearDetails.size() > 0) {
                fiscalYear = (String)fiscalYearDetails.get(0);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte1.setFY1(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE1(fyfte1);
            }
        } else if (answerDetails != null && answerDetails.equals("Y")) {
            nasaCivilServicePersonnel.setFYFTE1(null);
        }
        if (fteAnswerDetails.size() > 1) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE2 fyfte2 = NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE2.Factory.newInstance();
            fte = ((String)fteAnswerDetails.get(1)).toString();
            BigDecimal fte2 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte2.setFTE2(fte2);
            if (fiscalYearDetails.size() > 1) {
                fiscalYear = (String)fiscalYearDetails.get(1);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte2.setFY2(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE2(fyfte2);
            }
        }
        if (fteAnswerDetails.size() > 2) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE3 fyfte3 = NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE3.Factory.newInstance();
            fte = ((String)fteAnswerDetails.get(2)).toString();
            BigDecimal fte3 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte3.setFTE3(fte3);
            if (fiscalYearDetails.size() > 2) {
                fiscalYear = (String)fiscalYearDetails.get(2);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte3.setFY3(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE3(fyfte3);
            }
        }
        if (fteAnswerDetails.size() > 3) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE4 fyfte4 = NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE4.Factory.newInstance();
            fte = ((String)fteAnswerDetails.get(3)).toString();
            BigDecimal fte4 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte4.setFTE4(fte4);
            if (fiscalYearDetails.size() > 3) {
                fiscalYear = (String)fiscalYearDetails.get(3);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte4.setFY4(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE4(fyfte4);
            }
        }
        if (fteAnswerDetails.size() > 4) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE5 fyfte5 = NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE5.Factory.newInstance();
            fte = ((String)fteAnswerDetails.get(4)).toString();
            BigDecimal fte5 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte5.setFTE5(fte5);
            if (fiscalYearDetails.size() > 4) {
                fiscalYear = (String)fiscalYearDetails.get(4);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte5.setFY5(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE5(fyfte5);
            }
        }
        if (fteAnswerDetails.size() > 5) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE6 fyfte6 = NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE6.Factory.newInstance();
            fte = ((String)fteAnswerDetails.get(5)).toString();
            BigDecimal fte6 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte6.setFTE6(fte6);
            if (fiscalYearDetails.size() > 5) {
                fiscalYear = (String)fiscalYearDetails.get(5);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte6.setFY6(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE6(fyfte6);
            }
        }
        if (fteAnswerDetails.size() != fiscalYearDetails.size()) {
            nasaCivilServicePersonnel.setFYFTE1(null);
        }
        return nasaCivilServicePersonnel;
    }

    private FYDataType.Enum getFisaclYear(String fiscalYear) {
        FYDataType.Enum fyscalYear = null;
        switch (Integer.parseInt(fiscalYear)) {
            case 2006: {
                fyscalYear = FYDataType.X_2006;
                break;
            }
            case 2007: {
                fyscalYear = FYDataType.X_2007;
                break;
            }
            case 2008: {
                fyscalYear = FYDataType.X_2008;
                break;
            }
            case 2009: {
                fyscalYear = FYDataType.X_2009;
                break;
            }
            case 2010: {
                fyscalYear = FYDataType.X_2010;
                break;
            }
            case 2011: {
                fyscalYear = FYDataType.X_2011;
                break;
            }
            case 2012: {
                fyscalYear = FYDataType.X_2012;
                break;
            }
            case 2013: {
                fyscalYear = FYDataType.X_2013;
                break;
            }
            case 2014: {
                fyscalYear = FYDataType.X_2014;
                break;
            }
            case 2015: {
                fyscalYear = FYDataType.X_2015;
                break;
            }
            case 2016: {
                fyscalYear = FYDataType.X_2016;
                break;
            }
            case 2017: {
                fyscalYear = FYDataType.X_2017;
                break;
            }
            case 2018: {
                fyscalYear = FYDataType.X_2018;
                break;
            }
            case 2019: {
                fyscalYear = FYDataType.X_2019;
                break;
            }
            case 2020: {
                fyscalYear = FYDataType.X_2020;
                break;
            }
            case 2021: {
                fyscalYear = FYDataType.X_2021;
            }
        }
        return fyscalYear;
    }

    private NASAOtherProjectInformationDocument.NASAOtherProjectInformation.HistoricImpact getHistoricImpact() {
        String childAnswerrDetails;
        NASAOtherProjectInformationDocument.NASAOtherProjectInformation.HistoricImpact historicImpact = NASAOtherProjectInformationDocument.NASAOtherProjectInformation.HistoricImpact.Factory.newInstance();
        String answerDetails = this.getAnswer(HISTORICAL_IMPACT);
        if (answerDetails != null && !answerDetails.equals(NOT_ANSWERED)) {
            YesNoDataType.Enum answer = answerDetails.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            historicImpact.setHistoricImpactQ(answer);
        }
        if ((childAnswerrDetails = this.getChildQuestionAnswer(HISTORICAL_IMPACT, EXPLATATION)) != null && !childAnswerrDetails.equals(NOT_ANSWERED)) {
            if (childAnswerrDetails.length() > 2000) {
                historicImpact.setHistoricImpactEx(childAnswerrDetails.substring(0, 2000));
            } else {
                historicImpact.setHistoricImpactEx(childAnswerrDetails);
            }
        } else if (answerDetails != null && answerDetails.equals("Y")) {
            historicImpact.setHistoricImpactEx(null);
        }
        return historicImpact;
    }

    private NASAOtherProjectInformationDocument.NASAOtherProjectInformation.InternationalParticipation getInternationalParticipation() {
        List answerList;
        String childAnswerDetails;
        NASAOtherProjectInformationDocument.NASAOtherProjectInformation.InternationalParticipation inParticipation = NASAOtherProjectInformationDocument.NASAOtherProjectInformation.InternationalParticipation.Factory.newInstance();
        String answerDetails = this.getAnswer(INTERNATIONAL_PARTICIPATION);
        if (answerDetails != null && !answerDetails.equals(NOT_ANSWERED)) {
            YesNoDataType.Enum answer = answerDetails.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            inParticipation.setInternationalParticipationQ(answer);
        }
        if ((childAnswerDetails = this.getChildQuestionAnswer(INTERNATIONAL_PARTICIPATION, EXPLATATION)) != null) {
            if (inParticipation.getInternationalParticipationQ() != null && inParticipation.getInternationalParticipationQ().equals(YesNoDataType.Y_YES)) {
                if (childAnswerDetails.length() > 2000) {
                    inParticipation.setInternationalParticipatioEx(childAnswerDetails.substring(0, 2000));
                } else {
                    inParticipation.setInternationalParticipatioEx(childAnswerDetails);
                }
            }
        } else if (answerDetails != null && answerDetails.equals("Y")) {
            inParticipation.setInternationalParticipatioEx(null);
        }
        if ((answerList = this.getAnswerList(INTERNATIONAL_PARTICIPATION_SUPPORT)).size() > 0) {
            if (answerList.contains(PRINCIPAL_INVESTIGATOR)) {
                inParticipation.setInternationalParticipationPI(YesNoDataType.Y_YES);
            }
            if (answerList.contains(C0_INVESTIGATOR)) {
                inParticipation.setInternationalParticipationCoI(YesNoDataType.Y_YES);
            }
            if (answerList.contains(COLLABORATOR_ROLE)) {
                inParticipation.setInternationalParticipationCollaborator(YesNoDataType.Y_YES);
            }
            if (answerList.contains(EQUIPMENT)) {
                inParticipation.setInternationalParticipationEquipment(YesNoDataType.Y_YES);
            }
            if (answerList.contains(FACILITY)) {
                inParticipation.setInternationalParticipationFacility(YesNoDataType.Y_YES);
            }
        } else if (answerDetails != null && answerDetails.equals("Y")) {
            inParticipation.setInternationalParticipationPI(null);
        }
        return inParticipation;
    }

    private List<String> getAnswerList(String questionId) {
        ArrayList<String> answerList = new ArrayList<String>();
        for (AnswerHeader answerHeader : this.answerHeaders) {
            List answerDetails = answerHeader.getAnswers();
            for (Answer answers : answerDetails) {
                if (!questionId.equals(answers.getQuestion().getQuestionId()) || answers.getAnswer() == null) continue;
                answerList.add(answers.getAnswer());
            }
        }
        return answerList;
    }

    private boolean isProposalPersonForeign(ProposalPerson proposalPerson) {
        boolean isForeign = false;
        if (proposalPerson.getPersonId() != null) {
            if (proposalPerson.getCountryOfCitizenship() != null) {
                isForeign = !(proposalPerson.getCountryOfCitizenship().equals(COUNTRY_CODE_PUERTO_RICO) || proposalPerson.getCountryOfCitizenship().equals(COUNTRY_CODE_USA) || proposalPerson.getCountryOfCitizenship().equals(COUNTRY_CODE_VIRGIN_ISLANDS));
            }
        } else {
            isForeign = this.isRolodexPersonForeign(proposalPerson);
        }
        return isForeign;
    }

    private boolean isRolodexPersonForeign(ProposalPerson proposalPerson) {
        Rolodex rolodex;
        boolean isForeign = false;
        if (proposalPerson.getRolodexId() != null && (rolodex = ((RolodexService)KraServiceLocator.getService(RolodexService.class)).getRolodex(proposalPerson.getRolodexId().intValue())) != null) {
            if (rolodex.getSponsor() != null && rolodex.getSponsor().getSponsorTypeCode() != null) {
                if (Integer.parseInt(rolodex.getSponsor().getSponsorTypeCode()) > 9) {
                    isForeign = true;
                }
            } else if (rolodex.getCountryCode() != null) {
                isForeign = !rolodex.getCountryCode().equals(COUNTRY_CODE_PUERTO_RICO) && !rolodex.getCountryCode().equals(COUNTRY_CODE_USA) && !rolodex.getCountryCode().equals(COUNTRY_CODE_VIRGIN_ISLANDS);
            }
        }
        return isForeign;
    }

    private AttachedFileDataType[] getAppendixFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 48 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    private AttachedFileDataType[] getEndorsementFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 49 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    private AttachedFileDataType[] getIRBACUCLettersFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 50 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    private String getAnswer(String questionId) {
        String answer = null;
        for (AnswerHeader answerHeader : this.answerHeaders) {
            if (answerHeader == null) continue;
            List answerDetails = answerHeader.getAnswers();
            for (Answer answers : answerDetails) {
                if (!questionId.equals(answers.getQuestion().getQuestionId())) continue;
                answer = answers.getAnswer();
                return answer;
            }
        }
        return answer;
    }

    private String getChildQuestionAnswer(String parentQuestionId, String questionId) {
        String answer = null;
        for (AnswerHeader answerHeader : this.answerHeaders) {
            if (answerHeader == null) continue;
            List answerDetails = answerHeader.getAnswers();
            for (Answer answers : answerDetails) {
                if (answers.getParentAnswer() == null) continue;
                Answer parentAnswer = (Answer)answers.getParentAnswer().get(0);
                if (!questionId.equals(answers.getQuestion().getQuestionId()) || !parentAnswer.getQuestion().getQuestionId().equals(parentQuestionId)) continue;
                answer = answers.getAnswer();
                return answer;
            }
        }
        return answer;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.answerHeaders = this.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), true);
        return this.getNasaOtherProjectInformation();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        NASAOtherProjectInformationDocument.NASAOtherProjectInformation nasaOtherProjectInformation = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation)xmlObject;
        NASAOtherProjectInformationDocument nasaProjectInformationDocument = NASAOtherProjectInformationDocument.Factory.newInstance();
        nasaProjectInformationDocument.setNASAOtherProjectInformation(nasaOtherProjectInformation);
        return nasaProjectInformationDocument;
    }
}

