/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.nasaSeniorKeyPersonSupplementalDataSheetV10.CoItypeDataType;
import gov.grants.apply.forms.nasaSeniorKeyPersonSupplementalDataSheetV10.FederalAgencyDataType;
import gov.grants.apply.forms.nasaSeniorKeyPersonSupplementalDataSheetV10.NASASeniorKeyPersonSupplementalDataSheetDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonComparator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NASASeniorKeyPersonSupplementalDataSheetV1_0Generator
extends S2SBaseFormGenerator {
    private S2SUtilService s2sUtilService;
    private S2SBudgetCalculatorService s2sBudgetCalculatorService;
    private BusinessObjectService businessObjectService;
    private static final String COLLABORATOR = "COLLABORATOR";
    private static final String COUNTRY_CODE_USA = "USA";
    private static final String COUNTRY_CODE_PRI = "PRI";
    private static final String COUNTRY_CODE_VIR = "VIR";
    private static final String CO_INVESTIGATOR = "COI";
    private static final String ROLE_COLLABORATOR = "COLLABORATOR";
    private static final String ATTACHED_ATTACHMENT_1 = "Attached Attachment 1";
    private static final String ATTACHED_ATTACHMENT_2 = "Attached Attachment 2";
    private static final String ATTACHED_ATTACHMENT_3 = "Attached Attachment 3";
    private static final String ATTACHED_ATTACHMENT_4 = "Attached Attachment 4";
    private static final String ATTACHMENT_TYPE_BUDGET_DETAILS = "3";
    private static final String ATTACHMENT_TYPE_STATEMENT_OF_COMMITMENT_DOC = "4";
    protected static final int MAX_KEY_PERSON_COUNT = 8;
    private static final String HIERARCHY_GOVERNMENT_AGENCY = "GOVERNMENT AGENCY";
    List<ProposalPerson> extraPersons = new ArrayList();

    public NASASeniorKeyPersonSupplementalDataSheetV1_0Generator() {
        this.s2sUtilService = (S2SUtilService)KraServiceLocator.getService(S2SUtilService.class);
        this.s2sBudgetCalculatorService = (S2SBudgetCalculatorService)KraServiceLocator.getService(S2SBudgetCalculatorService.class);
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    private NASASeniorKeyPersonSupplementalDataSheetDocument getNasaSeniorKeyPersonSupplementalDataSheetDocument() {
        NASASeniorKeyPersonSupplementalDataSheetDocument nasaSeniorKPDoc = NASASeniorKeyPersonSupplementalDataSheetDocument.Factory.newInstance();
        NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet nasaSeniorKPDataSheet = nasaSeniorKPDoc.addNewNASASeniorKeyPersonSupplementalDataSheet();
        nasaSeniorKPDataSheet.setFormVersion("1.0");
        this.populateInvestigators(nasaSeniorKPDataSheet);
        if (this.extraPersons != null && this.extraPersons.size() > 0) {
            int extraPersonNumber = this.extraPersons.size();
            ArrayList<NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt> nasaSeniorKPAttList = new ArrayList<NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt>();
            int begin = 0;
            int index = 0;
            while (begin < extraPersonNumber) {
                NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt nasaSeniorKPAtt = NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt.Factory.newInstance();
                int attPersons = extraPersonNumber - begin > 8 ? begin + 8 : extraPersonNumber;
                ArrayList<NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt.SeniorKeyPerson> seniorKeyPersonList = new ArrayList<NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt.SeniorKeyPerson>();
                for (int cnt = begin; cnt < attPersons; ++cnt) {
                    int index1 = 0;
                    seniorKeyPersonList.add(this.getExtraPerson((ProposalPerson)this.extraPersons.get(cnt)));
                    ++index1;
                }
                NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt.SeniorKeyPerson[] seniorKeyPersons = new NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt.SeniorKeyPerson[]{};
                seniorKeyPersons = seniorKeyPersonList.toArray(seniorKeyPersons);
                nasaSeniorKPAtt.setSeniorKeyPersonArray(seniorKeyPersons);
                nasaSeniorKPAttList.add(nasaSeniorKPAtt);
                if (begin == 0) {
                    nasaSeniorKPDataSheet.setAttachment1(ATTACHED_ATTACHMENT_1);
                } else if (begin == 8) {
                    nasaSeniorKPDataSheet.setAttachment2(ATTACHED_ATTACHMENT_2);
                } else if (begin == 16) {
                    nasaSeniorKPDataSheet.setAttachment3(ATTACHED_ATTACHMENT_3);
                } else if (begin == 24) {
                    nasaSeniorKPDataSheet.setAttachment4(ATTACHED_ATTACHMENT_4);
                }
                begin += 8;
                ++index;
            }
            NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment seniorKeyPersonAttachment = NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.Factory.newInstance();
            NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt[] nasaSeniorKPAtts = new NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt[]{};
            nasaSeniorKPAtts = nasaSeniorKPAttList.toArray(nasaSeniorKPAtts);
            seniorKeyPersonAttachment.setNASASeniorKeyPersonSupplementalDataSheetAttArray(nasaSeniorKPAtts);
            nasaSeniorKPDataSheet.setSeniorKeyPersonAttachment(seniorKeyPersonAttachment);
        }
        return nasaSeniorKPDoc;
    }

    private void populateInvestigators(NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet nasaSeniorKPDataSheet) {
        List proposalPersonns = this.pdDoc.getDevelopmentProposal().getProposalPersons();
        Collections.sort(proposalPersonns, new ProposalPersonComparator());
        LinkedList<ProposalPerson> keyPersons = new LinkedList<ProposalPerson>();
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (proposalPerson.getProposalPersonRoleId() == null || !CO_INVESTIGATOR.equalsIgnoreCase(proposalPerson.getProposalPersonRoleId()) && !"COLLABORATOR".equalsIgnoreCase(proposalPerson.getProjectRole())) continue;
            keyPersons.add(proposalPerson);
        }
        if (keyPersons.isEmpty()) {
            nasaSeniorKPDataSheet.addNewSeniorKeyPerson();
            return;
        }
        List nKeyPersons = this.s2sUtilService.getNKeyPersons(keyPersons, true, 8);
        this.extraPersons = this.s2sUtilService.getNKeyPersons(keyPersons, false, 8);
        LinkedList<NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPerson> seniorKeyPersonList = new LinkedList<NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPerson>();
        for (ProposalPerson proposalPerson : nKeyPersons) {
            seniorKeyPersonList.add(this.getPerson(proposalPerson));
        }
        NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPerson[] seniorKeyPersonsArray = new NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPerson[]{};
        nasaSeniorKPDataSheet.setSeniorKeyPersonArray(seniorKeyPersonList.toArray(seniorKeyPersonsArray));
    }

    private FederalAgencyDataType.Enum getFederalAgencyDataType(String sponsorCode) {
        return null;
    }

    private NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPerson getPerson(ProposalPerson proposalPerson) {
        AttachedFileDataType budgetAttachment;
        FederalAgencyDataType.Enum federalAgency;
        NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPerson seniorKeyPerson = NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPerson.Factory.newInstance();
        seniorKeyPerson.setInternationalParticipation(YesNoDataType.N_NO);
        seniorKeyPerson.setUSGovernmentParticipation(YesNoDataType.N_NO);
        int sponsortType = -1;
        String sponsorCode = null;
        if (proposalPerson.getProposalPersonRoleId() != null && proposalPerson.getProposalPersonRoleId().equals("COLLABORATOR")) {
            seniorKeyPerson.setNASACoItype(CoItypeDataType.COLLABORATOR);
        }
        if (this.s2sBudgetCalculatorService.isPersonNonMITPerson(proposalPerson)) {
            if (proposalPerson.getRolodexId() != null) {
                HashMap<String, String> conditionMap = new HashMap<String, String>();
                conditionMap.put("rolodexId", proposalPerson.getRolodexId().toString());
                Rolodex rolodex = (Rolodex)this.businessObjectService.findByPrimaryKey(Rolodex.class, conditionMap);
                if (rolodex != null) {
                    Sponsor rolodexSponsor = rolodex.getSponsor();
                    Sponsor proposalSponsor = this.pdDoc.getDevelopmentProposal().getSponsor();
                    if (rolodexSponsor != null && rolodexSponsor.equals(rolodexSponsor.getSponsorCode()) && rolodexSponsor.getSponsorTypeCode() != null && rolodexSponsor.getSponsorTypeCode().equals(proposalSponsor.getSponsorTypeCode())) {
                        sponsortType = Integer.parseInt(rolodexSponsor.getSponsorTypeCode());
                        sponsorCode = rolodex.getSponsorCode();
                        if (sponsortType == 0) {
                            seniorKeyPerson.setUSGovernmentParticipation(YesNoDataType.Y_YES);
                        } else if (sponsortType > 9) {
                            seniorKeyPerson.setInternationalParticipation(YesNoDataType.Y_YES);
                        }
                    }
                    if (sponsortType == -1 && rolodex.getCountryCode() != null && (rolodex.getCountryCode().equals(COUNTRY_CODE_USA) || rolodex.getCountryCode().equals(COUNTRY_CODE_PRI) || rolodex.getCountryCode().equals(COUNTRY_CODE_VIR))) {
                        seniorKeyPerson.setNASACoItype(CoItypeDataType.CO_I_INSTITUTIONAL_PI);
                    } else {
                        seniorKeyPerson.setNASACoItype(CoItypeDataType.CO_I_CO_PI_NON_U_S_ORGANIZATION_ONLY);
                        seniorKeyPerson.setInternationalParticipation(YesNoDataType.Y_YES);
                    }
                }
            }
        } else {
            seniorKeyPerson.setNASACoItype(CoItypeDataType.CO_I);
        }
        if (proposalPerson.getProposalPersonRoleId() != null && proposalPerson.getProposalPersonRoleId().equals("KP") && proposalPerson.getProjectRole().equalsIgnoreCase("COLLABORATOR")) {
            seniorKeyPerson.setNASACoItype(CoItypeDataType.COLLABORATOR);
        }
        if (sponsorCode != null && sponsortType == 0 && (federalAgency = this.getFederalAgencyDataType(sponsorCode)) != null) {
            seniorKeyPerson.setFederalAgency(federalAgency);
        }
        seniorKeyPerson.setSeniorKeyPersonName(this.globLibV20Generator.getHumanNameDataType(proposalPerson));
        AttachedFileDataType commitmentAttachment = this.getPernonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), ATTACHMENT_TYPE_STATEMENT_OF_COMMITMENT_DOC);
        if (commitmentAttachment != null) {
            AttachmentGroupMin0Max100DataType attachmentGroup = AttachmentGroupMin0Max100DataType.Factory.newInstance();
            AttachedFileDataType[] commitmentAttachmentArray = new AttachedFileDataType[]{commitmentAttachment};
            attachmentGroup.setAttachedFileArray(commitmentAttachmentArray);
            seniorKeyPerson.setStatementofCommitment(attachmentGroup);
        }
        if ((budgetAttachment = this.getPernonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), ATTACHMENT_TYPE_BUDGET_DETAILS)) != null) {
            AttachmentGroupMin0Max100DataType attachmentGroup = AttachmentGroupMin0Max100DataType.Factory.newInstance();
            AttachedFileDataType[] budgetAttachmentArray = new AttachedFileDataType[]{budgetAttachment};
            attachmentGroup.setAttachedFileArray(budgetAttachmentArray);
            seniorKeyPerson.setBudgetDetails(attachmentGroup);
        }
        return seniorKeyPerson;
    }

    private NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt.SeniorKeyPerson getExtraPerson(ProposalPerson proposalPerson) {
        AttachedFileDataType budgetAttachment;
        FederalAgencyDataType.Enum federalAgency;
        NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt.SeniorKeyPerson seniorKeyPerson = NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.SeniorKeyPersonAttachment.NASASeniorKeyPersonSupplementalDataSheetAtt.SeniorKeyPerson.Factory.newInstance();
        seniorKeyPerson.setInternationalParticipation(YesNoDataType.N_NO);
        seniorKeyPerson.setUSGovernmentParticipation(YesNoDataType.N_NO);
        int sponsortType = -1;
        String sponsorCode = null;
        if (proposalPerson.getProposalPersonRoleId() != null && proposalPerson.getProposalPersonRoleId().equals("COLLABORATOR")) {
            seniorKeyPerson.setNASACoItype(CoItypeDataType.COLLABORATOR);
        }
        if (this.s2sBudgetCalculatorService.isPersonNonMITPerson(proposalPerson)) {
            if (proposalPerson.getRolodexId() != null) {
                HashMap<String, String> conditionMap = new HashMap<String, String>();
                conditionMap.put("rolodexId", proposalPerson.getRolodexId().toString());
                Rolodex rolodex = (Rolodex)this.businessObjectService.findByPrimaryKey(Rolodex.class, conditionMap);
                if (rolodex != null) {
                    if (rolodex.getSponsorCode() != null && rolodex.getSponsorCode().equals(this.pdDoc.getDevelopmentProposal().getSponsorCode()) && rolodex.getSponsor() != null && rolodex.getSponsor().getSponsorTypeCode() != null && Integer.parseInt(rolodex.getSponsor().getSponsorTypeCode()) == Integer.parseInt(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorTypeCode())) {
                        sponsortType = Integer.parseInt(rolodex.getSponsor().getSponsorTypeCode());
                        sponsorCode = rolodex.getSponsorCode();
                        if (sponsortType == 0) {
                            seniorKeyPerson.setUSGovernmentParticipation(YesNoDataType.Y_YES);
                        } else if (sponsortType > 9) {
                            seniorKeyPerson.setInternationalParticipation(YesNoDataType.Y_YES);
                        }
                    }
                    if (sponsortType == -1 && rolodex.getCountryCode() != null && (rolodex.getCountryCode().equals(COUNTRY_CODE_USA) || rolodex.getCountryCode().equals(COUNTRY_CODE_PRI) || rolodex.getCountryCode().equals(COUNTRY_CODE_VIR))) {
                        seniorKeyPerson.setNASACoItype(CoItypeDataType.CO_I_INSTITUTIONAL_PI);
                    } else {
                        seniorKeyPerson.setNASACoItype(CoItypeDataType.CO_I_CO_PI_NON_U_S_ORGANIZATION_ONLY);
                        seniorKeyPerson.setInternationalParticipation(YesNoDataType.Y_YES);
                    }
                }
            }
        } else {
            seniorKeyPerson.setNASACoItype(CoItypeDataType.CO_I);
        }
        if (sponsorCode != null && (federalAgency = this.getFederalAgencyDataType(sponsorCode)) != null) {
            seniorKeyPerson.setFederalAgency(federalAgency);
        }
        seniorKeyPerson.setSeniorKeyPersonName(this.globLibV20Generator.getHumanNameDataType(proposalPerson));
        AttachedFileDataType commitmentAttachment = this.getPernonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), ATTACHMENT_TYPE_STATEMENT_OF_COMMITMENT_DOC);
        if (commitmentAttachment != null) {
            AttachmentGroupMin0Max100DataType attachmentGroup = AttachmentGroupMin0Max100DataType.Factory.newInstance();
            AttachedFileDataType[] commitmentAttachmentArray = new AttachedFileDataType[]{commitmentAttachment};
            attachmentGroup.setAttachedFileArray(commitmentAttachmentArray);
            seniorKeyPerson.setStatementofCommitment(attachmentGroup);
        }
        if ((budgetAttachment = this.getPernonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), ATTACHMENT_TYPE_BUDGET_DETAILS)) != null) {
            AttachmentGroupMin0Max100DataType attachmentGroup = AttachmentGroupMin0Max100DataType.Factory.newInstance();
            AttachedFileDataType[] budgetAttachmentArray = new AttachedFileDataType[]{budgetAttachment};
            attachmentGroup.setAttachedFileArray(budgetAttachmentArray);
            seniorKeyPerson.setBudgetDetails(attachmentGroup);
        }
        return seniorKeyPerson;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNasaSeniorKeyPersonSupplementalDataSheetDocument();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        NASASeniorKeyPersonSupplementalDataSheetDocument nasaSeniorKPDoc = NASASeniorKeyPersonSupplementalDataSheetDocument.Factory.newInstance();
        NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet nasaSeniorKeyPersonSupplementalDataSheet = NASASeniorKeyPersonSupplementalDataSheetDocument.NASASeniorKeyPersonSupplementalDataSheet.Factory.newInstance();
        nasaSeniorKPDoc.setNASASeniorKeyPersonSupplementalDataSheet(nasaSeniorKeyPersonSupplementalDataSheet);
        return nasaSeniorKPDoc;
    }
}

