/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.nsfApplicationChecklist13V13.NSFApplicationChecklist13Document;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoNotApplicableDataType;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.s2s.generator.S2SQuestionnairing;
import org.kuali.kra.s2s.generator.impl.NSFApplicationChecklistBaseGenerator;

public class NSFApplicationChecklistV1_3Generator
extends NSFApplicationChecklistBaseGenerator
implements S2SQuestionnairing {
    private static String QUESTIONNAIRE_ANSWER_YES = "Y";
    private static String QUESTIONNAIRE_ANSWER_NO = "N";
    private static String QUESTIONNAIRE_ANSWER_X = "X";

    private NSFApplicationChecklist13Document getNSFApplicationChecklist13() {
        NSFApplicationChecklist13Document nsfChecklistDocument = NSFApplicationChecklist13Document.Factory.newInstance();
        NSFApplicationChecklist13Document.NSFApplicationChecklist13 nsfChecklist = NSFApplicationChecklist13Document.NSFApplicationChecklist13.Factory.newInstance();
        nsfChecklist.setFormVersion("1.3");
        NSFApplicationChecklist13Document.NSFApplicationChecklist13.CoverSheet coverSheet = this.getCoverSheet();
        NSFApplicationChecklist13Document.NSFApplicationChecklist13.ProjectNarrative projectNarrative = this.getProjectNarrative();
        this.setQuestionnaireAnswers(coverSheet, projectNarrative);
        nsfChecklist.setCoverSheet(coverSheet);
        nsfChecklist.setCheckRRSite(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(6)));
        nsfChecklist.setCheckRROtherInfo(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(7)));
        nsfChecklist.setCheckProjectSummary(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(8)));
        nsfChecklist.setProjectNarrative(projectNarrative);
        nsfChecklist.setCheckBiblio(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(14)));
        nsfChecklist.setCheckFacilities(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(15)));
        nsfChecklist.setEquipment(this.getEquipment());
        nsfChecklist.setRRSrProfile(this.getRRSrProfile());
        nsfChecklist.setCheckRRPersonalData(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(22)));
        nsfChecklist.setRRBudget(this.getRRBudget());
        nsfChecklist.setNSFCover(this.getNSFCover());
        nsfChecklistDocument.setNSFApplicationChecklist13(nsfChecklist);
        return nsfChecklistDocument;
    }

    private void setQuestionnaireAnswers(NSFApplicationChecklist13Document.NSFApplicationChecklist13.CoverSheet coverSheet, NSFApplicationChecklist13Document.NSFApplicationChecklist13.ProjectNarrative projectNarrative) {
        List answers = this.s2sUtilService.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), this.getNamespace(), this.getFormName());
        for (Answer answer : answers) {
            switch (answer.getQuestion().getQuestionIdAsInteger()) {
                case 1110: {
                    YesNoNotApplicableDataType.Enum yesNoNotApplicableDataType = YesNoNotApplicableDataType.N_NO;
                    if (QUESTIONNAIRE_ANSWER_YES.equals(answer.getAnswer())) {
                        yesNoNotApplicableDataType = YesNoNotApplicableDataType.Y_YES;
                    } else if (QUESTIONNAIRE_ANSWER_NO.equals(answer.getAnswer())) {
                        yesNoNotApplicableDataType = YesNoNotApplicableDataType.N_NO;
                    } else if (QUESTIONNAIRE_ANSWER_X.equals(answer.getAnswer())) {
                        yesNoNotApplicableDataType = YesNoNotApplicableDataType.NA_NOT_APPLICABLE;
                    }
                    coverSheet.setCheckFullApp(yesNoNotApplicableDataType);
                    break;
                }
                case 1111: {
                    if (QUESTIONNAIRE_ANSWER_YES.equals(answer.getAnswer())) {
                        projectNarrative.setCheckMeritReview(YesNoNotApplicableDataType.Y_YES);
                        break;
                    }
                    if (QUESTIONNAIRE_ANSWER_NO.equals(answer.getAnswer())) {
                        projectNarrative.setCheckMeritReview(YesNoNotApplicableDataType.N_NO);
                        break;
                    }
                    if (!QUESTIONNAIRE_ANSWER_X.equals(answer.getAnswer())) break;
                    projectNarrative.setCheckMeritReview(YesNoNotApplicableDataType.NA_NOT_APPLICABLE);
                    break;
                }
                case 1113: {
                    if (QUESTIONNAIRE_ANSWER_YES.equals(answer.getAnswer())) {
                        projectNarrative.setCheckMentoring(YesNoNotApplicableDataType.Y_YES);
                        break;
                    }
                    if (!QUESTIONNAIRE_ANSWER_NO.equals(answer.getAnswer())) break;
                    projectNarrative.setCheckMentoring(YesNoNotApplicableDataType.N_NO);
                    break;
                }
                case 1114: {
                    if (QUESTIONNAIRE_ANSWER_YES.equals(answer.getAnswer())) {
                        projectNarrative.setCheckPriorSupport(YesNoNotApplicableDataType.Y_YES);
                    }
                    if (QUESTIONNAIRE_ANSWER_NO.equals(answer.getAnswer())) {
                        projectNarrative.setCheckPriorSupport(YesNoNotApplicableDataType.N_NO);
                    }
                    if (!QUESTIONNAIRE_ANSWER_X.equals(answer.getAnswer())) break;
                    projectNarrative.setCheckPriorSupport(YesNoNotApplicableDataType.NA_NOT_APPLICABLE);
                    break;
                }
                case 1108: {
                    if (!QUESTIONNAIRE_ANSWER_NO.equals(answer)) break;
                    projectNarrative.setCheckHRInfo(YesNoNotApplicableDataType.N_NO);
                    break;
                }
                case 1117: {
                    if (!QUESTIONNAIRE_ANSWER_YES.equals(answer)) break;
                    projectNarrative.setCheckHRInfo(YesNoNotApplicableDataType.Y_YES);
                    break;
                }
            }
        }
    }

    private NSFApplicationChecklist13Document.NSFApplicationChecklist13.CoverSheet getCoverSheet() {
        NSFApplicationChecklist13Document.NSFApplicationChecklist13.CoverSheet coverSheet = NSFApplicationChecklist13Document.NSFApplicationChecklist13.CoverSheet.Factory.newInstance();
        coverSheet.setCheckCoverSheet(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(1)));
        coverSheet.setCheckRenewal(YesNoNotApplicableDataType.Enum.forInt((int)this.getChecklistAnswer(2)));
        coverSheet.setCheckTypeApp(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(4)));
        coverSheet.setCheckAppCert(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(5)));
        return coverSheet;
    }

    private NSFApplicationChecklist13Document.NSFApplicationChecklist13.ProjectNarrative getProjectNarrative() {
        NSFApplicationChecklist13Document.NSFApplicationChecklist13.ProjectNarrative projectNarrative = NSFApplicationChecklist13Document.NSFApplicationChecklist13.ProjectNarrative.Factory.newInstance();
        projectNarrative.setCheckProjectNarrative(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(9)));
        projectNarrative.setCheckURL(YesNoNotApplicableDataType.Enum.forInt((int)this.getChecklistAnswer(11)));
        return projectNarrative;
    }

    private NSFApplicationChecklist13Document.NSFApplicationChecklist13.Equipment getEquipment() {
        NSFApplicationChecklist13Document.NSFApplicationChecklist13.Equipment equipment = NSFApplicationChecklist13Document.NSFApplicationChecklist13.Equipment.Factory.newInstance();
        equipment.setCheckEquipment(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(16)));
        equipment.setCheckSuppDoc(YesNoNotApplicableDataType.Enum.forInt((int)this.getChecklistAnswer(17)));
        equipment.setCheckAdditionalItems(YesNoNotApplicableDataType.Enum.forInt((int)this.getChecklistAnswer(18)));
        return equipment;
    }

    private NSFApplicationChecklist13Document.NSFApplicationChecklist13.RRSrProfile getRRSrProfile() {
        NSFApplicationChecklist13Document.NSFApplicationChecklist13.RRSrProfile rrSrProfile = NSFApplicationChecklist13Document.NSFApplicationChecklist13.RRSrProfile.Factory.newInstance();
        rrSrProfile.setCheckRRSrProfile(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(19)));
        rrSrProfile.setCheckBioSketch(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(20)));
        rrSrProfile.setCheckCurrentPendingSupport(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(21)));
        return rrSrProfile;
    }

    private NSFApplicationChecklist13Document.NSFApplicationChecklist13.RRBudget getRRBudget() {
        NSFApplicationChecklist13Document.NSFApplicationChecklist13.RRBudget rrBudget = NSFApplicationChecklist13Document.NSFApplicationChecklist13.RRBudget.Factory.newInstance();
        rrBudget.setCheckRRBudget(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(23)));
        rrBudget.setCheckRRBudgetJustification(YesNoNotApplicableDataType.Enum.forInt((int)this.getChecklistAnswer(24)));
        return rrBudget;
    }

    private NSFApplicationChecklist13Document.NSFApplicationChecklist13.NSFCover getNSFCover() {
        NSFApplicationChecklist13Document.NSFApplicationChecklist13.NSFCover nsfCover = NSFApplicationChecklist13Document.NSFApplicationChecklist13.NSFCover.Factory.newInstance();
        nsfCover.setCheckNSFCover(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(26)));
        nsfCover.setCheckNSFUnit(YesNoDataType.Enum.forInt((int)this.getChecklistAnswer(27)));
        nsfCover.setCheckNSFOtherInfo(YesNoNotApplicableDataType.Enum.forInt((int)this.getChecklistAnswer(28)));
        nsfCover.setCheckNSFSFLLL(YesNoNotApplicableDataType.Enum.forInt((int)this.getChecklistAnswer(29)));
        nsfCover.setCheckNSFDevAuth(YesNoNotApplicableDataType.Enum.forInt((int)this.getChecklistAnswer(30)));
        nsfCover.setCheckNSFReg(YesNoNotApplicableDataType.Enum.forInt((int)this.getChecklistAnswer(31)));
        nsfCover.setCheckDoNotInclude(YesNoNotApplicableDataType.Enum.forInt((int)this.getChecklistAnswer(32)));
        return nsfCover;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFApplicationChecklist13();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        NSFApplicationChecklist13Document.NSFApplicationChecklist13 nsfChecklist = (NSFApplicationChecklist13Document.NSFApplicationChecklist13)xmlObject;
        NSFApplicationChecklist13Document nsfChecklistDocument = NSFApplicationChecklist13Document.Factory.newInstance();
        nsfChecklistDocument.setNSFApplicationChecklist13(nsfChecklist);
        return nsfChecklistDocument;
    }

    public String getFormName() {
        return "NSF_ApplicationChecklist_1_3-V1.3";
    }

    public String getNamespace() {
        return "http://apply.grants.gov/forms/NSF_ApplicationChecklist_1_3-V1.3";
    }
}

