/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.nsfCoverPageV11.DegreeTypeDataType;
import gov.grants.apply.forms.nsfCoverPageV11.NSFCoverPageDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonDegree;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonYnq;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.impl.NSFCoverPageBaseGenerator;

public class NSFCoverPageV1_1Generator
extends NSFCoverPageBaseGenerator {
    private static final String QUESTION_ID_ACCOMPLISHMENT_RENEWAL = "5";
    private static final String QUESTION_ID_ISCURRENT_PI = "19";
    private static final int PROGRAM_ANNOUNCEMENT_NUMBER_MAX_LENGTH = 40;
    private static final DegreeTypeDataType.Enum DEFAULT_DEGREE_TYPE = DegreeTypeDataType.UKNW_NO_DEGREE_INFORMATION_SPECIFIED;

    private NSFCoverPageDocument getNSFCoverPage() {
        NSFCoverPageDocument nsfCoverPageDocument = NSFCoverPageDocument.Factory.newInstance();
        NSFCoverPageDocument.NSFCoverPage nsfCoverPage = NSFCoverPageDocument.NSFCoverPage.Factory.newInstance();
        nsfCoverPage.setFormVersion("1.1");
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber() != null) {
            if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber().length() > 40) {
                nsfCoverPage.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber().substring(0, 40));
            } else {
                nsfCoverPage.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber());
            }
        }
        nsfCoverPage.setNSFUnitConsideration(this.getNSFUnitConsideration());
        nsfCoverPage.setPIInfo(this.getPIInfo());
        nsfCoverPage.setCoPIInfo(this.getCoPI());
        nsfCoverPage.setOtherInfo(this.getOtherInfo());
        AttachmentGroupMin1Max100DataType attachmentGroup = AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        nsfCoverPage.setSingleCopyDocuments(attachmentGroup);
        nsfCoverPageDocument.setNSFCoverPage(nsfCoverPage);
        return nsfCoverPageDocument;
    }

    private NSFCoverPageDocument.NSFCoverPage.PIInfo getPIInfo() {
        NSFCoverPageDocument.NSFCoverPage.PIInfo pInfo = NSFCoverPageDocument.NSFCoverPage.PIInfo.Factory.newInstance();
        ProposalPerson PI = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            for (ProposalPersonDegree personDegree : PI.getProposalPersonDegrees()) {
                DegreeTypeDataType.Enum degreeType = DEFAULT_DEGREE_TYPE;
                if (personDegree.getDegreeType() != null && personDegree.getDegreeType().getDegreeCode() != null) {
                    StringBuilder degreeTypeDetail = new StringBuilder();
                    degreeTypeDetail.append(personDegree.getDegreeType().getDegreeCode());
                    degreeTypeDetail.append(": ");
                    degreeTypeDetail.append(personDegree.getDegreeType().getDescription());
                    degreeType = DegreeTypeDataType.Enum.forString((String)degreeTypeDetail.toString());
                    if (degreeType == null) {
                        degreeType = DEFAULT_DEGREE_TYPE;
                    }
                } else {
                    degreeType = DEFAULT_DEGREE_TYPE;
                }
                pInfo.setDegreeType(degreeType);
                if (personDegree.getGraduationYear() == null) continue;
                pInfo.setDegreeYear(this.getYearAsCalendar(personDegree.getGraduationYear()));
            }
            pInfo.setIsCurrentPI(this.getYNQAnswer(QUESTION_ID_ISCURRENT_PI));
        }
        return pInfo;
    }

    private NSFCoverPageDocument.NSFCoverPage.CoPIInfo getCoPI() {
        NSFCoverPageDocument.NSFCoverPage.CoPIInfo coPIInfo = NSFCoverPageDocument.NSFCoverPage.CoPIInfo.Factory.newInstance();
        int count = 0;
        ProposalPerson coInvestigator = null;
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (proposalPerson.getProposalPersonRoleId() == null || !proposalPerson.getProposalPersonRoleId().equals("COI")) continue;
            ++count;
        }
        NSFCoverPageDocument.NSFCoverPage.CoPIInfo.CoPI[] coPIArray = new NSFCoverPageDocument.NSFCoverPage.CoPIInfo.CoPI[count];
        count = 0;
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (proposalPerson.getProposalPersonRoleId() == null || !proposalPerson.getProposalPersonRoleId().equals("COI")) continue;
            coInvestigator = proposalPerson;
            NSFCoverPageDocument.NSFCoverPage.CoPIInfo.CoPI coPI = NSFCoverPageDocument.NSFCoverPage.CoPIInfo.CoPI.Factory.newInstance();
            coPI.setName(this.globLibV20Generator.getHumanNameDataType(coInvestigator));
            for (ProposalPersonDegree personDegree : coInvestigator.getProposalPersonDegrees()) {
                DegreeTypeDataType.Enum degreeType = DEFAULT_DEGREE_TYPE;
                if (personDegree != null && personDegree.getDegreeType() != null && personDegree.getDegreeType().getDegreeCode() != null) {
                    StringBuilder degreeTypeDetail = new StringBuilder();
                    degreeTypeDetail.append(personDegree.getDegreeType().getDegreeCode());
                    degreeTypeDetail.append(": ");
                    degreeTypeDetail.append(personDegree.getDegreeType().getDescription());
                    degreeType = DegreeTypeDataType.Enum.forString((String)degreeTypeDetail.toString());
                    if (degreeType == null) {
                        degreeType = DEFAULT_DEGREE_TYPE;
                    }
                }
                coPI.setDegreeType(degreeType);
                if (personDegree.getGraduationYear() == null) continue;
                coPI.setDegreeYear(this.getYearAsCalendar(personDegree.getGraduationYear()));
            }
            coPIArray[count] = coPI;
            ++count;
        }
        coPIInfo.setCoPIArray(coPIArray);
        return coPIInfo;
    }

    private NSFCoverPageDocument.NSFCoverPage.OtherInfo getOtherInfo() {
        String proposalTypeCode;
        NSFCoverPageDocument.NSFCoverPage.OtherInfo otherInfo = NSFCoverPageDocument.NSFCoverPage.OtherInfo.Factory.newInstance();
        YesNoDataType.Enum yesNoDataType = this.getYNQAnswer("12");
        if (yesNoDataType != null) {
            otherInfo.setIsBeginInvestigator(yesNoDataType);
        }
        if ((yesNoDataType = this.getLobbyingAnswer()) != null) {
            otherInfo.setIsDisclosureLobbyingActivities(yesNoDataType);
        }
        if ((yesNoDataType = this.getYNQAnswer("14")) != null) {
            otherInfo.setIsExploratoryResearch(yesNoDataType);
        }
        if ((yesNoDataType = this.getYNQAnswer("G6")) != null) {
            otherInfo.setIsHistoricPlaces(yesNoDataType);
        }
        if ((proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalTypeCode()) != null) {
            otherInfo.setIsAccomplishmentRenewal(proposalTypeCode.equals(QUESTION_ID_ACCOMPLISHMENT_RENEWAL) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
        }
        if ((yesNoDataType = this.getYNQAnswer("20")) != null) {
            otherInfo.setIsHighResolutionGraphics(yesNoDataType);
        }
        return otherInfo;
    }

    private YesNoDataType.Enum getYNQAnswer(String questionId) {
        YesNoDataType.Enum answer = null;
        for (ProposalYnq proposalYnq : this.pdDoc.getDevelopmentProposal().getProposalYnqs()) {
            if (proposalYnq.getQuestionId() == null || !proposalYnq.getQuestionId().equals(questionId) || proposalYnq.getAnswer() == null) continue;
            answer = proposalYnq.getAnswer().equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
        }
        return answer;
    }

    private YesNoDataType.Enum getLobbyingAnswer() {
        YesNoDataType.Enum answer = YesNoDataType.N_NO;
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if ((proposalPerson.getProposalPersonRoleId() == null || !proposalPerson.getProposalPersonRoleId().equals("PI")) && !proposalPerson.getProposalPersonRoleId().equals("COI")) continue;
            for (ProposalPersonYnq personYnq : proposalPerson.getProposalPersonYnqs()) {
                if (personYnq == null || personYnq.getQuestionId() == null || !personYnq.getQuestionId().equals("10088") || personYnq.getAnswer() == null || !personYnq.getAnswer().equals("Y")) continue;
                return YesNoDataType.Y_YES;
            }
        }
        return answer;
    }

    private NSFCoverPageDocument.NSFCoverPage.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPageDocument.NSFCoverPage.NSFUnitConsideration nsfConsideration = NSFCoverPageDocument.NSFCoverPage.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    private AttachedFileDataType[] getAttachedFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            int narrativeTypeCode;
            if (narrative.getNarrativeTypeCode() == null || (narrativeTypeCode = Integer.parseInt(narrative.getNarrativeTypeCode())) != 13 && narrativeTypeCode != 14 && narrativeTypeCode != 87 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[attachedFileDataTypeList.size()]);
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        NSFCoverPageDocument.NSFCoverPage nsfCoverPage = (NSFCoverPageDocument.NSFCoverPage)xmlObject;
        NSFCoverPageDocument nsfCoverPageDocument = NSFCoverPageDocument.Factory.newInstance();
        nsfCoverPageDocument.setNSFCoverPage(nsfCoverPage);
        return nsfCoverPageDocument;
    }
}

