/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.nsfCoverPage12V12.NSFCoverPage12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.ArrayList;
import java.util.Date;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonYnq;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.impl.NSFCoverPageBaseGenerator;

public class NSFCoverPageV1_2Generator
extends NSFCoverPageBaseGenerator {
    private static final String QUESTION_ID_ACCOMPLISHMENT_RENEWAL = "5";
    private static final String QUESTION_ID_ISCURRENT_PI = "19";
    private static final int PROGRAM_ANNOUNCEMENT_NUMBER_MAX_LENGTH = 40;

    private NSFCoverPage12Document getNSFCoverPage12() {
        NSFCoverPage12Document nsfCoverPage12Document = NSFCoverPage12Document.Factory.newInstance();
        NSFCoverPage12Document.NSFCoverPage12 nsfCoverPage12 = NSFCoverPage12Document.NSFCoverPage12.Factory.newInstance();
        nsfCoverPage12.setFormVersion("1.2");
        this.setFundingOpportunityNumber(nsfCoverPage12);
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null) {
            nsfCoverPage12.setDueDate(this.dateTimeService.getCalendar((Date)this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate()));
        }
        nsfCoverPage12.setNSFUnitConsideration(this.getNSFUnitConsideration());
        nsfCoverPage12.setPIInfo(this.getPIInfo());
        nsfCoverPage12.setOtherInfo(this.getOtherInfo());
        AttachmentGroupMin1Max100DataType attachmentGroup = AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        nsfCoverPage12.setSingleCopyDocuments(attachmentGroup);
        nsfCoverPage12Document.setNSFCoverPage12(nsfCoverPage12);
        return nsfCoverPage12Document;
    }

    private void setFundingOpportunityNumber(NSFCoverPage12Document.NSFCoverPage12 nsfCoverPage12) {
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber() != null) {
            if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber().length() > 40) {
                nsfCoverPage12.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber().substring(0, 40));
            } else {
                nsfCoverPage12.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber());
            }
        }
    }

    private NSFCoverPage12Document.NSFCoverPage12.PIInfo getPIInfo() {
        NSFCoverPage12Document.NSFCoverPage12.PIInfo pInfo = NSFCoverPage12Document.NSFCoverPage12.PIInfo.Factory.newInstance();
        pInfo.setIsCurrentPI(this.getYNQAnswer(QUESTION_ID_ISCURRENT_PI));
        return pInfo;
    }

    private NSFCoverPage12Document.NSFCoverPage12.OtherInfo getOtherInfo() {
        String proposalTypeCode;
        NSFCoverPage12Document.NSFCoverPage12.OtherInfo otherInfo = NSFCoverPage12Document.NSFCoverPage12.OtherInfo.Factory.newInstance();
        YesNoDataType.Enum yesNoDataType = this.getYNQAnswer("12");
        if (yesNoDataType != null) {
            otherInfo.setIsBeginInvestigator(yesNoDataType);
        }
        if ((yesNoDataType = this.getLobbyingAnswer()) != null) {
            otherInfo.setIsDisclosureLobbyingActivities(yesNoDataType);
        }
        if ((yesNoDataType = this.getYNQAnswer("14")) != null) {
            otherInfo.setIsExploratoryResearch(yesNoDataType);
        }
        if ((proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalTypeCode()) != null) {
            otherInfo.setIsAccomplishmentRenewal(proposalTypeCode.equals(QUESTION_ID_ACCOMPLISHMENT_RENEWAL) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
        }
        if ((yesNoDataType = this.getYNQAnswer("20")) != null) {
            otherInfo.setIsHighResolutionGraphics(yesNoDataType);
        }
        return otherInfo;
    }

    private YesNoDataType.Enum getYNQAnswer(String questionId) {
        YesNoDataType.Enum answer = null;
        for (ProposalYnq proposalYnq : this.pdDoc.getDevelopmentProposal().getProposalYnqs()) {
            if (proposalYnq.getQuestionId() == null || !proposalYnq.getQuestionId().equals(questionId) || proposalYnq.getAnswer() == null) continue;
            answer = proposalYnq.getAnswer().equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
        }
        return answer;
    }

    private YesNoDataType.Enum getLobbyingAnswer() {
        YesNoDataType.Enum answer = YesNoDataType.N_NO;
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if ((proposalPerson.getProposalPersonRoleId() == null || !proposalPerson.getProposalPersonRoleId().equals("PI")) && !proposalPerson.getProposalPersonRoleId().equals("COI")) continue;
            for (ProposalPersonYnq personYnq : proposalPerson.getProposalPersonYnqs()) {
                if (personYnq == null || personYnq.getQuestionId() == null || !personYnq.getQuestionId().equals("10088") || personYnq.getAnswer() == null || !personYnq.getAnswer().equals("Y")) continue;
                return YesNoDataType.Y_YES;
            }
        }
        return answer;
    }

    private NSFCoverPage12Document.NSFCoverPage12.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPage12Document.NSFCoverPage12.NSFUnitConsideration nsfConsideration = NSFCoverPage12Document.NSFCoverPage12.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    private AttachedFileDataType[] getAttachedFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            int narrativeTypeCode;
            if (narrative.getNarrativeTypeCode() == null || (narrativeTypeCode = Integer.parseInt(narrative.getNarrativeTypeCode())) != 13 && narrativeTypeCode != 14 && narrativeTypeCode != 87 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[attachedFileDataTypeList.size()]);
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage12();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        NSFCoverPage12Document.NSFCoverPage12 nsfCoverPage12 = (NSFCoverPage12Document.NSFCoverPage12)xmlObject;
        NSFCoverPage12Document nsfCoverPage12Document = NSFCoverPage12Document.Factory.newInstance();
        nsfCoverPage12Document.setNSFCoverPage12(nsfCoverPage12);
        return nsfCoverPage12Document;
    }
}

