/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.phs398ModularBudgetV10.PHS398ModularBudgetDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.impl.PHS398ModularBudgetBaseGenerator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class PHS398ModularBudgetV1_0Generator
extends PHS398ModularBudgetBaseGenerator {
    private static final Log LOG = LogFactory.getLog(PHS398ModularBudgetV1_0Generator.class);
    private BudgetDecimal cumulativeConsortiumFandA = BudgetDecimal.ZERO;
    private BudgetDecimal cumulativeDirectCostLessConsortiumFandA = BudgetDecimal.ZERO;
    private BudgetDecimal cumulativeTotalFundsRequestedDirectCosts = BudgetDecimal.ZERO;
    private BudgetDecimal cumulativeTotalFundsRequestedDirectIndirectCosts = BudgetDecimal.ZERO;
    private BudgetDecimal cumulativeTotalFundsRequestedIndirectCost = BudgetDecimal.ZERO;

    private PHS398ModularBudgetDocument getPHS398ModularBudget() {
        PHS398ModularBudgetDocument modularBudgetDocument = PHS398ModularBudgetDocument.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget modularBudget = PHS398ModularBudgetDocument.PHS398ModularBudget.Factory.newInstance();
        modularBudget.setFormVersion("1.0");
        Budget budget = null;
        try {
            BudgetDocument budgetDocument = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
            budget = budgetDocument == null ? null : budgetDocument.getBudget();
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return modularBudgetDocument;
        }
        if (budget != null) {
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetPeriod() == 1) {
                    modularBudget.setPeriods(this.getPeriods(budgetPeriod));
                    continue;
                }
                if (budgetPeriod.getBudgetPeriod() == 2) {
                    modularBudget.setPeriods2(this.getPeriods2(budgetPeriod));
                    continue;
                }
                if (budgetPeriod.getBudgetPeriod() == 3) {
                    modularBudget.setPeriods3(this.getPeriods3(budgetPeriod));
                    continue;
                }
                if (budgetPeriod.getBudgetPeriod() == 4) {
                    modularBudget.setPeriods4(this.getPeriods4(budgetPeriod));
                    continue;
                }
                if (budgetPeriod.getBudgetPeriod() != 5) continue;
                modularBudget.setPeriods5(this.getPeriods5(budgetPeriod));
            }
            modularBudget.setCummulativeBudgetInfo(this.getCummBudget());
        }
        modularBudgetDocument.setPHS398ModularBudget(modularBudget);
        return modularBudgetDocument;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo getCummBudget() {
        PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo cummBudget = PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.EntirePeriodTotalCost entireCost = PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.EntirePeriodTotalCost.Factory.newInstance();
        entireCost.setCumulativeDirectCostLessConsortiumFandA(BigDecimal.ZERO);
        entireCost.setCumulativeTotalFundsRequestedDirectCosts(BigDecimal.ZERO);
        entireCost.setCumulativeTotalFundsRequestedDirectIndirectCosts(BigDecimal.ZERO);
        PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications budgetJustifications = PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.Factory.newInstance();
        if (!this.cumulativeTotalFundsRequestedDirectIndirectCosts.toString().equals("0")) {
            entireCost.setCumulativeDirectCostLessConsortiumFandA(this.cumulativeDirectCostLessConsortiumFandA.bigDecimalValue());
            entireCost.setCumulativeTotalFundsRequestedDirectCosts(this.cumulativeTotalFundsRequestedDirectCosts.bigDecimalValue());
            entireCost.setCumulativeConsortiumFandA(this.cumulativeConsortiumFandA.bigDecimalValue());
            entireCost.setCumulativeTotalFundsRequestedDirectIndirectCosts(this.cumulativeTotalFundsRequestedDirectIndirectCosts.bigDecimalValue());
            entireCost.setCumulativeTotalFundsRequestedIndirectCost(this.cumulativeTotalFundsRequestedIndirectCost.bigDecimalValue());
            cummBudget.setEntirePeriodTotalCost(entireCost);
            budgetJustifications = this.getBudgetJustifications();
            if (budgetJustifications.getAdditionalNarrativeJustification() != null || budgetJustifications.getConsortiumJustification() != null || budgetJustifications.getPersonnelJustification() != null) {
                cummBudget.setBudgetJustifications(budgetJustifications);
            }
        }
        cummBudget.setEntirePeriodTotalCost(entireCost);
        return cummBudget;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications getBudgetJustifications() {
        PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications budgetJustifications = PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.Factory.newInstance();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null) continue;
            if (Integer.parseInt(narrative.getNarrativeTypeCode()) == 35) {
                attachedFileDataType = this.getAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.PersonnelJustification personnelJustification = PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.PersonnelJustification.Factory.newInstance();
                personnelJustification.setAttFile(attachedFileDataType);
                budgetJustifications.setPersonnelJustification(personnelJustification);
            }
            if (Integer.parseInt(narrative.getNarrativeTypeCode()) == 36) {
                attachedFileDataType = this.getAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.ConsortiumJustification consortiumJustification = PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.ConsortiumJustification.Factory.newInstance();
                consortiumJustification.setAttFile(attachedFileDataType);
                budgetJustifications.setConsortiumJustification(consortiumJustification);
            }
            if (Integer.parseInt(narrative.getNarrativeTypeCode()) != 37 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.AdditionalNarrativeJustification additionalNarrative = PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.AdditionalNarrativeJustification.Factory.newInstance();
            additionalNarrative.setAttFile(attachedFileDataType);
            budgetJustifications.setAdditionalNarrativeJustification(additionalNarrative);
        }
        return budgetJustifications;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.Periods getPeriods(BudgetPeriod budgetPeriod) {
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods periods = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.DirectCost directCost = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.DirectCost.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost indirectCost = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.Factory.newInstance();
        BudgetDecimal consortiumFandA = BudgetDecimal.ZERO;
        BudgetDecimal directCostLessConsortiumFandA = BudgetDecimal.ZERO;
        BudgetDecimal totalDirectCosts = BudgetDecimal.ZERO;
        BudgetDecimal bdTotalIndirectCost = BudgetDecimal.ZERO;
        BudgetDecimal bdCost = BudgetDecimal.ZERO;
        BudgetDecimal bdBaseCost = BudgetDecimal.ZERO;
        BudgetDecimal bdRate = BudgetDecimal.ZERO;
        String costType = null;
        periods.setBudgetPeriod(1);
        if (budgetPeriod.getStartDate() != null) {
            periods.setBudgetPeriodStartDate(this.s2sUtilService.convertDateToCalendar(budgetPeriod.getStartDate()));
        }
        if (budgetPeriod.getEndDate() != null) {
            periods.setBudgetPeriodEndDate(this.s2sUtilService.convertDateToCalendar(budgetPeriod.getEndDate()));
        }
        directCost.setDirectCostLessConsortiumFandA(BigDecimal.ZERO);
        directCost.setTotalFundsRequestedDirectCosts(BigDecimal.ZERO);
        periods.setTotalFundsRequestedDirectIndirectCosts(BigDecimal.ZERO);
        BudgetModular budgetModular = budgetPeriod.getBudgetModular();
        if (budgetModular != null) {
            BudgetDecimal totalCost = this.getTotalCost(budgetModular);
            periods.setTotalFundsRequestedDirectIndirectCosts(totalCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedDirectIndirectCosts = (BudgetDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractKualiDecimal)totalCost);
            if (budgetModular.getConsortiumFna() != null) {
                consortiumFandA = budgetModular.getConsortiumFna();
                directCost.setConsortiumFandA(consortiumFandA.bigDecimalValue());
                this.cumulativeConsortiumFandA = (BudgetDecimal)this.cumulativeConsortiumFandA.add((AbstractKualiDecimal)consortiumFandA);
            }
            if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                directCost.setDirectCostLessConsortiumFandA(directCostLessConsortiumFandA.bigDecimalValue());
                this.cumulativeDirectCostLessConsortiumFandA = (BudgetDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractKualiDecimal)directCostLessConsortiumFandA);
            }
            if (budgetModular.getTotalDirectCost() != null) {
                totalDirectCosts = budgetModular.getTotalDirectCost();
                directCost.setTotalFundsRequestedDirectCosts(totalDirectCosts.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectCosts = (BudgetDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractKualiDecimal)totalDirectCosts);
            }
            ArrayList<PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems> indirectCostItemsList = new ArrayList<PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems>();
            for (BudgetModularIdc budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
                PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems indirectCostItems = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems.Factory.newInstance();
                if (budgetModularIdc.getFundsRequested() != null) {
                    bdCost = budgetModularIdc.getFundsRequested();
                    indirectCostItems.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                    bdTotalIndirectCost = (BudgetDecimal)bdTotalIndirectCost.add((AbstractKualiDecimal)bdCost);
                }
                if (budgetModularIdc.getIdcBase() != null) {
                    bdBaseCost = budgetModularIdc.getIdcBase();
                    indirectCostItems.setIndirectCostBase(bdBaseCost.bigDecimalValue());
                }
                if (budgetModularIdc.getIdcRate() != null) {
                    bdRate = budgetModularIdc.getIdcRate();
                    indirectCostItems.setIndirectCostRate(bdRate.bigDecimalValue());
                }
                if (budgetModularIdc.getDescription() != null) {
                    costType = budgetModularIdc.getDescription();
                    indirectCostItems.setIndirectCostTypeDescription(costType);
                }
                indirectCostItemsList.add(indirectCostItems);
            }
            PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems[] indirectCostItemsArray = new PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems[]{};
            indirectCostItemsArray = indirectCostItemsList.toArray(indirectCostItemsArray);
            indirectCost.setIndirectCostItemsArray(indirectCostItemsArray);
        }
        periods.setDirectCost(directCost);
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        Rolodex rolodex = organization.getCognizantAuditorRolodex();
        if (rolodex != null) {
            indirectCost.setCognizantFederalAgency(this.getCognizantFederalAgency(rolodex));
        }
        if (organization.getIndirectCostRateAgreement() != null) {
            indirectCost.setIndirectCostAgreementDate(this.s2sUtilService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
        }
        indirectCost.setTotalFundsRequestedIndirectCost(bdTotalIndirectCost.bigDecimalValue());
        this.cumulativeTotalFundsRequestedIndirectCost = (BudgetDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractKualiDecimal)bdTotalIndirectCost);
        periods.setIndirectCost(indirectCost);
        return periods;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2 getPeriods2(BudgetPeriod budgetPeriod) {
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2 periods2 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.DirectCost2 directCost2 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.DirectCost2.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2 indirectCost2 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.Factory.newInstance();
        BudgetDecimal bdTotalIndirectCost = BudgetDecimal.ZERO;
        periods2.setBudgetPeriod2(2);
        if (budgetPeriod.getStartDate() != null) {
            periods2.setBudgetPeriodStartDate2(this.s2sUtilService.convertDateToCalendar(budgetPeriod.getStartDate()));
        }
        if (budgetPeriod.getEndDate() != null) {
            periods2.setBudgetPeriodEndDate2(this.s2sUtilService.convertDateToCalendar(budgetPeriod.getEndDate()));
        }
        directCost2.setDirectCostLessConsortiumFandA2(BigDecimal.ZERO);
        directCost2.setTotalFundsRequestedDirectCosts2(BigDecimal.ZERO);
        periods2.setTotalFundsRequestedDirectIndirectCosts2(BigDecimal.ZERO);
        BudgetModular budgetModular = budgetPeriod.getBudgetModular();
        if (budgetModular != null) {
            BudgetDecimal totalCost = this.getTotalCost(budgetModular);
            periods2.setTotalFundsRequestedDirectIndirectCosts2(totalCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedDirectIndirectCosts = (BudgetDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractKualiDecimal)totalCost);
            if (budgetModular.getConsortiumFna() != null) {
                BudgetDecimal consortiumFandA = budgetModular.getConsortiumFna();
                directCost2.setConsortiumFandA2(consortiumFandA.bigDecimalValue());
                this.cumulativeConsortiumFandA = (BudgetDecimal)this.cumulativeConsortiumFandA.add((AbstractKualiDecimal)consortiumFandA);
            }
            if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                BudgetDecimal directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                directCost2.setDirectCostLessConsortiumFandA2(directCostLessConsortiumFandA.bigDecimalValue());
                this.cumulativeDirectCostLessConsortiumFandA = (BudgetDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractKualiDecimal)directCostLessConsortiumFandA);
            }
            if (budgetModular.getTotalDirectCost() != null) {
                BudgetDecimal totalDirectCosts = budgetModular.getTotalDirectCost();
                directCost2.setTotalFundsRequestedDirectCosts2(totalDirectCosts.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectCosts = (BudgetDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractKualiDecimal)totalDirectCosts);
            }
            BudgetDecimal bdCost = null;
            BudgetDecimal bdBaseCost = null;
            BudgetDecimal bdRate = null;
            String costType = null;
            PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.IndirectCostItems2[] indirectCostItems2Array = null;
            if (budgetModular != null && budgetModular.getBudgetModularIdcs() != null) {
                indirectCostItems2Array = new PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.IndirectCostItems2[budgetModular.getBudgetModularIdcs().size()];
            }
            int costItems = 0;
            for (BudgetModularIdc budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
                PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.IndirectCostItems2 indirectCostItems2 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.IndirectCostItems2.Factory.newInstance();
                if (budgetModularIdc.getFundsRequested() != null) {
                    bdCost = budgetModularIdc.getFundsRequested();
                    indirectCostItems2.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                    bdTotalIndirectCost = (BudgetDecimal)bdTotalIndirectCost.add((AbstractKualiDecimal)bdCost);
                }
                if (budgetModularIdc.getIdcBase() != null) {
                    bdBaseCost = budgetModularIdc.getIdcBase();
                    indirectCostItems2.setIndirectCostBase(bdBaseCost.bigDecimalValue());
                }
                if (budgetModularIdc.getIdcRate() != null) {
                    bdRate = budgetModularIdc.getIdcRate();
                    indirectCostItems2.setIndirectCostRate(bdRate.bigDecimalValue());
                }
                if (budgetModularIdc.getDescription() != null) {
                    costType = budgetModularIdc.getDescription();
                    indirectCostItems2.setIndirectCostTypeDescription(costType);
                }
                if (indirectCostItems2Array == null) continue;
                indirectCostItems2Array[costItems] = indirectCostItems2;
                ++costItems;
            }
            indirectCost2.setIndirectCostItems2Array(indirectCostItems2Array);
        }
        periods2.setDirectCost2(directCost2);
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            Rolodex rolodex = organization.getCognizantAuditorRolodex();
            if (rolodex != null) {
                indirectCost2.setCognizantFederalAgency2(this.getCognizantFederalAgency(rolodex));
            }
            if (organization.getIndirectCostRateAgreement() != null) {
                indirectCost2.setIndirectCostAgreementDate2(this.s2sUtilService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
            }
        }
        indirectCost2.setTotalFundsRequestedIndirectCost2(bdTotalIndirectCost.bigDecimalValue());
        this.cumulativeTotalFundsRequestedIndirectCost = (BudgetDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractKualiDecimal)bdTotalIndirectCost);
        periods2.setIndirectCost2(indirectCost2);
        return periods2;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3 getPeriods3(BudgetPeriod budgetPeriod) {
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3 periods3 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.DirectCost3 directCost3 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.DirectCost3.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3 indirectCost3 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.Factory.newInstance();
        BudgetDecimal bdTotalIndirectCost = BudgetDecimal.ZERO;
        periods3.setBudgetPeriod3(3);
        if (budgetPeriod.getStartDate() != null) {
            periods3.setBudgetPeriodStartDate3(this.s2sUtilService.convertDateToCalendar(budgetPeriod.getStartDate()));
        }
        if (budgetPeriod.getEndDate() != null) {
            periods3.setBudgetPeriodEndDate3(this.s2sUtilService.convertDateToCalendar(budgetPeriod.getEndDate()));
        }
        directCost3.setDirectCostLessConsortiumFandA3(BigDecimal.ZERO);
        directCost3.setTotalFundsRequestedDirectCosts3(BigDecimal.ZERO);
        periods3.setTotalFundsRequestedDirectIndirectCosts3(BigDecimal.ZERO);
        BudgetModular budgetModular = budgetPeriod.getBudgetModular();
        if (budgetModular != null) {
            BudgetDecimal totalCost = this.getTotalCost(budgetModular);
            periods3.setTotalFundsRequestedDirectIndirectCosts3(totalCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedDirectIndirectCosts = (BudgetDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractKualiDecimal)totalCost);
            if (budgetModular.getConsortiumFna() != null) {
                BudgetDecimal consortiumFandA = budgetModular.getConsortiumFna();
                directCost3.setConsortiumFandA3(consortiumFandA.bigDecimalValue());
                this.cumulativeConsortiumFandA = (BudgetDecimal)this.cumulativeConsortiumFandA.add((AbstractKualiDecimal)consortiumFandA);
            }
            if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                BudgetDecimal directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                directCost3.setDirectCostLessConsortiumFandA3(directCostLessConsortiumFandA.bigDecimalValue());
                this.cumulativeDirectCostLessConsortiumFandA = (BudgetDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractKualiDecimal)directCostLessConsortiumFandA);
            }
            if (budgetModular.getTotalDirectCost() != null) {
                BudgetDecimal totalDirectCosts = budgetModular.getTotalDirectCost();
                directCost3.setTotalFundsRequestedDirectCosts3(totalDirectCosts.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectCosts = (BudgetDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractKualiDecimal)totalDirectCosts);
            }
            BudgetDecimal bdCost = null;
            BudgetDecimal bdBaseCost = null;
            BudgetDecimal bdRate = null;
            String costType = null;
            PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.IndirectCostItems3[] indirectCostItems3Array = null;
            if (budgetModular.getBudgetModularIdcs() != null) {
                indirectCostItems3Array = new PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.IndirectCostItems3[budgetModular.getBudgetModularIdcs().size()];
            }
            int costItems = 0;
            for (BudgetModularIdc budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
                PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.IndirectCostItems3 indirectCostItems3 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.IndirectCostItems3.Factory.newInstance();
                if (budgetModularIdc.getFundsRequested() != null) {
                    bdCost = budgetModularIdc.getFundsRequested();
                    indirectCostItems3.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                    bdTotalIndirectCost = (BudgetDecimal)bdTotalIndirectCost.add((AbstractKualiDecimal)bdCost);
                }
                if (budgetModularIdc.getIdcBase() != null) {
                    bdBaseCost = budgetModularIdc.getIdcBase();
                    indirectCostItems3.setIndirectCostBase(bdBaseCost.bigDecimalValue());
                }
                if (budgetModularIdc.getIdcRate() != null) {
                    bdRate = budgetModularIdc.getIdcRate();
                    indirectCostItems3.setIndirectCostRate(bdRate.bigDecimalValue());
                }
                if (budgetModularIdc.getDescription() != null) {
                    costType = budgetModularIdc.getDescription();
                    indirectCostItems3.setIndirectCostTypeDescription(costType);
                }
                if (indirectCostItems3Array == null) continue;
                indirectCostItems3Array[costItems] = indirectCostItems3;
                ++costItems;
            }
            indirectCost3.setIndirectCostItems3Array(indirectCostItems3Array);
        }
        periods3.setDirectCost3(directCost3);
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        Rolodex rolodex = organization.getRolodex();
        if (rolodex != null) {
            indirectCost3.setCognizantFederalAgency3(this.getCognizantFederalAgency(rolodex));
        }
        if (organization.getIndirectCostRateAgreement() != null) {
            indirectCost3.setIndirectCostAgreementDate3(this.s2sUtilService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
        }
        indirectCost3.setTotalFundsRequestedIndirectCost3(bdTotalIndirectCost.bigDecimalValue());
        this.cumulativeTotalFundsRequestedIndirectCost = (BudgetDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractKualiDecimal)bdTotalIndirectCost);
        periods3.setIndirectCost3(indirectCost3);
        return periods3;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4 getPeriods4(BudgetPeriod budgetPeriod) {
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4 periods4 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.DirectCost4 directCost4 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.DirectCost4.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4 indirectCost4 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.Factory.newInstance();
        BudgetDecimal bdTotalIndirectCost = BudgetDecimal.ZERO;
        periods4.setBudgetPeriod4(4);
        if (budgetPeriod.getStartDate() != null) {
            periods4.setBudgetPeriodStartDate4(this.s2sUtilService.convertDateToCalendar(budgetPeriod.getStartDate()));
        }
        if (budgetPeriod.getEndDate() != null) {
            periods4.setBudgetPeriodEndDate4(this.s2sUtilService.convertDateToCalendar(budgetPeriod.getEndDate()));
        }
        directCost4.setDirectCostLessConsortiumFandA4(BigDecimal.ZERO);
        directCost4.setTotalFundsRequestedDirectCosts4(BigDecimal.ZERO);
        periods4.setTotalFundsRequestedDirectIndirectCosts4(BigDecimal.ZERO);
        BudgetModular budgetModular = budgetPeriod.getBudgetModular();
        if (budgetModular != null) {
            BudgetDecimal totalCost = this.getTotalCost(budgetModular);
            periods4.setTotalFundsRequestedDirectIndirectCosts4(totalCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedDirectIndirectCosts = (BudgetDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractKualiDecimal)totalCost);
            if (budgetModular.getConsortiumFna() != null) {
                BudgetDecimal consortiumFandA = budgetModular.getConsortiumFna();
                directCost4.setConsortiumFandA4(consortiumFandA.bigDecimalValue());
                this.cumulativeConsortiumFandA = (BudgetDecimal)this.cumulativeConsortiumFandA.add((AbstractKualiDecimal)consortiumFandA);
            }
            if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                BudgetDecimal directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                directCost4.setDirectCostLessConsortiumFandA4(directCostLessConsortiumFandA.bigDecimalValue());
                this.cumulativeDirectCostLessConsortiumFandA = (BudgetDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractKualiDecimal)directCostLessConsortiumFandA);
            }
            if (budgetModular.getTotalDirectCost() != null) {
                BudgetDecimal totalDirectCosts = budgetModular.getTotalDirectCost();
                directCost4.setTotalFundsRequestedDirectCosts4(totalDirectCosts.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectCosts = (BudgetDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractKualiDecimal)totalDirectCosts);
            }
            BudgetDecimal bdCost = null;
            BudgetDecimal bdBaseCost = null;
            BudgetDecimal bdRate = null;
            String costType = null;
            PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.IndirectCostItems4[] indirectCostItems4Array = null;
            if (budgetModular.getBudgetModularIdcs() != null) {
                indirectCostItems4Array = new PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.IndirectCostItems4[budgetModular.getBudgetModularIdcs().size()];
            }
            int costItems = 0;
            for (BudgetModularIdc budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
                PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.IndirectCostItems4 indirectCostItems4 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.IndirectCostItems4.Factory.newInstance();
                if (budgetModularIdc.getFundsRequested() != null) {
                    bdCost = budgetModularIdc.getFundsRequested();
                    indirectCostItems4.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                    bdTotalIndirectCost = (BudgetDecimal)bdTotalIndirectCost.add((AbstractKualiDecimal)bdCost);
                }
                if (budgetModularIdc.getIdcBase() != null) {
                    bdBaseCost = budgetModularIdc.getIdcBase();
                    indirectCostItems4.setIndirectCostBase(bdBaseCost.bigDecimalValue());
                }
                if (budgetModularIdc.getIdcRate() != null) {
                    bdRate = budgetModularIdc.getIdcRate();
                    indirectCostItems4.setIndirectCostRate(bdRate.bigDecimalValue());
                }
                if (budgetModularIdc.getDescription() != null) {
                    costType = budgetModularIdc.getDescription();
                    indirectCostItems4.setIndirectCostTypeDescription(costType);
                }
                if (indirectCostItems4Array == null) continue;
                indirectCostItems4Array[costItems] = indirectCostItems4;
                ++costItems;
            }
            indirectCost4.setIndirectCostItems4Array(indirectCostItems4Array);
        }
        periods4.setDirectCost4(directCost4);
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            Rolodex rolodex = organization.getRolodex();
            if (rolodex != null) {
                indirectCost4.setCognizantFederalAgency4(this.getCognizantFederalAgency(rolodex));
            }
            if (organization.getIndirectCostRateAgreement() != null) {
                indirectCost4.setIndirectCostAgreementDate4(this.s2sUtilService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
            }
        }
        indirectCost4.setTotalFundsRequestedIndirectCost4(bdTotalIndirectCost.bigDecimalValue());
        this.cumulativeTotalFundsRequestedIndirectCost = (BudgetDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractKualiDecimal)bdTotalIndirectCost);
        periods4.setIndirectCost4(indirectCost4);
        return periods4;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5 getPeriods5(BudgetPeriod budgetPeriod) {
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5 periods5 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.DirectCost5 directCost5 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.DirectCost5.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5 indirectCost5 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.Factory.newInstance();
        periods5.setBudgetPeriod5(5);
        if (budgetPeriod.getStartDate() != null) {
            periods5.setBudgetPeriodStartDate5(this.s2sUtilService.convertDateToCalendar(budgetPeriod.getStartDate()));
        }
        if (budgetPeriod.getEndDate() != null) {
            periods5.setBudgetPeriodEndDate5(this.s2sUtilService.convertDateToCalendar(budgetPeriod.getEndDate()));
        }
        directCost5.setDirectCostLessConsortiumFandA5(BigDecimal.ZERO);
        directCost5.setTotalFundsRequestedDirectCosts5(BigDecimal.ZERO);
        periods5.setTotalFundsRequestedDirectIndirectCosts5(BigDecimal.ZERO);
        BudgetModular budgetModular = budgetPeriod.getBudgetModular();
        if (budgetModular != null) {
            BudgetDecimal totalCost = this.getTotalCost(budgetModular);
            periods5.setTotalFundsRequestedDirectIndirectCosts5(totalCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedDirectIndirectCosts = (BudgetDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractKualiDecimal)totalCost);
            if (budgetModular.getConsortiumFna() != null) {
                BudgetDecimal consortiumFandA = budgetModular.getConsortiumFna();
                directCost5.setConsortiumFandA5(consortiumFandA.bigDecimalValue());
                this.cumulativeConsortiumFandA = (BudgetDecimal)this.cumulativeConsortiumFandA.add((AbstractKualiDecimal)consortiumFandA);
            }
            if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                BudgetDecimal directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                directCost5.setDirectCostLessConsortiumFandA5(directCostLessConsortiumFandA.bigDecimalValue());
                this.cumulativeDirectCostLessConsortiumFandA = (BudgetDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractKualiDecimal)directCostLessConsortiumFandA);
            }
            if (budgetModular.getTotalDirectCost() != null) {
                BudgetDecimal totalDirectCosts = budgetModular.getTotalDirectCost();
                directCost5.setTotalFundsRequestedDirectCosts5(totalDirectCosts.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectCosts = (BudgetDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractKualiDecimal)totalDirectCosts);
            }
        }
        periods5.setDirectCost5(directCost5);
        BudgetDecimal bdTotalIndirectCost = BudgetDecimal.ZERO;
        BudgetDecimal bdCost = null;
        BudgetDecimal bdBaseCost = null;
        BudgetDecimal bdRate = null;
        String costType = null;
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.IndirectCostItems5[] indirectCostItems5Array = null;
        if (budgetModular.getBudgetModularIdcs() != null) {
            indirectCostItems5Array = new PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.IndirectCostItems5[budgetModular.getBudgetModularIdcs().size()];
        }
        int costItems = 0;
        for (BudgetModularIdc budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
            PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.IndirectCostItems5 indirectCostItems5 = PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.IndirectCostItems5.Factory.newInstance();
            if (budgetModularIdc.getFundsRequested() != null) {
                bdCost = budgetModularIdc.getFundsRequested();
                indirectCostItems5.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                bdTotalIndirectCost = (BudgetDecimal)bdTotalIndirectCost.add((AbstractKualiDecimal)bdCost);
            }
            if (budgetModularIdc.getIdcBase() != null) {
                bdBaseCost = budgetModularIdc.getIdcBase();
                indirectCostItems5.setIndirectCostBase(bdBaseCost.bigDecimalValue());
            }
            if (budgetModularIdc.getIdcRate() != null) {
                bdRate = budgetModularIdc.getIdcRate();
                indirectCostItems5.setIndirectCostRate(bdRate.bigDecimalValue());
            }
            if (budgetModularIdc.getDescription() != null) {
                costType = budgetModularIdc.getDescription();
                indirectCostItems5.setIndirectCostTypeDescription(costType);
            }
            if (indirectCostItems5Array == null) continue;
            indirectCostItems5Array[costItems] = indirectCostItems5;
            ++costItems;
        }
        indirectCost5.setIndirectCostItems5Array(indirectCostItems5Array);
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            Rolodex rolodex = organization.getRolodex();
            if (rolodex != null) {
                indirectCost5.setCognizantFederalAgency5(this.getCognizantFederalAgency(rolodex));
            }
            if (organization.getIndirectCostRateAgreement() != null) {
                indirectCost5.setIndirectCostAgreementDate5(this.s2sUtilService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
            }
        }
        indirectCost5.setTotalFundsRequestedIndirectCost5(bdTotalIndirectCost.bigDecimalValue());
        this.cumulativeTotalFundsRequestedIndirectCost = (BudgetDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractKualiDecimal)bdTotalIndirectCost);
        periods5.setIndirectCost5(indirectCost5);
        return periods5;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398ModularBudget();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        PHS398ModularBudgetDocument.PHS398ModularBudget modularBudget = (PHS398ModularBudgetDocument.PHS398ModularBudget)xmlObject;
        PHS398ModularBudgetDocument modularBudgetDocument = PHS398ModularBudgetDocument.Factory.newInstance();
        modularBudgetDocument.setPHS398ModularBudget(modularBudget);
        return modularBudgetDocument;
    }
}

