/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.performanceSite13V13.PerformanceSite13Document;
import gov.grants.apply.forms.performanceSite13V13.SiteLocationDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.proposaldevelopment.bo.CongressionalDistrict;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;

public class PerformanceSiteV1_3Generator
extends S2SBaseFormGenerator {
    private static final String QUESTION_ID_FOR_INDIVIDUAL_YNQ = "30";
    private static final int PERFORMING_ORG_LOCATION_TYPE_CODE = 2;
    private static final int OTHER_ORG_LOCATION_TYPE_CODE = 3;
    private static final int PERFORMANCE_SITE_LOCATION_TYPE_CODE = 4;

    private XmlObject getPerformanceSite() {
        PerformanceSite13Document performanceSite13Document = PerformanceSite13Document.Factory.newInstance();
        PerformanceSite13Document.PerformanceSite13 performanceSite13 = PerformanceSite13Document.PerformanceSite13.Factory.newInstance();
        performanceSite13.setFormVersion("1.3");
        this.setOtherSites(performanceSite13);
        AttachedFileDataType attachedFile = this.getAttachment();
        if (attachedFile != null) {
            performanceSite13.setAttachedFile(attachedFile);
        }
        performanceSite13Document.setPerformanceSite13(performanceSite13);
        return performanceSite13Document;
    }

    private void setSiteLocationDataType(SiteLocationDataType siteLocationDataType, Organization organization) {
        if (organization.getOrganizationYnqs() != null && !organization.getOrganizationYnqs().isEmpty()) {
            for (OrganizationYnq organizationYnq : organization.getOrganizationYnqs()) {
                if (!organizationYnq.getQuestionId().equals(QUESTION_ID_FOR_INDIVIDUAL_YNQ)) continue;
                YesNoDataType.Enum answer = organizationYnq.getAnswer().equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
                siteLocationDataType.setIndividual(answer);
            }
        }
    }

    private void setOtherSites(PerformanceSite13Document.PerformanceSite13 performanceSite) {
        List proposalSites = this.pdDoc.getDevelopmentProposal().getProposalSites();
        if (proposalSites != null) {
            Organization organization = null;
            Rolodex rolodex = null;
            SiteLocationDataType siteLocationDataType = null;
            for (ProposalSite proposalSite : proposalSites) {
                String congressionalDistrict;
                switch (proposalSite.getLocationTypeCode()) {
                    case 2: {
                        siteLocationDataType = performanceSite.addNewPrimarySite();
                        organization = proposalSite.getOrganization();
                        this.setSiteLocationDataType(siteLocationDataType, organization);
                        rolodex = organization.getRolodex();
                        break;
                    }
                    case 3: {
                        organization = proposalSite.getOrganization();
                        rolodex = organization.getRolodex();
                        siteLocationDataType = performanceSite.addNewOtherSite();
                        break;
                    }
                    case 4: {
                        rolodex = proposalSite.getRolodex();
                        siteLocationDataType = performanceSite.addNewOtherSite();
                    }
                }
                if (siteLocationDataType == null) continue;
                siteLocationDataType.setOrganizationName(proposalSite.getLocationName());
                siteLocationDataType.setAddress(this.globLibV20Generator.getAddressDataType(rolodex));
                if (organization != null && organization.getDunsNumber() != null) {
                    siteLocationDataType.setDUNSNumber(organization.getDunsNumber());
                }
                if ((congressionalDistrict = this.getCongressionalDistrict(proposalSite)) == null) continue;
                siteLocationDataType.setCongressionalDistrictProgramProject(congressionalDistrict);
            }
        }
    }

    private String getCongressionalDistrict(ProposalSite proposalSite) {
        String congDistrictProject = null;
        for (CongressionalDistrict congDistrict : proposalSite.getCongressionalDistricts()) {
            congDistrictProject = congDistrict.getCongressionalDistrict();
            if (congDistrictProject == null || congDistrictProject.length() <= 6) continue;
            congDistrictProject = congDistrictProject.substring(0, 6);
        }
        return congDistrictProject;
    }

    protected AttachedFileDataType getAttachment() {
        return this.getAttachedFileDataType("40");
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPerformanceSite();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        PerformanceSite13Document performanceSite13Document = PerformanceSite13Document.Factory.newInstance();
        PerformanceSite13Document.PerformanceSite13 performanceSite13 = (PerformanceSite13Document.PerformanceSite13)xmlObject;
        performanceSite13Document.setPerformanceSite13(performanceSite13);
        return performanceSite13Document;
    }
}

