/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.performanceSite14V14.PerformanceSite14Document;
import gov.grants.apply.forms.performanceSite14V14.SiteLocationDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.proposaldevelopment.bo.CongressionalDistrict;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.validator.S2SErrorHandler;

public class PerformanceSiteV1_4Generator
extends S2SBaseFormGenerator {
    private static final String QUESTION_ID_FOR_INDIVIDUAL_YNQ = "30";
    private static final int PERFORMING_ORG_LOCATION_TYPE_CODE = 2;
    private static final int OTHER_ORG_LOCATION_TYPE_CODE = 3;
    private static final int PERFORMANCE_SITE_LOCATION_TYPE_CODE = 4;

    private XmlObject getPerformanceSite() {
        PerformanceSite14Document performanceSite14Document = PerformanceSite14Document.Factory.newInstance();
        PerformanceSite14Document.PerformanceSite14 performanceSite14 = PerformanceSite14Document.PerformanceSite14.Factory.newInstance();
        performanceSite14.setFormVersion("1.4");
        this.setOtherSites(performanceSite14);
        AttachedFileDataType attachedFile = this.getAttachedFileDataType("40");
        if (attachedFile != null) {
            performanceSite14.setAttachedFile(attachedFile);
        }
        performanceSite14Document.setPerformanceSite14(performanceSite14);
        return performanceSite14Document;
    }

    private void setSiteLocationDataType(SiteLocationDataType siteLocationDataType, Organization organization) {
        if (organization.getOrganizationYnqs() != null && !organization.getOrganizationYnqs().isEmpty()) {
            for (OrganizationYnq organizationYnq : organization.getOrganizationYnqs()) {
                if (!organizationYnq.getQuestionId().equals(QUESTION_ID_FOR_INDIVIDUAL_YNQ)) continue;
                YesNoDataType.Enum answer = organizationYnq.getAnswer().equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
                siteLocationDataType.setIndividual(answer);
            }
        }
    }

    private void setOtherSites(PerformanceSite14Document.PerformanceSite14 performanceSite) {
        List proposalSites = this.pdDoc.getDevelopmentProposal().getProposalSites();
        if (proposalSites != null) {
            Organization organization = null;
            Rolodex rolodex = null;
            SiteLocationDataType siteLocationDataType = null;
            for (ProposalSite proposalSite : proposalSites) {
                String congressionalDistrict;
                switch (proposalSite.getLocationTypeCode()) {
                    case 2: {
                        siteLocationDataType = performanceSite.addNewPrimarySite();
                        organization = proposalSite.getOrganization();
                        this.setSiteLocationDataType(siteLocationDataType, organization);
                        rolodex = organization.getRolodex();
                        break;
                    }
                    case 3: {
                        organization = proposalSite.getOrganization();
                        rolodex = organization.getRolodex();
                        siteLocationDataType = performanceSite.addNewOtherSite();
                        break;
                    }
                    case 4: {
                        organization = proposalSite.getOrganization();
                        rolodex = proposalSite.getRolodex();
                        siteLocationDataType = performanceSite.addNewOtherSite();
                    }
                }
                if (siteLocationDataType == null) continue;
                siteLocationDataType.setOrganizationName(proposalSite.getLocationName());
                siteLocationDataType.setAddress(this.globLibV20Generator.getAddressDataType(rolodex));
                if (organization != null && organization.getDunsNumber() != null) {
                    siteLocationDataType.setDUNSNumber(organization.getDunsNumber());
                }
                if ((congressionalDistrict = this.getCongressionalDistrict(proposalSite)) == null) {
                    this.getAuditErrors().add(S2SErrorHandler.getError((String)"performancesite.district.notfound"));
                    siteLocationDataType.setCongressionalDistrictProgramProject(null);
                    continue;
                }
                siteLocationDataType.setCongressionalDistrictProgramProject(congressionalDistrict);
            }
        }
    }

    private String getCongressionalDistrict(ProposalSite proposalSite) {
        String congDistrictProject = null;
        for (CongressionalDistrict congDistrict : proposalSite.getCongressionalDistricts()) {
            congDistrictProject = congDistrict.getCongressionalDistrict();
            if (congDistrictProject == null || congDistrictProject.length() <= 6) continue;
            congDistrictProject = congDistrictProject.substring(0, 6);
        }
        return congDistrictProject;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPerformanceSite();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        PerformanceSite14Document performanceSite14Document = PerformanceSite14Document.Factory.newInstance();
        PerformanceSite14Document.PerformanceSite14 performanceSite14 = (PerformanceSite14Document.PerformanceSite14)xmlObject;
        performanceSite14Document.setPerformanceSite14(performanceSite14);
        return performanceSite14Document;
    }
}

