/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.coeus.additionalEquipment.AdditionalEquipmentListDocument;
import gov.grants.apply.coeus.extraKeyPerson.ExtraKeyPersonListDocument;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.GenericPrintable;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.generator.bo.BudgetPeriodInfo;
import org.kuali.kra.s2s.generator.bo.CostInfo;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.kra.s2s.validator.S2SErrorHandler;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public abstract class RRBudgetBaseGenerator
extends S2SBaseFormGenerator {
    private static final String ADDITIONAL_EQUIPMENT = "ADDITIONAL_EQUIPMENT";
    protected S2SBudgetCalculatorService s2sBudgetCalculatorService;
    protected S2SUtilService s2sUtilService = (S2SUtilService)KraServiceLocator.getService(S2SUtilService.class);
    protected BusinessObjectService businessObjectService;
    private DocumentService documentService;
    protected BudgetService budgetService;
    public static final String OTHERCOST_DESCRIPTION = "Other";
    public static final String OTHERPERSONNEL_POSTDOC = "PostDoc";
    public static final String OTHERPERSONNEL_GRADUATE = "Grad";
    public static final String OTHERPERSONNEL_UNDERGRADUATE = "UnderGrad";
    public static final String OTHERPERSONNEL_SECRETARIAL = "Sec";
    public static final String NARRATIVE_ATTACHMENT_LIST = "narrativeAttachmentList";
    public static final int BUDGET_JUSTIFICATION_ATTACHMENT = 7;
    public static final int ADDITIONAL_KEYPERSONS_ATTACHMENT = 11;
    public static final int ADDITIONAL_EQUIPMENT_ATTACHMENT = 12;
    protected static final int OTHERPERSONNEL_MAX_ALLOWED = 6;
    protected static final int ARRAY_LIMIT_IN_SCHEMA = 4;
    protected static final String SPONSOR_GROUPS = "SPONSOR GROUPS";
    protected static final String NID_PD_PI = "PD/PI";
    protected static final String NID_CO_PD_PI = "CO-INVESTIGATOR";
    protected static final String KEYPERSON_CO_PD_PI = "CO-PD/PI";
    private static final String EXTRA_KEYPERSONS = "EXTRA_KEYPERSONS";
    private static final String EQUIPMENT_NARRATIVE_TYPE_CODE = "12";
    private static final String EXTRA_KEYPERSON_ATTACHMENT_XSL = "/org/kuali/kra/s2s/stylesheet/ExtraKeyPersonAttachment.xsl";
    private static final String EXTRA_KEYPERSONS_COMMENT = "EXTRA_KEYPERSONS";
    private static final String EXTRA_KEYPERSONS_TYPE = "11";

    public RRBudgetBaseGenerator() {
        this.s2sBudgetCalculatorService = (S2SBudgetCalculatorService)KraServiceLocator.getService(S2SBudgetCalculatorService.class);
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
    }

    protected void deleteAutoGenNarratives() {
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 11 && Integer.parseInt(narrative.getNarrativeTypeCode()) != 12) continue;
            businessObjectService.delete((PersistableBusinessObject)narrative);
        }
        this.pdDoc.getDevelopmentProposal();
    }

    protected Narrative saveAdditionalEquipments(BudgetPeriodInfo periodInfo, List<CostInfo> extraEquipmentArrayList) {
        Narrative narrative = null;
        if (extraEquipmentArrayList.size() > 0) {
            AdditionalEquipmentListDocument.AdditionalEquipmentList additionalEquipmentList = AdditionalEquipmentListDocument.AdditionalEquipmentList.Factory.newInstance();
            additionalEquipmentList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            additionalEquipmentList.setBudgetPeriod(new BigInteger(Integer.toString(periodInfo.getBudgetPeriod())));
            additionalEquipmentList.setEquipmentListArray(this.getEquipmentListArray(extraEquipmentArrayList));
            AdditionalEquipmentListDocument additionalEquipmentDoc = AdditionalEquipmentListDocument.Factory.newInstance();
            additionalEquipmentDoc.setAdditionalEquipmentList(additionalEquipmentList);
            StreamSource xsltSource = new StreamSource(this.getClass().getResourceAsStream("/org/kuali/kra/s2s/stylesheet/AdditionalEquipmentAttachment.xsl"));
            HashMap<String, StreamSource> xSLTemplateWithBookmarks = new HashMap<String, StreamSource>();
            xSLTemplateWithBookmarks.put("", xsltSource);
            String xmlData = additionalEquipmentDoc.xmlText();
            HashMap<String, byte[]> streamMap = new HashMap<String, byte[]>();
            streamMap.put("", xmlData.getBytes());
            GenericPrintable printable = new GenericPrintable();
            printable.setXSLTemplateWithBookmarks(xSLTemplateWithBookmarks);
            printable.setStreamMap(streamMap);
            PrintingService printingService = (PrintingService)KraServiceLocator.getService(PrintingService.class);
            try {
                AttachmentDataSource printData = printingService.print((Printable)printable);
                String fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + periodInfo.getBudgetPeriod() + ADDITIONAL_EQUIPMENT + ".pdf";
                narrative = this.saveNarrative(printData.getContent(), EQUIPMENT_NARRATIVE_TYPE_CODE, fileName, ADDITIONAL_EQUIPMENT);
            }
            catch (PrintingException e) {
                e.printStackTrace();
            }
        }
        return narrative;
    }

    private AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList[] getEquipmentListArray(List<CostInfo> extraEquipmentArrayList) {
        ArrayList<AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList> additionalEquipmentListList = new ArrayList<AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList>();
        AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList equipmentList = null;
        for (CostInfo costInfo : extraEquipmentArrayList) {
            equipmentList = AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList.Factory.newInstance();
            equipmentList.setFundsRequested(costInfo.getCost().bigDecimalValue());
            equipmentList.setEquipmentItem(costInfo.getDescription() != null ? costInfo.getDescription() : costInfo.getCategory());
            additionalEquipmentListList.add(equipmentList);
        }
        return additionalEquipmentListList.toArray(new AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList[0]);
    }

    protected Narrative saveExtraKeyPersons(BudgetPeriodInfo periodInfo) {
        Narrative extraKPNarrative = null;
        if (periodInfo.getExtraKeyPersons() != null && !periodInfo.getExtraKeyPersons().isEmpty()) {
            ExtraKeyPersonListDocument extraKeyPersonListDocument = ExtraKeyPersonListDocument.Factory.newInstance();
            ExtraKeyPersonListDocument.ExtraKeyPersonList extraKeyPersonList = ExtraKeyPersonListDocument.ExtraKeyPersonList.Factory.newInstance();
            extraKeyPersonList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            extraKeyPersonList.setBudgetPeriod(new BigInteger("" + periodInfo.getBudgetPeriod()));
            extraKeyPersonList.setKeyPersonsArray(this.getExtraKeyPersons(periodInfo.getExtraKeyPersons()));
            extraKeyPersonListDocument.setExtraKeyPersonList(extraKeyPersonList);
            String xmlData = extraKeyPersonListDocument.xmlText();
            HashMap<String, byte[]> streamMap = new HashMap<String, byte[]>();
            streamMap.put("", xmlData.getBytes());
            StreamSource xsltSource = new StreamSource(this.getClass().getResourceAsStream(EXTRA_KEYPERSON_ATTACHMENT_XSL));
            HashMap<String, StreamSource> xSLTemplateWithBookmarks = new HashMap<String, StreamSource>();
            xSLTemplateWithBookmarks.put("", xsltSource);
            GenericPrintable printable = new GenericPrintable();
            printable.setXSLTemplateWithBookmarks(xSLTemplateWithBookmarks);
            printable.setStreamMap(streamMap);
            PrintingService printingService = (PrintingService)KraServiceLocator.getService(PrintingService.class);
            try {
                AttachmentDataSource printData = printingService.print((Printable)printable);
                String fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + periodInfo.getBudgetPeriod() + "_" + "EXTRA_KEYPERSONS" + ".pdf";
                extraKPNarrative = this.saveNarrative(printData.getContent(), EXTRA_KEYPERSONS_TYPE, fileName, "EXTRA_KEYPERSONS");
            }
            catch (PrintingException e) {
                e.printStackTrace();
            }
        }
        return extraKPNarrative;
    }

    private ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons[] getExtraKeyPersons(List<KeyPersonInfo> keyPersonList) {
        ArrayList<ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons> keypersonslist = new ArrayList<ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons>();
        for (KeyPersonInfo keyPersonInfo : keyPersonList) {
            ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons keyPerson = ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Factory.newInstance();
            keyPerson.setFirstName(keyPersonInfo.getFirstName());
            keyPerson.setMiddleName(keyPersonInfo.getMiddleName());
            keyPerson.setLastName(keyPersonInfo.getLastName());
            keyPerson.setProjectRole(keyPersonInfo.getRole());
            keyPerson.setCompensation(this.getExtraKeyPersonCompensation(keyPersonInfo));
            keypersonslist.add(keyPerson);
        }
        return keypersonslist.toArray(new ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons[0]);
    }

    private ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation getExtraKeyPersonCompensation(KeyPersonInfo keyPersonInfo) {
        ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation compensation = ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation.Factory.newInstance();
        if (keyPersonInfo.getAcademicMonths() != null) {
            compensation.setAcademicMonths(keyPersonInfo.getAcademicMonths().bigDecimalValue());
        }
        if (keyPersonInfo.getBaseSalary() != null) {
            compensation.setBaseSalary(keyPersonInfo.getBaseSalary().bigDecimalValue());
        }
        if (keyPersonInfo.getCalendarMonths() != null) {
            compensation.setCalendarMonths(keyPersonInfo.getCalendarMonths().bigDecimalValue());
        }
        if (keyPersonInfo.getFringe() != null) {
            compensation.setFringeBenefits(keyPersonInfo.getFringe().bigDecimalValue());
        }
        if (keyPersonInfo.getFundsRequested() != null) {
            compensation.setFundsRequested(keyPersonInfo.getFundsRequested().bigDecimalValue());
        }
        if (keyPersonInfo.getRequestedSalary() != null) {
            compensation.setRequestedSalary(keyPersonInfo.getRequestedSalary().bigDecimalValue());
        }
        if (keyPersonInfo.getSummerMonths() != null) {
            compensation.setSummerMonths(keyPersonInfo.getSummerMonths().bigDecimalValue());
        }
        return compensation;
    }

    protected boolean isProposalPersonEqualsKeyPerson(ProposalPerson proposalPerson, KeyPersonInfo keyPerson) {
        if (keyPerson.getPersonId() != null) {
            return keyPerson.getPersonId().equals(proposalPerson.getPersonId());
        }
        if (keyPerson.getRolodexId() != null) {
            return keyPerson.getRolodexId().equals(proposalPerson.getRolodexId());
        }
        return false;
    }

    protected Boolean hasPersonnelBudget(KeyPersonInfo keyPerson, int period) {
        BudgetDocument budgetDocument = null;
        List budgetLineItemList = new ArrayList();
        ArrayList budgetPersonnelDetailsList = new ArrayList();
        try {
            budgetDocument = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(this.pdDoc.getBudgetDocumentVersion(0).getDocumentNumber());
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        budgetLineItemList = budgetDocument.getBudget().getBudgetPeriod(period - 1).getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : budgetLineItemList) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (budgetPersonnelDetails.getPersonId().equals(keyPerson.getPersonId())) {
                    return true;
                }
                if (keyPerson.getRolodexId() == null || !budgetPersonnelDetails.getPersonId().equals(keyPerson.getRolodexId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean validateBudgetForForm(ProposalDevelopmentDocument pdDoc) throws S2SException {
        boolean valid = true;
        BudgetDocument budget = this.s2sBudgetCalculatorService.getFinalBudgetVersion(pdDoc);
        if (budget != null) {
            for (BudgetPeriod period : budget.getBudget().getBudgetPeriods()) {
                int numberOfParticipants;
                ArrayList<String> participantSupportCode = new ArrayList<String>();
                participantSupportCode.add(this.budgetService.getParticipantSupportCategoryCode());
                List participantSupportLineItems = this.budgetService.getMatchingLineItems(period.getBudgetLineItems(), participantSupportCode);
                int n = numberOfParticipants = period.getNumberOfParticipants() == null ? 0 : period.getNumberOfParticipants();
                if (!participantSupportLineItems.isEmpty() && numberOfParticipants == 0) {
                    this.getAuditErrors().add(S2SErrorHandler.getError((String)"s2s.budget.participantcount.required"));
                    valid = false;
                    continue;
                }
                if (numberOfParticipants <= 0 || !participantSupportLineItems.isEmpty()) continue;
                this.getAuditErrors().add(S2SErrorHandler.getError((String)"s2s.budget.participantcost.required"));
                valid = false;
            }
        }
        return valid;
    }

    public DocumentService getDocumentService() {
        return (DocumentService)KraServiceLocator.getService(DocumentService.class);
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected BudgetService getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }
}

