/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrBudgetV11.BudgetTypeDataType;
import gov.grants.apply.forms.rrBudgetV11.BudgetYear1DataType;
import gov.grants.apply.forms.rrBudgetV11.BudgetYearDataType;
import gov.grants.apply.forms.rrBudgetV11.KeyPersonCompensationDataType;
import gov.grants.apply.forms.rrBudgetV11.KeyPersonDataType;
import gov.grants.apply.forms.rrBudgetV11.OtherPersonnelDataType;
import gov.grants.apply.forms.rrBudgetV11.RRBudgetDocument;
import gov.grants.apply.forms.rrBudgetV11.SectBCompensationDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeAttachment;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.bo.AttachmentData;
import org.kuali.kra.s2s.generator.bo.BudgetPeriodInfo;
import org.kuali.kra.s2s.generator.bo.BudgetSummaryInfo;
import org.kuali.kra.s2s.generator.bo.CompensationInfo;
import org.kuali.kra.s2s.generator.bo.CostInfo;
import org.kuali.kra.s2s.generator.bo.EquipmentInfo;
import org.kuali.kra.s2s.generator.bo.IndirectCostDetails;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.generator.bo.OtherDirectCostInfo;
import org.kuali.kra.s2s.generator.bo.OtherPersonnelInfo;
import org.kuali.kra.s2s.generator.impl.RRBudgetBaseGenerator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class RRBudgetV1_1Generator
extends RRBudgetBaseGenerator {
    private static final Log LOG = LogFactory.getLog(RRBudgetV1_1Generator.class);

    private RRBudgetDocument getRRBudget() {
        List budgetperiodList;
        this.deleteAutoGenNarratives();
        RRBudgetDocument rrBudgetDocument = RRBudgetDocument.Factory.newInstance();
        RRBudgetDocument.RRBudget rrBudget = RRBudgetDocument.RRBudget.Factory.newInstance();
        rrBudget.setFormVersion("1.1");
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            rrBudget.setDUNSID(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber());
            rrBudget.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
        }
        rrBudget.setBudgetType(BudgetTypeDataType.PROJECT);
        rrBudget.setBudgetYear1(BudgetYear1DataType.Factory.newInstance());
        BudgetSummaryInfo budgetSummary = null;
        try {
            this.validateBudgetForForm(this.pdDoc);
            budgetperiodList = this.s2sBudgetCalculatorService.getBudgetPeriods(this.pdDoc);
            budgetSummary = this.s2sBudgetCalculatorService.getBudgetInfo(this.pdDoc, budgetperiodList);
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return rrBudgetDocument;
        }
        for (BudgetPeriodInfo budgetPeriodData : budgetperiodList) {
            if (budgetPeriodData.getBudgetPeriod() == 1) {
                rrBudget.setBudgetYear1(this.getBudgetYear1DataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == 2) {
                rrBudget.setBudgetYear2(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == 3) {
                rrBudget.setBudgetYear3(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == 4) {
                rrBudget.setBudgetYear4(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() != 5) continue;
            rrBudget.setBudgetYear5(this.getBudgetYearDataType(budgetPeriodData));
        }
        for (BudgetPeriodInfo budgetPeriodData : budgetperiodList) {
            if (budgetPeriodData.getBudgetPeriod() != 1) continue;
            rrBudget.setBudgetYear1(this.getBudgetJustificationAttachment(rrBudget.getBudgetYear1()));
        }
        rrBudget.setBudgetSummary(this.getBudgetSummary(budgetSummary));
        rrBudgetDocument.setRRBudget(rrBudget);
        return rrBudgetDocument;
    }

    private BudgetYear1DataType getBudgetYear1DataType(BudgetPeriodInfo periodInfo) {
        BudgetYear1DataType budgetYear = BudgetYear1DataType.Factory.newInstance();
        if (periodInfo != null) {
            budgetYear.setBudgetPeriodStartDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getStartDate()));
            budgetYear.setBudgetPeriodEndDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getEndDate()));
            BudgetYearDataType.BudgetPeriod.Enum budgetPeriod = BudgetYearDataType.BudgetPeriod.Enum.forInt((int)periodInfo.getBudgetPeriod());
            budgetYear.setBudgetPeriod(budgetPeriod);
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            if (periodInfo.getTotalCompensation() != null) {
                budgetYear.setTotalCompensation(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            budgetYear.setDirectCosts(periodInfo.getDirectCostsTotal().bigDecimalValue());
            BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
            if (indirectCosts != null) {
                budgetYear.setIndirectCosts(indirectCosts);
                budgetYear.setTotalCosts(periodInfo.getDirectCostsTotal().bigDecimalValue().add(indirectCosts.getTotalIndirectCosts()));
            } else {
                budgetYear.setTotalCosts(periodInfo.getDirectCostsTotal().bigDecimalValue());
            }
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
        }
        return budgetYear;
    }

    private BudgetYear1DataType getBudgetJustificationAttachment(BudgetYear1DataType budgetYear) {
        Narrative narrative;
        AttachedFileDataType attachedFileDataType = AttachedFileDataType.Factory.newInstance();
        Iterator i$ = this.pdDoc.getDevelopmentProposal().getNarratives().iterator();
        while (i$.hasNext() && ((narrative = (Narrative)i$.next()).getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 7 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null)) {
        }
        budgetYear.setBudgetJustificationAttachment(attachedFileDataType);
        return budgetYear;
    }

    private BudgetYearDataType getBudgetYearDataType(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType budgetYear = BudgetYearDataType.Factory.newInstance();
        if (periodInfo != null) {
            budgetYear.setBudgetPeriodStartDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getStartDate()));
            budgetYear.setBudgetPeriodEndDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getEndDate()));
            BudgetYearDataType.BudgetPeriod.Enum budgetPeriod = BudgetYearDataType.BudgetPeriod.Enum.forInt((int)periodInfo.getBudgetPeriod());
            budgetYear.setBudgetPeriod(budgetPeriod);
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            if (periodInfo.getTotalCompensation() != null) {
                budgetYear.setTotalCompensation(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            BigDecimal directCosts = periodInfo.getDirectCostsTotal().bigDecimalValue();
            budgetYear.setDirectCosts(directCosts);
            BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
            budgetYear.setIndirectCosts(indirectCosts);
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
            if (indirectCosts != null) {
                budgetYear.setTotalCosts(directCosts.add(indirectCosts.getTotalIndirectCosts()));
            } else {
                budgetYear.setTotalCosts(periodInfo.getTotalCosts().bigDecimalValue());
            }
        }
        return budgetYear;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary getBudgetSummary(BudgetSummaryInfo budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary budgetSummary = RRBudgetDocument.RRBudget.BudgetSummary.Factory.newInstance();
        budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(BigDecimal.ZERO);
        budgetSummary.setCumulativeTotalFundsRequestedPersonnel(BigDecimal.ZERO);
        budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(BigDecimal.ZERO);
        if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
            budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(budgetSummaryData.getCumTotalFundsForSrPersonnel().bigDecimalValue());
        }
        if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null) {
            budgetSummary.setCumulativeTotalFundsRequestedOtherPersonnel(budgetSummaryData.getCumTotalFundsForOtherPersonnel().bigDecimalValue());
        }
        if (budgetSummaryData.getCumNumOtherPersonnel() != null) {
            budgetSummary.setCumulativeTotalNoOtherPersonnel(budgetSummaryData.getCumNumOtherPersonnel().intValue());
        }
        if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
            budgetSummary.setCumulativeTotalFundsRequestedPersonnel(budgetSummaryData.getCumTotalFundsForPersonnel().bigDecimalValue());
        }
        budgetSummary.setCumulativeEquipments(this.getCumulativeEquipments(budgetSummaryData));
        budgetSummary.setCumulativeTravels(this.getCumulativeTravels(budgetSummaryData));
        budgetSummary.setCumulativeTrainee(this.getCumulativeTrainee(budgetSummaryData));
        budgetSummary.setCumulativeOtherDirect(this.getCumulativeOtherDirect(budgetSummaryData));
        budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(budgetSummaryData.getCumTotalDirectCosts().bigDecimalValue());
        budgetSummary.setCumulativeTotalFundsRequestedIndirectCost(budgetSummaryData.getCumTotalIndirectCosts().bigDecimalValue());
        budgetSummary.setCumulativeTotalFundsRequestedDirectIndirectCosts(budgetSummaryData.getCumTotalCosts().bigDecimalValue());
        if (budgetSummaryData.getCumFee() != null) {
            budgetSummary.setCumulativeFee(budgetSummaryData.getCumFee().bigDecimalValue());
        }
        return budgetSummary;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeEquipments getCumulativeEquipments(BudgetSummaryInfo budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeEquipments cumulativeEquipments = RRBudgetDocument.RRBudget.BudgetSummary.CumulativeEquipments.Factory.newInstance();
        if (budgetSummaryData != null && budgetSummaryData.getCumEquipmentFunds() != null) {
            cumulativeEquipments.setCumulativeTotalFundsRequestedEquipment(budgetSummaryData.getCumEquipmentFunds().bigDecimalValue());
        }
        return cumulativeEquipments;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTravels getCumulativeTravels(BudgetSummaryInfo budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTravels cumulativeTravels = RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTravels.Factory.newInstance();
        if (budgetSummaryData.getCumDomesticTravel() != null) {
            cumulativeTravels.setCumulativeDomesticTravelCosts(budgetSummaryData.getCumDomesticTravel().bigDecimalValue());
        }
        if (budgetSummaryData.getCumForeignTravel() != null) {
            cumulativeTravels.setCumulativeForeignTravelCosts(budgetSummaryData.getCumForeignTravel().bigDecimalValue());
        }
        if (budgetSummaryData.getCumTravel() != null) {
            cumulativeTravels.setCumulativeTotalFundsRequestedTravel(budgetSummaryData.getCumTravel().bigDecimalValue());
        }
        return cumulativeTravels;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTrainee getCumulativeTrainee(BudgetSummaryInfo budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTrainee cumulativeTrainee = RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTrainee.Factory.newInstance();
        cumulativeTrainee.setCumulativeTotalFundsRequestedTraineeCosts(BigDecimal.ZERO);
        if (budgetSummaryData != null) {
            cumulativeTrainee.setCumulativeTotalFundsRequestedTraineeCosts(((BudgetDecimal)budgetSummaryData.getpartOtherCost().add(budgetSummaryData.getpartStipendCost().add(budgetSummaryData.getpartTravelCost().add(budgetSummaryData.getPartTuition().add((AbstractKualiDecimal)budgetSummaryData.getPartSubsistence()))))).bigDecimalValue());
            cumulativeTrainee.setCumulativeTraineeTuitionFeesHealthInsurance(budgetSummaryData.getPartTuition().bigDecimalValue());
            cumulativeTrainee.setCumulativeTraineeStipends(budgetSummaryData.getpartStipendCost().bigDecimalValue());
            cumulativeTrainee.setCumulativeTraineeTravel(budgetSummaryData.getpartTravelCost().bigDecimalValue());
            cumulativeTrainee.setCumulativeTraineeSubsistence(budgetSummaryData.getPartSubsistence().bigDecimalValue());
            cumulativeTrainee.setCumulativeOtherTraineeCost(budgetSummaryData.getpartOtherCost().bigDecimalValue());
            cumulativeTrainee.setCumulativeNoofTrainees(budgetSummaryData.getparticipantCount());
        }
        return cumulativeTrainee;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeOtherDirect getCumulativeOtherDirect(BudgetSummaryInfo budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeOtherDirect cumulativeOtherDirect = RRBudgetDocument.RRBudget.BudgetSummary.CumulativeOtherDirect.Factory.newInstance();
        cumulativeOtherDirect.setCumulativeTotalFundsRequestedOtherDirectCosts(BigDecimal.ZERO);
        if (budgetSummaryData != null && budgetSummaryData.getOtherDirectCosts() != null) {
            for (OtherDirectCostInfo cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                cumulativeOtherDirect.setCumulativeTotalFundsRequestedOtherDirectCosts(cumOtherDirect.gettotalOtherDirect().bigDecimalValue());
                if (cumOtherDirect.getmaterials() != null) {
                    cumulativeOtherDirect.setCumulativeMaterialAndSupplies(cumOtherDirect.getmaterials().bigDecimalValue());
                }
                if (cumOtherDirect.getpublications() != null) {
                    cumulativeOtherDirect.setCumulativePublicationCosts(cumOtherDirect.getpublications().bigDecimalValue());
                }
                if (cumOtherDirect.getConsultants() != null) {
                    cumulativeOtherDirect.setCumulativeConsultantServices(cumOtherDirect.getConsultants().bigDecimalValue());
                }
                if (cumOtherDirect.getcomputer() != null) {
                    cumulativeOtherDirect.setCumulativeADPComputerServices(cumOtherDirect.getcomputer().bigDecimalValue());
                }
                if (cumOtherDirect.getsubAwards() != null) {
                    cumulativeOtherDirect.setCumulativeSubawardConsortiumContractualCosts(cumOtherDirect.getsubAwards().bigDecimalValue());
                }
                if (cumOtherDirect.getEquipRental() != null) {
                    cumulativeOtherDirect.setCumulativeEquipmentFacilityRentalFees(cumOtherDirect.getEquipRental().bigDecimalValue());
                }
                if (cumOtherDirect.getAlterations() != null) {
                    cumulativeOtherDirect.setCumulativeAlterationsAndRenovations(cumOtherDirect.getAlterations().bigDecimalValue());
                }
                if (cumOtherDirect.getOtherCosts().size() <= 0) continue;
                cumulativeOtherDirect.setCumulativeOther1DirectCost(new BigDecimal((String)((Map)cumOtherDirect.getOtherCosts().get(0)).get("Cost")));
            }
        }
        return cumulativeOtherDirect;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts getParticipantTraineeSupportCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts traineeSupportCosts = BudgetYearDataType.ParticipantTraineeSupportCosts.Factory.newInstance();
        if (periodInfo != null) {
            traineeSupportCosts.setTuitionFeeHealthInsurance(periodInfo.getPartTuition().bigDecimalValue());
            traineeSupportCosts.setStipends(periodInfo.getpartStipendCost().bigDecimalValue());
            traineeSupportCosts.setTravel(periodInfo.getpartTravelCost().bigDecimalValue());
            traineeSupportCosts.setSubsistence(periodInfo.getPartSubsistence().bigDecimalValue());
            traineeSupportCosts.setOther(this.getOtherPTSupportCosts(periodInfo));
            traineeSupportCosts.setParticipantTraineeNumber(periodInfo.getparticipantCount());
            traineeSupportCosts.setTotalCost(traineeSupportCosts.getTuitionFeeHealthInsurance().add(traineeSupportCosts.getStipends().add(traineeSupportCosts.getTravel().add(traineeSupportCosts.getSubsistence().add(traineeSupportCosts.getOther().getCost())))));
        }
        return traineeSupportCosts;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts.Other getOtherPTSupportCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts.Other other = BudgetYearDataType.ParticipantTraineeSupportCosts.Other.Factory.newInstance();
        other.setDescription("Other");
        BudgetDecimal otherCost = BudgetDecimal.ZERO;
        if (periodInfo != null && periodInfo.getpartOtherCost() != null) {
            otherCost = periodInfo.getpartOtherCost();
        }
        other.setCost(otherCost.bigDecimalValue());
        return other;
    }

    private BudgetYearDataType.OtherDirectCosts getOtherDirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherDirectCosts otherDirectCosts = BudgetYearDataType.OtherDirectCosts.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts().size() > 0) {
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getpublications() != null) {
                otherDirectCosts.setPublicationCosts(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getpublications().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getmaterials() != null) {
                otherDirectCosts.setMaterialsSupplies(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getmaterials().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getConsultants() != null) {
                otherDirectCosts.setConsultantServices(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getConsultants().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getcomputer() != null) {
                otherDirectCosts.setADPComputerServices(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getcomputer().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getsubAwards() != null) {
                otherDirectCosts.setSubawardConsortiumContractualCosts(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getsubAwards().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getAlterations() != null) {
                otherDirectCosts.setAlterationsRenovations(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getAlterations().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getEquipRental() != null) {
                otherDirectCosts.setEquipmentRentalFee(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getEquipRental().bigDecimalValue());
            }
            otherDirectCosts.setOthers(this.getOthersForOtherDirectCosts(periodInfo));
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).gettotalOtherDirect() != null) {
                otherDirectCosts.setTotalOtherDirectCost(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).gettotalOtherDirect().bigDecimalValue());
            }
        }
        return otherDirectCosts;
    }

    private BudgetYearDataType.IndirectCosts getIndirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.IndirectCosts indirectCosts = null;
        if (periodInfo != null && periodInfo.getIndirectCosts() != null && periodInfo.getIndirectCosts().getIndirectCostDetails() != null) {
            ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost> indirectCostList = new ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost>();
            int IndirectCostCount = 0;
            for (IndirectCostDetails indirectCostDetails : periodInfo.getIndirectCosts().getIndirectCostDetails()) {
                BudgetYearDataType.IndirectCosts.IndirectCost indirectCost = BudgetYearDataType.IndirectCosts.IndirectCost.Factory.newInstance();
                if (indirectCostDetails.getBase() != null) {
                    indirectCost.setBase(indirectCostDetails.getBase().bigDecimalValue());
                }
                indirectCost.setCostType(indirectCostDetails.getCostType());
                if (indirectCostDetails.getFunds() != null) {
                    indirectCost.setFundRequested(indirectCostDetails.getFunds().bigDecimalValue());
                }
                if (indirectCostDetails.getRate() != null) {
                    indirectCost.setRate(indirectCostDetails.getRate().bigDecimalValue());
                }
                indirectCostList.add(indirectCost);
                if (++IndirectCostCount != 4) continue;
                LOG.warn((Object)"Stopping iteration over indirect cost details because array limit in schema is only 4");
                break;
            }
            if (IndirectCostCount > 0) {
                indirectCosts = BudgetYearDataType.IndirectCosts.Factory.newInstance();
                BudgetYearDataType.IndirectCosts.IndirectCost[] indirectCostArray = new BudgetYearDataType.IndirectCosts.IndirectCost[]{};
                indirectCosts.setIndirectCostArray(indirectCostList.toArray(indirectCostArray));
                if (periodInfo.getIndirectCosts().getTotalIndirectCosts() != null) {
                    indirectCosts.setTotalIndirectCosts(periodInfo.getIndirectCosts().getTotalIndirectCosts().bigDecimalValue());
                }
            }
        }
        return indirectCosts;
    }

    private BudgetYearDataType.OtherDirectCosts.Others getOthersForOtherDirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherDirectCosts.Others others = BudgetYearDataType.OtherDirectCosts.Others.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null) {
            BudgetYearDataType.OtherDirectCosts.Others.Other[] otherArray = new BudgetYearDataType.OtherDirectCosts.Others.Other[periodInfo.getOtherDirectCosts().size()];
            int Otherscount = 0;
            for (OtherDirectCostInfo otherDirectCostInfo : periodInfo.getOtherDirectCosts()) {
                BudgetYearDataType.OtherDirectCosts.Others.Other other = BudgetYearDataType.OtherDirectCosts.Others.Other.Factory.newInstance();
                if (otherDirectCostInfo.getOtherCosts() != null && otherDirectCostInfo.getOtherCosts().size() > 0) {
                    other.setCost(new BigDecimal((String)((Map)otherDirectCostInfo.getOtherCosts().get(0)).get("Cost")));
                }
                other.setDescription("Other");
                otherArray[Otherscount] = other;
                ++Otherscount;
            }
            others.setOtherArray(otherArray);
        }
        return others;
    }

    private BudgetYearDataType.Travel getTravel(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.Travel travel = BudgetYearDataType.Travel.Factory.newInstance();
        if (periodInfo != null) {
            travel.setDomesticTravelCost(periodInfo.getDomesticTravelCost().bigDecimalValue());
            travel.setForeignTravelCost(periodInfo.getForeignTravelCost().bigDecimalValue());
            travel.setTotalTravelCost(periodInfo.getTotalTravelCost().bigDecimalValue());
        }
        return travel;
    }

    private BudgetYearDataType.Equipment getEquipment(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.Equipment equipment = BudgetYearDataType.Equipment.Factory.newInstance();
        Narrative extraEquipmentNarr = null;
        if (periodInfo != null && periodInfo.getEquipment() != null && periodInfo.getEquipment().size() > 0) {
            ArrayList<BudgetYearDataType.Equipment.EquipmentList> equipmentArrayList = new ArrayList<BudgetYearDataType.Equipment.EquipmentList>();
            BudgetDecimal totalFund = BudgetDecimal.ZERO;
            for (CostInfo costInfo : ((EquipmentInfo)periodInfo.getEquipment().get(0)).getEquipmentList()) {
                BudgetYearDataType.Equipment.EquipmentList equipmentList = BudgetYearDataType.Equipment.EquipmentList.Factory.newInstance();
                equipmentList.setEquipmentItem(costInfo.getDescription());
                if (costInfo.getCost() != null) {
                    equipmentList.setFundsRequested(costInfo.getCost().bigDecimalValue());
                }
                totalFund = (BudgetDecimal)totalFund.add((AbstractKualiDecimal)costInfo.getCost());
                equipmentArrayList.add(equipmentList);
            }
            ArrayList<CostInfo> extraEquipmentArrayList = new ArrayList<CostInfo>();
            BudgetDecimal totalExtraEquipFund = BudgetDecimal.ZERO;
            for (CostInfo costInfo : ((EquipmentInfo)periodInfo.getEquipment().get(0)).getExtraEquipmentList()) {
                extraEquipmentArrayList.add(costInfo);
                totalExtraEquipFund = (BudgetDecimal)totalExtraEquipFund.add((AbstractKualiDecimal)costInfo.getCost());
            }
            BudgetYearDataType.Equipment.EquipmentList[] equipmentArray = new BudgetYearDataType.Equipment.EquipmentList[]{};
            equipmentArray = equipmentArrayList.toArray(equipmentArray);
            equipment.setEquipmentListArray(equipmentArray);
            BudgetYearDataType.Equipment.TotalFundForAttachedEquipment totalFundForAttachedEquipment = BudgetYearDataType.Equipment.TotalFundForAttachedEquipment.Factory.newInstance();
            totalFundForAttachedEquipment.setTotalFundForAttachedEquipmentExist(YesNoDataType.Y_YES);
            totalFundForAttachedEquipment.setBigDecimalValue(totalExtraEquipFund.bigDecimalValue());
            equipment.setTotalFundForAttachedEquipment(totalFundForAttachedEquipment);
            totalFund = (BudgetDecimal)totalFund.add((AbstractKualiDecimal)totalExtraEquipFund);
            equipment.setTotalFund(totalFund.bigDecimalValue());
            extraEquipmentNarr = this.saveAdditionalEquipments(periodInfo, extraEquipmentArrayList);
        }
        if (extraEquipmentNarr != null) {
            BudgetYearDataType.Equipment.AdditionalEquipmentsAttachment equipmentAttachment = BudgetYearDataType.Equipment.AdditionalEquipmentsAttachment.Factory.newInstance();
            AttachedFileDataType.FileLocation fileLocation = AttachedFileDataType.FileLocation.Factory.newInstance();
            equipmentAttachment.setFileLocation(fileLocation);
            String contentId = this.createContentId(extraEquipmentNarr);
            fileLocation.setHref(contentId);
            equipmentAttachment.setFileLocation(fileLocation);
            equipmentAttachment.setFileName(extraEquipmentNarr.getFileName());
            equipmentAttachment.setMimeType("application/octet-stream");
            extraEquipmentNarr.refreshReferenceObject("narrativeAttachmentList");
            if (extraEquipmentNarr.getNarrativeAttachmentList() != null && extraEquipmentNarr.getNarrativeAttachmentList().size() > 0) {
                equipmentAttachment.setHashValue(this.getHashValue(((NarrativeAttachment)extraEquipmentNarr.getNarrativeAttachmentList().get(0)).getContent()));
            }
            AttachmentData attachmentData = new AttachmentData();
            attachmentData.setContent(((NarrativeAttachment)extraEquipmentNarr.getNarrativeAttachmentList().get(0)).getContent());
            attachmentData.setContentId(contentId);
            attachmentData.setContentType("application/octet-stream");
            attachmentData.setFileName(extraEquipmentNarr.getFileName());
            this.addAttachment(attachmentData);
            equipmentAttachment.setTotalFundForAttachedEquipmentExist(YesNoDataType.Y_YES);
            equipment.setAdditionalEquipmentsAttachment(equipmentAttachment);
        }
        return equipment;
    }

    private BudgetYearDataType.OtherPersonnel getOtherPersonnel(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherPersonnel otherPersonnel = BudgetYearDataType.OtherPersonnel.Factory.newInstance();
        int OtherpersonalCount = 0;
        ArrayList<OtherPersonnelDataType> otherPersonnelList = new ArrayList<OtherPersonnelDataType>();
        OtherPersonnelDataType[] otherPersonnelDataTypeArray = new OtherPersonnelDataType[1];
        if (periodInfo != null) {
            for (OtherPersonnelInfo otherPersonnelInfo : periodInfo.getOtherPersonnel()) {
                if ("PostDoc".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setPostDocAssociates(this.getPostDocAssociates(otherPersonnelInfo));
                    continue;
                }
                if ("Grad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setGraduateStudents(this.getGraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("UnderGrad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setUndergraduateStudents(this.getUndergraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("Sec".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setSecretarialClerical(this.getSecretarialClerical(otherPersonnelInfo));
                    continue;
                }
                if (OtherpersonalCount >= 6) continue;
                OtherPersonnelDataType otherPersonnelDataType = OtherPersonnelDataType.Factory.newInstance();
                otherPersonnelDataType.setNumberOfPersonnel(otherPersonnelInfo.getNumberPersonnel());
                otherPersonnelDataType.setProjectRole(otherPersonnelInfo.getRole());
                otherPersonnelDataType.setCompensation(this.getSectBCompensationDataType(otherPersonnelInfo.getCompensation()));
                otherPersonnelList.add(otherPersonnelDataType);
                ++OtherpersonalCount;
            }
            otherPersonnelDataTypeArray = otherPersonnelList.toArray(otherPersonnelDataTypeArray);
            otherPersonnel.setOtherArray(otherPersonnelDataTypeArray);
            if (periodInfo.getOtherPersonnelTotalNumber() != null) {
                otherPersonnel.setOtherPersonnelTotalNumber(periodInfo.getOtherPersonnelTotalNumber().intValue());
            }
            if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                otherPersonnel.setTotalOtherPersonnelFund(periodInfo.getTotalOtherPersonnelFunds().bigDecimalValue());
            }
        }
        return otherPersonnel;
    }

    private BudgetYearDataType.OtherPersonnel.PostDocAssociates getPostDocAssociates(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.PostDocAssociates postDocAssociates = BudgetYearDataType.OtherPersonnel.PostDocAssociates.Factory.newInstance();
        if (otherPersonnel != null) {
            postDocAssociates.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            postDocAssociates.setProjectRole(otherPersonnel.getRole());
            postDocAssociates.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return postDocAssociates;
    }

    private BudgetYearDataType.OtherPersonnel.GraduateStudents getGraduateStudents(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.GraduateStudents graduate = BudgetYearDataType.OtherPersonnel.GraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            graduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            graduate.setProjectRole(otherPersonnel.getRole());
            graduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return graduate;
    }

    private BudgetYearDataType.OtherPersonnel.UndergraduateStudents getUndergraduateStudents(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.UndergraduateStudents undergraduate = BudgetYearDataType.OtherPersonnel.UndergraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            undergraduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            undergraduate.setProjectRole(otherPersonnel.getRole());
            undergraduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return undergraduate;
    }

    private BudgetYearDataType.OtherPersonnel.SecretarialClerical getSecretarialClerical(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.SecretarialClerical secretarialClerical = BudgetYearDataType.OtherPersonnel.SecretarialClerical.Factory.newInstance();
        if (otherPersonnel != null) {
            secretarialClerical.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            secretarialClerical.setProjectRole(otherPersonnel.getRole());
            secretarialClerical.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return secretarialClerical;
    }

    private SectBCompensationDataType getSectBCompensationDataType(CompensationInfo compensation) {
        SectBCompensationDataType sectBCompensation = SectBCompensationDataType.Factory.newInstance();
        if (compensation != null) {
            sectBCompensation.setAcademicMonths(compensation.getAcademicMonths().bigDecimalValue());
            sectBCompensation.setCalendarMonths(compensation.getCalendarMonths().bigDecimalValue());
            sectBCompensation.setSummerMonths(compensation.getSummerMonths().bigDecimalValue());
            sectBCompensation.setFringeBenefits(compensation.getFringe().bigDecimalValue());
            sectBCompensation.setFundsRequested(compensation.getFundsRequested().bigDecimalValue());
            sectBCompensation.setRequestedSalary(compensation.getRequestedSalary().bigDecimalValue());
        }
        return sectBCompensation;
    }

    private BudgetYearDataType.KeyPersons getKeyPersons(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.KeyPersons keyPersons = BudgetYearDataType.KeyPersons.Factory.newInstance();
        BudgetDecimal extraFunds = BudgetDecimal.ZERO;
        if (periodInfo != null) {
            if (periodInfo.getKeyPersons() != null) {
                ArrayList<KeyPersonDataType> keyPersonList = new ArrayList<KeyPersonDataType>();
                int keyPersonCount = 0;
                for (KeyPersonInfo keyPerson : periodInfo.getKeyPersons()) {
                    if (!keyPerson.getRole().equals("PD/PI") && !this.hasPersonnelBudget(keyPerson, periodInfo.getBudgetPeriod()).booleanValue()) continue;
                    KeyPersonDataType keyPersonDataType = KeyPersonDataType.Factory.newInstance();
                    keyPersonDataType.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
                    if (this.isSponsorNIH(this.pdDoc) && "CO-PD/PI".equals(keyPerson.getRole())) {
                        DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
                        for (ProposalPerson proposalPerson : developmentProposal.getInvestigators()) {
                            if (!this.isProposalPersonEqualsKeyPerson(proposalPerson, keyPerson)) continue;
                            if (proposalPerson.isMultiplePi()) {
                                keyPersonDataType.setProjectRole("PD/PI");
                                continue;
                            }
                            keyPersonDataType.setProjectRole("CO-INVESTIGATOR");
                        }
                    } else if (keyPerson.getKeyPersonRole() != null) {
                        keyPersonDataType.setProjectRole(keyPerson.getKeyPersonRole());
                    } else {
                        keyPersonDataType.setProjectRole(keyPerson.getRole());
                    }
                    keyPersonDataType.setCompensation(this.getCompensation(keyPerson, periodInfo.getBudgetPeriod()));
                    keyPersonList.add(keyPersonDataType);
                    LOG.info((Object)("keyPersonCount:" + ++keyPersonCount));
                }
                keyPersons.setKeyPersonArray(keyPersonList.toArray(new KeyPersonDataType[0]));
            }
            if (periodInfo.getTotalFundsKeyPersons() != null) {
                keyPersons.setTotalFundForKeyPersons(periodInfo.getTotalFundsKeyPersons().bigDecimalValue());
            }
            for (KeyPersonInfo keyPerson : periodInfo.getExtraKeyPersons()) {
                extraFunds = (BudgetDecimal)extraFunds.add((AbstractKualiDecimal)keyPerson.getFundsRequested());
            }
        }
        BudgetYearDataType.KeyPersons.TotalFundForAttachedKeyPersons totalFundForAttachedKeyPersons = BudgetYearDataType.KeyPersons.TotalFundForAttachedKeyPersons.Factory.newInstance();
        totalFundForAttachedKeyPersons.setTotalFundForAttachedKeyPersonsExist(YesNoDataType.Y_YES);
        totalFundForAttachedKeyPersons.setBigDecimalValue(extraFunds.bigDecimalValue());
        keyPersons.setTotalFundForAttachedKeyPersons(totalFundForAttachedKeyPersons);
        Narrative extraKeyPersonNarr = this.saveExtraKeyPersons(periodInfo);
        if (extraKeyPersonNarr != null) {
            BudgetYearDataType.KeyPersons.AttachedKeyPersons attachedKeyPersons = BudgetYearDataType.KeyPersons.AttachedKeyPersons.Factory.newInstance();
            AttachedFileDataType.FileLocation fileLocation = AttachedFileDataType.FileLocation.Factory.newInstance();
            attachedKeyPersons.setFileLocation(fileLocation);
            String contentId = this.createContentId(extraKeyPersonNarr);
            fileLocation.setHref(contentId);
            attachedKeyPersons.setFileLocation(fileLocation);
            attachedKeyPersons.setFileName(extraKeyPersonNarr.getFileName());
            attachedKeyPersons.setMimeType("application/octet-stream");
            extraKeyPersonNarr.refreshReferenceObject("narrativeAttachmentList");
            AttachmentData attachmentData = new AttachmentData();
            byte[] narrativeContent = null;
            if (extraKeyPersonNarr.getNarrativeAttachmentList() != null && extraKeyPersonNarr.getNarrativeAttachmentList().size() > 0) {
                narrativeContent = ((NarrativeAttachment)extraKeyPersonNarr.getNarrativeAttachmentList().get(0)).getContent();
            }
            if (narrativeContent != null && narrativeContent.length > 0) {
                attachedKeyPersons.setHashValue(this.getHashValue(narrativeContent));
                attachmentData.setContent(narrativeContent);
                attachmentData.setContentId(contentId);
                attachmentData.setContentType("application/octet-stream");
                attachmentData.setFileName(extraKeyPersonNarr.getFileName());
                this.addAttachment(attachmentData);
                attachedKeyPersons.setTotalFundForAttachedKeyPersonsExist(YesNoDataType.Y_YES);
                keyPersons.setAttachedKeyPersons(attachedKeyPersons);
            }
        }
        return keyPersons;
    }

    private KeyPersonCompensationDataType getCompensation(KeyPersonInfo keyPerson, int budgetPeriod) {
        KeyPersonCompensationDataType compensation = KeyPersonCompensationDataType.Factory.newInstance();
        BudgetService budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
        if (keyPerson != null) {
            compensation.setAcademicMonths(keyPerson.getAcademicMonths().bigDecimalValue());
            compensation.setCalendarMonths(keyPerson.getCalendarMonths().bigDecimalValue());
            compensation.setSummerMonths(keyPerson.getSummerMonths().bigDecimalValue());
            compensation.setFringeBenefits(keyPerson.getFringe().bigDecimalValue());
            compensation.setRequestedSalary(keyPerson.getRequestedSalary().bigDecimalValue());
            compensation.setFundsRequested(keyPerson.getFundsRequested().bigDecimalValue());
            if (this.pdDoc.getBudgetDocumentVersions() != null) {
                BudgetDecimal baseSalaryByPeriod = budgetService.getBaseSalaryByPeriod(this.pdDoc.getBudgetDocumentVersion(0).getBudgetVersionOverview().getBudgetId(), budgetPeriod, keyPerson);
                if (baseSalaryByPeriod != null) {
                    compensation.setBaseSalary(baseSalaryByPeriod.bigDecimalValue());
                } else if (keyPerson.getBaseSalary() != null) {
                    compensation.setBaseSalary(keyPerson.getBaseSalary().bigDecimalValue());
                }
            } else {
                compensation.setBaseSalary(keyPerson.getBaseSalary().bigDecimalValue());
            }
        }
        return compensation;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRBudget();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRBudgetDocument.RRBudget rrBudget = (RRBudgetDocument.RRBudget)xmlObject;
        RRBudgetDocument rrBudgetDocument = RRBudgetDocument.Factory.newInstance();
        rrBudgetDocument.setRRBudget(rrBudget);
        return rrBudgetDocument;
    }
}

