/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.kra.s2s.validator.S2SErrorHandler;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;

public abstract class RRFedNonFedBudgetBaseGenerator
extends S2SBaseFormGenerator {
    protected S2SBudgetCalculatorService s2sBudgetCalculatorService;
    protected S2SUtilService s2sUtilService = (S2SUtilService)KraServiceLocator.getService(S2SUtilService.class);
    private DocumentService documentService;
    protected BudgetService budgetService;
    public static final String OTHERPERSONNEL_POSTDOC = "PostDoc";
    public static final String OTHERPERSONNEL_GRADUATE = "Grad";
    public static final String OTHERPERSONNEL_UNDERGRADUATE = "UnderGrad";
    public static final String OTHERPERSONNEL_SECRETARIAL = "Sec";
    public static final String OTHERCOST_DESCRIPTION = "Other";
    protected static final String NID_PD_PI = "PD/PI";
    public static final int ADDITIONAL_KEYPERSONS_ATTACHMENT = 11;
    public static final int BUDGET_JUSTIFICATION_ATTACHMENT = 131;
    public static final int ADDITIONAL_EQUIPMENT_ATTACHMENT = 12;
    protected static final int OTHERPERSONNEL_MAX_ALLOWED = 6;
    protected static final int ARRAY_LIMIT_IN_SCHEMA = 4;

    public RRFedNonFedBudgetBaseGenerator() {
        this.s2sBudgetCalculatorService = (S2SBudgetCalculatorService)KraServiceLocator.getService(S2SBudgetCalculatorService.class);
        this.budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
    }

    protected Boolean hasPersonnelBudget(KeyPersonInfo keyPerson, int period) {
        BudgetDocument budgetDocument = null;
        List budgetLineItemList = new ArrayList();
        ArrayList budgetPersonnelDetailsList = new ArrayList();
        try {
            budgetDocument = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(this.pdDoc.getBudgetDocumentVersion(0).getDocumentNumber());
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        budgetLineItemList = budgetDocument.getBudget().getBudgetPeriod(period - 1).getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : budgetLineItemList) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (budgetPersonnelDetails.getPersonId().equals(keyPerson.getPersonId())) {
                    return true;
                }
                if (keyPerson.getRolodexId() == null || !budgetPersonnelDetails.getPersonId().equals(keyPerson.getRolodexId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean validateBudgetForForm(ProposalDevelopmentDocument pdDoc) throws S2SException {
        boolean valid = true;
        BudgetDocument budget = this.s2sBudgetCalculatorService.getFinalBudgetVersion(pdDoc);
        if (budget != null) {
            for (BudgetPeriod period : budget.getBudget().getBudgetPeriods()) {
                int numberOfParticipants;
                ArrayList<String> participantSupportCode = new ArrayList<String>();
                participantSupportCode.add(this.budgetService.getParticipantSupportCategoryCode());
                List participantSupportLineItems = this.budgetService.getMatchingLineItems(period.getBudgetLineItems(), participantSupportCode);
                int n = numberOfParticipants = period.getNumberOfParticipants() == null ? 0 : period.getNumberOfParticipants();
                if (!participantSupportLineItems.isEmpty() && numberOfParticipants == 0) {
                    this.getAuditErrors().add(S2SErrorHandler.getError((String)"s2s.budget.participantcount.required"));
                    valid = false;
                    continue;
                }
                if (numberOfParticipants <= 0 || !participantSupportLineItems.isEmpty()) continue;
                this.getAuditErrors().add(S2SErrorHandler.getError((String)"s2s.budget.participantcost.required"));
                valid = false;
            }
        }
        return valid;
    }

    public DocumentService getDocumentService() {
        return (DocumentService)KraServiceLocator.getService(DocumentService.class);
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected BudgetService getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }
}

