/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrFedNonFedBudgetV10.BudgetTypeDataType;
import gov.grants.apply.forms.rrFedNonFedBudgetV10.BudgetYear1DataType;
import gov.grants.apply.forms.rrFedNonFedBudgetV10.BudgetYearDataType;
import gov.grants.apply.forms.rrFedNonFedBudgetV10.KeyPersonCompensationDataType;
import gov.grants.apply.forms.rrFedNonFedBudgetV10.KeyPersonDataType;
import gov.grants.apply.forms.rrFedNonFedBudgetV10.OtherPersonnelDataType;
import gov.grants.apply.forms.rrFedNonFedBudgetV10.RRFedNonFedBudgetDocument;
import gov.grants.apply.forms.rrFedNonFedBudgetV10.SectBCompensationDataType;
import gov.grants.apply.forms.rrFedNonFedBudgetV10.SummaryDataType;
import gov.grants.apply.forms.rrFedNonFedBudgetV10.TotalDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.bo.BudgetPeriodInfo;
import org.kuali.kra.s2s.generator.bo.BudgetSummaryInfo;
import org.kuali.kra.s2s.generator.bo.CompensationInfo;
import org.kuali.kra.s2s.generator.bo.CostInfo;
import org.kuali.kra.s2s.generator.bo.EquipmentInfo;
import org.kuali.kra.s2s.generator.bo.IndirectCostDetails;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.generator.bo.OtherDirectCostInfo;
import org.kuali.kra.s2s.generator.bo.OtherPersonnelInfo;
import org.kuali.kra.s2s.generator.impl.RRFedNonFedBudgetBaseGenerator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class RRFedNonFedBudgetV1_0Generator
extends RRFedNonFedBudgetBaseGenerator {
    private static final Log LOG = LogFactory.getLog(RRFedNonFedBudgetV1_0Generator.class);

    private RRFedNonFedBudgetDocument getRRFedNonFedBudget() {
        List budgetPeriodList;
        RRFedNonFedBudgetDocument rrFedNonFedBudgetDocument = RRFedNonFedBudgetDocument.Factory.newInstance();
        RRFedNonFedBudgetDocument.RRFedNonFedBudget fedNonFedBudget = RRFedNonFedBudgetDocument.RRFedNonFedBudget.Factory.newInstance();
        fedNonFedBudget.setFormVersion("1.0");
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            fedNonFedBudget.setDUNSID(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber());
        }
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            fedNonFedBudget.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
        }
        fedNonFedBudget.setBudgetType(BudgetTypeDataType.PROJECT);
        BudgetSummaryInfo budgetSummary = null;
        try {
            budgetPeriodList = this.s2sBudgetCalculatorService.getBudgetPeriods(this.pdDoc);
            budgetSummary = this.s2sBudgetCalculatorService.getBudgetInfo(this.pdDoc, budgetPeriodList);
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return rrFedNonFedBudgetDocument;
        }
        for (BudgetPeriodInfo budgetPeriodData : budgetPeriodList) {
            if (budgetPeriodData.getBudgetPeriod() == 1) {
                fedNonFedBudget.setBudgetYear1(this.getBudgetYear1DataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == 2 && budgetPeriodData.getLineItemCount() > 0) {
                fedNonFedBudget.setBudgetYear2(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == 3 && budgetPeriodData.getLineItemCount() > 0) {
                fedNonFedBudget.setBudgetYear3(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == 4 && budgetPeriodData.getLineItemCount() > 0) {
                fedNonFedBudget.setBudgetYear4(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() != 5 || budgetPeriodData.getLineItemCount() <= 0) continue;
            fedNonFedBudget.setBudgetYear5(this.getBudgetYearDataType(budgetPeriodData));
        }
        fedNonFedBudget.setBudgetSummary(this.getBudgetSummary(budgetSummary));
        rrFedNonFedBudgetDocument.setRRFedNonFedBudget(fedNonFedBudget);
        return rrFedNonFedBudgetDocument;
    }

    private RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary getBudgetSummary(BudgetSummaryInfo budgetSummaryData) {
        RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary budgetSummary = RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.Factory.newInstance();
        SummaryDataType summaryPersonnel = SummaryDataType.Factory.newInstance();
        SummaryDataType summarySeniorKey = SummaryDataType.Factory.newInstance();
        SummaryDataType directCosts = SummaryDataType.Factory.newInstance();
        SummaryDataType directIndirectCosts = SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
                summarySeniorKey.setFederalSummary(budgetSummaryData.getCumTotalFundsForSrPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalNonFundsForSrPersonnel() != null) {
                summarySeniorKey.setNonFederalSummary(budgetSummaryData.getCumTotalNonFundsForSrPersonnel().bigDecimalValue());
                if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
                    summarySeniorKey.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTotalFundsForSrPersonnel().add((AbstractKualiDecimal)budgetSummaryData.getCumTotalNonFundsForSrPersonnel())).bigDecimalValue());
                } else {
                    summarySeniorKey.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalNonFundsForSrPersonnel().bigDecimalValue());
                }
            }
            SummaryDataType summaryOtherPersonnel = SummaryDataType.Factory.newInstance();
            if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null) {
                summaryOtherPersonnel.setFederalSummary(budgetSummaryData.getCumTotalFundsForOtherPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalNonFundsForOtherPersonnel() != null) {
                summaryOtherPersonnel.setNonFederalSummary(budgetSummaryData.getCumTotalNonFundsForOtherPersonnel().bigDecimalValue());
                if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null) {
                    summaryOtherPersonnel.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTotalFundsForOtherPersonnel().add((AbstractKualiDecimal)budgetSummaryData.getCumTotalNonFundsForOtherPersonnel())).bigDecimalValue());
                } else {
                    summaryOtherPersonnel.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalNonFundsForOtherPersonnel().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeTotalFundsRequestedOtherPersonnel(summaryOtherPersonnel);
            if (budgetSummaryData.getCumNumOtherPersonnel() != null) {
                budgetSummary.setCumulativeTotalNoOtherPersonnel(budgetSummaryData.getCumNumOtherPersonnel().intValue());
            }
            if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
                summaryPersonnel.setFederalSummary(budgetSummaryData.getCumTotalFundsForPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalNonFundsForPersonnel() != null) {
                summaryPersonnel.setNonFederalSummary(budgetSummaryData.getCumTotalNonFundsForPersonnel().bigDecimalValue());
                if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
                    summaryPersonnel.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTotalFundsForPersonnel().add((AbstractKualiDecimal)budgetSummaryData.getCumTotalNonFundsForPersonnel())).bigDecimalValue());
                } else {
                    summaryPersonnel.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalNonFundsForPersonnel().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeEquipments(this.getCumulativeEquipments(budgetSummaryData));
            budgetSummary.setCumulativeTravels(this.getCumulativeTravels(budgetSummaryData));
            budgetSummary.setCumulativeTrainee(this.getCumulativeTrainee(budgetSummaryData));
            budgetSummary.setCumulativeOtherDirect(this.getCumulativeOtherDirect(budgetSummaryData));
            if (budgetSummaryData.getCumTotalDirectCosts() != null && budgetSummaryData.getCumTotalDirectCostSharing() != null) {
                if (budgetSummaryData.getCumFee() != null) {
                    budgetSummary.setCumulativeFee(budgetSummaryData.getCumFee().bigDecimalValue());
                }
                directCosts.setFederalSummary(budgetSummaryData.getCumTotalDirectCosts().bigDecimalValue());
                directCosts.setNonFederalSummary(budgetSummaryData.getCumTotalDirectCostSharing().bigDecimalValue());
                directCosts.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTotalDirectCosts().add((AbstractKualiDecimal)budgetSummaryData.getCumTotalDirectCostSharing())).bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalIndirectCosts() != null && budgetSummaryData.getCumTotalIndirectCostSharing() != null) {
                SummaryDataType summaryDataType = SummaryDataType.Factory.newInstance();
                summaryDataType.setFederalSummary(budgetSummaryData.getCumTotalIndirectCosts().bigDecimalValue());
                summaryDataType.setNonFederalSummary(budgetSummaryData.getCumTotalIndirectCostSharing().bigDecimalValue());
                summaryDataType.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTotalIndirectCosts().add((AbstractKualiDecimal)budgetSummaryData.getCumTotalIndirectCostSharing())).bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedIndirectCost(summaryDataType);
            }
            if (budgetSummaryData.getCumTotalCosts() != null && budgetSummaryData.getCumTotalCostSharing() != null) {
                directIndirectCosts.setFederalSummary(budgetSummaryData.getCumTotalCosts().bigDecimalValue());
                directIndirectCosts.setNonFederalSummary(budgetSummaryData.getCumTotalCostSharing().bigDecimalValue());
                directIndirectCosts.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTotalCosts().add((AbstractKualiDecimal)budgetSummaryData.getCumTotalCostSharing())).bigDecimalValue());
            }
        }
        budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(summarySeniorKey);
        budgetSummary.setCumulativeTotalFundsRequestedPersonnel(summaryPersonnel);
        budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(directCosts);
        budgetSummary.setCumulativeTotalFundsRequestedDirectIndirectCosts(directIndirectCosts);
        return budgetSummary;
    }

    private RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeOtherDirect getCumulativeOtherDirect(BudgetSummaryInfo budgetSummaryData) {
        RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeOtherDirect cumulativeOtherDirect = RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeOtherDirect.Factory.newInstance();
        SummaryDataType summary = SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null && budgetSummaryData.getOtherDirectCosts() != null) {
            for (OtherDirectCostInfo cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.gettotalOtherDirect() != null) {
                    summary.setFederalSummary(cumOtherDirect.gettotalOtherDirect().bigDecimalValue());
                }
                if (cumOtherDirect.getTotalOtherDirectCostSharing() != null) {
                    summary.setNonFederalSummary(cumOtherDirect.getTotalOtherDirectCostSharing().bigDecimalValue());
                    if (cumOtherDirect.gettotalOtherDirect() != null) {
                        summary.setTotalFedNonFedSummary(((BudgetDecimal)cumOtherDirect.gettotalOtherDirect().add((AbstractKualiDecimal)cumOtherDirect.getTotalOtherDirectCostSharing())).bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(cumOtherDirect.getTotalOtherDirectCostSharing().bigDecimalValue());
                    }
                }
                cumulativeOtherDirect.setCumulativeTotalFundsRequestedOtherDirectCosts(summary);
                TotalDataType totalMaterial = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getmaterials() != null) {
                    totalMaterial.setFederal(cumOtherDirect.getmaterials().bigDecimalValue());
                }
                if (cumOtherDirect.getMaterialsCostSharing() != null) {
                    totalMaterial.setNonFederal(cumOtherDirect.getMaterialsCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getmaterials() != null) {
                        totalMaterial.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getmaterials().add((AbstractKualiDecimal)cumOtherDirect.getMaterialsCostSharing())).bigDecimalValue());
                    } else {
                        totalMaterial.setTotalFedNonFed(cumOtherDirect.getMaterialsCostSharing().bigDecimalValue());
                    }
                }
                cumulativeOtherDirect.setCumulativeMaterialAndSupplies(totalMaterial);
                TotalDataType totalPublication = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getpublications() != null) {
                    totalPublication.setFederal(cumOtherDirect.getpublications().bigDecimalValue());
                }
                if (cumOtherDirect.getPublicationsCostSharing() != null) {
                    totalPublication.setNonFederal(cumOtherDirect.getPublicationsCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getpublications() != null) {
                        totalPublication.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getpublications().add((AbstractKualiDecimal)cumOtherDirect.getPublicationsCostSharing())).bigDecimalValue());
                    } else {
                        totalPublication.setTotalFedNonFed(cumOtherDirect.getPublicationsCostSharing().bigDecimalValue());
                    }
                }
                cumulativeOtherDirect.setCumulativePublicationCosts(totalPublication);
                TotalDataType totalConsultant = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getConsultants() != null) {
                    totalConsultant.setFederal(cumOtherDirect.getConsultants().bigDecimalValue());
                }
                if (cumOtherDirect.getConsultantsCostSharing() != null) {
                    totalConsultant.setNonFederal(cumOtherDirect.getConsultantsCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getConsultants() != null) {
                        totalConsultant.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getConsultants().add((AbstractKualiDecimal)cumOtherDirect.getConsultantsCostSharing())).bigDecimalValue());
                    } else {
                        totalConsultant.setTotalFedNonFed(cumOtherDirect.getConsultantsCostSharing().bigDecimalValue());
                    }
                }
                cumulativeOtherDirect.setCumulativeConsultantServices(totalConsultant);
                TotalDataType totalComputer = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getcomputer() != null) {
                    totalComputer.setFederal(cumOtherDirect.getcomputer().bigDecimalValue());
                }
                if (cumOtherDirect.getComputerCostSharing() != null) {
                    totalComputer.setNonFederal(cumOtherDirect.getComputerCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getcomputer() != null) {
                        totalComputer.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getcomputer().add((AbstractKualiDecimal)cumOtherDirect.getComputerCostSharing())).bigDecimalValue());
                    } else {
                        totalComputer.setTotalFedNonFed(cumOtherDirect.getComputerCostSharing().bigDecimalValue());
                    }
                }
                cumulativeOtherDirect.setCumulativeADPComputerServices(totalComputer);
                TotalDataType totalSubaward = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getsubAwards() != null) {
                    totalSubaward.setFederal(cumOtherDirect.getsubAwards().bigDecimalValue());
                }
                if (cumOtherDirect.getSubAwardsCostSharing() != null) {
                    totalSubaward.setNonFederal(cumOtherDirect.getSubAwardsCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getsubAwards() != null) {
                        totalSubaward.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getsubAwards().add((AbstractKualiDecimal)cumOtherDirect.getSubAwardsCostSharing())).bigDecimalValue());
                    } else {
                        totalSubaward.setTotalFedNonFed(cumOtherDirect.getSubAwardsCostSharing().bigDecimalValue());
                    }
                }
                cumulativeOtherDirect.setCumulativeSubawardConsortiumContractualCosts(totalSubaward);
                TotalDataType totalEquipment = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getEquipRental() != null) {
                    totalEquipment.setFederal(cumOtherDirect.getEquipRental().bigDecimalValue());
                }
                if (cumOtherDirect.getEquipRentalCostSharing() != null) {
                    totalEquipment.setNonFederal(cumOtherDirect.getEquipRentalCostSharing().bigDecimalValue());
                    totalEquipment.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getEquipRental().add((AbstractKualiDecimal)cumOtherDirect.getEquipRentalCostSharing())).bigDecimalValue());
                }
                cumulativeOtherDirect.setCumulativeEquipmentFacilityRentalFees(totalEquipment);
                TotalDataType totalAlterations = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getAlterations() != null) {
                    totalAlterations.setFederal(cumOtherDirect.getAlterations().bigDecimalValue());
                }
                if (cumOtherDirect.getAlterationsCostSharing() != null) {
                    totalAlterations.setNonFederal(cumOtherDirect.getAlterationsCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getAlterations() != null) {
                        totalAlterations.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getAlterations().add((AbstractKualiDecimal)cumOtherDirect.getAlterationsCostSharing())).bigDecimalValue());
                    } else {
                        totalAlterations.setTotalFedNonFed(cumOtherDirect.getAlterationsCostSharing().bigDecimalValue());
                    }
                }
                cumulativeOtherDirect.setCumulativeAlterationsAndRenovations(totalAlterations);
                TotalDataType totalOther = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getOtherCosts() != null && cumOtherDirect.getOtherCosts().size() > 0) {
                    totalOther.setFederal(new BigDecimal((String)((Map)cumOtherDirect.getOtherCosts().get(0)).get("Cost")));
                    totalOther.setNonFederal(new BigDecimal((String)((Map)cumOtherDirect.getOtherCosts().get(0)).get("CostSharing")));
                }
                if (totalOther.getFederal() != null && totalOther.getNonFederal() != null) {
                    totalOther.setTotalFedNonFed(totalOther.getFederal().add(totalOther.getNonFederal()));
                }
                cumulativeOtherDirect.setCumulativeOther1DirectCost(totalOther);
            }
        }
        cumulativeOtherDirect.setCumulativeTotalFundsRequestedOtherDirectCosts(summary);
        return cumulativeOtherDirect;
    }

    private RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeTrainee getCumulativeTrainee(BudgetSummaryInfo budgetSummaryData) {
        RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeTrainee cumulativeTrainee = RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeTrainee.Factory.newInstance();
        SummaryDataType summaryTraineeCosts = SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getpartOtherCost() != null && budgetSummaryData.getpartStipendCost() != null && budgetSummaryData.getpartTravelCost() != null && budgetSummaryData.getPartSubsistence() != null && budgetSummaryData.getPartTuition() != null) {
                summaryTraineeCosts.setFederalSummary(((BudgetDecimal)budgetSummaryData.getpartOtherCost().add(budgetSummaryData.getpartStipendCost().add(budgetSummaryData.getpartTravelCost().add(budgetSummaryData.getPartSubsistence().add((AbstractKualiDecimal)budgetSummaryData.getPartTuition()))))).bigDecimalValue());
            }
            if (budgetSummaryData.getPartOtherCostSharing() != null && budgetSummaryData.getPartStipendCostSharing() != null && budgetSummaryData.getPartTravelCostSharing() != null && budgetSummaryData.getPartSubsistenceCostSharing() != null && budgetSummaryData.getPartTuitionCostSharing() != null) {
                summaryTraineeCosts.setNonFederalSummary(((BudgetDecimal)budgetSummaryData.getPartOtherCostSharing().add(budgetSummaryData.getPartStipendCostSharing().add(budgetSummaryData.getPartTravelCostSharing().add(budgetSummaryData.getPartSubsistenceCostSharing().add((AbstractKualiDecimal)budgetSummaryData.getPartTuitionCostSharing()))))).bigDecimalValue());
            }
            if (summaryTraineeCosts.getNonFederalSummary() != null) {
                if (summaryTraineeCosts.getFederalSummary() != null) {
                    summaryTraineeCosts.setTotalFedNonFedSummary(summaryTraineeCosts.getFederalSummary().add(summaryTraineeCosts.getNonFederalSummary()));
                } else {
                    summaryTraineeCosts.setTotalFedNonFedSummary(summaryTraineeCosts.getNonFederalSummary());
                }
            }
            TotalDataType totalTuition = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getPartTuition() != null) {
                totalTuition.setFederal(budgetSummaryData.getPartTuition().bigDecimalValue());
            }
            if (budgetSummaryData.getPartTuitionCostSharing() != null) {
                totalTuition.setNonFederal(budgetSummaryData.getPartTuitionCostSharing().bigDecimalValue());
                if (budgetSummaryData.getPartTuition() != null) {
                    totalTuition.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getPartTuition().add((AbstractKualiDecimal)budgetSummaryData.getPartTuitionCostSharing())).bigDecimalValue());
                } else {
                    totalTuition.setTotalFedNonFed(budgetSummaryData.getPartTuitionCostSharing().bigDecimalValue());
                }
            }
            cumulativeTrainee.setCumulativeTraineeTuitionFeesHealthInsurance(totalTuition);
            TotalDataType totalStipends = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getpartStipendCost() != null) {
                totalStipends.setFederal(budgetSummaryData.getpartStipendCost().bigDecimalValue());
            }
            if (budgetSummaryData.getPartStipendCostSharing() != null) {
                totalStipends.setNonFederal(budgetSummaryData.getPartStipendCostSharing().bigDecimalValue());
                if (budgetSummaryData.getpartStipendCost() != null) {
                    totalStipends.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getpartStipendCost().add((AbstractKualiDecimal)budgetSummaryData.getPartStipendCostSharing())).bigDecimalValue());
                } else {
                    totalStipends.setTotalFedNonFed(budgetSummaryData.getPartStipendCostSharing().bigDecimalValue());
                }
            }
            cumulativeTrainee.setCumulativeTraineeStipends(totalStipends);
            TotalDataType totalTravel = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getpartTravelCost() != null) {
                totalTravel.setFederal(budgetSummaryData.getpartTravelCost().bigDecimalValue());
            }
            if (budgetSummaryData.getPartTravelCostSharing() != null) {
                totalTravel.setNonFederal(budgetSummaryData.getPartTravelCostSharing().bigDecimalValue());
                if (budgetSummaryData.getpartTravelCost() != null) {
                    totalTravel.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getpartTravelCost().add((AbstractKualiDecimal)budgetSummaryData.getPartTravelCostSharing())).bigDecimalValue());
                } else {
                    totalTravel.setTotalFedNonFed(budgetSummaryData.getPartTravelCostSharing().bigDecimalValue());
                }
            }
            cumulativeTrainee.setCumulativeTraineeTravel(totalTravel);
            TotalDataType totalSubsistence = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getPartSubsistence() != null) {
                totalSubsistence.setFederal(budgetSummaryData.getPartSubsistence().bigDecimalValue());
            }
            if (budgetSummaryData.getPartSubsistenceCostSharing() != null) {
                totalSubsistence.setNonFederal(budgetSummaryData.getPartSubsistenceCostSharing().bigDecimalValue());
                if (budgetSummaryData.getPartSubsistence() != null) {
                    totalSubsistence.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getPartSubsistence().add((AbstractKualiDecimal)budgetSummaryData.getPartSubsistenceCostSharing())).bigDecimalValue());
                } else {
                    totalSubsistence.setTotalFedNonFed(budgetSummaryData.getPartSubsistenceCostSharing().bigDecimalValue());
                }
            }
            cumulativeTrainee.setCumulativeTraineeSubsistence(totalSubsistence);
            TotalDataType totalOtherTrainee = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getpartOtherCost() != null) {
                totalOtherTrainee.setFederal(budgetSummaryData.getpartOtherCost().bigDecimalValue());
            }
            if (budgetSummaryData.getPartOtherCostSharing() != null) {
                totalOtherTrainee.setNonFederal(budgetSummaryData.getPartOtherCostSharing().bigDecimalValue());
                if (budgetSummaryData.getpartOtherCost() != null) {
                    totalOtherTrainee.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getpartOtherCost().add((AbstractKualiDecimal)budgetSummaryData.getPartOtherCostSharing())).bigDecimalValue());
                } else {
                    totalOtherTrainee.setTotalFedNonFed(budgetSummaryData.getPartOtherCostSharing().bigDecimalValue());
                }
            }
            cumulativeTrainee.setCumulativeOtherTraineeCost(totalOtherTrainee);
            cumulativeTrainee.setCumulativeNoofTrainees(budgetSummaryData.getparticipantCount());
        }
        cumulativeTrainee.setCumulativeTotalFundsRequestedTraineeCosts(summaryTraineeCosts);
        return cumulativeTrainee;
    }

    private RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeTravels getCumulativeTravels(BudgetSummaryInfo budgetSummaryData) {
        RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeTravels cumulativeTravels = RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeTravels.Factory.newInstance();
        SummaryDataType summary = SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumTravel() != null) {
                summary.setFederalSummary(budgetSummaryData.getCumTravel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTravelNonFund() != null) {
                summary.setNonFederalSummary(budgetSummaryData.getCumTravelNonFund().bigDecimalValue());
                if (budgetSummaryData.getCumTravel() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTravel().add((AbstractKualiDecimal)budgetSummaryData.getCumTravelNonFund())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(budgetSummaryData.getCumTravelNonFund().bigDecimalValue());
                }
            }
            TotalDataType totalDomestic = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getCumDomesticTravel() != null) {
                totalDomestic.setFederal(budgetSummaryData.getCumDomesticTravel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumDomesticTravelNonFund() != null) {
                totalDomestic.setNonFederal(budgetSummaryData.getCumDomesticTravelNonFund().bigDecimalValue());
                if (budgetSummaryData.getCumDomesticTravel() != null) {
                    totalDomestic.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getCumDomesticTravel().add((AbstractKualiDecimal)budgetSummaryData.getCumDomesticTravelNonFund())).bigDecimalValue());
                } else {
                    totalDomestic.setTotalFedNonFed(budgetSummaryData.getCumDomesticTravelNonFund().bigDecimalValue());
                }
            }
            cumulativeTravels.setCumulativeDomesticTravelCosts(totalDomestic);
            TotalDataType totalForeign = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getCumForeignTravel() != null) {
                totalForeign.setFederal(budgetSummaryData.getCumForeignTravel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumForeignTravelNonFund() != null) {
                totalForeign.setNonFederal(budgetSummaryData.getCumForeignTravelNonFund().bigDecimalValue());
                if (budgetSummaryData.getCumForeignTravel() != null) {
                    totalForeign.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getCumForeignTravel().add((AbstractKualiDecimal)budgetSummaryData.getCumForeignTravelNonFund())).bigDecimalValue());
                } else {
                    totalForeign.setTotalFedNonFed(budgetSummaryData.getCumForeignTravelNonFund().bigDecimalValue());
                }
            }
            cumulativeTravels.setCumulativeForeignTravelCosts(totalForeign);
        }
        cumulativeTravels.setCumulativeTotalFundsRequestedTravel(summary);
        return cumulativeTravels;
    }

    private RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeEquipments getCumulativeEquipments(BudgetSummaryInfo budgetSummaryData) {
        RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeEquipments cumulativeEquipments = RRFedNonFedBudgetDocument.RRFedNonFedBudget.BudgetSummary.CumulativeEquipments.Factory.newInstance();
        SummaryDataType summary = SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumEquipmentFunds() != null) {
                summary.setFederalSummary(budgetSummaryData.getCumEquipmentFunds().bigDecimalValue());
            }
            if (budgetSummaryData.getCumEquipmentNonFunds() != null) {
                summary.setNonFederalSummary(budgetSummaryData.getCumEquipmentNonFunds().bigDecimalValue());
                if (budgetSummaryData.getCumEquipmentFunds() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumEquipmentFunds().add((AbstractKualiDecimal)budgetSummaryData.getCumEquipmentNonFunds())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(budgetSummaryData.getCumEquipmentNonFunds().bigDecimalValue());
                }
            }
        }
        cumulativeEquipments.setCumulativeTotalFundsRequestedEquipment(summary);
        return cumulativeEquipments;
    }

    private BudgetYearDataType getBudgetYearDataType(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType budgetYear = BudgetYearDataType.Factory.newInstance();
        if (periodInfo != null) {
            budgetYear.setBudgetPeriodStartDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getStartDate()));
            budgetYear.setBudgetPeriodEndDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getEndDate()));
            BudgetYearDataType.BudgetPeriod.Enum budgetPeriod = BudgetYearDataType.BudgetPeriod.Enum.forInt((int)periodInfo.getBudgetPeriod());
            budgetYear.setBudgetPeriod(budgetPeriod);
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalCompensation() != null) {
                summary.setFederalSummary(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            if (periodInfo.getTotalCompensationCostSharing() != null) {
                summary.setNonFederalSummary(periodInfo.getTotalCompensationCostSharing().bigDecimalValue());
                if (periodInfo.getTotalCompensation() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalCompensation().add((AbstractKualiDecimal)periodInfo.getTotalCompensationCostSharing())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(periodInfo.getTotalCompensationCostSharing().bigDecimalValue());
                }
            }
            budgetYear.setTotalCompensation(summary);
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            SummaryDataType summaryDirect = SummaryDataType.Factory.newInstance();
            if (periodInfo.getDirectCostsTotal() != null) {
                summaryDirect.setFederalSummary(periodInfo.getDirectCostsTotal().bigDecimalValue());
            }
            if (periodInfo.getTotalDirectCostSharing() != null) {
                summaryDirect.setNonFederalSummary(periodInfo.getTotalDirectCostSharing().bigDecimalValue());
                if (periodInfo.getDirectCostsTotal() != null) {
                    summaryDirect.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getDirectCostsTotal().add((AbstractKualiDecimal)periodInfo.getTotalDirectCostSharing())).bigDecimalValue());
                } else {
                    summaryDirect.setTotalFedNonFedSummary(periodInfo.getTotalDirectCostSharing().bigDecimalValue());
                }
            }
            budgetYear.setDirectCosts(summaryDirect);
            BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
            if (indirectCosts != null) {
                budgetYear.setIndirectCosts(indirectCosts);
            }
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
            SummaryDataType summaryTotal = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalCosts() != null) {
                summaryTotal.setFederalSummary(periodInfo.getTotalCosts().bigDecimalValue());
            }
            if (periodInfo.getCostSharingAmount() != null) {
                summaryTotal.setNonFederalSummary(periodInfo.getCostSharingAmount().bigDecimalValue());
                if (periodInfo.getTotalCosts() != null) {
                    summaryTotal.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalCosts().add((AbstractKualiDecimal)periodInfo.getCostSharingAmount())).bigDecimalValue());
                } else {
                    summaryTotal.setTotalFedNonFedSummary(periodInfo.getCostSharingAmount().bigDecimalValue());
                }
            }
            budgetYear.setTotalCosts(summaryTotal);
        }
        return budgetYear;
    }

    private BudgetYear1DataType getBudgetYear1DataType(BudgetPeriodInfo periodInfo) {
        BudgetYear1DataType budgetYear = BudgetYear1DataType.Factory.newInstance();
        if (periodInfo != null) {
            budgetYear.setBudgetPeriodStartDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getStartDate()));
            budgetYear.setBudgetPeriodEndDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getEndDate()));
            BudgetYearDataType.BudgetPeriod.Enum budgetPeriod = BudgetYearDataType.BudgetPeriod.Enum.forInt((int)periodInfo.getBudgetPeriod());
            budgetYear.setBudgetPeriod(budgetPeriod);
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalCompensation() != null) {
                summary.setFederalSummary(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            if (periodInfo.getTotalCompensationCostSharing() != null) {
                summary.setNonFederalSummary(periodInfo.getTotalCompensationCostSharing().bigDecimalValue());
                if (periodInfo.getTotalCompensation() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalCompensation().add((AbstractKualiDecimal)periodInfo.getTotalCompensationCostSharing())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(periodInfo.getTotalCompensationCostSharing().bigDecimalValue());
                }
            }
            budgetYear.setTotalCompensation(summary);
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            SummaryDataType summaryDirect = SummaryDataType.Factory.newInstance();
            if (periodInfo.getDirectCostsTotal() != null) {
                summaryDirect.setFederalSummary(periodInfo.getDirectCostsTotal().bigDecimalValue());
            }
            if (periodInfo.getTotalDirectCostSharing() != null) {
                summaryDirect.setNonFederalSummary(periodInfo.getTotalDirectCostSharing().bigDecimalValue());
                if (periodInfo.getDirectCostsTotal() != null) {
                    summaryDirect.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getDirectCostsTotal().add((AbstractKualiDecimal)periodInfo.getTotalDirectCostSharing())).bigDecimalValue());
                } else {
                    summaryDirect.setTotalFedNonFedSummary(periodInfo.getTotalDirectCostSharing().bigDecimalValue());
                }
            }
            budgetYear.setDirectCosts(summaryDirect);
            budgetYear.setIndirectCosts(this.getIndirectCosts(periodInfo));
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
            SummaryDataType summaryTotal = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalCosts() != null) {
                summaryTotal.setFederalSummary(periodInfo.getTotalCosts().bigDecimalValue());
            }
            if (periodInfo.getCostSharingAmount() != null) {
                summaryTotal.setNonFederalSummary(periodInfo.getCostSharingAmount().bigDecimalValue());
                if (periodInfo.getTotalCosts() != null) {
                    summaryTotal.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalCosts().add((AbstractKualiDecimal)periodInfo.getCostSharingAmount())).bigDecimalValue());
                } else {
                    summaryTotal.setTotalFedNonFedSummary(periodInfo.getCostSharingAmount().bigDecimalValue());
                }
            }
            budgetYear.setTotalCosts(summaryTotal);
        }
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 131 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            budgetYear.setBudgetJustificationAttachment(attachedFileDataType);
            break;
        }
        return budgetYear;
    }

    private BudgetYearDataType.KeyPersons getKeyPersons(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.KeyPersons keyPersons = BudgetYearDataType.KeyPersons.Factory.newInstance();
        if (periodInfo != null) {
            if (periodInfo.getKeyPersons() != null) {
                KeyPersonDataType[] keyPersonDataTypeArray = new KeyPersonDataType[periodInfo.getKeyPersons().size()];
                int keyPersonCount = 0;
                for (KeyPersonInfo keyPerson : periodInfo.getKeyPersons()) {
                    KeyPersonDataType keyPersonDataType = KeyPersonDataType.Factory.newInstance();
                    keyPersonDataType.setName(this.globLibV10Generator.getHumanNameDataType(keyPerson));
                    keyPersonDataType.setProjectRole(keyPerson.getRole());
                    keyPersonDataType.setCompensation(this.getCompensation(keyPerson));
                    keyPersonDataTypeArray[keyPersonCount] = keyPersonDataType;
                    LOG.info((Object)("keyPersonCount:" + ++keyPersonCount));
                }
                keyPersons.setKeyPersonArray(keyPersonDataTypeArray);
            }
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalFundsKeyPersons() != null) {
                summary.setFederalSummary(periodInfo.getTotalFundsKeyPersons().bigDecimalValue());
            }
            if (periodInfo.getTotalNonFundsKeyPersons() != null) {
                summary.setNonFederalSummary(periodInfo.getTotalNonFundsKeyPersons().bigDecimalValue());
                if (periodInfo.getTotalFundsKeyPersons() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalFundsKeyPersons().add((AbstractKualiDecimal)periodInfo.getTotalNonFundsKeyPersons())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(periodInfo.getTotalNonFundsKeyPersons().bigDecimalValue());
                }
            }
            keyPersons.setTotalFundForKeyPersons(summary);
            SummaryDataType summaryAttachedKey = SummaryDataType.Factory.newInstance();
            if (periodInfo.getKeyPersons() != null && periodInfo.getKeyPersons().size() > 0) {
                if (((KeyPersonInfo)periodInfo.getKeyPersons().get(0)).getFundsRequested() != null) {
                    summaryAttachedKey.setFederalSummary(((KeyPersonInfo)periodInfo.getKeyPersons().get(0)).getFundsRequested().bigDecimalValue());
                }
                if (((KeyPersonInfo)periodInfo.getKeyPersons().get(0)).getNonFundsRequested() != null) {
                    summaryAttachedKey.setNonFederalSummary(((KeyPersonInfo)periodInfo.getKeyPersons().get(0)).getNonFundsRequested().bigDecimalValue());
                    if (((KeyPersonInfo)periodInfo.getKeyPersons().get(0)).getFundsRequested() != null) {
                        summaryAttachedKey.setTotalFedNonFedSummary(((BudgetDecimal)((KeyPersonInfo)periodInfo.getKeyPersons().get(0)).getFundsRequested().add((AbstractKualiDecimal)((KeyPersonInfo)periodInfo.getKeyPersons().get(0)).getNonFundsRequested())).bigDecimalValue());
                    } else {
                        summaryAttachedKey.setTotalFedNonFedSummary(((KeyPersonInfo)periodInfo.getKeyPersons().get(0)).getNonFundsRequested().bigDecimalValue());
                    }
                }
            }
            keyPersons.setTotalFundForAttachedKeyPersons(summaryAttachedKey);
        }
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 11 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            keyPersons.setAttachedKeyPersons(attachedFileDataType);
            break;
        }
        return keyPersons;
    }

    private BudgetYearDataType.OtherPersonnel getOtherPersonnel(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherPersonnel otherPersonnel = BudgetYearDataType.OtherPersonnel.Factory.newInstance();
        int OtherpersonalCount = 0;
        ArrayList<OtherPersonnelDataType> otherPersonnelList = new ArrayList<OtherPersonnelDataType>();
        OtherPersonnelDataType[] otherPersonnelDataTypeArray = new OtherPersonnelDataType[1];
        if (periodInfo != null) {
            for (OtherPersonnelInfo otherPersonnelInfo : periodInfo.getOtherPersonnel()) {
                if ("PostDoc".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setPostDocAssociates(this.getPostDocAssociates(otherPersonnelInfo));
                    continue;
                }
                if ("Grad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setGraduateStudents(this.getGraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("UnderGrad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setUndergraduateStudents(this.getUndergraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("Sec".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setSecretarialClerical(this.getSecretarialClerical(otherPersonnelInfo));
                    continue;
                }
                if (OtherpersonalCount >= 6) continue;
                OtherPersonnelDataType otherPersonnelDataType = OtherPersonnelDataType.Factory.newInstance();
                otherPersonnelDataType.setNumberOfPersonnel(otherPersonnelInfo.getNumberPersonnel());
                otherPersonnelDataType.setProjectRole(otherPersonnelInfo.getRole());
                otherPersonnelDataType.setCompensation(this.getSectBCompensationDataType(otherPersonnelInfo.getCompensation()));
                otherPersonnelList.add(otherPersonnelDataType);
                ++OtherpersonalCount;
            }
            otherPersonnelDataTypeArray = otherPersonnelList.toArray(otherPersonnelDataTypeArray);
            otherPersonnel.setOtherArray(otherPersonnelDataTypeArray);
            if (periodInfo.getOtherPersonnelTotalNumber() != null) {
                otherPersonnel.setOtherPersonnelTotalNumber(periodInfo.getOtherPersonnelTotalNumber().intValue());
            }
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                summary.setFederalSummary(periodInfo.getTotalOtherPersonnelFunds().bigDecimalValue());
            }
            if (periodInfo.getTotalOtherPersonnelNonFunds() != null) {
                summary.setNonFederalSummary(periodInfo.getTotalOtherPersonnelNonFunds().bigDecimalValue());
                if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalOtherPersonnelFunds().add((AbstractKualiDecimal)periodInfo.getTotalOtherPersonnelNonFunds())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(periodInfo.getTotalOtherPersonnelNonFunds().bigDecimalValue());
                }
            }
            otherPersonnel.setTotalOtherPersonnelFund(summary);
        }
        return otherPersonnel;
    }

    private BudgetYearDataType.OtherPersonnel.PostDocAssociates getPostDocAssociates(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.PostDocAssociates postDocAssociates = BudgetYearDataType.OtherPersonnel.PostDocAssociates.Factory.newInstance();
        if (otherPersonnel != null) {
            postDocAssociates.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            postDocAssociates.setProjectRole(otherPersonnel.getRole());
            postDocAssociates.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return postDocAssociates;
    }

    private BudgetYearDataType.OtherPersonnel.GraduateStudents getGraduateStudents(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.GraduateStudents graduate = BudgetYearDataType.OtherPersonnel.GraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            graduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            graduate.setProjectRole(otherPersonnel.getRole());
            graduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return graduate;
    }

    private BudgetYearDataType.OtherPersonnel.UndergraduateStudents getUndergraduateStudents(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.UndergraduateStudents undergraduate = BudgetYearDataType.OtherPersonnel.UndergraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            undergraduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            undergraduate.setProjectRole(otherPersonnel.getRole());
            undergraduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return undergraduate;
    }

    private BudgetYearDataType.OtherPersonnel.SecretarialClerical getSecretarialClerical(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.SecretarialClerical secretarialClerical = BudgetYearDataType.OtherPersonnel.SecretarialClerical.Factory.newInstance();
        if (otherPersonnel != null) {
            secretarialClerical.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            secretarialClerical.setProjectRole(otherPersonnel.getRole());
            secretarialClerical.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return secretarialClerical;
    }

    private SectBCompensationDataType getSectBCompensationDataType(CompensationInfo compensation) {
        SectBCompensationDataType sectBCompensation = SectBCompensationDataType.Factory.newInstance();
        if (compensation != null) {
            if (compensation.getAcademicMonths() != null) {
                sectBCompensation.setAcademicMonths(compensation.getAcademicMonths().bigDecimalValue());
            }
            if (compensation.getCalendarMonths() != null) {
                sectBCompensation.setCalendarMonths(compensation.getCalendarMonths().bigDecimalValue());
            }
            if (compensation.getSummerMonths() != null) {
                sectBCompensation.setSummerMonths(compensation.getSummerMonths().bigDecimalValue());
            }
            if (compensation.getRequestedSalary() != null) {
                sectBCompensation.setRequestedSalary(compensation.getRequestedSalary().bigDecimalValue());
            }
            if (compensation.getFringe() != null) {
                sectBCompensation.setFringeBenefits(compensation.getFringe().bigDecimalValue());
            }
            TotalDataType total = TotalDataType.Factory.newInstance();
            if (compensation.getFundsRequested() != null) {
                total.setFederal(compensation.getFundsRequested().bigDecimalValue());
            }
            if (compensation.getNonFundsRequested() != null) {
                total.setNonFederal(compensation.getNonFundsRequested().bigDecimalValue());
            }
            if (compensation.getFundsRequested() != null && compensation.getNonFundsRequested() != null) {
                total.setTotalFedNonFed(((BudgetDecimal)compensation.getFundsRequested().add((AbstractKualiDecimal)compensation.getNonFundsRequested())).bigDecimalValue());
            }
            sectBCompensation.setOtherTotal(total);
        }
        return sectBCompensation;
    }

    private KeyPersonCompensationDataType getCompensation(KeyPersonInfo keyPerson) {
        KeyPersonCompensationDataType keyPersonCompensation = KeyPersonCompensationDataType.Factory.newInstance();
        if (keyPerson != null) {
            if (keyPerson.getAcademicMonths() != null) {
                keyPersonCompensation.setAcademicMonths(keyPerson.getAcademicMonths().bigDecimalValue());
            }
            if (keyPerson.getCalendarMonths() != null) {
                keyPersonCompensation.setCalendarMonths(keyPerson.getCalendarMonths().bigDecimalValue());
            }
            if (keyPerson.getFringe() != null) {
                keyPersonCompensation.setFringeBenefits(keyPerson.getFringe().bigDecimalValue());
            }
            if (keyPerson.getSummerMonths() != null) {
                keyPersonCompensation.setSummerMonths(keyPerson.getSummerMonths().bigDecimalValue());
            }
            if (keyPerson.getRequestedSalary() != null) {
                keyPersonCompensation.setRequestedSalary(keyPerson.getRequestedSalary().bigDecimalValue());
            }
            TotalDataType total = TotalDataType.Factory.newInstance();
            if (keyPerson.getFundsRequested() != null) {
                total.setFederal(keyPerson.getFundsRequested().bigDecimalValue());
            }
            if (keyPerson.getNonFundsRequested() != null) {
                total.setNonFederal(keyPerson.getNonFundsRequested().bigDecimalValue());
            }
            if (keyPerson.getFundsRequested() != null && keyPerson.getNonFundsRequested() != null) {
                total.setTotalFedNonFed(((BudgetDecimal)keyPerson.getFundsRequested().add((AbstractKualiDecimal)keyPerson.getNonFundsRequested())).bigDecimalValue());
            }
            keyPersonCompensation.setTotal(total);
            if (keyPerson.getBaseSalary() != null) {
                keyPersonCompensation.setBaseSalary(keyPerson.getBaseSalary().bigDecimalValue());
            }
        }
        return keyPersonCompensation;
    }

    private BudgetYearDataType.Equipment getEquipment(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.Equipment equipment = BudgetYearDataType.Equipment.Factory.newInstance();
        BudgetYearDataType.Equipment.EquipmentList[] equipmentArray = new BudgetYearDataType.Equipment.EquipmentList[]{};
        ArrayList<BudgetYearDataType.Equipment.EquipmentList> equipmentArrayList = new ArrayList<BudgetYearDataType.Equipment.EquipmentList>();
        if (periodInfo != null) {
            if (periodInfo.getEquipment() != null && periodInfo.getEquipment() != null && periodInfo.getEquipment().size() > 0) {
                SummaryDataType totalFund = SummaryDataType.Factory.newInstance();
                totalFund.setFederalSummary(BigDecimal.ZERO);
                totalFund.setNonFederalSummary(BigDecimal.ZERO);
                totalFund.setTotalFedNonFedSummary(BigDecimal.ZERO);
                for (CostInfo costInfo : ((EquipmentInfo)periodInfo.getEquipment().get(0)).getEquipmentList()) {
                    BudgetYearDataType.Equipment.EquipmentList equipmentList = BudgetYearDataType.Equipment.EquipmentList.Factory.newInstance();
                    equipmentList.setEquipmentItem(costInfo.getDescription());
                    TotalDataType fundsRequested = TotalDataType.Factory.newInstance();
                    fundsRequested.setFederal(costInfo.getCost().bigDecimalValue());
                    fundsRequested.setNonFederal(costInfo.getCostSharing().bigDecimalValue());
                    fundsRequested.setTotalFedNonFed(((BudgetDecimal)costInfo.getCost().add((AbstractKualiDecimal)costInfo.getCostSharing())).bigDecimalValue());
                    totalFund.setFederalSummary(totalFund.getFederalSummary().add(costInfo.getCost().bigDecimalValue()));
                    totalFund.setNonFederalSummary(totalFund.getNonFederalSummary().add(costInfo.getCostSharing().bigDecimalValue()));
                    equipmentList.setFundsRequested(fundsRequested);
                    equipmentArrayList.add(equipmentList);
                }
                totalFund.setTotalFedNonFedSummary(totalFund.getFederalSummary().add(totalFund.getNonFederalSummary()));
                equipmentArray = equipmentArrayList.toArray(equipmentArray);
                equipment.setEquipmentListArray(equipmentArray);
                equipment.setTotalFund(totalFund);
            }
            if (periodInfo.getExtraEquipment() != null && periodInfo.getExtraEquipment().size() > 0) {
                EquipmentInfo equipmentInfo = (EquipmentInfo)periodInfo.getExtraEquipment().get(0);
                TotalDataType totalFund = TotalDataType.Factory.newInstance();
                totalFund.setFederal(equipmentInfo.getTotalExtraFund().bigDecimalValue());
                totalFund.setNonFederal(equipmentInfo.getTotalExtraNonFund().bigDecimalValue());
                if (equipmentInfo.getTotalExtraFund() != null) {
                    totalFund.setTotalFedNonFed(((BudgetDecimal)equipmentInfo.getTotalExtraFund().add((AbstractKualiDecimal)equipmentInfo.getTotalExtraNonFund())).bigDecimalValue());
                } else {
                    totalFund.setTotalFedNonFed(equipmentInfo.getTotalExtraNonFund().bigDecimalValue());
                }
                equipment.setTotalFundForAttachedEquipment(totalFund);
                SummaryDataType summary = SummaryDataType.Factory.newInstance();
                if (equipmentInfo.getTotalFund() != null) {
                    summary.setFederalSummary(equipmentInfo.getTotalFund().bigDecimalValue());
                }
                if (equipmentInfo.getTotalNonFund() != null) {
                    summary.setNonFederalSummary(equipmentInfo.getTotalNonFund().bigDecimalValue());
                    if (equipmentInfo.getTotalFund() != null) {
                        summary.setTotalFedNonFedSummary(((BudgetDecimal)equipmentInfo.getTotalFund().add((AbstractKualiDecimal)equipmentInfo.getTotalNonFund())).bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(equipmentInfo.getTotalNonFund().bigDecimalValue());
                    }
                }
                equipment.setTotalFund(summary);
            }
        }
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 12 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            equipment.setAdditionalEquipmentsAttachment(attachedFileDataType);
            break;
        }
        return equipment;
    }

    private BudgetYearDataType.Travel getTravel(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.Travel travel = BudgetYearDataType.Travel.Factory.newInstance();
        TotalDataType total = TotalDataType.Factory.newInstance();
        if (periodInfo != null) {
            if (periodInfo.getDomesticTravelCost() != null) {
                total.setFederal(periodInfo.getDomesticTravelCost().bigDecimalValue());
            }
            if (periodInfo.getDomesticTravelCostSharing() != null) {
                total.setNonFederal(periodInfo.getDomesticTravelCostSharing().bigDecimalValue());
                if (periodInfo.getDomesticTravelCost() != null) {
                    total.setTotalFedNonFed(((BudgetDecimal)periodInfo.getDomesticTravelCost().add((AbstractKualiDecimal)periodInfo.getDomesticTravelCostSharing())).bigDecimalValue());
                } else {
                    total.setTotalFedNonFed(periodInfo.getDomesticTravelCostSharing().bigDecimalValue());
                }
            }
            travel.setDomesticTravelCost(total);
            TotalDataType totalForeign = TotalDataType.Factory.newInstance();
            if (periodInfo.getForeignTravelCost() != null) {
                totalForeign.setFederal(periodInfo.getForeignTravelCost().bigDecimalValue());
            }
            if (periodInfo.getForeignTravelCostSharing() != null) {
                totalForeign.setNonFederal(periodInfo.getForeignTravelCostSharing().bigDecimalValue());
                if (periodInfo.getForeignTravelCost() != null) {
                    totalForeign.setTotalFedNonFed(((BudgetDecimal)periodInfo.getForeignTravelCost().add((AbstractKualiDecimal)periodInfo.getForeignTravelCostSharing())).bigDecimalValue());
                } else {
                    totalForeign.setTotalFedNonFed(periodInfo.getForeignTravelCostSharing().bigDecimalValue());
                }
            }
            travel.setForeignTravelCost(totalForeign);
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalTravelCost() != null) {
                summary.setFederalSummary(periodInfo.getTotalTravelCost().bigDecimalValue());
            }
            if (periodInfo.getTotalTravelCostSharing() != null) {
                summary.setNonFederalSummary(periodInfo.getTotalTravelCostSharing().bigDecimalValue());
                if (periodInfo.getTotalTravelCost() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalTravelCost().add((AbstractKualiDecimal)periodInfo.getTotalTravelCostSharing())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(periodInfo.getTotalTravelCostSharing().bigDecimalValue());
                }
            }
            travel.setTotalTravelCost(summary);
        }
        return travel;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts getParticipantTraineeSupportCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts traineeSupportCosts = BudgetYearDataType.ParticipantTraineeSupportCosts.Factory.newInstance();
        if (periodInfo != null) {
            TotalDataType totalTution = TotalDataType.Factory.newInstance();
            if (periodInfo.getPartTuition() != null) {
                totalTution.setFederal(periodInfo.getPartTuition().bigDecimalValue());
            }
            if (periodInfo.getPartTuitionCostSharing() != null) {
                totalTution.setNonFederal(periodInfo.getPartTuitionCostSharing().bigDecimalValue());
                if (periodInfo.getPartTuition() != null) {
                    totalTution.setTotalFedNonFed(((BudgetDecimal)periodInfo.getPartTuition().add((AbstractKualiDecimal)periodInfo.getPartTuitionCostSharing())).bigDecimalValue());
                } else {
                    totalTution.setTotalFedNonFed(periodInfo.getPartTuitionCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setTuitionFeeHealthInsurance(totalTution);
            TotalDataType totalStipends = TotalDataType.Factory.newInstance();
            if (periodInfo.getpartStipendCost() != null) {
                totalStipends.setFederal(periodInfo.getpartStipendCost().bigDecimalValue());
            }
            if (periodInfo.getPartStipendCostSharing() != null) {
                totalStipends.setNonFederal(periodInfo.getPartStipendCostSharing().bigDecimalValue());
                if (periodInfo.getpartStipendCost() != null) {
                    totalStipends.setTotalFedNonFed(((BudgetDecimal)periodInfo.getpartStipendCost().add((AbstractKualiDecimal)periodInfo.getPartStipendCostSharing())).bigDecimalValue());
                } else {
                    totalStipends.setTotalFedNonFed(periodInfo.getPartStipendCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setStipends(totalStipends);
            TotalDataType totalTravel = TotalDataType.Factory.newInstance();
            if (periodInfo.getpartTravelCost() != null) {
                totalTravel.setFederal(periodInfo.getpartTravelCost().bigDecimalValue());
            }
            if (periodInfo.getPartTravelCostSharing() != null) {
                totalTravel.setNonFederal(periodInfo.getPartTravelCostSharing().bigDecimalValue());
                if (periodInfo.getpartTravelCost() != null) {
                    totalTravel.setTotalFedNonFed(((BudgetDecimal)periodInfo.getpartTravelCost().add((AbstractKualiDecimal)periodInfo.getPartTravelCostSharing())).bigDecimalValue());
                } else {
                    totalTravel.setTotalFedNonFed(periodInfo.getPartTravelCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setTravel(totalTravel);
            TotalDataType totalSubsistence = TotalDataType.Factory.newInstance();
            if (periodInfo.getPartSubsistence() != null) {
                totalSubsistence.setFederal(periodInfo.getPartSubsistence().bigDecimalValue());
            }
            if (periodInfo.getPartSubsistenceCostSharing() != null) {
                totalSubsistence.setNonFederal(periodInfo.getPartSubsistenceCostSharing().bigDecimalValue());
                if (periodInfo.getPartSubsistence() != null) {
                    totalSubsistence.setTotalFedNonFed(((BudgetDecimal)periodInfo.getPartSubsistence().add((AbstractKualiDecimal)periodInfo.getPartSubsistenceCostSharing())).bigDecimalValue());
                } else {
                    totalSubsistence.setTotalFedNonFed(periodInfo.getPartSubsistenceCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setSubsistence(totalSubsistence);
            traineeSupportCosts.setOther(this.getOtherPTSupportCosts(periodInfo));
            traineeSupportCosts.setParticipantTraineeNumber(periodInfo.getparticipantCount());
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            summary.setFederalSummary(((BudgetDecimal)periodInfo.getpartOtherCost().add(periodInfo.getpartStipendCost().add(periodInfo.getpartTravelCost().add(periodInfo.getPartSubsistence().add((AbstractKualiDecimal)periodInfo.getPartTuition()))))).bigDecimalValue());
            summary.setNonFederalSummary(((BudgetDecimal)periodInfo.getPartOtherCostSharing().add(periodInfo.getPartStipendCostSharing().add(periodInfo.getPartTravelCostSharing().add(periodInfo.getPartSubsistenceCostSharing().add((AbstractKualiDecimal)periodInfo.getPartTuitionCostSharing()))))).bigDecimalValue());
            if (summary.getNonFederalSummary() != null) {
                if (summary.getFederalSummary() != null) {
                    summary.setTotalFedNonFedSummary(summary.getFederalSummary().add(summary.getNonFederalSummary()));
                } else {
                    summary.setTotalFedNonFedSummary(summary.getNonFederalSummary());
                }
            }
            traineeSupportCosts.setTotalCost(summary);
        }
        return traineeSupportCosts;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts.Other getOtherPTSupportCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts.Other partOther = BudgetYearDataType.ParticipantTraineeSupportCosts.Other.Factory.newInstance();
        partOther.setDescription("Other");
        TotalDataType total = TotalDataType.Factory.newInstance();
        if (periodInfo != null) {
            if (periodInfo.getpartOtherCost() != null) {
                total.setFederal(periodInfo.getpartOtherCost().bigDecimalValue());
            }
            if (periodInfo.getPartOtherCostSharing() != null) {
                total.setNonFederal(periodInfo.getPartOtherCostSharing().bigDecimalValue());
                if (periodInfo.getpartOtherCost() != null) {
                    total.setTotalFedNonFed(((BudgetDecimal)periodInfo.getpartOtherCost().add((AbstractKualiDecimal)periodInfo.getPartOtherCostSharing())).bigDecimalValue());
                } else {
                    total.setTotalFedNonFed(periodInfo.getPartOtherCostSharing().bigDecimalValue());
                }
            }
        }
        partOther.setCost(total);
        return partOther;
    }

    private BudgetYearDataType.OtherDirectCosts getOtherDirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherDirectCosts otherDirectCosts = BudgetYearDataType.OtherDirectCosts.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null && periodInfo.getOtherDirectCosts().size() > 0) {
            TotalDataType totalMaterials = TotalDataType.Factory.newInstance();
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getmaterials() != null) {
                totalMaterials.setFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getmaterials().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getMaterialsCostSharing() != null) {
                totalMaterials.setNonFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getMaterialsCostSharing().bigDecimalValue());
                if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getmaterials() != null) {
                    totalMaterials.setTotalFedNonFed(((BudgetDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getmaterials().add((AbstractKualiDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getMaterialsCostSharing())).bigDecimalValue());
                } else {
                    totalMaterials.setTotalFedNonFed(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getMaterialsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setMaterialsSupplies(totalMaterials);
            TotalDataType totalPublication = TotalDataType.Factory.newInstance();
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getpublications() != null) {
                totalPublication.setFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getpublications().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getPublicationsCostSharing() != null) {
                totalPublication.setNonFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getPublicationsCostSharing().bigDecimalValue());
                if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getpublications() != null) {
                    totalPublication.setTotalFedNonFed(((BudgetDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getpublications().add((AbstractKualiDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getPublicationsCostSharing())).bigDecimalValue());
                } else {
                    totalPublication.setTotalFedNonFed(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getPublicationsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setPublicationCosts(totalPublication);
            TotalDataType totalConsultant = TotalDataType.Factory.newInstance();
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getConsultants() != null) {
                totalConsultant.setFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getConsultants().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getConsultantsCostSharing() != null) {
                totalConsultant.setNonFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getConsultantsCostSharing().bigDecimalValue());
                if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getConsultants() != null) {
                    totalConsultant.setTotalFedNonFed(((BudgetDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getConsultants().add((AbstractKualiDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getConsultantsCostSharing())).bigDecimalValue());
                } else {
                    totalConsultant.setTotalFedNonFed(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getConsultantsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setConsultantServices(totalConsultant);
            TotalDataType totalADP = TotalDataType.Factory.newInstance();
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getcomputer() != null) {
                totalADP.setFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getcomputer().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getComputerCostSharing() != null) {
                totalADP.setNonFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getComputerCostSharing().bigDecimalValue());
                if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getcomputer() != null) {
                    totalADP.setTotalFedNonFed(((BudgetDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getcomputer().add((AbstractKualiDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getComputerCostSharing())).bigDecimalValue());
                } else {
                    totalADP.setTotalFedNonFed(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getComputerCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setADPComputerServices(totalADP);
            TotalDataType totalSubaward = TotalDataType.Factory.newInstance();
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getsubAwards() != null) {
                totalSubaward.setFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getsubAwards().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getSubAwardsCostSharing() != null) {
                totalSubaward.setNonFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getSubAwardsCostSharing().bigDecimalValue());
                if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getsubAwards() != null) {
                    totalSubaward.setTotalFedNonFed(((BudgetDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getsubAwards().add((AbstractKualiDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getSubAwardsCostSharing())).bigDecimalValue());
                } else {
                    totalSubaward.setTotalFedNonFed(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getSubAwardsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setSubawardConsortiumContractualCosts(totalSubaward);
            TotalDataType totalEquipment = TotalDataType.Factory.newInstance();
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getEquipRental() != null) {
                totalEquipment.setFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getEquipRental().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getEquipRentalCostSharing() != null) {
                totalEquipment.setNonFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getEquipRentalCostSharing().bigDecimalValue());
                if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getEquipRental() != null) {
                    totalEquipment.setTotalFedNonFed(((BudgetDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getEquipRental().add((AbstractKualiDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getEquipRentalCostSharing())).bigDecimalValue());
                } else {
                    totalEquipment.setTotalFedNonFed(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getEquipRentalCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setEquipmentRentalFee(totalEquipment);
            TotalDataType totalAlterations = TotalDataType.Factory.newInstance();
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getAlterations() != null) {
                totalAlterations.setFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getAlterations().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getAlterationsCostSharing() != null) {
                totalAlterations.setNonFederal(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getAlterationsCostSharing().bigDecimalValue());
                if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getAlterations() != null) {
                    totalAlterations.setTotalFedNonFed(((BudgetDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getAlterations().add((AbstractKualiDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getAlterationsCostSharing())).bigDecimalValue());
                } else {
                    totalAlterations.setTotalFedNonFed(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getAlterationsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setAlterationsRenovations(totalAlterations);
            otherDirectCosts.setOthers(this.getOthersForOtherDirectCosts(periodInfo));
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).gettotalOtherDirect() != null) {
                summary.setFederalSummary(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).gettotalOtherDirect().bigDecimalValue());
            }
            if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirectCostSharing() != null) {
                summary.setNonFederalSummary(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirectCostSharing().bigDecimalValue());
                if (((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).gettotalOtherDirect() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).gettotalOtherDirect().add((AbstractKualiDecimal)((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirectCostSharing())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(((OtherDirectCostInfo)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirectCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setTotalOtherDirectCost(summary);
        }
        return otherDirectCosts;
    }

    private BudgetYearDataType.OtherDirectCosts.Others getOthersForOtherDirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherDirectCosts.Others othersDirect = BudgetYearDataType.OtherDirectCosts.Others.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null) {
            BudgetYearDataType.OtherDirectCosts.Others.Other[] otherArray = new BudgetYearDataType.OtherDirectCosts.Others.Other[periodInfo.getOtherDirectCosts().size()];
            int Otherscount = 0;
            BudgetYearDataType.OtherDirectCosts.Others.Other other = BudgetYearDataType.OtherDirectCosts.Others.Other.Factory.newInstance();
            for (OtherDirectCostInfo otherDirectCostInfo : periodInfo.getOtherDirectCosts()) {
                TotalDataType total = TotalDataType.Factory.newInstance();
                if (otherDirectCostInfo.getOtherCosts() != null && otherDirectCostInfo.getOtherCosts().size() > 0) {
                    total.setFederal(new BigDecimal((String)((Map)otherDirectCostInfo.getOtherCosts().get(0)).get("Cost")));
                    total.setNonFederal(new BigDecimal((String)((Map)otherDirectCostInfo.getOtherCosts().get(0)).get("CostSharing")));
                    if (((Map)otherDirectCostInfo.getOtherCosts().get(0)).get("Cost") != null) {
                        total.setTotalFedNonFed(new BigDecimal((String)((Map)otherDirectCostInfo.getOtherCosts().get(0)).get("Cost")).add(new BigDecimal((String)((Map)otherDirectCostInfo.getOtherCosts().get(0)).get("CostSharing"))));
                    } else {
                        total.setTotalFedNonFed(new BigDecimal((String)((Map)otherDirectCostInfo.getOtherCosts().get(0)).get("CostSharing")));
                    }
                }
                other.setCost(total);
                other.setDescription("Other");
                otherArray[Otherscount] = other;
                ++Otherscount;
            }
            othersDirect.setOtherArray(otherArray);
        }
        return othersDirect;
    }

    private BudgetYearDataType.IndirectCosts getIndirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.IndirectCosts indirectCosts = null;
        if (periodInfo != null && periodInfo.getIndirectCosts() != null && periodInfo.getIndirectCosts().getIndirectCostDetails() != null) {
            int IndirectCostCount = 0;
            ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost> indirectCostList = new ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost>();
            for (IndirectCostDetails indirectCostDetails : periodInfo.getIndirectCosts().getIndirectCostDetails()) {
                BudgetYearDataType.IndirectCosts.IndirectCost indirectCost = BudgetYearDataType.IndirectCosts.IndirectCost.Factory.newInstance();
                indirectCost.setCostType(indirectCostDetails.getCostType());
                if (indirectCostDetails.getBase() != null) {
                    indirectCost.setBase(indirectCostDetails.getBase().bigDecimalValue());
                }
                if (indirectCostDetails.getRate() != null) {
                    indirectCost.setRate(indirectCostDetails.getRate().bigDecimalValue());
                }
                TotalDataType total = TotalDataType.Factory.newInstance();
                if (indirectCostDetails.getFunds() != null) {
                    total.setFederal(indirectCostDetails.getFunds().bigDecimalValue());
                }
                if (indirectCostDetails.getCostSharing() != null) {
                    total.setNonFederal(indirectCostDetails.getCostSharing().bigDecimalValue());
                    if (indirectCostDetails.getFunds() != null) {
                        total.setTotalFedNonFed(((BudgetDecimal)indirectCostDetails.getFunds().add((AbstractKualiDecimal)indirectCostDetails.getCostSharing())).bigDecimalValue());
                    } else {
                        total.setTotalFedNonFed(indirectCostDetails.getCostSharing().bigDecimalValue());
                    }
                }
                indirectCost.setFundRequested(total);
                indirectCostList.add(indirectCost);
                if (++IndirectCostCount != 4) continue;
                LOG.warn((Object)"Stopping iteration over indirect cost details because array limit in schema is only 4");
                break;
            }
            if (IndirectCostCount > 0) {
                indirectCosts = BudgetYearDataType.IndirectCosts.Factory.newInstance();
                BudgetYearDataType.IndirectCosts.IndirectCost[] indirectCostArray = new BudgetYearDataType.IndirectCosts.IndirectCost[]{};
                indirectCosts.setIndirectCostArray(indirectCostList.toArray(indirectCostArray));
                SummaryDataType summary = SummaryDataType.Factory.newInstance();
                if (periodInfo.getIndirectCosts().getTotalIndirectCosts() != null) {
                    summary.setFederalSummary(periodInfo.getIndirectCosts().getTotalIndirectCosts().bigDecimalValue());
                }
                if (periodInfo.getIndirectCosts().getTotalIndirectCostSharing() != null) {
                    summary.setNonFederalSummary(periodInfo.getIndirectCosts().getTotalIndirectCostSharing().bigDecimalValue());
                    if (periodInfo.getIndirectCosts().getTotalIndirectCosts() != null) {
                        summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getIndirectCosts().getTotalIndirectCosts().add((AbstractKualiDecimal)periodInfo.getIndirectCosts().getTotalIndirectCostSharing())).bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(periodInfo.getIndirectCosts().getTotalIndirectCostSharing().bigDecimalValue());
                    }
                }
                indirectCosts.setTotalIndirectCosts(summary);
            }
        }
        return indirectCosts;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRFedNonFedBudget();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRFedNonFedBudgetDocument.RRFedNonFedBudget rrFedNonFedBudget = (RRFedNonFedBudgetDocument.RRFedNonFedBudget)xmlObject;
        RRFedNonFedBudgetDocument rrfedNonFedBudgetDocument = RRFedNonFedBudgetDocument.Factory.newInstance();
        rrfedNonFedBudgetDocument.setRRFedNonFedBudget(rrFedNonFedBudget);
        return rrfedNonFedBudgetDocument;
    }
}

