/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrKeyPersonExpandedV11.PersonProfileDataType;
import gov.grants.apply.forms.rrKeyPersonExpandedV11.ProjectRoleDataType;
import gov.grants.apply.forms.rrKeyPersonExpandedV11.RRKeyPersonExpandedDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonComparator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.impl.RRKeyPersonExpandedBaseGenerator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.rice.kns.util.AuditError;

public class RRKeyPersonExpandedV1_1Generator
extends RRKeyPersonExpandedBaseGenerator {
    private RRKeyPersonExpandedDocument getRRKeyPersonExpanded() {
        RRKeyPersonExpandedDocument rrKeyPersonExpandedDocument = RRKeyPersonExpandedDocument.Factory.newInstance();
        RRKeyPersonExpandedDocument.RRKeyPersonExpanded rrKeyPersonExpanded = RRKeyPersonExpandedDocument.RRKeyPersonExpanded.Factory.newInstance();
        rrKeyPersonExpanded.setFormVersion("1.1");
        rrKeyPersonExpanded.setPDPI(this.getPersonProfilePI());
        rrKeyPersonExpanded.setKeyPersonArray(this.getpersonProfileKeyPerson());
        this.saveKeyPersonAttachmentsToProposal();
        AttachedFileDataType attachedFileDataType = null;
        RRKeyPersonExpandedDocument.RRKeyPersonExpanded.BioSketchsAttached bioSketchAttached = RRKeyPersonExpandedDocument.RRKeyPersonExpanded.BioSketchsAttached.Factory.newInstance();
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 16 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            bioSketchAttached.setBioSketchAttached(attachedFileDataType);
            rrKeyPersonExpanded.setBioSketchsAttached(bioSketchAttached);
            break;
        }
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 17 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            RRKeyPersonExpandedDocument.RRKeyPersonExpanded.SupportsAttached supportsAttached = RRKeyPersonExpandedDocument.RRKeyPersonExpanded.SupportsAttached.Factory.newInstance();
            supportsAttached.setSupportAttached(attachedFileDataType);
            rrKeyPersonExpanded.setSupportsAttached(supportsAttached);
            break;
        }
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 18 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            RRKeyPersonExpandedDocument.RRKeyPersonExpanded.AdditionalProfilesAttached additionalProfilesAttached = RRKeyPersonExpandedDocument.RRKeyPersonExpanded.AdditionalProfilesAttached.Factory.newInstance();
            additionalProfilesAttached.setAdditionalProfileAttached(attachedFileDataType);
            rrKeyPersonExpanded.setAdditionalProfilesAttached(additionalProfilesAttached);
            break;
        }
        rrKeyPersonExpandedDocument.setRRKeyPersonExpanded(rrKeyPersonExpanded);
        return rrKeyPersonExpandedDocument;
    }

    private PersonProfileDataType getPersonProfilePI() {
        PersonProfileDataType profileDataType = PersonProfileDataType.Factory.newInstance();
        PersonProfileDataType.Profile profile = PersonProfileDataType.Profile.Factory.newInstance();
        ProposalPerson PI = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            if (PI.getPersonId() != null) {
                this.pIPersonOrRolodexId = PI.getPersonId();
            } else if (PI.getRolodexId() != null) {
                this.pIPersonOrRolodexId = PI.getRolodexId().toString();
            }
            profile.setName(this.globLibV20Generator.getHumanNameDataType(PI));
            if (PI.getDirectoryTitle() != null) {
                if (PI.getDirectoryTitle().length() > 45) {
                    profile.setTitle(PI.getDirectoryTitle().substring(0, 45));
                } else {
                    profile.setTitle(PI.getDirectoryTitle());
                }
            }
            profile.setAddress(this.globLibV20Generator.getAddressDataType(PI));
            profile.setPhone(PI.getOfficePhone());
            if (PI.getFaxNumber() != null) {
                profile.setFax(PI.getFaxNumber());
            }
            profile.setEmail(PI.getEmailAddress());
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                profile.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
            }
            if (PI.getHomeUnit() != null) {
                KcPersonService kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
                KcPerson kcPersons = kcPersonService.getKcPersonByPersonId(PI.getPersonId());
                String departmentName = kcPersons.getOrganizationIdentifier();
                profile.setDepartmentName(departmentName);
            } else {
                DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
                profile.setDepartmentName(developmentProposal.getOwnedByUnit().getUnitName());
            }
            String divisionName = PI.getDivision();
            if (divisionName != null) {
                profile.setDivisionName(divisionName);
            }
            if (PI.getEraCommonsUserName() != null) {
                profile.setCredential(PI.getEraCommonsUserName());
            } else if (((SponsorService)KraServiceLocator.getService(SponsorService.class)).isSponsorNihMultiplePi((Sponsorable)this.pdDoc.getDevelopmentProposal())) {
                this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + PI.getFullName(), "grantsGov.Opportunity"));
            }
            profile.setProjectRole(ProjectRoleDataType.PD_PI);
            PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
            AttachedFileDataType bioSketchAttachment = this.getPernonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "1");
            personBioSketch.setBioSketchAttached(bioSketchAttachment);
            profile.setBioSketchsAttached(personBioSketch);
            AttachedFileDataType supportAttachment = this.getPernonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "2");
            if (supportAttachment != null) {
                PersonProfileDataType.Profile.SupportsAttached supportsAttached = PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
                supportsAttached.setSupportAttached(supportAttachment);
                profile.setSupportsAttached(supportsAttached);
            }
            profileDataType.setProfile(profile);
        }
        return profileDataType;
    }

    private PersonProfileDataType[] getpersonProfileKeyPerson() {
        ArrayList<PersonProfileDataType> personProfileDataTypeList = new ArrayList<PersonProfileDataType>();
        List keyPersons = this.pdDoc.getDevelopmentProposal().getProposalPersons();
        Collections.sort(keyPersons, new ProposalPersonComparator());
        List nKeyPersons = this.s2sUtilService.getNKeyPersons(keyPersons, true, 40);
        this.extraPersons = this.s2sUtilService.getNKeyPersons(keyPersons, false, 40);
        if (nKeyPersons.size() > 0) {
            for (ProposalPerson keyPerson : nKeyPersons) {
                if (this.pIPersonOrRolodexId != null && (keyPerson.getPersonId() != null && keyPerson.getPersonId().equals(this.pIPersonOrRolodexId) || keyPerson.getRolodexId() != null && this.pIPersonOrRolodexId.equals(keyPerson.getRolodexId().toString()))) continue;
                PersonProfileDataType.Profile profileKeyPerson = PersonProfileDataType.Profile.Factory.newInstance();
                profileKeyPerson.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
                if (keyPerson.getDirectoryTitle() != null) {
                    if (keyPerson.getDirectoryTitle().length() > 45) {
                        profileKeyPerson.setTitle(keyPerson.getDirectoryTitle().substring(0, 45));
                    } else {
                        profileKeyPerson.setTitle(keyPerson.getDirectoryTitle());
                    }
                }
                profileKeyPerson.setAddress(this.globLibV20Generator.getAddressDataType(keyPerson));
                profileKeyPerson.setPhone(keyPerson.getOfficePhone());
                if (keyPerson.getFaxNumber() != null) {
                    profileKeyPerson.setFax(keyPerson.getFaxNumber());
                }
                profileKeyPerson.setEmail(keyPerson.getEmailAddress());
                if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                    profileKeyPerson.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
                }
                if (keyPerson.getHomeUnit() != null) {
                    KcPersonService kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
                    KcPerson kcPersons = kcPersonService.getKcPersonByPersonId(keyPerson.getPersonId());
                    String departmentName = kcPersons.getOrganizationIdentifier();
                    profileKeyPerson.setDepartmentName(departmentName);
                } else {
                    DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
                    profileKeyPerson.setDepartmentName(developmentProposal.getOwnedByUnit().getUnitName());
                }
                String divisionName = keyPerson.getDivision();
                if (divisionName != null) {
                    profileKeyPerson.setDivisionName(divisionName);
                }
                if (keyPerson.getEraCommonsUserName() != null) {
                    profileKeyPerson.setCredential(keyPerson.getEraCommonsUserName());
                } else if (((SponsorService)KraServiceLocator.getService(SponsorService.class)).isSponsorNihMultiplePi((Sponsorable)this.pdDoc.getDevelopmentProposal()) && keyPerson.isMultiplePi()) {
                    this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + keyPerson.getFullName(), "grantsGov.Opportunity"));
                }
                if (keyPerson.getProposalPersonRoleId().equals("COI")) {
                    if (((SponsorService)KraServiceLocator.getService(SponsorService.class)).isSponsorNihMultiplePi((Sponsorable)this.pdDoc.getDevelopmentProposal())) {
                        if (keyPerson.isMultiplePi()) {
                            profileKeyPerson.setProjectRole(ProjectRoleDataType.PD_PI);
                        } else {
                            profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
                        }
                    } else {
                        profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
                    }
                } else {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.OTHER_SPECIFY);
                    PersonProfileDataType.Profile.OtherProjectRoleCategory otherProjectRole = PersonProfileDataType.Profile.OtherProjectRoleCategory.Factory.newInstance();
                    String otherRole = keyPerson.getProjectRole() != null ? (keyPerson.getProjectRole().length() > 40 ? keyPerson.getProjectRole().substring(0, 40) : keyPerson.getProjectRole()) : "Unknown";
                    otherProjectRole.setStringValue(otherRole);
                    profileKeyPerson.setOtherProjectRoleCategory(otherProjectRole);
                }
                PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
                AttachedFileDataType bioSketchAttachment = this.getPernonnelAttachments(this.pdDoc, keyPerson.getPersonId(), keyPerson.getRolodexId(), "1");
                personBioSketch.setBioSketchAttached(bioSketchAttachment);
                profileKeyPerson.setBioSketchsAttached(personBioSketch);
                AttachedFileDataType supportAttachment = this.getPernonnelAttachments(this.pdDoc, keyPerson.getPersonId(), keyPerson.getRolodexId(), "2");
                if (supportAttachment != null) {
                    PersonProfileDataType.Profile.SupportsAttached supportsAttached = PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
                    supportsAttached.setSupportAttached(supportAttachment);
                    profileKeyPerson.setSupportsAttached(supportsAttached);
                }
                PersonProfileDataType personProfileDataTypeKeyPerson = PersonProfileDataType.Factory.newInstance();
                personProfileDataTypeKeyPerson.setProfile(profileKeyPerson);
                personProfileDataTypeList.add(personProfileDataTypeKeyPerson);
            }
        }
        PersonProfileDataType[] personProfileDataArray = new PersonProfileDataType[]{};
        personProfileDataArray = personProfileDataTypeList.toArray(personProfileDataArray);
        return personProfileDataArray;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRKeyPersonExpanded();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRKeyPersonExpandedDocument.RRKeyPersonExpanded rrKeyPersonExpanded = (RRKeyPersonExpandedDocument.RRKeyPersonExpanded)xmlObject;
        RRKeyPersonExpandedDocument rrKeyPersonExpandedDocument = RRKeyPersonExpandedDocument.Factory.newInstance();
        rrKeyPersonExpandedDocument.setRRKeyPersonExpanded(rrKeyPersonExpanded);
        return rrKeyPersonExpandedDocument;
    }
}

