/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrKeyPersonExpanded12V12.PersonProfileDataType;
import gov.grants.apply.forms.rrKeyPersonExpanded12V12.ProjectRoleDataType;
import gov.grants.apply.forms.rrKeyPersonExpanded12V12.RRKeyPersonExpanded12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonComparator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonDegree;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.impl.RRKeyPersonExpandedBaseGenerator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.krad.service.BusinessObjectService;

public class RRKeyPersonExpandedV1_2Generator
extends RRKeyPersonExpandedBaseGenerator {
    private static final Log LOG = LogFactory.getLog(RRKeyPersonExpandedV1_2Generator.class);
    Rolodex rolodex;

    private RRKeyPersonExpanded12Document getRRKeyPersonExpanded() {
        RRKeyPersonExpanded12Document rrKeyPersonExpandedDocument = RRKeyPersonExpanded12Document.Factory.newInstance();
        RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded = RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.Factory.newInstance();
        this.setRRKeyPersonExpandedAttributes(rrKeyPersonExpanded);
        rrKeyPersonExpandedDocument.setRRKeyPersonExpanded12(rrKeyPersonExpanded);
        return rrKeyPersonExpandedDocument;
    }

    private void setRRKeyPersonExpandedAttributes(RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded) {
        rrKeyPersonExpanded.setFormVersion("1.2");
        rrKeyPersonExpanded.setPDPI(this.getPersonProfilePI());
        PersonProfileDataType[] keyPersonArray = this.getpersonProfileKeyPerson();
        if (keyPersonArray.length > 0) {
            rrKeyPersonExpanded.setKeyPersonArray(keyPersonArray);
        }
        this.saveKeyPersonAttachmentsToProposal();
        if (this.extraPersons.size() > 0) {
            for (ProposalPerson extraPerson : this.extraPersons) {
                this.setBioSketchAttchment(rrKeyPersonExpanded, extraPerson);
                this.setCurrentPendingTypeAttachment(rrKeyPersonExpanded, extraPerson);
            }
            for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
                if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 18) continue;
                this.setProfileTypeAttachment(rrKeyPersonExpanded, narrative);
            }
        }
    }

    private void setProfileTypeAttachment(RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded, Narrative narrative) {
        AttachedFileDataType attachedFileDataType = this.getAttachedFileType(narrative);
        if (attachedFileDataType != null) {
            RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.AdditionalProfilesAttached additionalProfilesAttached = RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.AdditionalProfilesAttached.Factory.newInstance();
            additionalProfilesAttached.setAdditionalProfileAttached(attachedFileDataType);
            rrKeyPersonExpanded.setAdditionalProfilesAttached(additionalProfilesAttached);
        }
    }

    private void setCurrentPendingTypeAttachment(RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded, ProposalPerson extraPerson) {
        AttachedFileDataType supportAttachment = this.getPernonnelAttachments(this.pdDoc, extraPerson.getPersonId(), extraPerson.getRolodexId(), "2");
        if (supportAttachment != null) {
            RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.SupportsAttached supportsAttached = RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.SupportsAttached.Factory.newInstance();
            supportsAttached.setSupportAttached(supportAttachment);
            rrKeyPersonExpanded.setSupportsAttached(supportsAttached);
        }
    }

    private void setBioSketchAttchment(RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded, ProposalPerson extraPerson) {
        RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.BioSketchsAttached personBioSketch = RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.BioSketchsAttached.Factory.newInstance();
        AttachedFileDataType bioSketchAttachment = this.getPernonnelAttachments(this.pdDoc, extraPerson.getPersonId(), extraPerson.getRolodexId(), "1");
        personBioSketch.setBioSketchAttached(bioSketchAttachment);
        rrKeyPersonExpanded.setBioSketchsAttached(personBioSketch);
    }

    private PersonProfileDataType getPersonProfilePI() {
        PersonProfileDataType profileDataType = PersonProfileDataType.Factory.newInstance();
        PersonProfileDataType.Profile profile = PersonProfileDataType.Profile.Factory.newInstance();
        ProposalPerson PI = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            this.setPersonalProfileDetailsToProfile(profileDataType, profile, PI);
        }
        return profileDataType;
    }

    private void setPersonalProfileDetailsToProfile(PersonProfileDataType profileDataType, PersonProfileDataType.Profile profile, ProposalPerson PI) {
        ProposalPersonDegree proposalPersonDegree;
        this.assignRolodexId(PI);
        profile.setName(this.globLibV20Generator.getHumanNameDataType(PI));
        this.setDirectoryTitleToProfile(profile, PI);
        profile.setAddress(this.globLibV20Generator.getAddressDataType(PI));
        profile.setPhone(PI.getOfficePhone());
        if (PI.getFaxNumber() != null) {
            profile.setFax(PI.getFaxNumber());
        }
        if (PI.getDegree() != null) {
            profile.setDegreeType(PI.getDegree());
        }
        if (PI.getYearGraduated() != null) {
            profile.setDegreeYear(PI.getYearGraduated());
        }
        if (PI.getDegree() == null && PI.getYearGraduated() == null && PI.getProposalPersonDegrees() != null && PI.getProposalPersonDegrees().size() > 0 && (proposalPersonDegree = (ProposalPersonDegree)PI.getProposalPersonDegrees().get(0)) != null) {
            if (proposalPersonDegree.getDegreeType() != null && proposalPersonDegree.getDegreeType().getDescription() != null) {
                profile.setDegreeType(proposalPersonDegree.getDegreeType().getDescription());
            }
            if (proposalPersonDegree.getGraduationYear() != null) {
                profile.setDegreeYear(proposalPersonDegree.getGraduationYear());
            }
        }
        profile.setEmail(PI.getEmailAddress());
        DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
        this.setOrganizationName(profile, developmentProposal);
        this.setDepartmentNameToProfile(profile, PI);
        String divisionName = PI.getDivision();
        if (divisionName != null) {
            profile.setDivisionName(divisionName);
        }
        if (PI.getEraCommonsUserName() != null) {
            profile.setCredential(PI.getEraCommonsUserName());
        } else if (((SponsorService)KraServiceLocator.getService(SponsorService.class)).isSponsorNihMultiplePi((Sponsorable)this.pdDoc.getDevelopmentProposal())) {
            this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + PI.getFullName(), "grantsGov.Opportunity"));
        }
        profile.setProjectRole(ProjectRoleDataType.PD_PI);
        this.setAttachments(profile, PI);
        profileDataType.setProfile(profile);
    }

    private void setDepartmentNameToProfile(PersonProfileDataType.Profile profile, ProposalPerson PI) {
        if (PI.getHomeUnit() != null) {
            KcPersonService kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
            KcPerson kcPersons = kcPersonService.getKcPersonByPersonId(PI.getPersonId());
            String departmentName = kcPersons.getOrganizationIdentifier();
            profile.setDepartmentName(departmentName);
        } else {
            DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
            profile.setDepartmentName(developmentProposal.getOwnedByUnit().getUnitName());
        }
    }

    private void setDirectoryTitleToProfile(PersonProfileDataType.Profile profile, ProposalPerson PI) {
        if (PI.getDirectoryTitle() != null) {
            if (PI.getDirectoryTitle().length() > 45) {
                profile.setTitle(PI.getDirectoryTitle().substring(0, 45));
            } else {
                profile.setTitle(PI.getDirectoryTitle());
            }
        }
    }

    private void assignRolodexId(ProposalPerson PI) {
        if (PI.getPersonId() != null) {
            this.pIPersonOrRolodexId = PI.getPersonId();
            this.rolodex = null;
        } else if (PI.getRolodexId() != null) {
            this.pIPersonOrRolodexId = PI.getRolodexId().toString();
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            this.rolodex = (Rolodex)businessObjectService.findBySinglePrimaryKey(Rolodex.class, (Object)this.pIPersonOrRolodexId);
        }
    }

    private void setAttachments(PersonProfileDataType.Profile profile, ProposalPerson PI) {
        this.setBioSketchAttachment(profile, PI);
        this.setCurrentPendingAttachment(profile, PI);
    }

    private void setCurrentPendingAttachment(PersonProfileDataType.Profile profile, ProposalPerson PI) {
        AttachedFileDataType supportAttachment = this.getPernonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "2");
        if (supportAttachment != null) {
            PersonProfileDataType.Profile.SupportsAttached supportsAttached = PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
            supportsAttached.setSupportAttached(supportAttachment);
            profile.setSupportsAttached(supportsAttached);
        }
    }

    private void setBioSketchAttachment(PersonProfileDataType.Profile profile, ProposalPerson PI) {
        PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
        AttachedFileDataType bioSketchAttachment = this.getPernonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "1");
        personBioSketch.setBioSketchAttached(bioSketchAttachment);
        profile.setBioSketchsAttached(personBioSketch);
    }

    private PersonProfileDataType[] getpersonProfileKeyPerson() {
        ArrayList personProfileDataTypeList = new ArrayList();
        DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
        List keyPersons = developmentProposal.getProposalPersons();
        if (keyPersons != null) {
            Collections.sort(keyPersons, new ProposalPersonComparator());
        }
        List nKeyPersons = this.s2sUtilService.getNKeyPersons(keyPersons, true, 40);
        this.extraPersons = this.s2sUtilService.getNKeyPersons(keyPersons, false, 40);
        if (nKeyPersons.size() > 0) {
            this.setKeyPersonToPersonProfileDataType(personProfileDataTypeList, nKeyPersons);
        }
        PersonProfileDataType[] personProfileDataArray = new PersonProfileDataType[]{};
        personProfileDataArray = personProfileDataTypeList.toArray(personProfileDataArray);
        return personProfileDataArray;
    }

    private void setKeyPersonToPersonProfileDataType(List<PersonProfileDataType> personProfileDataTypeList, List<ProposalPerson> nKeyPersons) {
        for (ProposalPerson keyPerson : nKeyPersons) {
            if (this.pIPersonOrRolodexId != null && (keyPerson.getPersonId() != null && keyPerson.getPersonId().equals(this.pIPersonOrRolodexId) || keyPerson.getRolodexId() != null && this.pIPersonOrRolodexId.equals(keyPerson.getRolodexId().toString()))) continue;
            PersonProfileDataType.Profile profileKeyPerson = PersonProfileDataType.Profile.Factory.newInstance();
            this.setAllkeyPersonDetailsToKeyPerson(keyPerson, profileKeyPerson);
            this.setAttachments(profileKeyPerson, keyPerson);
            PersonProfileDataType personProfileDataTypeKeyPerson = PersonProfileDataType.Factory.newInstance();
            personProfileDataTypeKeyPerson.setProfile(profileKeyPerson);
            personProfileDataTypeList.add(personProfileDataTypeKeyPerson);
        }
    }

    private void setAllkeyPersonDetailsToKeyPerson(ProposalPerson keyPerson, PersonProfileDataType.Profile profileKeyPerson) {
        ProposalPersonDegree proposalPersonDegree;
        this.assignRolodexId(keyPerson);
        profileKeyPerson.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
        this.setDirectoryTitleToProfile(profileKeyPerson, keyPerson);
        profileKeyPerson.setAddress(this.globLibV20Generator.getAddressDataType(keyPerson));
        profileKeyPerson.setPhone(keyPerson.getOfficePhone());
        if (keyPerson.getFaxNumber() != null) {
            profileKeyPerson.setFax(keyPerson.getFaxNumber());
        }
        if (keyPerson.getDegree() != null) {
            profileKeyPerson.setDegreeType(keyPerson.getDegree());
        }
        if (keyPerson.getYearGraduated() != null) {
            profileKeyPerson.setDegreeYear(keyPerson.getYearGraduated());
        }
        if (keyPerson.getDegree() == null && keyPerson.getYearGraduated() == null && keyPerson.getProposalPersonDegrees() != null && keyPerson.getProposalPersonDegrees().size() > 0 && (proposalPersonDegree = (ProposalPersonDegree)keyPerson.getProposalPersonDegrees().get(0)) != null) {
            if (proposalPersonDegree.getDegreeType() != null && proposalPersonDegree.getDegreeType().getDescription() != null) {
                profileKeyPerson.setDegreeType(proposalPersonDegree.getDegreeType().getDescription());
            }
            if (proposalPersonDegree.getGraduationYear() != null) {
                profileKeyPerson.setDegreeYear(proposalPersonDegree.getGraduationYear());
            }
        }
        profileKeyPerson.setEmail(keyPerson.getEmailAddress());
        DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
        this.setOrganizationName(profileKeyPerson, developmentProposal);
        this.setDepartmentNameToProfile(profileKeyPerson, keyPerson);
        String divisionName = keyPerson.getDivision();
        if (divisionName != null) {
            profileKeyPerson.setDivisionName(divisionName);
        }
        if (keyPerson.getEraCommonsUserName() != null) {
            profileKeyPerson.setCredential(keyPerson.getEraCommonsUserName());
        } else if (((SponsorService)KraServiceLocator.getService(SponsorService.class)).isSponsorNihMultiplePi((Sponsorable)this.pdDoc.getDevelopmentProposal()) && keyPerson.isMultiplePi()) {
            this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + keyPerson.getFullName(), "grantsGov.Opportunity"));
        }
        if (keyPerson.getProposalPersonRoleId().equals("COI")) {
            if (((SponsorService)KraServiceLocator.getService(SponsorService.class)).isSponsorNihMultiplePi((Sponsorable)this.pdDoc.getDevelopmentProposal())) {
                if (keyPerson.isMultiplePi()) {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.PD_PI);
                } else {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_INVESTIGATOR);
                }
            } else {
                profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
            }
        } else {
            this.setProjectRoleCategoryToProfile(keyPerson, profileKeyPerson);
        }
    }

    private void setOrganizationName(PersonProfileDataType.Profile profileKeyPerson, DevelopmentProposal developmentProposal) {
        if (developmentProposal.getApplicantOrganization() != null && developmentProposal.getApplicantOrganization().getOrganization() != null) {
            if (this.rolodex != null) {
                profileKeyPerson.setOrganizationName(this.rolodex.getOrganization());
            } else {
                profileKeyPerson.setOrganizationName(developmentProposal.getApplicantOrganization().getOrganization().getOrganizationName());
            }
        }
    }

    private void setProjectRoleCategoryToProfile(ProposalPerson keyPerson, PersonProfileDataType.Profile profileKeyPerson) {
        profileKeyPerson.setProjectRole(ProjectRoleDataType.OTHER_SPECIFY);
        PersonProfileDataType.Profile.OtherProjectRoleCategory otherProjectRole = PersonProfileDataType.Profile.OtherProjectRoleCategory.Factory.newInstance();
        String otherRole = keyPerson.getRole().getDescription() != null ? (keyPerson.getProjectRole().length() > 40 ? keyPerson.getProjectRole().substring(0, 40) : keyPerson.getProjectRole()) : "Unknown";
        otherProjectRole.setStringValue(otherRole);
        profileKeyPerson.setOtherProjectRoleCategory(otherProjectRole);
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRKeyPersonExpanded();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded = (RRKeyPersonExpanded12Document.RRKeyPersonExpanded12)xmlObject;
        RRKeyPersonExpanded12Document rrKeyPersonExpandedDocument = RRKeyPersonExpanded12Document.Factory.newInstance();
        rrKeyPersonExpandedDocument.setRRKeyPersonExpanded12(rrKeyPersonExpanded);
        return rrKeyPersonExpandedDocument;
    }
}

