/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrKeyPersonV11.PersonProfileDataType;
import gov.grants.apply.forms.rrKeyPersonV11.ProjectRoleDataType;
import gov.grants.apply.forms.rrKeyPersonV11.RRKeyPersonDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonComparator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.impl.RRKeyPersonBaseGenerator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.krad.service.BusinessObjectService;

public class RRKeyPersonV1_1Generator
extends RRKeyPersonBaseGenerator {
    private static final Log LOG = LogFactory.getLog(RRKeyPersonV1_1Generator.class);
    Rolodex rolodex;

    private RRKeyPersonDocument getRRKeyPerson() {
        RRKeyPersonDocument rrKeyPersonDocument = RRKeyPersonDocument.Factory.newInstance();
        RRKeyPersonDocument.RRKeyPerson rrKeyPerson = RRKeyPersonDocument.RRKeyPerson.Factory.newInstance();
        rrKeyPerson.setFormVersion("1.1");
        rrKeyPerson.setPDPI(this.getPersonProfilePI());
        rrKeyPerson.setKeyPersonArray(this.getPersonProfileKeyPerson());
        this.saveKeyPersonAttachmentsToProposal();
        if (this.extraPersons.size() > 0) {
            AttachedFileDataType attachedFileDataType = null;
            RRKeyPersonDocument.RRKeyPerson.BioSketchsAttached bioSketchAttached = RRKeyPersonDocument.RRKeyPerson.BioSketchsAttached.Factory.newInstance();
            for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
                if (narrative.getNarrativeTypeCode() == null) continue;
                switch (Integer.parseInt(narrative.getNarrativeTypeCode())) {
                    case 16: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        bioSketchAttached.setBioSketchAttached(attachedFileDataType);
                        break;
                    }
                    case 17: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        RRKeyPersonDocument.RRKeyPerson.SupportsAttached supportsAttached = RRKeyPersonDocument.RRKeyPerson.SupportsAttached.Factory.newInstance();
                        supportsAttached.setSupportAttached(attachedFileDataType);
                        rrKeyPerson.setSupportsAttached(supportsAttached);
                        break;
                    }
                    case 18: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        RRKeyPersonDocument.RRKeyPerson.AdditionalProfilesAttached additionalProfilesAttached = RRKeyPersonDocument.RRKeyPerson.AdditionalProfilesAttached.Factory.newInstance();
                        additionalProfilesAttached.setAdditionalProfileAttached(attachedFileDataType);
                        rrKeyPerson.setAdditionalProfilesAttached(additionalProfilesAttached);
                    }
                }
            }
            rrKeyPerson.setBioSketchsAttached(bioSketchAttached);
        }
        rrKeyPersonDocument.setRRKeyPerson(rrKeyPerson);
        return rrKeyPersonDocument;
    }

    private PersonProfileDataType getPersonProfilePI() {
        PersonProfileDataType personProfileDataType = PersonProfileDataType.Factory.newInstance();
        PersonProfileDataType.Profile profile = PersonProfileDataType.Profile.Factory.newInstance();
        ProposalPerson PI = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            if (PI.getPersonId() != null) {
                this.pIPersonOrRolodexId = PI.getPersonId();
                this.rolodex = null;
            } else if (PI.getRolodexId() != null) {
                this.pIPersonOrRolodexId = PI.getRolodexId().toString();
                BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
                this.rolodex = (Rolodex)businessObjectService.findBySinglePrimaryKey(Rolodex.class, (Object)this.pIPersonOrRolodexId);
            }
            profile.setName(this.globLibV20Generator.getHumanNameDataType(PI));
            if (PI.getDirectoryTitle() != null) {
                if (PI.getDirectoryTitle().length() > 45) {
                    profile.setTitle(PI.getDirectoryTitle().substring(0, 45));
                } else {
                    profile.setTitle(PI.getDirectoryTitle());
                }
            }
            profile.setAddress(this.globLibV20Generator.getAddressDataType(PI));
            profile.setPhone(PI.getOfficePhone());
            if (PI.getFaxNumber() != null) {
                profile.setFax(PI.getFaxNumber());
            }
            profile.setEmail(PI.getEmailAddress());
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                if (this.rolodex != null) {
                    profile.setOrganizationName(this.rolodex.getOrganization());
                } else {
                    profile.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
                }
            }
            if (PI.getHomeUnit() != null) {
                KcPersonService kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
                KcPerson kcPersons = kcPersonService.getKcPersonByPersonId(PI.getPersonId());
                String departmentName = kcPersons.getOrganizationIdentifier();
                profile.setDepartmentName(departmentName);
            } else {
                DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
                profile.setDepartmentName(developmentProposal.getOwnedByUnit().getUnitName());
            }
            String divisionName = PI.getDivision();
            if (divisionName != null) {
                profile.setDivisionName(divisionName);
            }
            if (PI.getEraCommonsUserName() != null) {
                profile.setCredential(PI.getEraCommonsUserName());
            } else if (((SponsorService)KraServiceLocator.getService(SponsorService.class)).isSponsorNihMultiplePi((Sponsorable)this.pdDoc.getDevelopmentProposal())) {
                this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + PI.getFullName(), "grantsGov.Opportunity"));
            }
            profile.setProjectRole(ProjectRoleDataType.PD_PI);
            PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
            AttachedFileDataType bioSketchAttachment = this.getPernonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "1");
            personBioSketch.setBioSketchAttached(bioSketchAttachment);
            profile.setBioSketchsAttached(personBioSketch);
            AttachedFileDataType supportAttachment = this.getPernonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "2");
            if (supportAttachment != null) {
                PersonProfileDataType.Profile.SupportsAttached supportsAttached = PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
                supportsAttached.setSupportAttached(supportAttachment);
                profile.setSupportsAttached(supportsAttached);
            }
            personProfileDataType.setProfile(profile);
        }
        return personProfileDataType;
    }

    private PersonProfileDataType[] getPersonProfileKeyPerson() {
        ArrayList<PersonProfileDataType> personProfileDataTypeList = new ArrayList<PersonProfileDataType>();
        List keyPersons = this.pdDoc.getDevelopmentProposal().getProposalPersons();
        Collections.sort(keyPersons, new ProposalPersonComparator());
        List nKeyPersons = this.s2sUtilService.getNKeyPersons(keyPersons, true, 8);
        this.extraPersons = this.s2sUtilService.getNKeyPersons(keyPersons, false, 8);
        if (nKeyPersons.size() > 0) {
            for (ProposalPerson keyPerson : nKeyPersons) {
                if (this.pIPersonOrRolodexId != null && (keyPerson.getPersonId() != null && keyPerson.getPersonId().equals(this.pIPersonOrRolodexId) || keyPerson.getRolodexId() != null && this.pIPersonOrRolodexId.equals(keyPerson.getRolodexId().toString()))) continue;
                if (keyPerson.getPersonId() != null) {
                    this.pIPersonOrRolodexId = keyPerson.getPersonId();
                    this.rolodex = null;
                } else if (keyPerson.getRolodexId() != null) {
                    this.pIPersonOrRolodexId = keyPerson.getRolodexId().toString();
                    BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
                    this.rolodex = (Rolodex)businessObjectService.findBySinglePrimaryKey(Rolodex.class, (Object)this.pIPersonOrRolodexId);
                }
                PersonProfileDataType.Profile profileKeyPerson = PersonProfileDataType.Profile.Factory.newInstance();
                profileKeyPerson.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
                if (keyPerson.getDirectoryTitle() != null) {
                    profileKeyPerson.setTitle(keyPerson.getDirectoryTitle());
                }
                profileKeyPerson.setAddress(this.globLibV20Generator.getAddressDataType(keyPerson));
                profileKeyPerson.setPhone(keyPerson.getOfficePhone());
                if (keyPerson.getFaxNumber() != null) {
                    profileKeyPerson.setFax(keyPerson.getFaxNumber());
                }
                profileKeyPerson.setEmail(keyPerson.getEmailAddress());
                if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                    if (this.rolodex != null) {
                        profileKeyPerson.setOrganizationName(this.rolodex.getOrganization());
                    } else {
                        profileKeyPerson.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
                    }
                }
                if (keyPerson.getHomeUnit() != null) {
                    KcPersonService kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
                    KcPerson kcPersons = kcPersonService.getKcPersonByPersonId(keyPerson.getPersonId());
                    String departmentName = kcPersons.getOrganizationIdentifier();
                    profileKeyPerson.setDepartmentName(departmentName);
                } else {
                    DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
                    profileKeyPerson.setDepartmentName(developmentProposal.getOwnedByUnit().getUnitName());
                }
                String divisionName = keyPerson.getDivision();
                if (divisionName != null) {
                    profileKeyPerson.setDivisionName(divisionName);
                }
                if (keyPerson.getEraCommonsUserName() != null) {
                    profileKeyPerson.setCredential(keyPerson.getEraCommonsUserName());
                } else if (((SponsorService)KraServiceLocator.getService(SponsorService.class)).isSponsorNihMultiplePi((Sponsorable)this.pdDoc.getDevelopmentProposal()) && keyPerson.isMultiplePi()) {
                    this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + keyPerson.getFullName(), "grantsGov.Opportunity"));
                }
                if (keyPerson.getProposalPersonRoleId().equals("COI")) {
                    if (((SponsorService)KraServiceLocator.getService(SponsorService.class)).isSponsorNihMultiplePi((Sponsorable)this.pdDoc.getDevelopmentProposal())) {
                        if (keyPerson.isMultiplePi()) {
                            profileKeyPerson.setProjectRole(ProjectRoleDataType.PD_PI);
                        } else {
                            profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
                        }
                    } else {
                        profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
                    }
                } else {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.OTHER_SPECIFY);
                    PersonProfileDataType.Profile.OtherProjectRoleCategory otherProjectRole = PersonProfileDataType.Profile.OtherProjectRoleCategory.Factory.newInstance();
                    String otherRole = keyPerson.getRole().getDescription() != null ? (keyPerson.getProjectRole().length() > 40 ? keyPerson.getProjectRole().substring(0, 40) : keyPerson.getProjectRole()) : "Unknown";
                    otherProjectRole.setStringValue(otherRole);
                    profileKeyPerson.setOtherProjectRoleCategory(otherProjectRole);
                }
                PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
                AttachedFileDataType bioSketchAttachment = this.getPernonnelAttachments(this.pdDoc, keyPerson.getPersonId(), keyPerson.getRolodexId(), "1");
                personBioSketch.setBioSketchAttached(bioSketchAttachment);
                profileKeyPerson.setBioSketchsAttached(personBioSketch);
                AttachedFileDataType supportAttachment = this.getPernonnelAttachments(this.pdDoc, keyPerson.getPersonId(), keyPerson.getRolodexId(), "2");
                if (supportAttachment != null) {
                    PersonProfileDataType.Profile.SupportsAttached supportsAttached = PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
                    supportsAttached.setSupportAttached(supportAttachment);
                    profileKeyPerson.setSupportsAttached(supportsAttached);
                }
                PersonProfileDataType personProfileDataTypeKeyperson = PersonProfileDataType.Factory.newInstance();
                personProfileDataTypeKeyperson.setProfile(profileKeyPerson);
                personProfileDataTypeList.add(personProfileDataTypeKeyperson);
            }
        }
        PersonProfileDataType[] personProfileDataTypeArray = new PersonProfileDataType[]{};
        personProfileDataTypeArray = personProfileDataTypeList.toArray(personProfileDataTypeArray);
        return personProfileDataTypeArray;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRKeyPerson();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRKeyPersonDocument.RRKeyPerson rrKeyPerson = (RRKeyPersonDocument.RRKeyPerson)xmlObject;
        RRKeyPersonDocument rrKeyPersonDocument = RRKeyPersonDocument.Factory.newInstance();
        rrKeyPersonDocument.setRRKeyPerson(rrKeyPerson);
        return rrKeyPersonDocument;
    }
}

