/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrPerformanceSiteV10.RRPerformanceSiteDocument;
import gov.grants.apply.forms.rrPerformanceSiteV10.SiteLocationDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.universalCodesV10.CountryCodeType;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.impl.RRPerformanceSiteBaseGenerator;

public class RRPerformanceSiteV1_0Generator
extends RRPerformanceSiteBaseGenerator {
    private RRPerformanceSiteDocument getRRPerformanceSite() {
        RRPerformanceSiteDocument rrPerformanceSiteDocument = RRPerformanceSiteDocument.Factory.newInstance();
        RRPerformanceSiteDocument.RRPerformanceSite rrPerformanceSite = rrPerformanceSiteDocument.addNewRRPerformanceSite();
        rrPerformanceSite.setFormVersion("1.0");
        List propsoalSites = this.pdDoc.getDevelopmentProposal().getProposalSites();
        SiteLocationDataType siteLocation = null;
        Organization organization = null;
        Rolodex rolodex = null;
        for (ProposalSite proposalSite : propsoalSites) {
            switch (proposalSite.getLocationTypeCode()) {
                case 2: {
                    siteLocation = rrPerformanceSite.addNewPrimarySite();
                    organization = proposalSite.getOrganization();
                    rolodex = organization.getRolodex();
                    break;
                }
                case 3: {
                    siteLocation = rrPerformanceSite.addNewOtherSite();
                    organization = proposalSite.getOrganization();
                    rolodex = organization.getRolodex();
                    break;
                }
                case 4: {
                    siteLocation = rrPerformanceSite.addNewOtherSite();
                    rolodex = proposalSite.getRolodex();
                }
            }
            if (siteLocation == null) continue;
            SiteLocationDataType.Address addressType = siteLocation.addNewAddress();
            this.setAddress(addressType, rolodex);
            siteLocation.setOrganizationName(proposalSite.getLocationName());
        }
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 40 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            rrPerformanceSite.setAttachedFile(attachedFileDataType);
            break;
        }
        return rrPerformanceSiteDocument;
    }

    private void setAddress(SiteLocationDataType.Address address, Rolodex rolodex) {
        if (rolodex != null) {
            address.setStreet1(rolodex.getAddressLine1());
            address.setStreet2(rolodex.getAddressLine2());
            address.setCity(this.checkNull(rolodex.getCity()));
            address.setCounty(rolodex.getCounty());
            address.setState(rolodex.getState());
            address.setZipCode(rolodex.getPostalCode());
            if (rolodex.getCountryCode() != null) {
                CountryCodeType.Enum country = CountryCodeType.Enum.forString((String)rolodex.getCountryCode());
                address.setCountry(country);
            }
        } else {
            address.setStreet1("");
            address.setCity("");
        }
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRPerformanceSite();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRPerformanceSiteDocument.RRPerformanceSite rrPerformanceSite = (RRPerformanceSiteDocument.RRPerformanceSite)xmlObject;
        RRPerformanceSiteDocument rrDocument = RRPerformanceSiteDocument.Factory.newInstance();
        rrDocument.setRRPerformanceSite(rrPerformanceSite);
        return rrDocument;
    }
}

