/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrPerformanceSiteV11.RRPerformanceSiteDocument;
import gov.grants.apply.forms.rrPerformanceSiteV11.SiteLocationDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.impl.RRPerformanceSiteBaseGenerator;
import org.kuali.kra.s2s.generator.impl.RRPerformanceSiteV1_0Generator;

public class RRPerformanceSiteV1_1Generator
extends RRPerformanceSiteBaseGenerator {
    private static final Log LOG = LogFactory.getLog(RRPerformanceSiteV1_0Generator.class);

    private RRPerformanceSiteDocument getRRPerformanceSite() {
        RRPerformanceSiteDocument rrPerformanceSiteDocument = RRPerformanceSiteDocument.Factory.newInstance();
        RRPerformanceSiteDocument.RRPerformanceSite rrPerformanceSite = RRPerformanceSiteDocument.RRPerformanceSite.Factory.newInstance();
        rrPerformanceSite.setFormVersion("1.1");
        List propsoalSites = this.pdDoc.getDevelopmentProposal().getProposalSites();
        SiteLocationDataType siteLocation = null;
        Organization organization = null;
        Rolodex rolodex = null;
        for (ProposalSite proposalSite : propsoalSites) {
            switch (proposalSite.getLocationTypeCode()) {
                case 2: {
                    siteLocation = rrPerformanceSite.addNewPrimarySite();
                    organization = proposalSite.getOrganization();
                    if (organization == null) break;
                    rolodex = organization.getRolodex();
                    break;
                }
                case 3: {
                    siteLocation = rrPerformanceSite.addNewOtherSite();
                    organization = proposalSite.getOrganization();
                    if (organization == null) break;
                    rolodex = organization.getRolodex();
                    break;
                }
                case 4: {
                    siteLocation = rrPerformanceSite.addNewOtherSite();
                    rolodex = proposalSite.getRolodex();
                }
            }
            if (siteLocation == null) continue;
            siteLocation.setAddress(this.globLibV20Generator.getAddressDataType(rolodex));
            siteLocation.setOrganizationName(proposalSite.getLocationName());
        }
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 40 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            rrPerformanceSite.setAttachedFile(attachedFileDataType);
            break;
        }
        rrPerformanceSiteDocument.setRRPerformanceSite(rrPerformanceSite);
        return rrPerformanceSiteDocument;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRPerformanceSite();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRPerformanceSiteDocument.RRPerformanceSite rrPerformanceSite = RRPerformanceSiteDocument.RRPerformanceSite.Factory.newInstance();
        RRPerformanceSiteDocument rrDocument = RRPerformanceSiteDocument.Factory.newInstance();
        rrDocument.setRRPerformanceSite(rrPerformanceSite);
        return rrDocument;
    }
}

