/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrSF424V10.AORInfoType;
import gov.grants.apply.forms.rrSF424V10.ApplicantTypeCodeDataType;
import gov.grants.apply.forms.rrSF424V10.ApplicationTypeCodeDataType;
import gov.grants.apply.forms.rrSF424V10.OrganizationContactPersonDataType;
import gov.grants.apply.forms.rrSF424V10.RRSF424Document;
import gov.grants.apply.forms.rrSF424V10.StateReviewCodeTypeDataType;
import gov.grants.apply.forms.rrSF424V10.SubmissionTypeDataType;
import gov.grants.apply.forms.sf424V10.StateReviewCodeType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV10.OrganizationDataTypeV2;
import gov.grants.apply.system.globalLibraryV10.YesNoDataType;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationType;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.RRSF424BaseGenerator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class RRSF424V1_0Generator
extends RRSF424BaseGenerator {
    private DepartmentalPerson departmentalPerson;
    private static final Log LOG = LogFactory.getLog(RRSF424V1_0Generator.class);

    private RRSF424Document getRRSF424() {
        Rolodex rolodexOrganization;
        Sponsor sponsor;
        String federalId;
        RRSF424Document rrSF424Document = RRSF424Document.Factory.newInstance();
        RRSF424Document.RRSF424 rrsf424 = RRSF424Document.RRSF424.Factory.newInstance();
        rrsf424.setFormVersion("1.0");
        S2sOpportunity s2sOpportunity = this.pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (s2sOpportunity != null && s2sOpportunity.getS2sSubmissionTypeCode() != null) {
            s2sOpportunity.refreshNonUpdateableReferences();
            rrsf424.setSubmissionTypeCode(SubmissionTypeDataType.Enum.forString((String)this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionType().getDescription()));
        }
        rrsf424.setSubmittedDate(this.s2sUtilService.getCurrentCalendar());
        Rolodex rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getRolodex();
        if (rolodex != null) {
            rrsf424.setStateID(rolodex.getState());
        }
        if ((federalId = this.s2sUtilService.getFederalId(this.pdDoc)) != null) {
            if (federalId.length() > 30) {
                rrsf424.setFederalID(federalId.substring(0, 30));
            } else {
                rrsf424.setFederalID(federalId);
            }
        }
        rrsf424.setApplicantInfo(this.getApplicationInfo());
        rrsf424.setApplicantType(this.getApplicantType());
        rrsf424.setApplicationType(this.getApplicationType());
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            rrsf424.setEmployerID(organization.getFedralEmployerId());
        }
        if ((sponsor = this.pdDoc.getDevelopmentProposal().getSponsor()) != null) {
            rrsf424.setFederalAgencyName(sponsor.getSponsorName());
        }
        if (this.pdDoc.getDevelopmentProposal().getCfdaNumber() != null) {
            rrsf424.setCFDANumber(this.pdDoc.getDevelopmentProposal().getCfdaNumber());
        }
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            String announcementTitle = this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120 ? this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120) : this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle();
            rrsf424.setActivityTitle(announcementTitle);
        }
        rrsf424.setProjectTitle(this.pdDoc.getDevelopmentProposal().getTitle());
        ProposalSite performingOrganization = this.pdDoc.getDevelopmentProposal().getPerformingOrganization();
        if (performingOrganization.getOrganization() != null && (rolodexOrganization = performingOrganization.getOrganization().getRolodex()) != null) {
            rrsf424.setLocation(rolodexOrganization.getState());
        }
        rrsf424.setProposedProjectPeriod(this.getProjectPeriod());
        rrsf424.setCongressionalDistrict(this.getCongDistrict());
        rrsf424.setPDPIContactInfo(this.getPDPI());
        try {
            rrsf424.setEstimatedProjectFunding(this.getProjectFunding());
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return rrSF424Document;
        }
        rrsf424.setStateReview(this.getStateReview());
        rrsf424.setTrustAgree(YesNoDataType.YES);
        rrsf424.setAORInfo(this.getAORInfoType());
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType preAttachment;
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 6 || (preAttachment = this.getAttachedFileType(narrative)) == null) continue;
            rrsf424.setPreApplicationAttachment(preAttachment);
            break;
        }
        if (this.departmentalPerson != null) {
            rrsf424.setAORSignature(this.departmentalPerson.getFullName());
        } else {
            rrsf424.setAORSignature("");
        }
        rrsf424.setAORSignedDate(this.s2sUtilService.getCurrentCalendar());
        rrSF424Document.setRRSF424(rrsf424);
        return rrSF424Document;
    }

    private RRSF424Document.RRSF424.EstimatedProjectFunding getProjectFunding() throws S2SException {
        BudgetDocument budgetDocument = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
        Budget budget = budgetDocument == null ? null : budgetDocument.getBudget();
        RRSF424Document.RRSF424.EstimatedProjectFunding funding = RRSF424Document.RRSF424.EstimatedProjectFunding.Factory.newInstance();
        funding.setTotalEstimatedAmount(BigDecimal.ZERO);
        funding.setTotalfedNonfedrequested(BigDecimal.ZERO);
        funding.setEstimatedProgramIncome(BigDecimal.ZERO);
        if (budget != null) {
            if (budget.getModularBudgetFlag().booleanValue()) {
                BudgetDecimal fundsRequested = BudgetDecimal.ZERO;
                BudgetDecimal totalDirectCost = BudgetDecimal.ZERO;
                BudgetDecimal totalCost = BudgetDecimal.ZERO;
                for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                    totalDirectCost = (BudgetDecimal)totalDirectCost.add((AbstractKualiDecimal)budgetPeriod.getBudgetModular().getTotalDirectCost());
                    for (BudgetModularIdc budgetModularIdc : budgetPeriod.getBudgetModular().getBudgetModularIdcs()) {
                        fundsRequested = (BudgetDecimal)fundsRequested.add((AbstractKualiDecimal)budgetModularIdc.getFundsRequested());
                    }
                }
                totalCost = (BudgetDecimal)totalCost.add((AbstractKualiDecimal)totalDirectCost);
                totalCost = (BudgetDecimal)totalCost.add((AbstractKualiDecimal)fundsRequested);
                budget.setTotalIndirectCost(fundsRequested);
                budget.setTotalCost(totalCost);
            }
            BudgetDecimal fedNonFedCost = BudgetDecimal.ZERO;
            fedNonFedCost = (BudgetDecimal)fedNonFedCost.add((AbstractKualiDecimal)budget.getTotalCost());
            fedNonFedCost = (BudgetDecimal)fedNonFedCost.add((AbstractKualiDecimal)budget.getCostSharingAmount());
            BigDecimal totalProjectIncome = BigDecimal.ZERO;
            for (BudgetProjectIncome budgetProjectIncome : budget.getBudgetProjectIncomes()) {
                if (budgetProjectIncome.getProjectIncome() == null) continue;
                totalProjectIncome = totalProjectIncome.add(budgetProjectIncome.getProjectIncome().bigDecimalValue());
            }
            funding.setTotalEstimatedAmount(budget.getTotalCost().bigDecimalValue());
            funding.setTotalfedNonfedrequested(fedNonFedCost.bigDecimalValue());
            funding.setEstimatedProgramIncome(totalProjectIncome);
        }
        return funding;
    }

    private RRSF424Document.RRSF424.ApplicantInfo getApplicationInfo() {
        RRSF424Document.RRSF424.ApplicantInfo appInfo = RRSF424Document.RRSF424.ApplicantInfo.Factory.newInstance();
        String contactType = this.getContactType();
        if ("I".equals(contactType)) {
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                appInfo.setContactPersonInfo(this.getContactInfo(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getRolodex()));
            }
        } else {
            DepartmentalPerson depPerson = this.getContactPerson(this.pdDoc);
            RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo contactInfo = RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
            if (depPerson != null) {
                contactInfo.setName(this.globLibV10Generator.getHumanNameDataType(depPerson));
                contactInfo.setPhone(depPerson.getOfficePhone());
                if (depPerson.getFaxNumber() != null) {
                    contactInfo.setFax(depPerson.getFaxNumber());
                }
                if (depPerson.getEmailAddress() != null) {
                    contactInfo.setEmail(depPerson.getEmailAddress());
                }
            }
            appInfo.setContactPersonInfo(contactInfo);
        }
        OrganizationDataTypeV2 orgType = OrganizationDataTypeV2.Factory.newInstance();
        Rolodex rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex();
        orgType.setAddress(this.globLibV10Generator.getAddressRequireCountryDataType(rolodex));
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            orgType.setOrganizationName(organization.getOrganizationName());
            orgType.setDUNSID(organization.getDunsNumber());
        }
        if (this.pdDoc.getDevelopmentProposal().getOwnedByUnit() != null) {
            String divisionName;
            String departmentName = this.pdDoc.getDevelopmentProposal().getOwnedByUnit().getUnitName();
            if (departmentName != null && departmentName.length() > 30) {
                departmentName = departmentName.substring(0, 29);
            }
            if (departmentName != null) {
                orgType.setDepartmentName(departmentName);
            }
            if ((divisionName = this.s2sUtilService.getDivisionName(this.pdDoc)) != null) {
                orgType.setDivisionName(divisionName);
            }
        }
        appInfo.setOrganizationInfo(orgType);
        return appInfo;
    }

    private RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo getContactInfo(Rolodex rolodexOrganization) {
        RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo contactInfo = RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
        contactInfo.setName(this.globLibV10Generator.getHumanNameDataType(rolodexOrganization));
        contactInfo.setPhone("");
        if (rolodexOrganization != null) {
            contactInfo.setPhone(rolodexOrganization.getPhoneNumber());
            if (rolodexOrganization.getFaxNumber() != null) {
                contactInfo.setFax(rolodexOrganization.getFaxNumber());
            }
            if (rolodexOrganization.getEmailAddress() != null) {
                contactInfo.setEmail(rolodexOrganization.getEmailAddress());
            }
        }
        return contactInfo;
    }

    private RRSF424Document.RRSF424.StateReview getStateReview() {
        Map eoStateReview = this.s2sUtilService.getEOStateReview(this.pdDoc);
        StateReviewCodeTypeDataType.Enum stateReviewCodeType = null;
        String stateReviewData = null;
        String strReview = (String)eoStateReview.get("answer");
        if ("Y".equals(strReview)) {
            stateReviewCodeType = StateReviewCodeTypeDataType.YES;
        } else if ("N".equals(strReview)) {
            stateReviewData = (String)eoStateReview.get("stateReviewData");
            if (stateReviewData != null && StateReviewCodeType.NOT_COVERED.toString().equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_IS_NOT_COVERED_BY_E_O_12372;
            } else if (stateReviewData != null && "Not Selected".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_HAS_NOT_BEEN_SELECTED_BY_STATE_FOR_REVIEW;
            }
        }
        RRSF424Document.RRSF424.StateReview stateReview = RRSF424Document.RRSF424.StateReview.Factory.newInstance();
        stateReview.setStateReviewCodeType(stateReviewCodeType);
        return stateReview;
    }

    private RRSF424Document.RRSF424.ApplicationType getApplicationType() {
        RRSF424Document.RRSF424.ApplicationType applicationType = RRSF424Document.RRSF424.ApplicationType.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getProposalTypeCode() != null && Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()) < 6) {
            ApplicationTypeCodeDataType.Enum applicationTypeCodeDataType = ApplicationTypeCodeDataType.Enum.forInt((int)Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()));
            applicationType.setApplicationTypeCode(applicationTypeCodeDataType);
            Map submissionInfo = this.s2sUtilService.getSubmissionType(this.pdDoc);
            if (Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()) == 5) {
                String revisionCode = null;
                if (submissionInfo.get("revisionCode") != null) {
                    revisionCode = (String)submissionInfo.get("revisionCode");
                    RRSF424Document.RRSF424.ApplicationType.RevisionCode revisionCodeApplication = RRSF424Document.RRSF424.ApplicationType.RevisionCode.Factory.newInstance();
                    revisionCodeApplication.setStringValue(revisionCode);
                    applicationType.setRevisionCode(revisionCodeApplication);
                }
                String revisionCodeOtherDesc = null;
                if (submissionInfo.get("revisionOtherDescription") != null) {
                    revisionCodeOtherDesc = (String)submissionInfo.get("revisionOtherDescription");
                    RRSF424Document.RRSF424.ApplicationType.RevisionCodeOtherExplanation revisionCodeOtherExplanation = RRSF424Document.RRSF424.ApplicationType.RevisionCodeOtherExplanation.Factory.newInstance();
                    revisionCodeOtherExplanation.setStringValue(revisionCodeOtherDesc);
                    applicationType.setRevisionCodeOtherExplanation(revisionCodeOtherExplanation);
                }
            }
        }
        ProposalYnq proposalYnq = this.getAnswer("15", this.pdDoc);
        YesNoDataType.Enum answer = YesNoDataType.NO;
        if (proposalYnq != null && proposalYnq.getAnswer() != null) {
            answer = proposalYnq.getAnswer().equals("Y") ? YesNoDataType.YES : YesNoDataType.NO;
        }
        applicationType.setIsOtherAgencySubmission(answer);
        if (answer.equals(YesNoDataType.YES)) {
            RRSF424Document.RRSF424.ApplicationType.OtherAgencySubmissionExplanation otherAgencySubmissionExplanation = RRSF424Document.RRSF424.ApplicationType.OtherAgencySubmissionExplanation.Factory.newInstance();
            otherAgencySubmissionExplanation.setIsOtherAgencySubmission(answer);
            String answerExplanation = proposalYnq.getExplanation();
            if (answerExplanation != null) {
                if (answerExplanation.length() > 20) {
                    otherAgencySubmissionExplanation.setStringValue(answerExplanation.substring(0, 20));
                } else {
                    otherAgencySubmissionExplanation.setStringValue(answerExplanation);
                }
            }
            applicationType.setOtherAgencySubmissionExplanation(otherAgencySubmissionExplanation);
        }
        return applicationType;
    }

    private RRSF424Document.RRSF424.ProposedProjectPeriod getProjectPeriod() {
        RRSF424Document.RRSF424.ProposedProjectPeriod proposedProjectPeriod = RRSF424Document.RRSF424.ProposedProjectPeriod.Factory.newInstance();
        proposedProjectPeriod.setProposedStartDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        proposedProjectPeriod.setProposedEndDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        return proposedProjectPeriod;
    }

    private RRSF424Document.RRSF424.CongressionalDistrict getCongDistrict() {
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        ProposalSite performingOrgSite = this.pdDoc.getDevelopmentProposal().getPerformingOrganization();
        Organization performingOrganization = null;
        if (performingOrgSite != null) {
            performingOrganization = performingOrgSite.getOrganization();
        }
        RRSF424Document.RRSF424.CongressionalDistrict congressionalDistrict = RRSF424Document.RRSF424.CongressionalDistrict.Factory.newInstance();
        if (organization != null) {
            congressionalDistrict.setApplicantCongressionalDistrict(organization.getCongressionalDistrict());
        } else {
            congressionalDistrict.setApplicantCongressionalDistrict("");
        }
        if (performingOrganization != null) {
            congressionalDistrict.setProjectCongressionalDistrict(performingOrganization.getCongressionalDistrict());
        } else {
            congressionalDistrict.setProjectCongressionalDistrict("");
        }
        return congressionalDistrict;
    }

    private OrganizationContactPersonDataType getPDPI() {
        OrganizationContactPersonDataType PDPI2 = OrganizationContactPersonDataType.Factory.newInstance();
        ProposalPerson PI = null;
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!"PI".equals(proposalPerson.getProposalPersonRoleId())) continue;
            PI = proposalPerson;
            Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
            PDPI2.setName(this.globLibV10Generator.getHumanNameDataType(PI));
            PDPI2.setPhone(PI.getOfficePhone());
            PDPI2.setEmail(PI.getEmailAddress());
            if (PI.getFaxNumber() != null) {
                PDPI2.setFax(PI.getFaxNumber());
            }
            PDPI2.setAddress(this.globLibV10Generator.getAddressRequireCountryDataType(PI));
            if (PI.getDirectoryTitle() != null) {
                if (PI.getDirectoryTitle().length() > 45) {
                    PDPI2.setTitle(PI.getDirectoryTitle().substring(0, 45));
                } else {
                    PDPI2.setTitle(PI.getDirectoryTitle());
                }
            }
            if (PI.getHomeUnit() != null) {
                KcPersonService kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
                KcPerson kcPersons = kcPersonService.getKcPersonByPersonId(PI.getPersonId());
                String departmentName = kcPersons.getOrganizationIdentifier();
                PDPI2.setDepartmentName(departmentName);
            } else {
                DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
                PDPI2.setDepartmentName(developmentProposal.getOwnedByUnit().getUnitName());
            }
            String divisionName = proposalPerson.getDivision();
            if (divisionName != null) {
                PDPI2.setDivisionName(divisionName);
            }
            if (organization == null) continue;
            PDPI2.setOrganizationName(organization.getOrganizationName());
        }
        return PDPI2;
    }

    private AORInfoType getAORInfoType() {
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        AORInfoType aorInfoType = AORInfoType.Factory.newInstance();
        if (this.departmentalPerson != null) {
            aorInfoType.setName(this.globLibV10Generator.getHumanNameDataType(this.departmentalPerson));
            if (this.departmentalPerson.getPrimaryTitle() != null) {
                if (this.departmentalPerson.getPrimaryTitle().length() > 45) {
                    aorInfoType.setTitle(this.departmentalPerson.getPrimaryTitle().substring(0, 45));
                } else {
                    aorInfoType.setTitle(this.departmentalPerson.getPrimaryTitle());
                }
            }
            aorInfoType.setAddress(this.globLibV10Generator.getAddressRequireCountryDataType(this.departmentalPerson));
            aorInfoType.setPhone(this.departmentalPerson.getOfficePhone());
            aorInfoType.setFax(this.departmentalPerson.getFaxNumber());
            aorInfoType.setDepartmentName(this.departmentalPerson.getDirDept());
            aorInfoType.setEmail(this.departmentalPerson.getEmailAddress());
            if (this.departmentalPerson.getHomeUnit() != null) {
                aorInfoType.setDivisionName(this.departmentalPerson.getHomeUnit());
            }
        }
        if (organization != null) {
            aorInfoType.setOrganizationName(organization.getOrganizationName());
        }
        return aorInfoType;
    }

    private RRSF424Document.RRSF424.ApplicantType getApplicantType() {
        RRSF424Document.RRSF424.ApplicantType applicantType = RRSF424Document.RRSF424.ApplicantType.Factory.newInstance();
        RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType smallOrganizationType = RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.Factory.newInstance();
        RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged isSociallyEconomicallyDisadvantaged = RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged.Factory.newInstance();
        RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned isWomenOwned = RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned.Factory.newInstance();
        boolean smallBusflag = false;
        int orgTypeCode = 0;
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().size() > 0) {
            orgTypeCode = ((OrganizationType)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().get(0)).getOrganizationTypeCode();
        }
        ApplicantTypeCodeDataType.Enum applicantTypeCode = null;
        switch (orgTypeCode) {
            case 1: {
                applicantTypeCode = ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                break;
            }
            case 2: {
                applicantTypeCode = ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                break;
            }
            case 3: {
                applicantTypeCode = ApplicantTypeCodeDataType.P_OTHER_SPECIFY;
                break;
            }
            case 4: {
                applicantTypeCode = ApplicantTypeCodeDataType.J_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 5: {
                applicantTypeCode = ApplicantTypeCodeDataType.K_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 6: {
                applicantTypeCode = ApplicantTypeCodeDataType.N_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                break;
            }
            case 7: {
                applicantTypeCode = ApplicantTypeCodeDataType.P_OTHER_SPECIFY;
                break;
            }
            case 8: {
                applicantTypeCode = ApplicantTypeCodeDataType.G_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                break;
            }
            case 9: {
                applicantTypeCode = ApplicantTypeCodeDataType.M_INDIVIDUAL;
                break;
            }
            case 10: {
                applicantTypeCode = ApplicantTypeCodeDataType.L_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 11: {
                applicantTypeCode = ApplicantTypeCodeDataType.O_SMALL_BUSINESS;
                break;
            }
            case 14: {
                applicantTypeCode = ApplicantTypeCodeDataType.P_OTHER_SPECIFY;
                isSociallyEconomicallyDisadvantaged.setStringValue("Yes");
                applicantTypeCode = ApplicantTypeCodeDataType.O_SMALL_BUSINESS;
                smallOrganizationType.setApplicantTypeCode(applicantTypeCode);
                smallOrganizationType.setIsSociallyEconomicallyDisadvantaged(isSociallyEconomicallyDisadvantaged);
                smallBusflag = true;
                break;
            }
            case 15: {
                applicantTypeCode = ApplicantTypeCodeDataType.P_OTHER_SPECIFY;
                isWomenOwned.setStringValue("Yes");
                applicantTypeCode = ApplicantTypeCodeDataType.O_SMALL_BUSINESS;
                smallOrganizationType.setApplicantTypeCode(applicantTypeCode);
                smallOrganizationType.setIsWomenOwned(isWomenOwned);
                smallBusflag = true;
                break;
            }
            case 21: {
                applicantTypeCode = ApplicantTypeCodeDataType.F_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 22: {
                applicantTypeCode = ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                break;
            }
            case 23: {
                applicantTypeCode = ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENTS;
                break;
            }
            case 24: {
                applicantTypeCode = ApplicantTypeCodeDataType.E_INDEPENDENT_SCHOOL_DISTRICT;
                break;
            }
            case 25: {
                applicantTypeCode = ApplicantTypeCodeDataType.H_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                break;
            }
            case 26: {
                applicantTypeCode = ApplicantTypeCodeDataType.I_NATIVE_AMERICAN_TRIBAL_ORGANIZATION_OTHER_THAN_FEDERALLY_RECOGNIZED;
                break;
            }
            default: {
                applicantTypeCode = ApplicantTypeCodeDataType.P_OTHER_SPECIFY;
            }
        }
        if (smallBusflag) {
            applicantType.setSmallBusinessOrganizationType(smallOrganizationType);
        }
        applicantType.setApplicantTypeCode(applicantTypeCode);
        return applicantType;
    }

    private ProposalYnq getAnswer(String questionId, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        ProposalYnq ynQ = null;
        for (ProposalYnq proposalYnq : proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs()) {
            String question = proposalYnq.getQuestionId();
            if (question == null || !question.equals(questionId)) continue;
            ynQ = proposalYnq;
            break;
        }
        return ynQ;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.departmentalPerson = this.s2sUtilService.getDepartmentalPerson(proposalDevelopmentDocument);
        return this.getRRSF424();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRSF424Document.RRSF424 rrsf424 = (RRSF424Document.RRSF424)xmlObject;
        RRSF424Document rrSF424Document = RRSF424Document.Factory.newInstance();
        rrSF424Document.setRRSF424(rrsf424);
        return rrSF424Document;
    }
}

