/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardAttachment;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.generator.bo.AttachmentData;
import org.kuali.kra.s2s.validator.S2SErrorHandler;
import org.kuali.kra.service.KcAttachmentService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class S2SAdobeFormAttachmentBaseGenerator
extends S2SBaseFormGenerator {
    protected static final String RR_BUDGET_10_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_Budget-V1.0";
    protected static final String RR_BUDGET_11_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_Budget-V1.1";
    protected static final String LOCAL_NAME = "RR_Budget";
    protected static final String ERROR1_PROPERTY_KEY = "s2sSubawardBudgetV1-2_10000";
    protected static final String ERROR2_PROPERTY_KEY = "s2sSubawardBudget_10002";
    private static transient KcAttachmentService kcAttachmentService;

    public Document nodeToDom(Node node) throws S2SException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer xf = tf.newTransformer();
            DOMResult dr = new DOMResult();
            xf.transform(new DOMSource(node), dr);
            return (Document)dr.getNode();
        }
        catch (TransformerException ex) {
            throw new S2SException(ex.getMessage());
        }
    }

    public Document stringToDom(String xmlSource) throws S2SException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xmlSource)));
        }
        catch (SAXException ex) {
            throw new S2SException(ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            throw new S2SException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new S2SException(ex.getMessage());
        }
    }

    public byte[] docToBytes(Document node) throws S2SException {
        return this.docToString(node).getBytes();
    }

    public String docToString(Document node) throws S2SException {
        try {
            DOMSource domSource = new DOMSource(node);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (Exception e) {
            throw new S2SException(e.getMessage());
        }
    }

    protected static final String prepareAttName(BudgetSubAwards budgetSubAwards) {
        StringBuilder attachmentName = new StringBuilder();
        attachmentName.append(budgetSubAwards.getBudgetId() + "-");
        String cleanSubAwardOrganizationName = S2SAdobeFormAttachmentBaseGenerator.getKcAttachmentService().checkAndReplaceInvalidCharacters(budgetSubAwards.getOrganizationName());
        attachmentName.append(cleanSubAwardOrganizationName + "-");
        attachmentName.append(budgetSubAwards.getSubAwardNumber());
        return attachmentName.toString();
    }

    protected static KcAttachmentService getKcAttachmentService() {
        if (kcAttachmentService == null) {
            kcAttachmentService = (KcAttachmentService)KraServiceLocator.getService(KcAttachmentService.class);
        }
        return kcAttachmentService;
    }

    protected void addSubAwdAttachments(BudgetSubAwards budgetSubAwards) {
        budgetSubAwards.refreshReferenceObject("budgetSubAwardAttachments");
        List subAwardAttachments = budgetSubAwards.getBudgetSubAwardAttachments();
        for (BudgetSubAwardAttachment budgetSubAwardAttachment : subAwardAttachments) {
            AttachmentData attachmentData = new AttachmentData();
            attachmentData.setContent(budgetSubAwardAttachment.getAttachment());
            attachmentData.setContentId(budgetSubAwardAttachment.getContentId());
            attachmentData.setContentType(budgetSubAwardAttachment.getContentType());
            attachmentData.setFileName(budgetSubAwardAttachment.getContentId());
            this.addAttachment(attachmentData);
        }
    }

    protected List<BudgetSubAwards> getBudgetSubAwards(ProposalDevelopmentDocument proposalDevelopmentDocument, String namespace, boolean checkNull) {
        List<BudgetSubAwards> budgetSubAwardsList = new ArrayList();
        Budget budget = this.findBudgetFromProposal(proposalDevelopmentDocument);
        if (budget == null) {
            this.getAuditErrors().add(S2SErrorHandler.getError((String)"budget.subaward.notfound"));
        } else {
            budgetSubAwardsList = this.findBudgetSubawards(namespace, budget, checkNull);
            if (budgetSubAwardsList.isEmpty()) {
                this.getAuditErrors().add(S2SErrorHandler.getError((String)"budget.subaward.notfound"));
            }
        }
        return budgetSubAwardsList;
    }

    private List<BudgetSubAwards> findBudgetSubawards(String namespace, Budget budget, boolean checkNull) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("budgetId", budget.getBudgetId());
        paramMap.put("namespace", namespace);
        List budgetSubAwardsList = (List)this.getBusinessObjectService().findMatching(BudgetSubAwards.class, paramMap);
        if (checkNull) {
            paramMap.put("namespace", null);
            budgetSubAwardsList.addAll(this.getBusinessObjectService().findMatching(BudgetSubAwards.class, paramMap));
        }
        return budgetSubAwardsList;
    }

    private Budget findBudgetFromProposal(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        Budget finalBudget = proposalDevelopmentDocument.getFinalBudgetForThisProposal();
        if (finalBudget == null) {
            List budgetDocumentVersions = proposalDevelopmentDocument.getBudgetDocumentVersions();
            BudgetVersionOverview budgetVersionOverview = null;
            for (BudgetDocumentVersion budgetDocumentVersion : budgetDocumentVersions) {
                if (!budgetDocumentVersion.isBudgetComplete()) continue;
                budgetVersionOverview = budgetDocumentVersion.getBudgetVersionOverview();
                return budgetDocumentVersion.findBudget();
            }
            if (!budgetDocumentVersions.isEmpty()) {
                finalBudget = ((BudgetDocumentVersion)budgetDocumentVersions.get(0)).findBudget();
            }
        }
        return finalBudget;
    }

    public BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }
}

