/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.sf424AV10.BudgetCategoriesDocument;
import gov.grants.apply.forms.sf424AV10.BudgetFirstQuarterAmountsDocument;
import gov.grants.apply.forms.sf424AV10.BudgetFirstYearAmountsDocument;
import gov.grants.apply.forms.sf424AV10.BudgetForecastedCashNeedsDocument;
import gov.grants.apply.forms.sf424AV10.BudgetFourthQuarterAmountsDocument;
import gov.grants.apply.forms.sf424AV10.BudgetInformationDocument;
import gov.grants.apply.forms.sf424AV10.BudgetInformationType;
import gov.grants.apply.forms.sf424AV10.BudgetSecondQuarterAmountsDocument;
import gov.grants.apply.forms.sf424AV10.BudgetSummaryDocument;
import gov.grants.apply.forms.sf424AV10.BudgetThirdQuarterAmountsDocument;
import gov.grants.apply.forms.sf424AV10.CategorySetDocument;
import gov.grants.apply.forms.sf424AV10.CategoryTotalsDocument;
import gov.grants.apply.forms.sf424AV10.FederalFundsNeededDocument;
import gov.grants.apply.forms.sf424AV10.FundsLineItemDocument;
import gov.grants.apply.forms.sf424AV10.FundsTotalsDocument;
import gov.grants.apply.forms.sf424AV10.NonFederalResourcesDocument;
import gov.grants.apply.forms.sf424AV10.ResourceLineItemDocument;
import gov.grants.apply.forms.sf424AV10.ResourceTotalsDocument;
import gov.grants.apply.forms.sf424AV10.SummaryLineItemDocument;
import gov.grants.apply.forms.sf424AV10.SummaryTotalsDocument;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCategoryMap;
import org.kuali.kra.budget.core.BudgetCategoryMapping;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.impl.SF424BaseGenerator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class SF424AV1_0Generator
extends SF424BaseGenerator {
    private static final Log LOG = LogFactory.getLog(SF424AV1_0Generator.class);
    private Budget budget = null;

    private BudgetInformationDocument getSF424A() {
        BudgetInformationDocument budgetInformationDocument = BudgetInformationDocument.Factory.newInstance();
        try {
            BudgetDocument budgetDocument = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
            this.budget = budgetDocument == null ? null : budgetDocument.getBudget();
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return budgetInformationDocument;
        }
        BudgetInformationType SF424A = BudgetInformationType.Factory.newInstance();
        SF424A.setCoreSchemaVersion("1.0");
        SF424A.setFormVersionIdentifier("1.0");
        SF424A.setProgramType("Non-Construction");
        BudgetSummaryDocument.BudgetSummary budgetSummary = this.getBudgetSummary();
        BudgetCategoriesDocument.BudgetCategories budgetCategories = this.getBudgetCategories();
        NonFederalResourcesDocument.NonFederalResources nonFederalResources = this.getNonFederalResources();
        BudgetForecastedCashNeedsDocument.BudgetForecastedCashNeeds budgetForecastedCashNeeds = this.getBudgetForecastedCashNeeds();
        FederalFundsNeededDocument.FederalFundsNeeded federalFundsNeeded = this.getFederalFundsNeeded();
        SF424A.setBudgetSummary(budgetSummary);
        SF424A.setBudgetCategories(budgetCategories);
        SF424A.setNonFederalResources(nonFederalResources);
        SF424A.setBudgetForecastedCashNeeds(budgetForecastedCashNeeds);
        SF424A.setFederalFundsNeeded(federalFundsNeeded);
        budgetInformationDocument.setBudgetInformation(SF424A);
        return budgetInformationDocument;
    }

    private BudgetCategoriesDocument.BudgetCategories getBudgetCategories() {
        BudgetDecimal constructionCost = BudgetDecimal.ZERO;
        BudgetDecimal contractualCost = BudgetDecimal.ZERO;
        BudgetDecimal equipmentCost = BudgetDecimal.ZERO;
        BudgetDecimal personnelCost = BudgetDecimal.ZERO;
        BudgetDecimal suppliesCost = BudgetDecimal.ZERO;
        BudgetDecimal otherCost = BudgetDecimal.ZERO;
        BudgetDecimal travelCost = BudgetDecimal.ZERO;
        BudgetDecimal programIncome = BudgetDecimal.ZERO;
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        BudgetCategoriesDocument.BudgetCategories budgetCategories = BudgetCategoriesDocument.BudgetCategories.Factory.newInstance();
        CategoryTotalsDocument.CategoryTotals categoryTotals = CategoryTotalsDocument.CategoryTotals.Factory.newInstance();
        if (this.budget == null) {
            return budgetCategories;
        }
        BudgetPeriod budgetPeriod = this.budget.getBudgetPeriod(0);
        CategorySetDocument.CategorySet[] categorySetArray = new CategorySetDocument.CategorySet[1];
        CategorySetDocument.CategorySet categorySet = CategorySetDocument.CategorySet.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode() != null) {
            this.pdDoc.getDevelopmentProposal().getS2sOpportunity().refreshNonUpdateableReferences();
            categorySet.setActivityTitle(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle());
        }
        List budgetCategoryMapList = this.s2sBudgetCalculatorService.getBudgetCategoryMapList(new ArrayList(), new ArrayList());
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetCategoryMap budgetCategoryMap : budgetCategoryMapList) {
                for (BudgetCategoryMapping budgetCategoryMapping : budgetCategoryMap.getBudgetCategoryMappings()) {
                    if (!budgetLineItem.getBudgetCategoryCode().equals(budgetCategoryMapping.getBudgetCategoryCode())) continue;
                    if (budgetCategoryMap.getTargetCategoryCode().equals("40")) {
                        constructionCost = (BudgetDecimal)constructionCost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
                        continue;
                    }
                    if (budgetCategoryMap.getTargetCategoryCode().equals("04")) {
                        contractualCost = (BudgetDecimal)contractualCost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
                        continue;
                    }
                    if (budgetCategoryMap.getTargetCategoryCode().equals("42")) {
                        equipmentCost = (BudgetDecimal)equipmentCost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
                        continue;
                    }
                    if (budgetCategoryMap.getCategoryType().equals("P")) {
                        personnelCost = (BudgetDecimal)personnelCost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
                        continue;
                    }
                    if (budgetCategoryMap.getTargetCategoryCode().equals("43")) {
                        suppliesCost = (BudgetDecimal)suppliesCost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
                        continue;
                    }
                    if (budgetCategoryMap.getTargetCategoryCode().equals("73") || budgetCategoryMap.getTargetCategoryCode().equals("74")) {
                        travelCost = (BudgetDecimal)travelCost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
                        continue;
                    }
                    otherCost = (BudgetDecimal)otherCost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
                }
            }
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                budgetLineItemCalculatedAmount.refreshReferenceObject("rateClass");
                if (!budgetLineItemCalculatedAmount.getRateClass().getRateClassType().equals("E") && !budgetLineItemCalculatedAmount.getRateClass().getRateClassType().equals("E")) continue;
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)budgetLineItemCalculatedAmount.getCalculatedCost());
            }
        }
        for (BudgetProjectIncome budgetProjectIncome : this.budget.getBudgetProjectIncomes()) {
            programIncome = (BudgetDecimal)programIncome.add((AbstractKualiDecimal)new BudgetDecimal(budgetProjectIncome.getProjectIncome().bigDecimalValue()));
        }
        categorySet.setBudgetConstructionRequestedAmount(constructionCost.bigDecimalValue());
        categoryTotals.setBudgetConstructionRequestedAmount(constructionCost.bigDecimalValue());
        categorySet.setBudgetContractualRequestedAmount(contractualCost.bigDecimalValue());
        categoryTotals.setBudgetContractualRequestedAmount(contractualCost.bigDecimalValue());
        categorySet.setBudgetEquipmentRequestedAmount(equipmentCost.bigDecimalValue());
        categoryTotals.setBudgetEquipmentRequestedAmount(equipmentCost.bigDecimalValue());
        categorySet.setBudgetFringeBenefitsRequestedAmount(calculatedCost.bigDecimalValue());
        categoryTotals.setBudgetFringeBenefitsRequestedAmount(calculatedCost.bigDecimalValue());
        categorySet.setBudgetIndirectChargesAmount(this.budget.getTotalIndirectCost().bigDecimalValue());
        categoryTotals.setBudgetIndirectChargesAmount(this.budget.getTotalIndirectCost().bigDecimalValue());
        categorySet.setBudgetOtherRequestedAmount(otherCost.bigDecimalValue());
        categoryTotals.setBudgetOtherRequestedAmount(otherCost.bigDecimalValue());
        categorySet.setBudgetPersonnelRequestedAmount(personnelCost.bigDecimalValue());
        categoryTotals.setBudgetPersonnelRequestedAmount(personnelCost.bigDecimalValue());
        categorySet.setBudgetSuppliesRequestedAmount(suppliesCost.bigDecimalValue());
        categoryTotals.setBudgetSuppliesRequestedAmount(suppliesCost.bigDecimalValue());
        categorySet.setBudgetTotalAmount(this.budget.getTotalCost().bigDecimalValue());
        categorySet.setBudgetTotalDirectChargesAmount(this.budget.getTotalDirectCost().bigDecimalValue());
        categorySet.setBudgetTravelRequestedAmount(travelCost.bigDecimalValue());
        categoryTotals.setBudgetTravelRequestedAmount(travelCost.bigDecimalValue());
        categorySet.setProgramIncomeAmount(programIncome.bigDecimalValue());
        categoryTotals.setProgramIncomeAmount(programIncome.bigDecimalValue());
        categoryTotals.setBudgetTotalAmount(this.budget.getTotalCost().bigDecimalValue());
        categoryTotals.setBudgetTotalDirectChargesAmount(this.budget.getTotalDirectCost().bigDecimalValue());
        categorySetArray[0] = categorySet;
        budgetCategories.setCategorySetArray(categorySetArray);
        budgetCategories.setCategoryTotals(categoryTotals);
        return budgetCategories;
    }

    private BudgetSummaryDocument.BudgetSummary getBudgetSummary() {
        BudgetSummaryDocument.BudgetSummary budgetSummary = BudgetSummaryDocument.BudgetSummary.Factory.newInstance();
        SummaryLineItemDocument.SummaryLineItem[] summaryLineItemArray = new SummaryLineItemDocument.SummaryLineItem[1];
        SummaryLineItemDocument.SummaryLineItem summaryLineItem = SummaryLineItemDocument.SummaryLineItem.Factory.newInstance();
        boolean hasBudgetLineItem = false;
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode() != null) {
            this.pdDoc.getDevelopmentProposal().getS2sOpportunity().refreshNonUpdateableReferences();
            summaryLineItem.setActivityTitle(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle());
            summaryLineItem.setCFDANumber(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getCfdaNumber());
        }
        if (this.budget != null) {
            BudgetDecimal fedNonFedCost = this.budget.getTotalCost();
            BudgetDecimal costSharingAmount = BudgetDecimal.ZERO;
            for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudgetLineItem = true;
                    if (!this.budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    costSharingAmount = (BudgetDecimal)costSharingAmount.add((AbstractKualiDecimal)lineItem.getCostSharingAmount());
                    List calculatedAmounts = lineItem.getBudgetCalculatedAmounts();
                    for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : calculatedAmounts) {
                        costSharingAmount = (BudgetDecimal)costSharingAmount.add((AbstractKualiDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudgetLineItem && this.budget.getSubmitCostSharingFlag().booleanValue()) {
                costSharingAmount = this.budget.getCostSharingAmount();
            }
            fedNonFedCost = (BudgetDecimal)fedNonFedCost.add((AbstractKualiDecimal)costSharingAmount);
            summaryLineItem.setBudgetFederalNewOrRevisedAmount(this.budget.getTotalCost().bigDecimalValue());
            summaryLineItem.setBudgetNonFederalNewOrRevisedAmount(costSharingAmount.bigDecimalValue());
            summaryLineItem.setBudgetTotalNewOrRevisedAmount(fedNonFedCost.bigDecimalValue());
            summaryLineItemArray[0] = summaryLineItem;
            budgetSummary.setSummaryLineItemArray(summaryLineItemArray);
            SummaryTotalsDocument.SummaryTotals summaryTotals = SummaryTotalsDocument.SummaryTotals.Factory.newInstance();
            summaryTotals.setBudgetFederalNewOrRevisedAmount(this.budget.getTotalCost().bigDecimalValue());
            summaryTotals.setBudgetNonFederalNewOrRevisedAmount(costSharingAmount.bigDecimalValue());
            summaryTotals.setBudgetTotalNewOrRevisedAmount(fedNonFedCost.bigDecimalValue());
            budgetSummary.setSummaryTotals(summaryTotals);
        }
        return budgetSummary;
    }

    private NonFederalResourcesDocument.NonFederalResources getNonFederalResources() {
        NonFederalResourcesDocument.NonFederalResources nonFederalResources = NonFederalResourcesDocument.NonFederalResources.Factory.newInstance();
        ResourceLineItemDocument.ResourceLineItem[] resourceLineItemArray = new ResourceLineItemDocument.ResourceLineItem[1];
        ResourceLineItemDocument.ResourceLineItem resourceLineItem = ResourceLineItemDocument.ResourceLineItem.Factory.newInstance();
        boolean hasBudegetLineItem = false;
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode() != null) {
            this.pdDoc.getDevelopmentProposal().getS2sOpportunity().refreshNonUpdateableReferences();
            resourceLineItem.setActivityTitle(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle());
        }
        if (this.budget != null) {
            BudgetDecimal fedNonFedCost = BudgetDecimal.ZERO;
            for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudegetLineItem = true;
                    if (!this.budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    fedNonFedCost = (BudgetDecimal)fedNonFedCost.add((AbstractKualiDecimal)lineItem.getCostSharingAmount());
                    for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                        fedNonFedCost = (BudgetDecimal)fedNonFedCost.add((AbstractKualiDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudegetLineItem && this.budget.getSubmitCostSharingFlag().booleanValue()) {
                fedNonFedCost = (BudgetDecimal)fedNonFedCost.add((AbstractKualiDecimal)this.budget.getCostSharingAmount());
            }
            resourceLineItem.setBudgetApplicantContributionAmount(fedNonFedCost.bigDecimalValue());
            resourceLineItem.setBudgetTotalContributionAmount(fedNonFedCost.bigDecimalValue());
            resourceLineItemArray[0] = resourceLineItem;
            nonFederalResources.setResourceLineItemArray(resourceLineItemArray);
            ResourceTotalsDocument.ResourceTotals resourceTotals = ResourceTotalsDocument.ResourceTotals.Factory.newInstance();
            resourceTotals.setBudgetApplicantContributionAmount(fedNonFedCost.bigDecimalValue());
            resourceTotals.setBudgetTotalContributionAmount(fedNonFedCost.bigDecimalValue());
            nonFederalResources.setResourceTotals(resourceTotals);
        }
        return nonFederalResources;
    }

    private BudgetForecastedCashNeedsDocument.BudgetForecastedCashNeeds getBudgetForecastedCashNeeds() {
        BudgetDecimal totalFedCost = BudgetDecimal.ZERO;
        BudgetDecimal costSharing = BudgetDecimal.ZERO;
        BudgetDecimal totalEstimation = BudgetDecimal.ZERO;
        BudgetDecimal costShareEstimation = BudgetDecimal.ZERO;
        BudgetDecimal totalFedEstimation = BudgetDecimal.ZERO;
        BudgetForecastedCashNeedsDocument.BudgetForecastedCashNeeds budgetForecastedCashNeeds = BudgetForecastedCashNeedsDocument.BudgetForecastedCashNeeds.Factory.newInstance();
        if (this.budget != null) {
            BudgetFirstYearAmountsDocument.BudgetFirstYearAmounts budgetFirstYearAmounts = BudgetFirstYearAmountsDocument.BudgetFirstYearAmounts.Factory.newInstance();
            BudgetFirstQuarterAmountsDocument.BudgetFirstQuarterAmounts budgetFirstQuarterAmounts = BudgetFirstQuarterAmountsDocument.BudgetFirstQuarterAmounts.Factory.newInstance();
            BudgetSecondQuarterAmountsDocument.BudgetSecondQuarterAmounts budgetSecondQuarterAmounts = BudgetSecondQuarterAmountsDocument.BudgetSecondQuarterAmounts.Factory.newInstance();
            BudgetThirdQuarterAmountsDocument.BudgetThirdQuarterAmounts budgetThirdQuarterAmounts = BudgetThirdQuarterAmountsDocument.BudgetThirdQuarterAmounts.Factory.newInstance();
            BudgetFourthQuarterAmountsDocument.BudgetFourthQuarterAmounts budgetFourthQuarterAmounts = BudgetFourthQuarterAmountsDocument.BudgetFourthQuarterAmounts.Factory.newInstance();
            for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!this.budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue() || budgetPeriod.getBudgetPeriod() != 1) continue;
                    costSharing = (BudgetDecimal)costSharing.add((AbstractKualiDecimal)lineItem.getCostSharingAmount());
                    for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                        costSharing = (BudgetDecimal)costSharing.add((AbstractKualiDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
                if (budgetPeriod.getBudgetPeriod() != 1) continue;
                totalFedCost = budgetPeriod.getTotalCost();
                totalFedEstimation = totalFedCost.divide(new BudgetDecimal(4));
                costShareEstimation = costSharing.divide(new BudgetDecimal(4));
                totalEstimation = (BudgetDecimal)totalFedEstimation.add((AbstractKualiDecimal)costShareEstimation);
            }
            budgetFirstYearAmounts.setBudgetFederalForecastedAmount(totalFedCost.bigDecimalValue());
            budgetFirstYearAmounts.setBudgetNonFederalForecastedAmount(costSharing.bigDecimalValue());
            budgetFirstYearAmounts.setBudgetTotalForecastedAmount(((BudgetDecimal)costSharing.add((AbstractKualiDecimal)totalFedCost)).bigDecimalValue());
            budgetForecastedCashNeeds.setBudgetFirstYearAmounts(budgetFirstYearAmounts);
            budgetFirstQuarterAmounts.setBudgetFederalForecastedAmount(totalFedEstimation.bigDecimalValue());
            budgetFirstQuarterAmounts.setBudgetNonFederalForecastedAmount(costShareEstimation.bigDecimalValue());
            budgetFirstQuarterAmounts.setBudgetTotalForecastedAmount(totalEstimation.bigDecimalValue());
            budgetForecastedCashNeeds.setBudgetFirstQuarterAmounts(budgetFirstQuarterAmounts);
            budgetSecondQuarterAmounts.setBudgetFederalForecastedAmount(totalFedEstimation.bigDecimalValue());
            budgetSecondQuarterAmounts.setBudgetNonFederalForecastedAmount(costShareEstimation.bigDecimalValue());
            budgetSecondQuarterAmounts.setBudgetTotalForecastedAmount(totalEstimation.bigDecimalValue());
            budgetForecastedCashNeeds.setBudgetSecondQuarterAmounts(budgetSecondQuarterAmounts);
            budgetThirdQuarterAmounts.setBudgetFederalForecastedAmount(totalFedEstimation.bigDecimalValue());
            budgetThirdQuarterAmounts.setBudgetNonFederalForecastedAmount(costShareEstimation.bigDecimalValue());
            budgetThirdQuarterAmounts.setBudgetTotalForecastedAmount(totalEstimation.bigDecimalValue());
            budgetForecastedCashNeeds.setBudgetThirdQuarterAmounts(budgetThirdQuarterAmounts);
            budgetFourthQuarterAmounts.setBudgetFederalForecastedAmount(totalFedEstimation.bigDecimalValue());
            budgetFourthQuarterAmounts.setBudgetNonFederalForecastedAmount(costShareEstimation.bigDecimalValue());
            budgetFourthQuarterAmounts.setBudgetTotalForecastedAmount(totalEstimation.bigDecimalValue());
            budgetForecastedCashNeeds.setBudgetFourthQuarterAmounts(budgetFourthQuarterAmounts);
        }
        return budgetForecastedCashNeeds;
    }

    private FederalFundsNeededDocument.FederalFundsNeeded getFederalFundsNeeded() {
        BudgetDecimal firstYearCost = BudgetDecimal.ZERO;
        BudgetDecimal firstYearCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal firstYearNetCost = BudgetDecimal.ZERO;
        BudgetDecimal secondYearCost = BudgetDecimal.ZERO;
        BudgetDecimal secondYearCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal secondYearNetCost = BudgetDecimal.ZERO;
        BudgetDecimal thirdYearCost = BudgetDecimal.ZERO;
        BudgetDecimal thirdYearCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal thirdYearNetCost = BudgetDecimal.ZERO;
        BudgetDecimal fourthYearCost = BudgetDecimal.ZERO;
        BudgetDecimal fourthYearCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal fourthYearNetCost = BudgetDecimal.ZERO;
        FederalFundsNeededDocument.FederalFundsNeeded federalFundsNeeded = FederalFundsNeededDocument.FederalFundsNeeded.Factory.newInstance();
        if (this.budget == null) {
            return federalFundsNeeded;
        }
        FundsTotalsDocument.FundsTotals fundsTotals = FundsTotalsDocument.FundsTotals.Factory.newInstance();
        FundsLineItemDocument.FundsLineItem[] fundsLineItemArray = new FundsLineItemDocument.FundsLineItem[1];
        FundsLineItemDocument.FundsLineItem fundsLineItem = FundsLineItemDocument.FundsLineItem.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode() != null) {
            this.pdDoc.getDevelopmentProposal().getS2sOpportunity().refreshNonUpdateableReferences();
            fundsLineItem.setActivityTitle(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle());
        }
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetPeriod() == 2) {
                firstYearCost = (BudgetDecimal)firstYearCost.add((AbstractKualiDecimal)budgetPeriod.getTotalCost());
                firstYearCostSharing = (BudgetDecimal)firstYearCostSharing.add((AbstractKualiDecimal)budgetPeriod.getCostSharingAmount());
                firstYearNetCost = (BudgetDecimal)firstYearCost.subtract((AbstractKualiDecimal)firstYearCostSharing);
            }
            if (budgetPeriod.getBudgetPeriod() == 3) {
                secondYearCost = (BudgetDecimal)secondYearCost.add((AbstractKualiDecimal)budgetPeriod.getTotalCost());
                secondYearCostSharing = (BudgetDecimal)secondYearCostSharing.add((AbstractKualiDecimal)budgetPeriod.getCostSharingAmount());
                secondYearNetCost = (BudgetDecimal)secondYearCost.subtract((AbstractKualiDecimal)secondYearCostSharing);
            }
            if (budgetPeriod.getBudgetPeriod() == 4) {
                thirdYearCost = (BudgetDecimal)thirdYearCost.add((AbstractKualiDecimal)budgetPeriod.getTotalCost());
                thirdYearCostSharing = (BudgetDecimal)thirdYearCostSharing.add((AbstractKualiDecimal)budgetPeriod.getCostSharingAmount());
                thirdYearNetCost = (BudgetDecimal)thirdYearCost.subtract((AbstractKualiDecimal)thirdYearCostSharing);
            }
            if (budgetPeriod.getBudgetPeriod() != 5) continue;
            fourthYearCost = (BudgetDecimal)fourthYearCost.add((AbstractKualiDecimal)budgetPeriod.getTotalCost());
            fourthYearCostSharing = (BudgetDecimal)fourthYearCostSharing.add((AbstractKualiDecimal)budgetPeriod.getCostSharingAmount());
            fourthYearNetCost = (BudgetDecimal)fourthYearCost.subtract((AbstractKualiDecimal)fourthYearCostSharing);
        }
        fundsLineItem.setBudgetFirstYearAmount(firstYearNetCost.bigDecimalValue());
        fundsTotals.setBudgetFirstYearAmount(firstYearNetCost.bigDecimalValue());
        fundsLineItem.setBudgetSecondYearAmount(secondYearNetCost.bigDecimalValue());
        fundsTotals.setBudgetSecondYearAmount(secondYearNetCost.bigDecimalValue());
        fundsLineItem.setBudgetThirdYearAmount(thirdYearNetCost.bigDecimalValue());
        fundsTotals.setBudgetThirdYearAmount(thirdYearNetCost.bigDecimalValue());
        fundsLineItem.setBudgetFourthYearAmount(fourthYearNetCost.bigDecimalValue());
        fundsTotals.setBudgetFourthYearAmount(fourthYearNetCost.bigDecimalValue());
        fundsLineItemArray[0] = fundsLineItem;
        federalFundsNeeded.setFundsLineItemArray(fundsLineItemArray);
        federalFundsNeeded.setFundsTotals(fundsTotals);
        return federalFundsNeeded;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getSF424A();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        BudgetInformationType SF424A = (BudgetInformationType)xmlObject;
        BudgetInformationDocument budgetInformationDocument = BudgetInformationDocument.Factory.newInstance();
        budgetInformationDocument.setBudgetInformation(SF424A);
        return budgetInformationDocument;
    }
}

