/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.sflllV11.AwardeeDataType;
import gov.grants.apply.forms.sflllV11.LobbyingActivitiesDisclosureDocument;
import gov.grants.apply.forms.sflllV11.ReportDataType;
import gov.grants.apply.forms.sflllV11.ReportEntityDataType;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import gov.grants.apply.system.universalCodesV20.StateCodeDataType;
import java.util.HashMap;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.SFLLLBaseGenerator;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SFLLLV1_1Generator
extends SFLLLBaseGenerator {
    private DepartmentalPerson aorInfo;

    private LobbyingActivitiesDisclosureDocument getLobbyingActivitiesDisclosure() {
        LobbyingActivitiesDisclosureDocument lobbyinADDocument = LobbyingActivitiesDisclosureDocument.Factory.newInstance();
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure lobbyingDisclosure = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.Factory.newInstance();
        lobbyingDisclosure.setFormVersion("1.1");
        lobbyingDisclosure.setFederalActionType(LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalActionType.GRANT);
        lobbyingDisclosure.setFederalActionStatus(LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalActionStatus.BID_OFFER);
        lobbyingDisclosure.setReportType(ReportDataType.INITIAL_FILING);
        lobbyingDisclosure.setReportEntity(this.getReportEntity());
        lobbyingDisclosure.setFederalAgencyDepartment("");
        Sponsor sponsor = this.pdDoc.getDevelopmentProposal().getSponsor();
        if (sponsor != null) {
            if (sponsor.getSponsorName() != null) {
                if (sponsor.getSponsorName().length() > 40) {
                    lobbyingDisclosure.setFederalAgencyDepartment(sponsor.getSponsorName().substring(0, 40));
                } else {
                    lobbyingDisclosure.setFederalAgencyDepartment(sponsor.getSponsorName());
                }
            }
        } else {
            String primeSponsorCode = this.pdDoc.getDevelopmentProposal().getPrimeSponsorCode();
            if (primeSponsorCode != null) {
                BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
                HashMap<String, String> sponsorMap = new HashMap<String, String>();
                sponsorMap.put("sponsorCode", primeSponsorCode);
                Sponsor primeSponsor = (Sponsor)businessObjectService.findByPrimaryKey(Sponsor.class, sponsorMap);
                if (primeSponsor.getSponsorName() != null) {
                    if (primeSponsor.getSponsorName().length() > 40) {
                        lobbyingDisclosure.setFederalAgencyDepartment(primeSponsor.getSponsorName().substring(0, 40));
                    } else {
                        lobbyingDisclosure.setFederalAgencyDepartment(primeSponsor.getSponsorName());
                    }
                }
            }
        }
        lobbyingDisclosure.setFederalProgramName(this.getFedProgramName());
        lobbyingDisclosure.setLobbyingRegistrant(this.getLobbyingRegistrant());
        lobbyingDisclosure.setIndividualsPerformingServices(this.getIndividualsPerformingServices());
        lobbyingDisclosure.setSignatureBlock(this.getSignatureBlock());
        lobbyinADDocument.setLobbyingActivitiesDisclosure(lobbyingDisclosure);
        return lobbyinADDocument;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.SignatureBlock getSignatureBlock() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.SignatureBlock signatureBlock = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.SignatureBlock.Factory.newInstance();
        signatureBlock.setName(this.globLibV20Generator.getHumanNameDataType(this.aorInfo));
        if (this.aorInfo.getPrimaryTitle() != null) {
            if (this.aorInfo.getPrimaryTitle().length() > 45) {
                signatureBlock.setTitle(this.aorInfo.getPrimaryTitle().substring(0, 45));
            } else {
                signatureBlock.setTitle(this.aorInfo.getPrimaryTitle());
            }
        }
        signatureBlock.setSignature(this.aorInfo.getFullName());
        signatureBlock.setSignedDate(this.s2sUtilService.getCurrentCalendar());
        return signatureBlock;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.LobbyingRegistrant getLobbyingRegistrant() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.LobbyingRegistrant lobbyingRegistrant = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.LobbyingRegistrant.Factory.newInstance();
        lobbyingRegistrant.setOrganizationName("N/A");
        return lobbyingRegistrant;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices getIndividualsPerformingServices() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices individualServices = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Factory.newInstance();
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual individual = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual.Factory.newInstance();
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        humanName.setFirstName("N/A");
        humanName.setLastName("N/A");
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual[] individualArray = new LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual[1];
        individual.setName(humanName);
        individualArray[0] = individual;
        individualServices.setIndividualArray(individualArray);
        return individualServices;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalProgramName getFedProgramName() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalProgramName federalProgramName = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalProgramName.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            String announcementTitle = this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120 ? this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120) : this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle();
            federalProgramName.setFederalProgramDescription(announcementTitle);
        }
        federalProgramName.setCFDANumber(this.pdDoc.getDevelopmentProposal().getCfdaNumber());
        return federalProgramName;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity getReportEntity() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity reportEntity = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity.Factory.newInstance();
        reportEntity.setReportEntityType(ReportEntityDataType.PRIME);
        reportEntity.setReportEntityIsPrime(YesNoDataType.Y_YES);
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity.Prime prime = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity.Prime.Factory.newInstance();
        Organization organization = null;
        organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            if (organization.getOrganizationName() != null) {
                if (organization.getOrganizationName().length() > 60) {
                    prime.setOrganizationName(organization.getOrganizationName().substring(0, 60));
                } else {
                    prime.setOrganizationName(organization.getOrganizationName());
                }
            }
            if (organization.getCongressionalDistrict() != null) {
                if (organization.getCongressionalDistrict().length() > 6) {
                    prime.setCongressionalDistrict(organization.getCongressionalDistrict().substring(0, 6));
                } else {
                    prime.setCongressionalDistrict(organization.getCongressionalDistrict());
                }
            }
        }
        prime.setReportEntityType(ReportEntityDataType.PRIME);
        AwardeeDataType.Address address = AwardeeDataType.Address.Factory.newInstance();
        Rolodex rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex();
        if (rolodex != null) {
            StateCodeDataType.Enum state;
            if (rolodex.getAddressLine1() != null) {
                if (rolodex.getAddressLine1().length() > 55) {
                    address.setStreet1(rolodex.getAddressLine1().substring(0, 55));
                } else {
                    address.setStreet1(rolodex.getAddressLine1());
                }
            }
            if (rolodex.getAddressLine2() != null) {
                if (rolodex.getAddressLine2().length() > 55) {
                    address.setStreet2(rolodex.getAddressLine2().substring(0, 55));
                } else {
                    address.setStreet2(rolodex.getAddressLine2());
                }
            }
            if (rolodex.getCity() != null) {
                if (rolodex.getCity().length() > 35) {
                    address.setCity(rolodex.getCity().substring(0, 35));
                } else {
                    address.setCity(rolodex.getCity());
                }
            }
            if ((state = this.globLibV20Generator.getStateCodeDataType(rolodex.getCountryCode(), rolodex.getState())) != null) {
                address.setState(state);
            }
            address.setZipPostalCode(rolodex.getPostalCode());
        }
        prime.setAddress(address);
        reportEntity.setPrime(prime);
        return reportEntity;
    }

    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.s2sUtilService.getDepartmentalPerson(this.pdDoc);
        return this.getLobbyingActivitiesDisclosure();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        LobbyingActivitiesDisclosureDocument lobbyingDisclosureDocument = LobbyingActivitiesDisclosureDocument.Factory.newInstance();
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure lobbyingDisclosure = (LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure)xmlObject;
        lobbyingDisclosureDocument.setLobbyingActivitiesDisclosure(lobbyingDisclosure);
        return lobbyingDisclosureDocument;
    }
}

