/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.polling;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronExpression;
import org.quartz.CronTrigger;
import org.quartz.Trigger;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class S2SSchedulerFactoryBean
extends SchedulerFactoryBean {
    private static final Log LOG = LogFactory.getLog(S2SSchedulerFactoryBean.class);
    private List<CronTrigger> triggers;

    public List<CronTrigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<CronTrigger> triggers) {
        this.triggers = triggers;
        ArrayList<CronTrigger> schedulableTriggers = new ArrayList<CronTrigger>();
        for (CronTrigger cronTrigger : triggers) {
            block4: {
                try {
                    CronExpression cronExpression = new CronExpression(cronTrigger.getCronExpression());
                    if (cronExpression.getNextValidTimeAfter(new Date()) == null) {
                        LOG.info((Object)(cronTrigger.getCronExpression() + " not valid cronexpression. The job will not be scheduled."));
                    }
                    break block4;
                }
                catch (ParseException e) {
                    LOG.info((Object)(cronTrigger.getCronExpression() + " not valid cronexpression. The job will not be scheduled."));
                }
                continue;
            }
            schedulableTriggers.add(cronTrigger);
        }
        super.setTriggers((Trigger[])schedulableTriggers.toArray(new CronTrigger[0]));
    }
}

