/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import gov.grants.apply.system.globalV10.HashValueDocument;
import gov.grants.apply.system.headerV10.GrantSubmissionHeaderDocument;
import gov.grants.apply.system.metaGrantApplication.GrantApplicationDocument;
import gov.grants.apply.webservices.applicantintegrationservices_v1.ApplicationInformationType;
import gov.grants.apply.webservices.applicantintegrationservices_v1.GetApplicationListResponse;
import gov.grants.apply.webservices.applicantintegrationservices_v1.GetApplicationStatusDetailResponse;
import gov.grants.apply.webservices.applicantintegrationservices_v1.GetOpportunityListResponse;
import gov.grants.apply.webservices.applicantintegrationservices_v1.OpportunityInformationType;
import gov.grants.apply.webservices.applicantintegrationservices_v1.SubmitApplicationResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sAppAttachments;
import org.kuali.kra.s2s.bo.S2sAppSubmission;
import org.kuali.kra.s2s.bo.S2sApplication;
import org.kuali.kra.s2s.bo.S2sOppForms;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.bo.S2sProvider;
import org.kuali.kra.s2s.formmapping.FormMappingInfo;
import org.kuali.kra.s2s.formmapping.FormMappingLoader;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.generator.S2SGeneratorNotFoundException;
import org.kuali.kra.s2s.generator.bo.AttachmentData;
import org.kuali.kra.s2s.service.PrintService;
import org.kuali.kra.s2s.service.S2SConnectorService;
import org.kuali.kra.s2s.service.S2SFormGeneratorService;
import org.kuali.kra.s2s.service.S2SProposalValidatorService;
import org.kuali.kra.s2s.service.S2SService;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.kra.s2s.service.S2SValidatorService;
import org.kuali.kra.s2s.util.GrantApplicationHash;
import org.kuali.kra.s2s.validator.OpportunitySchemaParser;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class KRAS2SServiceImpl
implements S2SService {
    private static final Log LOG = LogFactory.getLog(KRAS2SServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private S2SFormGeneratorService s2SFormGeneratorService;
    private S2SProposalValidatorService s2SProposalValidatorService;
    private S2SUtilService s2SUtilService;
    private PrintService printService;
    private S2SValidatorService s2SValidatorService;
    private static final String GRANTS_GOV_STATUS_ERROR = "ERROR";
    private static final String KEY_PROPOSAL_NUMBER = "proposalNumber";

    public String getStatusDetails(String ggTrackingId, String proposalNumber) throws S2SException {
        if (this.isAuthorizedToAccess(proposalNumber)) {
            if (StringUtils.isNotBlank((String)proposalNumber) && proposalNumber.contains(":")) {
                proposalNumber = StringUtils.split((String)proposalNumber, (String)":")[0];
            }
            HashMap<String, String> opportunityMap = new HashMap<String, String>();
            opportunityMap.put(KEY_PROPOSAL_NUMBER, proposalNumber);
            S2sOpportunity s2sOpportunity = (S2sOpportunity)this.businessObjectService.findByPrimaryKey(S2sOpportunity.class, opportunityMap);
            Object statusDetail = null;
            GetApplicationStatusDetailResponse applicationStatusDetailResponse = this.getS2sConnectorService(s2sOpportunity).getApplicationStatusDetail(ggTrackingId, proposalNumber);
            if (applicationStatusDetailResponse != null) {
                statusDetail = applicationStatusDetailResponse.getDetailedStatus();
            }
            return statusDetail.toString();
        }
        return "";
    }

    public List<S2sOppForms> parseOpportunityForms(S2sOpportunity opportunity) throws S2SException {
        String opportunityContent = this.getOpportunityContent(opportunity.getSchemaUrl());
        opportunity.setOpportunity(opportunityContent);
        return new OpportunitySchemaParser().getForms(opportunity.getSchemaUrl());
    }

    private String getOpportunityContent(String schemaUrl) throws S2SException {
        String opportunity = "";
        InputStream is = null;
        BufferedInputStream br = null;
        try {
            URL url = new URL(schemaUrl);
            is = (InputStream)url.getContent();
            br = new BufferedInputStream(is);
            byte[] bufContent = new byte[is.available()];
            br.read(bufContent);
            opportunity = new String(bufContent);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Occured", (Throwable)e);
            throw new S2SException("error.grantsgov.form.schema.server.down", e.getMessage(), new String[]{schemaUrl});
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Cannot close stream after fetching the content of opportinity schema", (Throwable)e);
            }
        }
        return opportunity;
    }

    public boolean refreshGrantsGov(ProposalDevelopmentDocument pdDoc) throws S2SException {
        GetApplicationListResponse applicationListResponse = this.fetchApplicationListResponse(pdDoc);
        if (applicationListResponse != null) {
            this.saveGrantsGovStatus(pdDoc, applicationListResponse);
        }
        return true;
    }

    public GetApplicationListResponse fetchApplicationListResponse(ProposalDevelopmentDocument pdDoc) throws S2SException {
        HashMap<String, String> opportunityMap = new HashMap<String, String>();
        opportunityMap.put(KEY_PROPOSAL_NUMBER, pdDoc.getDevelopmentProposal().getProposalNumber());
        S2sOpportunity s2sOpportunity = (S2sOpportunity)this.businessObjectService.findByPrimaryKey(S2sOpportunity.class, opportunityMap);
        GetApplicationListResponse applicationListResponse = this.getS2sConnectorService(s2sOpportunity).getApplicationList(s2sOpportunity.getOpportunityId(), s2sOpportunity.getCfdaNumber(), s2sOpportunity.getProposalNumber());
        return applicationListResponse;
    }

    protected void saveGrantsGovStatus(ProposalDevelopmentDocument pdDoc, GetApplicationListResponse applicationListResponse) throws S2SException {
        S2sAppSubmission appSubmission = null;
        List appSubmissionList = pdDoc.getDevelopmentProposal().getS2sAppSubmission();
        int submissionNo = 0;
        for (S2sAppSubmission s2AppSubmission : appSubmissionList) {
            if (s2AppSubmission.getSubmissionNumber() <= submissionNo) continue;
            appSubmission = s2AppSubmission;
            submissionNo = s2AppSubmission.getSubmissionNumber();
        }
        if (appSubmission != null) {
            boolean statusChanged = false;
            if (applicationListResponse.getApplicationInformation() == null || applicationListResponse.getApplicationInformation().size() == 0) {
                statusChanged = this.checkForSubmissionStatusChange(pdDoc, appSubmission);
            } else {
                int appSize = applicationListResponse.getApplicationInformation().size();
                ApplicationInformationType ggApplication = (ApplicationInformationType)applicationListResponse.getApplicationInformation().get(appSize - 1);
                if (ggApplication != null) {
                    statusChanged = !appSubmission.getStatus().equalsIgnoreCase(ggApplication.getGrantsGovApplicationStatus().value());
                    this.populateAppSubmission(pdDoc, appSubmission, ggApplication);
                }
            }
            if (statusChanged) {
                this.businessObjectService.save((PersistableBusinessObject)appSubmission);
            }
        }
    }

    public boolean checkForSubmissionStatusChange(ProposalDevelopmentDocument pdDoc, S2sAppSubmission appSubmission) throws S2SException {
        boolean statusChanged = false;
        GetApplicationStatusDetailResponse applicationStatusDetailResponse = this.getS2sConnectorService(pdDoc.getDevelopmentProposal().getS2sOpportunity()).getApplicationStatusDetail(appSubmission.getGgTrackingId(), pdDoc.getDevelopmentProposal().getProposalNumber());
        if (applicationStatusDetailResponse != null && applicationStatusDetailResponse.getDetailedStatus() != null) {
            String statusDetail = applicationStatusDetailResponse.getDetailedStatus().toString();
            String statusStr = statusDetail.toUpperCase().indexOf(GRANTS_GOV_STATUS_ERROR) == -1 ? statusDetail : "S2S Submission Error";
            statusChanged = !appSubmission.getStatus().equalsIgnoreCase(statusStr);
            appSubmission.setComments(statusDetail);
            appSubmission.setStatus(statusStr);
        } else {
            appSubmission.setComments("No response from S2S Server");
        }
        return statusChanged;
    }

    public void populateAppSubmission(ProposalDevelopmentDocument pdDoc, S2sAppSubmission appSubmission, ApplicationInformationType ggApplication) {
        appSubmission.setGgTrackingId(ggApplication.getGrantsGovTrackingNumber());
        appSubmission.setReceivedDate(new Timestamp(ggApplication.getReceivedDateTime().toGregorianCalendar().getTimeInMillis()));
        appSubmission.setStatus(ggApplication.getGrantsGovApplicationStatus().toString());
        appSubmission.setLastModifiedDate(new Timestamp(ggApplication.getStatusDateTime().toGregorianCalendar().getTimeInMillis()));
        appSubmission.setAgencyTrackingId(ggApplication.getAgencyTrackingNumber());
        if (ggApplication.getAgencyTrackingNumber() != null && ggApplication.getAgencyTrackingNumber().length() > 0) {
            appSubmission.setComments("Agency Tracking Number Assigned");
            this.populateSponsorProposalId(pdDoc, appSubmission);
        } else {
            appSubmission.setComments(ggApplication.getGrantsGovApplicationStatus().toString());
        }
    }

    public void populateSponsorProposalId(ProposalDevelopmentDocument pdDoc, S2sAppSubmission appSubmission) {
        if (StringUtils.isNotBlank((String)appSubmission.getAgencyTrackingId())) {
            if (StringUtils.isBlank((String)pdDoc.getDevelopmentProposal().getSponsorProposalNumber())) {
                pdDoc.getDevelopmentProposal().setSponsorProposalNumber(appSubmission.getAgencyTrackingId());
                this.getBusinessObjectService().save((PersistableBusinessObject)pdDoc.getDevelopmentProposal());
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("devProposalNumber", pdDoc.getDevelopmentProposal().getProposalNumber());
            Collection proposalAdminDetails = this.businessObjectService.findMatching(ProposalAdminDetails.class, values);
            for (ProposalAdminDetails pad : proposalAdminDetails) {
                pad.refreshReferenceObject("institutionalProposal");
                if (!StringUtils.isBlank((String)pad.getInstitutionalProposal().getSponsorProposalNumber())) continue;
                pad.getInstitutionalProposal().setSponsorProposalNumber(appSubmission.getAgencyTrackingId());
                this.getBusinessObjectService().save((PersistableBusinessObject)pad.getInstitutionalProposal());
            }
        }
    }

    public List<S2sOpportunity> searchOpportunity(String providerCode, String cfdaNumber, String opportunityId, String competitionId) throws S2SException {
        S2sProvider provider = (S2sProvider)this.businessObjectService.findBySinglePrimaryKey(S2sProvider.class, (Object)providerCode);
        if (provider == null) {
            throw new S2SException("An invalid provider code was provided when attempting to search for opportunities.");
        }
        S2SConnectorService connectorService = (S2SConnectorService)KraServiceLocator.getService((String)provider.getConnectorServiceName());
        if (connectorService == null) {
            throw new S2SException("The connector service '" + provider.getConnectorServiceName() + "' required by '" + provider.getDescription() + "' S2S provider is not configured.");
        }
        ArrayList s2sOpportunityList = this.convertToArrayList(provider.getCode(), connectorService.getOpportunityList(cfdaNumber, opportunityId, competitionId));
        return s2sOpportunityList;
    }

    public boolean submitApplication(ProposalDevelopmentDocument pdDoc) throws S2SException {
        ArrayList attList;
        boolean submissionStatus = false;
        GrantApplicationDocument.GrantApplication.Forms forms = GrantApplicationDocument.GrantApplication.Forms.Factory.newInstance();
        if (this.generateAndValidateForms(forms, attList = new ArrayList(), pdDoc)) {
            HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
            ArrayList<S2sAppAttachments> s2sAppAttachmentList = new ArrayList<S2sAppAttachments>();
            for (AttachmentData attachmentData : attList) {
                DataHandler attachmentFile = new DataHandler((DataSource)new ByteArrayDataSource(attachmentData.getContent(), attachmentData.getContentType()));
                attachments.put(attachmentData.getContentId(), attachmentFile);
                S2sAppAttachments appAttachments = new S2sAppAttachments();
                appAttachments.setContentId(attachmentData.getContentId());
                appAttachments.setProposalNumber(pdDoc.getDevelopmentProposal().getProposalNumber());
                s2sAppAttachmentList.add(appAttachments);
            }
            S2sAppSubmission appSubmission = new S2sAppSubmission();
            appSubmission.setStatus("S2S Submission in Process");
            appSubmission.setComments("Trying to submit to S2S");
            SubmitApplicationResponse response = null;
            String applicationXml = this.getGrantApplicationDocument(pdDoc, forms);
            S2sOpportunity s2sOpportunity = pdDoc.getDevelopmentProposal().getS2sOpportunity();
            S2SConnectorService connectorService = this.getS2sConnectorService(s2sOpportunity);
            response = connectorService.submitApplication(applicationXml, attachments, pdDoc.getDevelopmentProposal().getProposalNumber());
            appSubmission.setStatus("Submitted to S2S");
            this.saveSubmissionDetails(pdDoc, appSubmission, response, applicationXml, s2sAppAttachmentList);
            submissionStatus = true;
        }
        return submissionStatus;
    }

    protected String getGrantApplicationDocument(ProposalDevelopmentDocument pdDoc, GrantApplicationDocument.GrantApplication.Forms forms) throws S2SException {
        Timestamp openingDate;
        GrantApplicationDocument grantApplicationDocument = GrantApplicationDocument.Factory.newInstance();
        GrantApplicationDocument.GrantApplication grantApplication = GrantApplicationDocument.GrantApplication.Factory.newInstance();
        grantApplication.setForms(forms);
        GrantSubmissionHeaderDocument.GrantSubmissionHeader grantSubmissionHeader = GrantSubmissionHeaderDocument.GrantSubmissionHeader.Factory.newInstance();
        grantSubmissionHeader.setActivityTitle(pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle());
        grantSubmissionHeader.setOpportunityTitle(pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle());
        grantSubmissionHeader.setAgencyName(pdDoc.getDevelopmentProposal().getSponsor().getSponsorName());
        if (pdDoc.getDevelopmentProposal().getCfdaNumber() != null) {
            grantSubmissionHeader.setCFDANumber(pdDoc.getDevelopmentProposal().getCfdaNumber());
        }
        S2sOpportunity s2sOpportunity = pdDoc.getDevelopmentProposal().getS2sOpportunity();
        s2sOpportunity.refreshNonUpdateableReferences();
        if (s2sOpportunity.getCompetetionId() != null) {
            grantSubmissionHeader.setCompetitionID(s2sOpportunity.getCompetetionId());
        }
        grantSubmissionHeader.setOpportunityID(s2sOpportunity.getOpportunityId());
        grantSubmissionHeader.setSchemaVersion("1.0");
        grantSubmissionHeader.setSubmissionTitle(s2sOpportunity.getProposalNumber());
        Timestamp closingDate = s2sOpportunity.getClosingDate();
        if (closingDate != null) {
            Calendar calClosingDate = Calendar.getInstance();
            calClosingDate.setTime(closingDate);
            grantSubmissionHeader.setClosingDate(calClosingDate);
        }
        if ((openingDate = s2sOpportunity.getOpeningDate()) != null) {
            Calendar calOpeningDate = Calendar.getInstance();
            calOpeningDate.setTime(openingDate);
            grantSubmissionHeader.setOpeningDate(calOpeningDate);
        }
        String applicationXml = this.getXmlFromDocument((XmlObject)grantApplication);
        String hashVal = GrantApplicationHash.computeGrantFormsHash((String)applicationXml);
        HashValueDocument.HashValue hashValue = HashValueDocument.HashValue.Factory.newInstance();
        hashValue.setHashAlgorithm("SHA-1");
        hashValue.setStringValue(hashVal);
        grantSubmissionHeader.setHashValue(hashValue);
        grantApplication.setGrantSubmissionHeader(grantSubmissionHeader);
        grantApplicationDocument.setGrantApplication(grantApplication);
        String schemaUrl = s2sOpportunity.getSchemaUrl();
        XmlCursor cursor = grantApplicationDocument.newCursor();
        cursor.toStartDoc();
        if (cursor.toFirstChild()) {
            String defaultNameSpace = cursor.getName().getNamespaceURI();
            String schemaLocation = defaultNameSpace + " " + schemaUrl;
            cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"), schemaLocation);
        }
        return this.getXmlFromDocument((XmlObject)grantApplicationDocument);
    }

    private String getXmlFromDocument(XmlObject grantApplicationDocument) {
        String applicationXmlText = grantApplicationDocument.xmlText(this.s2SFormGeneratorService.getXmlOptionsPrefixes());
        String applicationXml = this.s2SUtilService.removeTimezoneFactor(applicationXmlText);
        return applicationXml;
    }

    protected void saveSubmissionDetails(ProposalDevelopmentDocument pdDoc, S2sAppSubmission appSubmission, SubmitApplicationResponse response, String grantApplicationXml, List<S2sAppAttachments> s2sAppAttachmentList) {
        if (response != null) {
            String proposalNumber = pdDoc.getDevelopmentProposal().getProposalNumber();
            S2sApplication application = new S2sApplication();
            application.setApplication(grantApplicationXml);
            application.setProposalNumber(proposalNumber);
            application.setS2sAppAttachmentList(s2sAppAttachmentList);
            ArrayList<S2sApplication> s2sApplicationList = new ArrayList<S2sApplication>();
            s2sApplicationList.add(application);
            appSubmission.setGgTrackingId(response.getGrantsGovTrackingNumber());
            appSubmission.setReceivedDate(new Timestamp(response.getReceivedDateTime().toGregorianCalendar().getTimeInMillis()));
            appSubmission.setS2sApplication(s2sApplicationList);
            appSubmission.setProposalNumber(proposalNumber);
            List appList = pdDoc.getDevelopmentProposal().getS2sAppSubmission();
            int submissionNumber = 1;
            for (S2sAppSubmission submittedApplication : appList) {
                if (submittedApplication.getSubmissionNumber() < submissionNumber) continue;
                ++submissionNumber;
            }
            appSubmission.setSubmissionNumber(Integer.valueOf(submissionNumber));
            this.businessObjectService.save((PersistableBusinessObject)appSubmission);
            pdDoc.getDevelopmentProposal().refreshReferenceObject("s2sAppSubmission");
        }
    }

    public boolean validateApplication(ProposalDevelopmentDocument proposalDevelopmentDocument) throws S2SException {
        return this.generateAndValidateForms(null, null, proposalDevelopmentDocument, new ArrayList());
    }

    public boolean validateApplication(ProposalDevelopmentDocument proposalDevelpmentDocument, List<AuditError> auditErrors) throws S2SException {
        return this.generateAndValidateForms(null, null, proposalDevelpmentDocument, auditErrors);
    }

    protected boolean generateAndValidateForms(GrantApplicationDocument.GrantApplication.Forms forms, List<AttachmentData> attList, ProposalDevelopmentDocument pdDoc) throws S2SException {
        return this.generateAndValidateForms(forms, attList, pdDoc, new ArrayList());
    }

    protected boolean generateAndValidateForms(GrantApplicationDocument.GrantApplication.Forms forms, List<AttachmentData> attList, ProposalDevelopmentDocument pdDoc, List<AuditError> auditErrors) throws S2SException {
        boolean validationSucceeded = true;
        DevelopmentProposal developmentProposal = pdDoc.getDevelopmentProposal();
        List opportunityForms = developmentProposal.getS2sOppForms();
        if (opportunityForms.isEmpty()) {
            developmentProposal.refreshReferenceObject("s2sOppForms");
        }
        if (attList == null) {
            attList = new ArrayList<AttachmentData>();
        }
        this.getS2sUtilService().deleteSystemGeneratedAttachments(pdDoc);
        for (S2sOppForms opportunityForm : opportunityForms) {
            if (!opportunityForm.getInclude().booleanValue()) continue;
            ArrayList formAttList = new ArrayList();
            FormMappingInfo info = null;
            S2SBaseFormGenerator s2sFormGenerator = null;
            try {
                info = new FormMappingLoader().getFormInfo(opportunityForm.getOppNameSpace());
                s2sFormGenerator = (S2SBaseFormGenerator)this.s2SFormGeneratorService.getS2SGenerator(info.getNameSpace());
            }
            catch (S2SGeneratorNotFoundException e) {
                continue;
            }
            try {
                s2sFormGenerator.setAuditErrors(auditErrors);
                s2sFormGenerator.setAttachments(formAttList);
                XmlObject formObject = s2sFormGenerator.getFormObject(pdDoc);
                if (this.s2SValidatorService.validate(formObject, auditErrors)) {
                    if (forms != null && attList != null) {
                        this.setFormObject(forms, formObject);
                    }
                } else {
                    validationSucceeded = false;
                }
                attList.addAll(formAttList);
            }
            catch (Exception ex) {
                LOG.error((Object)("Unknown error from " + opportunityForm.getFormName()), (Throwable)ex);
                throw new S2SException("Could not generate form for " + opportunityForm.getFormName(), ex);
            }
        }
        if (!validationSucceeded || !auditErrors.isEmpty()) {
            this.setValidationErrorMessage(auditErrors);
        }
        return validationSucceeded;
    }

    protected void setFormObject(GrantApplicationDocument.GrantApplication.Forms forms, XmlObject formObject) {
        XmlCursor formCursor = formObject.newCursor();
        formCursor.toStartDoc();
        formCursor.toNextToken();
        XmlCursor metaGrantCursor = forms.newCursor();
        metaGrantCursor.toNextToken();
        formCursor.moveXml(metaGrantCursor);
    }

    protected void setValidationErrorMessage(List<AuditError> errors) {
        LOG.info((Object)("Error list size:" + errors.size() + errors.toString()));
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        for (AuditError error : errors) {
            auditErrors.add(new AuditError(error.getErrorKey(), "error.grantsgov.schemavalidation.generic.errorkey", error.getLink(), new String[]{error.getMessageKey()}));
        }
        if (!auditErrors.isEmpty()) {
            KNSGlobalVariables.getAuditErrorMap().put("grantsGovAuditErrors", new AuditCluster("GrantsGov", auditErrors, "Grants.Gov Errors"));
        }
    }

    protected ArrayList<S2sOpportunity> convertToArrayList(String source, GetOpportunityListResponse resList) {
        ArrayList<S2sOpportunity> convList = new ArrayList<S2sOpportunity>();
        if (resList == null || resList.getOpportunityInformation() == null) {
            return convList;
        }
        for (OpportunityInformationType opportunityInformationType : resList.getOpportunityInformation()) {
            convList.add(this.convert2S2sOpportunity(source, opportunityInformationType));
        }
        return convList;
    }

    protected S2sOpportunity convert2S2sOpportunity(String providerCode, OpportunityInformationType oppInfoType) {
        S2sOpportunity s2Opportunity = new S2sOpportunity();
        s2Opportunity.setCfdaNumber(oppInfoType.getCFDANumber());
        s2Opportunity.setClosingDate(oppInfoType.getClosingDate() == null ? null : new Timestamp(oppInfoType.getClosingDate().toGregorianCalendar().getTimeInMillis()));
        s2Opportunity.setCompetetionId(oppInfoType.getCompetitionID());
        s2Opportunity.setInstructionUrl(oppInfoType.getInstructionURL());
        s2Opportunity.setOpeningDate(oppInfoType.getOpeningDate() == null ? null : new Timestamp(oppInfoType.getOpeningDate().toGregorianCalendar().getTimeInMillis()));
        s2Opportunity.setOpportunityId(oppInfoType.getOpportunityID());
        s2Opportunity.setOpportunityTitle(oppInfoType.getOpportunityTitle());
        s2Opportunity.setSchemaUrl(oppInfoType.getSchemaURL());
        s2Opportunity.setProviderCode(providerCode);
        return s2Opportunity;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setS2SFormGeneratorService(S2SFormGeneratorService s2SFormGeneratorService) {
        this.s2SFormGeneratorService = s2SFormGeneratorService;
    }

    public void setS2SProposalValidatorService(S2SProposalValidatorService s2SProposalValidatorService) {
        this.s2SProposalValidatorService = s2SProposalValidatorService;
    }

    public void setS2SUtilService(S2SUtilService s2SUtilService) {
        this.s2SUtilService = s2SUtilService;
    }

    public AttachmentDataSource printForm(ProposalDevelopmentDocument pdDoc) throws S2SException, PrintingException {
        return this.printService.printForm(pdDoc);
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    public void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    public S2SFormGeneratorService getS2SFormGeneratorService() {
        return this.s2SFormGeneratorService;
    }

    public S2SProposalValidatorService getS2SProposalValidatorService() {
        return this.s2SProposalValidatorService;
    }

    public S2SUtilService getS2sUtilService() {
        return this.s2SUtilService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public S2SValidatorService getS2SValidatorService() {
        return this.s2SValidatorService;
    }

    public void setS2SValidatorService(S2SValidatorService validatorService) {
        this.s2SValidatorService = validatorService;
    }

    private boolean isAuthorizedToAccess(String proposalNumber) {
        boolean isAuthorized = true;
        if (proposalNumber.contains(":")) {
            if (GlobalVariables.getUserSession() != null) {
                Map editModes;
                Object formObj;
                String[] invalues = StringUtils.split((String)proposalNumber, (String)":");
                String docFormKey = invalues[1];
                isAuthorized = StringUtils.isBlank((String)docFormKey) ? false : ((formObj = GlobalVariables.getUserSession().retrieveObject(docFormKey)) == null || !(formObj instanceof ProposalDevelopmentForm) ? false : (BooleanUtils.toBoolean((String)((String)(editModes = ((ProposalDevelopmentForm)formObj).getEditingMode()).get("fullEntry"))) || BooleanUtils.toBoolean((String)((String)editModes.get("viewOnly"))) || BooleanUtils.toBoolean((String)((String)editModes.get("modifyProposal")))) && BooleanUtils.toBoolean((String)((String)editModes.get("submitToSponsor"))));
            } else {
                LOG.info((Object)"dwr/ajax does not have session ");
            }
        }
        return isAuthorized;
    }

    protected S2SConnectorService getS2sConnectorService(S2sOpportunity s2sOpportunity) {
        return (S2SConnectorService)KraServiceLocator.getService((String)s2sOpportunity.getS2sProvider().getConnectorServiceName());
    }
}

