/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import gov.grants.apply.system.metaGrantApplication.GrantApplicationDocument;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xpath.XPathAPI;
import org.kuali.kra.bo.SponsorFormTemplate;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeAttachment;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiographyAttachment;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sAppAttachments;
import org.kuali.kra.s2s.bo.S2sAppSubmission;
import org.kuali.kra.s2s.bo.S2sApplication;
import org.kuali.kra.s2s.bo.S2sOppForms;
import org.kuali.kra.s2s.formmapping.FormMappingInfo;
import org.kuali.kra.s2s.formmapping.FormMappingLoader;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.generator.S2SGeneratorNotFoundException;
import org.kuali.kra.s2s.generator.bo.AttachmentData;
import org.kuali.kra.s2s.printing.print.S2SFormPrint;
import org.kuali.kra.s2s.service.PrintService;
import org.kuali.kra.s2s.service.S2SFormGeneratorService;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.kra.s2s.service.S2SValidatorService;
import org.kuali.kra.s2s.util.XPathExecutor;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrintServiceImpl
implements PrintService {
    private static final Log LOG = LogFactory.getLog(PrintServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private S2SFormGeneratorService s2SFormGeneratorService;
    private S2SValidatorService s2SValidatorService;
    private static final String NARRATIVE_ATTACHMENT_LIST = "narrativeAttachmentList";
    private S2SUtilService s2SUtilService;
    private PrintingService printingService;
    File grantsGovXmlDirectoryFile = null;

    public byte[] printProposalSponsorForms(String proposalNumber, List<SponsorFormTemplate> sponsorFormTemplates) throws S2SException {
        throw new RuntimeException("Unsupported functionality");
    }

    public AttachmentDataSource printForm(ProposalDevelopmentDocument pdDoc) throws S2SException, PrintingException {
        List printableList = null;
        S2sAppSubmission s2sAppSubmission = this.getLatestS2SAppSubmission(pdDoc);
        printableList = s2sAppSubmission != null && s2sAppSubmission.getGgTrackingId() != null ? this.getSubmittedPDFStream(pdDoc) : this.getPDFStream(pdDoc);
        if (pdDoc.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue()) {
            return null;
        }
        AttachmentDataSource attachmentDataSource = this.printingService.print(printableList);
        attachmentDataSource.setFileName(this.getFileNameForFormPrinting(pdDoc));
        return attachmentDataSource;
    }

    protected void saveGrantsGovXml(ProposalDevelopmentDocument pdDoc, boolean formEntryFlag, XmlObject formObject, List<AttachmentData> attachmentList, List<S2sAppAttachments> attachmentLists) throws Exception {
        File attachmentFile;
        String loggingDirectory = ((ConfigurationService)KraServiceLocator.getService(ConfigurationService.class)).getPropertyValueAsString("print.xml.directory");
        String opportunityId = pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityId();
        String proposalnumber = pdDoc.getDevelopmentProposal().getProposalNumber();
        String exportDate = StringUtils.replaceChars((String)pdDoc.getDevelopmentProposal().getUpdateTimestamp().toString(), (String)":", (String)"_");
        exportDate = StringUtils.replaceChars((String)exportDate, (String)" ", (String)".");
        if (this.grantsGovXmlDirectoryFile == null) {
            this.grantsGovXmlDirectoryFile = new File(loggingDirectory + proposalnumber);
        }
        File newgrantsGovXmlDirectoryFile = null;
        int suffix = 1;
        while (this.grantsGovXmlDirectoryFile.exists() && formEntryFlag) {
            this.grantsGovXmlDirectoryFile = new File(loggingDirectory + proposalnumber);
            String filename = String.valueOf(suffix);
            newgrantsGovXmlDirectoryFile = new File(loggingDirectory + proposalnumber + "-" + filename);
            if (!newgrantsGovXmlDirectoryFile.exists()) {
                this.grantsGovXmlDirectoryFile = newgrantsGovXmlDirectoryFile;
                break;
            }
            ++suffix;
        }
        if (formEntryFlag) {
            this.grantsGovXmlDirectoryFile.mkdir();
        }
        pdDoc.setSaveXmlFolderName(this.grantsGovXmlDirectoryFile.getName());
        for (AttachmentData attachmentData : attachmentList) {
            attachmentFile = new File(this.grantsGovXmlDirectoryFile, "Attachments");
            attachmentFile.mkdir();
            File attachedFile = new File(attachmentFile, attachmentData.getFileName());
            FileOutputStream output = new FileOutputStream(attachedFile);
            output.write(attachmentData.getContent());
            output.close();
        }
        for (S2sAppAttachments attAppAttachments : attachmentLists) {
            attachmentFile = new File(this.grantsGovXmlDirectoryFile, "Attachments");
            attachmentFile.mkdir();
            AttachmentDataSource ads = this.getAttributeContent(pdDoc, attAppAttachments.getContentId());
            File attachedFile = new File(attachmentFile, ads.getFileName());
            FileOutputStream output = new FileOutputStream(attachedFile);
            output.write(this.getAttContent(pdDoc, attAppAttachments.getContentId()));
            output.close();
        }
        File xmlFile = new File(this.grantsGovXmlDirectoryFile, opportunityId + "." + proposalnumber + "." + exportDate + ".xml");
        BufferedWriter out = new BufferedWriter(new FileWriter(xmlFile));
        out.write(formObject.xmlText());
        out.close();
        ZipOutputStream zipOutputStream = null;
        FileOutputStream fileOutputStream = new FileOutputStream(this.grantsGovXmlDirectoryFile + ".zip");
        zipOutputStream = new ZipOutputStream(fileOutputStream);
        PrintServiceImpl.addFolderToZip((String)"", (String)this.grantsGovXmlDirectoryFile.getPath(), (ZipOutputStream)zipOutputStream);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    public static void addFolderToZip(String path, String sourceFolder, ZipOutputStream zipOutputStream) throws Exception {
        File proposalNumberfolder = new File(sourceFolder);
        for (String fileName : proposalNumberfolder.list()) {
            if (path.equals("")) {
                PrintServiceImpl.addFileToZip((String)proposalNumberfolder.getName(), (String)(sourceFolder + "/" + fileName), (ZipOutputStream)zipOutputStream);
                continue;
            }
            PrintServiceImpl.addFileToZip((String)(path + "/" + proposalNumberfolder.getName()), (String)(sourceFolder + "/" + fileName), (ZipOutputStream)zipOutputStream);
        }
    }

    public static void addFileToZip(String path, String sourceFile, ZipOutputStream zipOutputStream) throws Exception {
        File attachmentFile = new File(sourceFile);
        if (attachmentFile.isDirectory()) {
            PrintServiceImpl.addFolderToZip((String)path, (String)sourceFile, (ZipOutputStream)zipOutputStream);
        } else {
            int length;
            byte[] buffer = new byte[1024];
            FileInputStream fileInputStream = new FileInputStream(attachmentFile);
            zipOutputStream.putNextEntry(new ZipEntry(path + "/" + attachmentFile.getName()));
            while ((length = fileInputStream.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, length);
            }
        }
    }

    protected String getFileNameForFormPrinting(ProposalDevelopmentDocument pdDoc) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(pdDoc.getDocumentNumber());
        fileName.append(pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber());
        fileName.append(".pdf");
        return fileName.toString();
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected List<Printable> getSubmittedPDFStream(ProposalDevelopmentDocument pdDoc) throws S2SException {
        GrantApplicationDocument submittedDocument;
        String frmXpath = null;
        String frmAttXpath = null;
        this.grantsGovXmlDirectoryFile = null;
        try {
            S2sAppSubmission s2sAppSubmission = this.getLatestS2SAppSubmission(pdDoc);
            String submittedApplicationXml = this.findSubmittedXml(s2sAppSubmission);
            String submittedApplication = this.getS2SUtilService().removeTimezoneFactor(submittedApplicationXml);
            submittedDocument = GrantApplicationDocument.Factory.parse((String)submittedApplication);
        }
        catch (XmlException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new S2SException((Exception)((Object)e));
        }
        FormMappingInfo info = null;
        Object s2sFormGenerator = null;
        ArrayList errors = new ArrayList();
        List sortedNameSpaces = this.getSortedNameSpaces(pdDoc.getDevelopmentProposal().getS2sOppForms());
        boolean formEntryFlag = true;
        ArrayList<Printable> formPrintables = new ArrayList<Printable>();
        for (String namespace : sortedNameSpaces) {
            XmlObject formFragment = null;
            try {
                info = new FormMappingLoader().getFormInfo(namespace);
                formFragment = this.getFormObject(submittedDocument, info);
                frmXpath = "//*[namespace-uri(.) = '" + namespace + "']";
                frmAttXpath = "//*[namespace-uri(.) = '" + namespace + "']//*[local-name(.) = 'FileLocation' and namespace-uri(.) = 'http://apply.grants.gov/system/Attachments-V1.0']";
            }
            catch (S2SGeneratorNotFoundException e) {
                continue;
            }
            byte[] formXmlBytes = formFragment.xmlText().getBytes();
            S2SFormPrint formPrintable = new S2SFormPrint();
            ArrayList<StreamSource> templates = new ArrayList<StreamSource>();
            StreamSource xsltSource = new StreamSource(this.getClass().getResourceAsStream("/" + info.getStyleSheet()));
            templates.add(xsltSource);
            formPrintable.setXSLT(templates);
            LinkedHashMap<String, byte[]> formXmlDataMap = new LinkedHashMap<String, byte[]>();
            formXmlDataMap.put(info.getFormName(), formXmlBytes);
            formPrintable.setXmlDataMap(formXmlDataMap);
            S2sApplication s2sApplciation = (S2sApplication)this.getBusinessObjectService().findBySinglePrimaryKey(S2sApplication.class, (Object)pdDoc.getDevelopmentProposal().getProposalNumber());
            List attachmentList = s2sApplciation.getS2sAppAttachmentList();
            LinkedHashMap<String, byte[]> formAttachments = new LinkedHashMap<String, byte[]>();
            try {
                XPathExecutor executer = new XPathExecutor(formFragment.toString());
                Node d = executer.getNode(frmXpath);
                NodeList attList = XPathAPI.selectNodeList((Node)d, (String)frmAttXpath);
                int attLen = attList.getLength();
                for (int i = 0; i < attLen; ++i) {
                    Node attNode = attList.item(i);
                    String contentId = ((Element)attNode).getAttributeNS("http://apply.grants.gov/system/Attachments-V1.0", "href");
                    if (attachmentList == null || attachmentList.isEmpty()) continue;
                    for (S2sAppAttachments attAppAttachments : attachmentList) {
                        if (!attAppAttachments.getContentId().equals(contentId)) continue;
                        ByteArrayOutputStream attStream = new ByteArrayOutputStream();
                        try {
                            attStream.write(this.getAttContent(pdDoc, attAppAttachments.getContentId()));
                        }
                        catch (IOException e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                            throw new S2SException((Exception)e);
                        }
                        StringBuilder attachment = new StringBuilder();
                        attachment.append("   ATT : ");
                        attachment.append(attAppAttachments.getContentId());
                        formAttachments.put(attachment.toString(), this.getAttContent(pdDoc, attAppAttachments.getContentId()));
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (pdDoc.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue()) {
                    ArrayList attachmentLists = new ArrayList();
                    this.saveGrantsGovXml(pdDoc, formEntryFlag, formFragment, attachmentLists, attachmentList);
                    formEntryFlag = false;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            formPrintable.setAttachments(formAttachments);
            formPrintables.add((Printable)formPrintable);
        }
        return formPrintables;
    }

    protected String findSubmittedXml(S2sAppSubmission appSubmission) {
        S2sApplication s2sApplication = (S2sApplication)this.getBusinessObjectService().findBySinglePrimaryKey(S2sApplication.class, (Object)appSubmission.getProposalNumber());
        return s2sApplication.getApplication();
    }

    protected List<Printable> getPDFStream(ProposalDevelopmentDocument pdDoc) throws S2SException {
        FormMappingInfo info = null;
        S2SBaseFormGenerator s2sFormGenerator = null;
        this.grantsGovXmlDirectoryFile = null;
        ArrayList errors = new ArrayList();
        List sortedNameSpaces = this.getSortedNameSpaces(pdDoc.getDevelopmentProposal().getS2sOppForms());
        ArrayList<Printable> formPrintables = new ArrayList<Printable>();
        boolean formEntryFlag = true;
        this.getS2SUtilService().deleteSystemGeneratedAttachments(pdDoc);
        GrantApplicationDocument.GrantApplication.Forms forms = GrantApplicationDocument.GrantApplication.Forms.Factory.newInstance();
        for (String namespace : sortedNameSpaces) {
            try {
                info = new FormMappingLoader().getFormInfo(namespace);
                s2sFormGenerator = (S2SBaseFormGenerator)this.s2SFormGeneratorService.getS2SGenerator(info.getNameSpace());
            }
            catch (S2SGeneratorNotFoundException e) {
                LOG.info((Object)("Form not found for namespace: " + namespace));
                continue;
            }
            s2sFormGenerator.setAuditErrors(errors);
            s2sFormGenerator.setAttachments(new ArrayList());
            XmlObject formObject = s2sFormGenerator.getFormObject(pdDoc);
            if (!this.s2SValidatorService.validate(formObject, errors) || !errors.isEmpty()) continue;
            String applicationXml = formObject.xmlText(this.s2SFormGeneratorService.getXmlOptionsPrefixes());
            String filteredApplicationXml = this.getS2SUtilService().removeTimezoneFactor(applicationXml);
            byte[] formXmlBytes = filteredApplicationXml.getBytes();
            S2SFormPrint formPrintable = new S2SFormPrint();
            LinkedHashMap<String, byte[]> formXmlDataMap = new LinkedHashMap<String, byte[]>();
            formXmlDataMap.put(info.getFormName(), formXmlBytes);
            formPrintable.setXmlDataMap(formXmlDataMap);
            ArrayList<StreamSource> templates = new ArrayList<StreamSource>();
            StreamSource xsltSource = new StreamSource(this.getClass().getResourceAsStream("/" + info.getStylesheet()));
            templates.add(xsltSource);
            formPrintable.setXSLT(templates);
            List attachmentList = s2sFormGenerator.getAttachments();
            try {
                if (pdDoc.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue()) {
                    ArrayList attachmentLists = new ArrayList();
                    this.setFormObject(forms, formObject);
                    this.saveGrantsGovXml(pdDoc, formEntryFlag, (XmlObject)forms, attachmentList, attachmentLists);
                    formEntryFlag = false;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            LinkedHashMap<String, byte[]> formAttachments = new LinkedHashMap<String, byte[]>();
            if (attachmentList != null && !attachmentList.isEmpty()) {
                for (AttachmentData attachmentData : attachmentList) {
                    if (!this.isPdfType(attachmentData.getContent())) continue;
                    StringBuilder attachment = new StringBuilder();
                    attachment.append("   ATT : ");
                    attachment.append(attachmentData.getContentId());
                    formAttachments.put(attachment.toString(), attachmentData.getContent());
                }
            }
            if (formAttachments.size() > 0) {
                formPrintable.setAttachments(formAttachments);
            }
            formPrintables.add((Printable)formPrintable);
        }
        if (!errors.isEmpty()) {
            this.setValidationErrorMessage(errors);
        }
        return formPrintables;
    }

    protected void setValidationErrorMessage(List<AuditError> errors) {
        LOG.info((Object)("Error list size:" + errors.size() + errors.toString()));
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        for (AuditError error : errors) {
            auditErrors.add(new AuditError(error.getErrorKey(), "error.grantsgov.schemavalidation.generic.errorkey", error.getLink(), new String[]{error.getMessageKey()}));
        }
        if (!auditErrors.isEmpty()) {
            KNSGlobalVariables.getAuditErrorMap().put("grantsGovAuditErrors", new AuditCluster("GrantsGov", auditErrors, "Grants.Gov Errors"));
        }
    }

    protected XmlObject getFormObject(GrantApplicationDocument submittedXml, FormMappingInfo info) {
        Object formObject = null;
        GrantApplicationDocument.GrantApplication.Forms forms = submittedXml.getGrantApplication().getForms();
        return forms.newCursor().getObject();
    }

    protected byte[] getAttContent(ProposalDevelopmentDocument pdDoc, String contentId) {
        block3: {
            String[] contentDesc;
            String[] contentIds;
            block2: {
                contentIds = contentId.split("-");
                contentDesc = contentIds[1].split("_");
                if (!StringUtils.equals((String)contentIds[0], (String)"N")) break block2;
                for (Narrative narrative : pdDoc.getDevelopmentProposal().getNarratives()) {
                    if (!narrative.getModuleNumber().equals(Integer.valueOf(contentDesc[0]))) continue;
                    narrative.refreshReferenceObject("narrativeAttachmentList");
                    return ((NarrativeAttachment)narrative.getNarrativeAttachmentList().get(0)).getContent();
                }
                break block3;
            }
            if (!StringUtils.equals((String)contentIds[0], (String)"B")) break block3;
            for (ProposalPersonBiography biography : pdDoc.getDevelopmentProposal().getPropPersonBios()) {
                if (!biography.getProposalPersonNumber().equals(Integer.valueOf(contentDesc[0])) || !biography.getBiographyNumber().equals(Integer.valueOf(contentDesc[1]))) continue;
                biography.refreshReferenceObject("personnelAttachmentList");
                return ((ProposalPersonBiographyAttachment)biography.getPersonnelAttachmentList().get(0)).getContent();
            }
        }
        return null;
    }

    protected AttachmentDataSource getAttributeContent(ProposalDevelopmentDocument pdDoc, String contentId) {
        block3: {
            String[] contentDesc;
            String[] contentIds;
            block2: {
                contentIds = contentId.split("-");
                contentDesc = contentIds[1].split("_");
                if (!StringUtils.equals((String)contentIds[0], (String)"N")) break block2;
                for (Narrative narrative : pdDoc.getDevelopmentProposal().getNarratives()) {
                    if (!narrative.getModuleNumber().equals(Integer.valueOf(contentDesc[0]))) continue;
                    narrative.refreshReferenceObject("narrativeAttachmentList");
                    return (AttachmentDataSource)narrative.getNarrativeAttachmentList().get(0);
                }
                break block3;
            }
            if (!StringUtils.equals((String)contentIds[0], (String)"B")) break block3;
            for (ProposalPersonBiography biography : pdDoc.getDevelopmentProposal().getPropPersonBios()) {
                if (!biography.getProposalPersonNumber().equals(Integer.valueOf(contentDesc[0])) || !biography.getBiographyNumber().equals(Integer.valueOf(contentDesc[1]))) continue;
                biography.refreshReferenceObject("personnelAttachmentList");
                return (AttachmentDataSource)biography.getPersonnelAttachmentList().get(0);
            }
        }
        return null;
    }

    protected S2sAppSubmission getLatestS2SAppSubmission(ProposalDevelopmentDocument pdDoc) {
        S2sAppSubmission s2sSubmission = null;
        int submissionNo = 0;
        for (S2sAppSubmission s2sAppSubmission : pdDoc.getDevelopmentProposal().getS2sAppSubmission()) {
            if (s2sAppSubmission.getSubmissionNumber() == null || s2sAppSubmission.getSubmissionNumber() <= submissionNo) continue;
            s2sSubmission = s2sAppSubmission;
            submissionNo = s2sAppSubmission.getSubmissionNumber();
        }
        return s2sSubmission;
    }

    protected List<String> getSortedNameSpaces(List<S2sOppForms> s2sOppForms) {
        ArrayList<String> orderedNamespaces = new ArrayList<String>();
        FormMappingLoader formMappingLoader = new FormMappingLoader();
        formMappingLoader.getBindings();
        Map sortedNamespaces = formMappingLoader.getSortedNameSpaces();
        ArrayList sortedIndices = new ArrayList(sortedNamespaces.keySet());
        int index = 0;
        for (Integer sortedIndex : sortedIndices) {
            for (S2sOppForms oppForm : s2sOppForms) {
                List namespaces = (List)sortedNamespaces.get(sortedIndex);
                for (String namespace : namespaces) {
                    if (!namespace.equals(oppForm.getOppNameSpace()) || !Boolean.TRUE.equals(oppForm.getSelectToPrint())) continue;
                    orderedNamespaces.add(index++, namespace);
                }
            }
        }
        return orderedNamespaces;
    }

    public void setS2SFormGeneratorService(S2SFormGeneratorService s2SFormGeneratorService) {
        this.s2SFormGeneratorService = s2SFormGeneratorService;
    }

    public void setS2SValidatorService(S2SValidatorService s2SValidatorService) {
        this.s2SValidatorService = s2SValidatorService;
    }

    protected boolean isPdfType(byte[] data) {
        int ATTRIBUTE_CHUNK_SIZE = 1200;
        String PRE_HEXA = "0x";
        boolean retValue = false;
        String[] str = new String[]{"25", "50", "44", "46"};
        byte[] byteCheckArr = new byte[4];
        byte[] byteDataArr = new byte[4];
        for (int byteIndex = 0; byteIndex < byteCheckArr.length; ++byteIndex) {
            byteCheckArr[byteIndex] = Integer.decode("0x" + str[byteIndex]).byteValue();
        }
        int startPoint = 0;
        int endPoint = 1200 > data.length / 2 ? data.length / 2 : 1200;
        for (int forwardIndex = startPoint; forwardIndex < endPoint - str.length; ++forwardIndex) {
            int fillIndex;
            if (forwardIndex == 0) {
                for (fillIndex = 0; fillIndex < str.length; ++fillIndex) {
                    byteDataArr[fillIndex] = PrintServiceImpl.toUnsignedByte((int)data[fillIndex]);
                }
            } else {
                for (fillIndex = 0; fillIndex < str.length - 1; ++fillIndex) {
                    byteDataArr[fillIndex] = byteDataArr[fillIndex + 1];
                }
                byteDataArr[str.length - 1] = PrintServiceImpl.toUnsignedByte((int)data[str.length - 1 + forwardIndex]);
            }
            if (!new String(byteCheckArr).equals(new String(byteDataArr))) continue;
            retValue = true;
        }
        return retValue;
    }

    protected static byte toUnsignedByte(int intVal) {
        byte byteVal;
        if (intVal > 127) {
            int temp = intVal - 256;
            byteVal = (byte)temp;
        } else {
            byteVal = (byte)intVal;
        }
        return byteVal;
    }

    public S2SUtilService getS2SUtilService() {
        return this.s2SUtilService;
    }

    public void setS2SUtilService(S2SUtilService utilService) {
        this.s2SUtilService = utilService;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    protected void setFormObject(GrantApplicationDocument.GrantApplication.Forms forms, XmlObject formObject) {
        XmlCursor formCursor = formObject.newCursor();
        formCursor.toStartDoc();
        formCursor.toNextToken();
        XmlCursor metaGrantCursor = forms.newCursor();
        metaGrantCursor.toNextToken();
        formCursor.moveXml(metaGrantCursor);
    }
}

