/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.polling.MailInfo;
import org.kuali.kra.s2s.polling.PollingInfo;
import org.kuali.kra.s2s.polling.SchedulerReader;
import org.kuali.kra.s2s.polling.StatusInfo;
import org.kuali.kra.s2s.polling.TaskInfo;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.kra.s2s.service.SchedulerService;
import org.kuali.rice.core.api.mail.MailMessage;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SchedulerServiceImpl
implements SchedulerService {
    private boolean started;
    private static final Log LOG = LogFactory.getLog(SchedulerServiceImpl.class);
    private Scheduler scheduler = null;
    private S2SUtilService s2SUtilService;
    private static final String KEY_JOB_SCHEDULER = "jobscheduler";
    private static final String KEY_ENABLING_KEY = "enablingkey";
    private static final String KEY_ENABLING_VALUE = "1";
    private static final String SCHEDULER_GROUP = "S2SSchedulerGroup";
    private static final String KEY_TASK = "task";
    private static final String KEY_ID = "id";
    private static final String KEY_POLLING_INTERVAL = "pollinginterval";
    private static final String KEY_MAILING_INTERVAL = "mailinterval";
    private static final String KEY_STOP_POLLING_INTERVAL = "stoppollinterval";
    private static final String KEY_MAIL = "mail";
    private static final String KEY_ADDRESS_TO = "to";
    private static final String KEY_ADDRESS_CC = "cc";
    private static final String KEY_ADDRESS_BCC = "bcc";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_SUBJECT = "subject";
    private static final String KEY_FOOTER = "footer";
    private static final String KEY_DUNS_NUMBER = "dunsnumber";
    private static final String KEY_STATUS = "status";
    private static final String KEY_CODE = "code";
    private static final String KEY_VALUE = "value";

    public synchronized void startAllServices() {
        Hashtable elements;
        if (this.started) {
            return;
        }
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        try {
            this.scheduler = schedulerFactory.getScheduler();
            elements = SchedulerReader.getScheduleNodes();
        }
        catch (SchedulerException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        Enumeration keys = elements.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Element schNode = (Element)elements.get(key);
            String taskClassName = schNode.getAttribute(KEY_JOB_SCHEDULER);
            String enablingKey = schNode.getAttribute(KEY_ENABLING_KEY);
            String enabledStr = this.s2SUtilService.getParameterValue(enablingKey);
            if (enabledStr.equals("") || !enabledStr.trim().equals(KEY_ENABLING_VALUE)) continue;
            try {
                TaskInfo[] tasks = this.read(schNode);
                for (int ti = 0; ti < tasks.length; ++ti) {
                    TaskInfo taskInfo = tasks[ti];
                    try {
                        JobDetail jobDetail = new JobDetail(taskInfo.getTaskId(), SCHEDULER_GROUP, Class.forName(taskClassName));
                        jobDetail.getJobDataMap().put((Object)"taskInfo", (Object)taskInfo);
                        SimpleTrigger simpleTrigger = new SimpleTrigger(taskInfo.getTaskId(), SCHEDULER_GROUP, new Date(), null, -1, 60000L * taskInfo.getPollingInterval());
                        this.scheduler.scheduleJob(jobDetail, (Trigger)simpleTrigger);
                        continue;
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex.getMessage(), (Throwable)ex);
                        LOG.error((Object)("Error while creating schedule for task: " + taskInfo.getTaskId()));
                    }
                }
                this.scheduler.start();
            }
            catch (Exception ex) {
                LOG.error((Object)("Error in scheduling job for Node " + key), (Throwable)ex);
            }
        }
        this.started = true;
    }

    public synchronized void stopAllServices() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void restartAllServices() {
        this.stopAllServices();
        this.started = false;
        this.startAllServices();
    }

    protected TaskInfo[] read(Element element) {
        NodeList taskList = element.getElementsByTagName(KEY_TASK);
        int taskSize = taskList.getLength();
        TaskInfo[] taskInfo = new TaskInfo[taskSize];
        for (int index = 0; index < taskSize; ++index) {
            Element taskNode = (Element)taskList.item(index);
            String taskId = taskNode.getAttribute(KEY_ID);
            PollingInfo pollingInfo = new PollingInfo();
            pollingInfo.setTaskId(taskId);
            pollingInfo.setPollingInterval(taskNode.getAttribute(KEY_POLLING_INTERVAL));
            pollingInfo.setMailInterval(taskNode.getAttribute(KEY_MAILING_INTERVAL));
            pollingInfo.setStopPollInterval(taskNode.getAttribute(KEY_STOP_POLLING_INTERVAL));
            NodeList mailList = taskNode.getElementsByTagName(KEY_MAIL);
            int mlLength = mailList.getLength();
            ArrayList<MailInfo> mailInfoList = new ArrayList<MailInfo>(mlLength);
            for (int k = 0; k < mlLength; ++k) {
                Element mailNode = (Element)mailList.item(k);
                MailInfo mailInfo = new MailInfo();
                MailMessage mailMessage = mailInfo.getMailMessage();
                mailMessage.addToAddress(mailNode.getAttribute(KEY_ADDRESS_TO));
                mailMessage.addCcAddress(mailNode.getAttribute(KEY_ADDRESS_CC));
                mailMessage.addBccAddress(mailNode.getAttribute(KEY_ADDRESS_BCC));
                mailMessage.setMessage(mailNode.getAttribute(KEY_MESSAGE));
                mailMessage.setSubject(mailNode.getAttribute(KEY_SUBJECT));
                mailInfo.setMailMessage(mailMessage);
                mailInfo.setFooter(mailNode.getAttribute(KEY_FOOTER));
                mailInfo.setDunsNumber(mailNode.getAttribute(KEY_DUNS_NUMBER));
                mailInfoList.add(mailInfo);
            }
            pollingInfo.setMailInfoList(mailInfoList);
            NodeList statusList = taskNode.getElementsByTagName(KEY_STATUS);
            int stLength = statusList.getLength();
            StatusInfo[] statusArray = new StatusInfo[stLength];
            for (int j = 0; j < stLength; ++j) {
                Element statusNode = (Element)statusList.item(j);
                StatusInfo status = new StatusInfo();
                status.setCode(statusNode.getAttribute(KEY_CODE));
                status.setValue(statusNode.getAttribute(KEY_VALUE));
                statusArray[j] = status;
            }
            pollingInfo.setStatuses(statusArray);
            taskInfo[index] = pollingInfo;
        }
        return taskInfo;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stopAllServices();
    }

    public synchronized void sets2SUtilService(S2SUtilService s2SUtilService) {
        this.s2SUtilService = s2SUtilService;
        this.startAllServices();
        LOG.info((Object)"Scheduler started");
    }
}

