/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.s2s.util.XPathExecutor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GrantApplicationXpath {
    private static final String HASH_ALGORITHM = "glob:hashAlgorithm";
    private static final String SHA_1 = "SHA";
    static final Log log = LogFactory.getLog((String)GrantApplicationXpath.class.getName());
    public static final String GS_HEADER_XPATH = "/*[namespace-uri()='http://apply.grants.gov/system/MetaGrantApplication' and local-name()='GrantApplication']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='GrantSubmissionHeader']";
    public static final String OPPORTUNITY_ID_XPATH = "/*[namespace-uri()='http://apply.grants.gov/system/MetaGrantApplication' and local-name()='GrantApplication']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='GrantSubmissionHeader']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='OpportunityID']";
    public static final String CFDA_NUMBER_XPATH = "/*[namespace-uri()='http://apply.grants.gov/system/MetaGrantApplication' and local-name()='GrantApplication']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='GrantSubmissionHeader']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='CFDANumber']";
    public static final String OPPORTUNITY_TITLE_XPATH = "/*[namespace-uri()='http://apply.grants.gov/system/MetaGrantApplication' and local-name()='GrantApplication']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='GrantSubmissionHeader']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='OpportunityTitle']";
    public static final String CLOSING_DATE_XPATH = "/*[namespace-uri()='http://apply.grants.gov/system/MetaGrantApplication' and local-name()='GrantApplication']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='GrantSubmissionHeader']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='ClosingDate']";
    public static final String AGENCY_NAME_XPATH = "/*[namespace-uri()='http://apply.grants.gov/system/MetaGrantApplication' and local-name()='GrantApplication']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='GrantSubmissionHeader']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='AgencyName']";
    public static final String COMPETITION_ID_XPATH = "/*[namespace-uri()='http://apply.grants.gov/system/MetaGrantApplication' and local-name()='GrantApplication']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='GrantSubmissionHeader']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='CompetitionID']";
    public static final String SUBMISSION_TITLE_XPATH = "/*[namespace-uri()='http://apply.grants.gov/system/MetaGrantApplication' and local-name()='GrantApplication']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='GrantSubmissionHeader']/*[namespace-uri()='http://apply.grants.gov/system/Header-V1.0' and local-name()='SubmissionTitle']";
    public static final String HASHVALUE = "glob:HashValue";
    public static final String FORMS_XPATH = "//*[local-name(.) = 'Forms' and namespace-uri(.) = 'http://apply.grants.gov/system/MetaGrantApplication']";
    public static final String HEADER_XPATH = "//*[local-name(.) = 'GrantSubmissionHeader' and namespace-uri(.) = 'http://apply.grants.gov/system/Header-V1.0']";
    public static final String HASH_XPATH = "//*[local-name(.) = 'GrantSubmissionHeader' and namespace-uri(.) = 'http://apply.grants.gov/system/Header-V1.0']/*[local-name(.) = 'HashValue' and namespace-uri(.) = 'http://apply.grants.gov/system/Global-V1.0']";
    public static final String GLOBAL_NS = "http://apply.grants.gov/system/Global-V1.0";
    private XPathExecutor executor;

    public GrantApplicationXpath(String xmlDoc) throws Exception {
        this.setExecutor(this.createExecutor(xmlDoc));
    }

    public XPathExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(XPathExecutor executor) {
        this.executor = executor;
    }

    private XPathExecutor createExecutor(String xmlDoc) throws Exception {
        return new XPathExecutor(xmlDoc);
    }

    public Node getFormsNode() throws TransformerException {
        return this.getExecutor().getNode(FORMS_XPATH);
    }

    public Node getHeaderNode() throws TransformerException {
        return this.getExecutor().getNode(HEADER_XPATH);
    }

    public Node getHashNode() throws TransformerException {
        Node hashNode = this.getExecutor().getNode(HASH_XPATH);
        if (hashNode == null) {
            hashNode = this.getExecutor().getDoc().createElementNS(GLOBAL_NS, HASHVALUE);
            Attr algorithm = this.getExecutor().getDoc().createAttributeNS(GLOBAL_NS, HASH_ALGORITHM);
            algorithm.setValue(SHA_1);
            ((Element)hashNode).setAttributeNodeNS(algorithm);
            hashNode.appendChild(this.getExecutor().getDoc().createTextNode(""));
            Node header = this.getHeaderNode();
            header.insertBefore(hashNode, header.getFirstChild());
        }
        return hashNode;
    }

    public String getHeaderHashValue() throws Exception {
        return this.getExecutor().execute(HASH_XPATH);
    }

    public String getAgencyName() throws Exception {
        return this.getExecutor().execute(AGENCY_NAME_XPATH);
    }

    public String getCfdaNumber() throws Exception {
        return this.getExecutor().execute(CFDA_NUMBER_XPATH);
    }

    public String getClosingDate() throws Exception {
        return this.getExecutor().execute(CLOSING_DATE_XPATH);
    }

    public String getOpportunityId() throws Exception {
        return this.getExecutor().execute(OPPORTUNITY_ID_XPATH);
    }

    public String getOpportunityTitle() throws Exception {
        return this.getExecutor().execute(OPPORTUNITY_TITLE_XPATH);
    }

    public String getCompetitionId() throws Exception {
        return this.getExecutor().execute(COMPETITION_ID_XPATH);
    }

    public String getSubmissionTitle() throws Exception {
        return this.getExecutor().execute(SUBMISSION_TITLE_XPATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BufferedReader reader = null;
        try {
            File f = new File("c:/GetApplicationResponseMessage.xml");
            reader = new BufferedReader(new FileReader(f));
            String line = null;
            StringBuffer buf = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buf.append(line);
            }
            GrantApplicationXpath xpath = new GrantApplicationXpath(buf.toString());
            log.debug((Object)xpath.getAgencyName());
            log.debug((Object)xpath.getCfdaNumber());
            log.debug((Object)xpath.getOpportunityId());
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }
}

