/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.expr;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.kuali.kra.scheduling.expr.CronExpression;
import org.kuali.kra.scheduling.expr.util.CronSpecialChars;
import org.kuali.kra.scheduling.util.Time24HrFmt;

public class MonthDayOrLastDayMultipleYearsCronExpression
extends CronExpression {
    protected static final Integer MAXIMUM_DAY_VALUE = 28;
    private Integer day;

    public MonthDayOrLastDayMultipleYearsCronExpression(Date startDate, Time24HrFmt time, Integer day) throws ParseException {
        super(startDate, time);
        this.day = day;
    }

    public String getExpression() {
        GregorianCalendar stDt = new GregorianCalendar();
        stDt.setTime(this.getStartDate());
        StringBuilder exp = new StringBuilder();
        exp.append("0").append(CronSpecialChars.SPACE);
        exp.append(this.getTime().getMinutes()).append(CronSpecialChars.SPACE);
        exp.append(this.getTime().getHours()).append(CronSpecialChars.SPACE);
        if (this.day > MAXIMUM_DAY_VALUE) {
            exp.append("L");
        } else {
            exp.append(this.day);
        }
        exp.append(CronSpecialChars.SPACE);
        exp.append(CronSpecialChars.STAR).append(CronSpecialChars.SPACE);
        exp.append(CronSpecialChars.QUESTION).append(CronSpecialChars.SPACE);
        System.err.println("MonthDayMultipleYearsCronExpression getExpression: " + exp.toString());
        return exp.toString();
    }
}

