/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.expr;

import java.text.ParseException;
import java.util.Date;
import org.kuali.kra.scheduling.expr.CronExpression;
import org.kuali.kra.scheduling.expr.util.CronSpecialChars;
import org.kuali.kra.scheduling.util.Time24HrFmt;

public class MonthlyWeekDayCronExpression
extends CronExpression {
    private Integer frequencyInMonth;
    private CronSpecialChars dayOfWeek;
    private CronSpecialChars weekOfMonth;

    public MonthlyWeekDayCronExpression(Date startDate, Time24HrFmt time, CronSpecialChars dayOfWeek, CronSpecialChars weekOfMonth, Integer frequencyInMonth) throws ParseException {
        super(startDate, time);
        this.frequencyInMonth = frequencyInMonth;
        this.dayOfWeek = dayOfWeek;
        this.weekOfMonth = weekOfMonth;
    }

    public String getExpression() {
        StringBuilder exp = new StringBuilder();
        exp.append("0").append(CronSpecialChars.SPACE);
        exp.append(this.getTime().getMinutes()).append(CronSpecialChars.SPACE);
        exp.append(this.getTime().getHours()).append(CronSpecialChars.SPACE);
        exp.append(CronSpecialChars.QUESTION).append(CronSpecialChars.SPACE);
        exp.append(CronSpecialChars.FIRST).append(CronSpecialChars.SLASH).append(this.frequencyInMonth).append(CronSpecialChars.SPACE);
        if (this.weekOfMonth != CronSpecialChars.LAST) {
            exp.append(this.dayOfWeek).append(CronSpecialChars.HASH).append(this.weekOfMonth);
        } else {
            exp.append(this.dayOfWeek).append(CronSpecialChars.LAST);
        }
        return exp.toString();
    }
}

