/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.expr;

import java.text.ParseException;
import java.util.Date;
import org.kuali.kra.scheduling.expr.CronExpression;
import org.kuali.kra.scheduling.expr.util.CronSpecialChars;
import org.kuali.kra.scheduling.util.Time24HrFmt;

public class WeekCronExpression
extends CronExpression {
    private CronSpecialChars[] weekdays;

    public WeekCronExpression(Date startDate, Time24HrFmt time, CronSpecialChars[] weekdays) throws ParseException {
        super(startDate, time);
        this.weekdays = weekdays;
    }

    public String getExpression() {
        StringBuilder exp = new StringBuilder();
        exp.append("0").append(CronSpecialChars.SPACE);
        exp.append(this.getTime().getMinutes()).append(CronSpecialChars.SPACE);
        exp.append(this.getTime().getHours()).append(CronSpecialChars.SPACE);
        exp.append(CronSpecialChars.QUESTION).append(CronSpecialChars.SPACE);
        exp.append(CronSpecialChars.STAR).append(CronSpecialChars.SPACE);
        exp.append(this.toStringWeekDays(this.weekdays, CronSpecialChars.COMMASEPRATOR));
        return exp.toString();
    }

    private String toStringWeekDays(CronSpecialChars[] day, CronSpecialChars seperator) {
        StringBuilder sb = new StringBuilder();
        for (CronSpecialChars str : day) {
            sb.append(str).append(seperator);
        }
        return sb.substring(0, sb.length() - 1);
    }
}

