/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.expr;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.kuali.kra.scheduling.expr.CronExpression;
import org.kuali.kra.scheduling.expr.util.CronSpecialChars;
import org.kuali.kra.scheduling.util.Time24HrFmt;

public class YearMonthDayCronExpression
extends CronExpression {
    private CronSpecialChars month;
    private Integer day;
    private Integer frequencyInYear;

    public YearMonthDayCronExpression(Date startDate, Time24HrFmt time, CronSpecialChars month, Integer day, Integer frequencyInYear) throws ParseException {
        super(startDate, time);
        this.month = month;
        this.day = day;
        this.frequencyInYear = frequencyInYear;
    }

    public String getExpression() {
        GregorianCalendar stDt = new GregorianCalendar();
        stDt.setTime(this.getStartDate());
        int stDt_year = stDt.get(1);
        StringBuilder exp = new StringBuilder();
        exp.append("0").append(CronSpecialChars.SPACE);
        exp.append(this.getTime().getMinutes()).append(CronSpecialChars.SPACE);
        exp.append(this.getTime().getHours()).append(CronSpecialChars.SPACE);
        exp.append(this.day).append(CronSpecialChars.SPACE);
        exp.append(this.month).append(CronSpecialChars.SPACE);
        exp.append(CronSpecialChars.QUESTION).append(CronSpecialChars.SPACE);
        exp.append(stDt_year).append(CronSpecialChars.SLASH).append(this.frequencyInYear);
        return exp.toString();
    }
}

