/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.expr;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.kuali.kra.scheduling.expr.CronExpression;
import org.kuali.kra.scheduling.expr.util.CronSpecialChars;
import org.kuali.kra.scheduling.util.Time24HrFmt;

public class YearMonthDayOfWeekCronExpression
extends CronExpression {
    private CronSpecialChars weekOfMonth;
    private CronSpecialChars dayOfWeek;
    private CronSpecialChars month;
    private Integer frequencyInYear;

    public YearMonthDayOfWeekCronExpression(Date startDate, Time24HrFmt time, CronSpecialChars weekOfMonth, CronSpecialChars dayOfWeek, CronSpecialChars month, Integer frequencyInYear) throws ParseException {
        super(startDate, time);
        this.weekOfMonth = weekOfMonth;
        this.dayOfWeek = dayOfWeek;
        this.month = month;
        this.frequencyInYear = frequencyInYear;
    }

    public String getExpression() {
        GregorianCalendar stDt = new GregorianCalendar();
        stDt.setTime(this.getStartDate());
        int stDt_year = stDt.get(1);
        StringBuilder exp = new StringBuilder();
        exp.append("0").append(CronSpecialChars.SPACE);
        exp.append(this.getTime().getMinutes()).append(CronSpecialChars.SPACE);
        exp.append(this.getTime().getHours()).append(CronSpecialChars.SPACE);
        exp.append(CronSpecialChars.QUESTION).append(CronSpecialChars.SPACE);
        exp.append(this.month).append(CronSpecialChars.SPACE);
        if (this.weekOfMonth != CronSpecialChars.LAST) {
            exp.append(this.dayOfWeek).append(CronSpecialChars.HASH).append(this.weekOfMonth).append(CronSpecialChars.SPACE);
        } else {
            exp.append(this.dayOfWeek).append(CronSpecialChars.LAST).append(CronSpecialChars.SPACE);
        }
        exp.append(stDt_year).append(CronSpecialChars.SLASH).append(this.frequencyInYear);
        return exp.toString();
    }
}

