/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.award.home.AwardBasisOfPayment;
import org.kuali.kra.award.home.AwardMethodOfPayment;
import org.kuali.kra.award.home.ValidAwardBasisPayment;
import org.kuali.kra.award.home.ValidBasisMethodPayment;
import org.kuali.kra.service.AwardPaymentAndInvoicesService;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.kra.util.ValuesFinderUtility;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardPaymentAndInvoicesServiceImpl
implements AwardPaymentAndInvoicesService {
    static final String AWARDTYPECODE = "awardTypeCode";
    static final String VALIDAWARDBASISPAYMENT_ID = "validAwardBasisPaymentId";
    static final String BASISOFPAYMENTCODE = "basisOfPaymentCode";
    static final String METHODOFPAYMENTCODE = "methodOfPaymentCode";
    private static final String SEMICOLON_AS_DELIMITOR = ";";
    private static final String COMMA_AS_DELIMITOR = ",";
    private static final String AWARDBASISOFPAYMENT_CODE = "basisOfPaymentCode";
    private static final String AWARDMETHODOFPAYMENT_CODE = "methodOfPaymentCode";
    BusinessObjectService businessObjectService;

    public String getEncodedValidAwardBasisPaymentsByAwardTypeCode(Integer awardTypeCode) {
        ArrayList<ConcreteKeyValue> results = new ArrayList<ConcreteKeyValue>();
        results.add(new ConcreteKeyValue("", "select"));
        List found = this.getValidAwardBasisPaymentsByAwardTypeCode(awardTypeCode);
        for (ValidAwardBasisPayment current : found) {
            current.refresh();
            results.add(new ConcreteKeyValue(current.getBasisOfPaymentCode(), current.getBasisOfPayment().getDescription()));
        }
        return ValuesFinderUtility.processKeyValueList(results);
    }

    public String getEncodedValidBasisMethodPaymentsByBasisCode(String basisOfPaymentCode) {
        ArrayList<ConcreteKeyValue> results = new ArrayList<ConcreteKeyValue>();
        results.add(new ConcreteKeyValue("", "select"));
        List found = this.getValidBasisMethodPaymentByBasisCode(basisOfPaymentCode);
        for (ValidBasisMethodPayment current : found) {
            current.refresh();
            results.add(new ConcreteKeyValue(current.getMethodOfPaymentCode(), current.getMethodOfPayment().getDescription()));
        }
        return ValuesFinderUtility.processKeyValueList(results);
    }

    public List<ValidAwardBasisPayment> getValidAwardBasisPaymentsByAwardTypeCode(Integer awardTypeCode) {
        ArrayList<ValidAwardBasisPayment> results = new ArrayList<ValidAwardBasisPayment>(this.businessObjectService.findMatchingOrderBy(ValidAwardBasisPayment.class, ServiceHelper.getInstance().buildCriteriaMap(AWARDTYPECODE, (Object)awardTypeCode), VALIDAWARDBASISPAYMENT_ID, true));
        return results;
    }

    public List<ValidBasisMethodPayment> getValidBasisMethodPaymentByBasisCode(String basisOfPaymentCode) {
        ArrayList<ValidBasisMethodPayment> results = new ArrayList<ValidBasisMethodPayment>(this.businessObjectService.findMatchingOrderBy(ValidBasisMethodPayment.class, ServiceHelper.getInstance().buildCriteriaMap(new String[]{"basisOfPaymentCode"}, (Object[])new String[]{basisOfPaymentCode}), "methodOfPaymentCode", true));
        return results;
    }

    public List<ValidBasisMethodPayment> getValidBasisMethodPaymentByMethodCode(String methodOfPaymentCode) {
        ArrayList<ValidBasisMethodPayment> results = new ArrayList<ValidBasisMethodPayment>(this.businessObjectService.findMatchingOrderBy(ValidBasisMethodPayment.class, ServiceHelper.getInstance().buildCriteriaMap("methodOfPaymentCode", (Object)methodOfPaymentCode), "basisOfPaymentCode", true));
        return results;
    }

    public ValidAwardBasisPayment getValidAwardBasisPayment(Integer validAwardBasisPaymentId) {
        ValidAwardBasisPayment vBasisPayment = (ValidAwardBasisPayment)this.businessObjectService.findByPrimaryKey(ValidAwardBasisPayment.class, ServiceHelper.getInstance().buildCriteriaMap(VALIDAWARDBASISPAYMENT_ID, (Object)validAwardBasisPaymentId));
        return vBasisPayment;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public String getAwardBasisOfPaymentDescription(String awardBasisOfPaymentId) {
        AwardBasisOfPayment basisOfPayment = (AwardBasisOfPayment)this.businessObjectService.findByPrimaryKey(AwardBasisOfPayment.class, ServiceHelper.getInstance().buildCriteriaMap("basisOfPaymentCode", (Object)awardBasisOfPaymentId));
        return basisOfPayment != null ? basisOfPayment.getDescription() : "";
    }

    public String getAwardMethodOfPaymentDescription(String awardMethodOfPaymentId) {
        AwardMethodOfPayment awardMethodOfPayment = (AwardMethodOfPayment)this.businessObjectService.findByPrimaryKey(AwardMethodOfPayment.class, ServiceHelper.getInstance().buildCriteriaMap("methodOfPaymentCode", (Object)awardMethodOfPaymentId));
        return awardMethodOfPayment != null ? awardMethodOfPayment.getDescription() : "";
    }
}

