/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service;

import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.protocol.ProtocolBase;

public class ResearchAreaCurrentReferencerHolderBase {
    private String researchAreaCode;
    private ProtocolBase currentReferencingProtocol;
    private CommitteeBase currentReferencingCommittee;
    private CommitteeMembershipBase currentReferencingCommitteeMembership;
    public static final ResearchAreaCurrentReferencerHolderBase NO_REFERENCER = new ResearchAreaCurrentReferencerHolderBase();

    private ResearchAreaCurrentReferencerHolderBase() {
    }

    public ResearchAreaCurrentReferencerHolderBase(String researchAreaCode, ProtocolBase currentReferencingProtocol, CommitteeBase currentReferencingCommittee, CommitteeMembershipBase currentReferencingCommitteeMembership) {
        this.researchAreaCode = researchAreaCode;
        this.currentReferencingProtocol = currentReferencingProtocol;
        this.currentReferencingCommittee = currentReferencingCommittee;
        this.currentReferencingCommitteeMembership = currentReferencingCommitteeMembership;
    }

    public ProtocolBase getCurrentReferencingProtocol() {
        return this.currentReferencingProtocol;
    }

    public CommitteeBase getCurrentReferencingCommittee() {
        return this.currentReferencingCommittee;
    }

    public CommitteeMembershipBase getCurrentReferencingCommitteeMembership() {
        return this.currentReferencingCommitteeMembership;
    }

    public String getResearchAreaCode() {
        return this.researchAreaCode;
    }

    public boolean containsAnyValidReferencers() {
        boolean retValue = false;
        if (null != this.currentReferencingProtocol || null != this.currentReferencingCommittee || null != this.currentReferencingCommitteeMembership) {
            retValue = true;
        }
        return retValue;
    }

    public String getMessage() {
        String retValue = "";
        if (this == NO_REFERENCER) {
            retValue = "No referencers";
        } else if (null == this.researchAreaCode) {
            retValue = "Research area code undefined";
        } else if (null != this.currentReferencingProtocol) {
            retValue = "Research area " + this.researchAreaCode + " is referenced by current version of protocol with number " + this.currentReferencingProtocol.getProtocolNumber();
        } else if (null != this.currentReferencingCommitteeMembership) {
            retValue = "Research area " + this.researchAreaCode + " is referenced by current version of committee membership named " + this.currentReferencingCommitteeMembership.getPersonName();
            if (null != this.currentReferencingCommittee) {
                retValue = retValue + " in committee with ID " + this.currentReferencingCommittee.getCommitteeId();
            }
        } else if (null != this.currentReferencingCommittee) {
            retValue = "Research area " + this.researchAreaCode + " is referenced by current version of committee with ID " + this.currentReferencingCommittee.getCommitteeId();
        }
        return retValue;
    }
}

